/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.util.DasUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlAggregatesInspection;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAnalyticClause;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.impl.SqlColumnSymbol;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.slicer.SqlPsiUtilCoreKt;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlAggregatesInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "<init>", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlAggregatesInspection
extends SqlInspectionBase {
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result, dbms2, onTheFly){
            private final Lazy clausesWithAggregates$delegate;
            private final Lazy groupByPrimaryKeys$delegate;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ Dbms $dbms;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$dialect = $dialect;
                this.$dbms = $dbms;
                this.$onTheFly = $onTheFly;
                super($manager, (SqlLanguageDialect)$dialect, (Collection)$result);
                this.clausesWithAggregates$delegate = LazyKt.lazy(createAnnotationVisitor.1::clausesWithAggregates_delegate$lambda$0);
                this.groupByPrimaryKeys$delegate = LazyKt.lazy(createAnnotationVisitor.1::groupByPrimaryKeys_delegate$lambda$1);
            }

            private final HashSet<SqlClause> getClausesWithAggregates() {
                Lazy lazy = this.clausesWithAggregates$delegate;
                return (HashSet)lazy.getValue();
            }

            private final HashSet<SqlGroupByClause> getGroupByPrimaryKeys() {
                Lazy lazy = this.groupByPrimaryKeys$delegate;
                return (HashSet)lazy.getValue();
            }

            private final boolean getHasAnalyticClause(SqlFunctionCallExpression $this$hasAnalyticClause) {
                return PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)$this$hasAnalyticClause), SqlAnalyticClause.class) != null;
            }

            private final PsiElement resolveToOriginal(SqlReferenceExpression $this$resolveToOriginal) {
                PsiElement result = $this$resolveToOriginal.resolve();
                if (result instanceof SqlColumnSymbol) {
                    result = ((SqlColumnSymbol)result).getTargetDefinition();
                }
                return result;
            }

            private final boolean maybeSameRefs(SqlReferenceExpression groupByRef, SqlReferenceExpression testRef, boolean unwrapAlias) {
                PsiElement psiElement = this.resolveToOriginal(groupByRef);
                if (psiElement == null) {
                    return true;
                }
                PsiElement groupByResult = psiElement;
                PsiElement psiElement2 = this.resolveToOriginal(testRef);
                if (psiElement2 == null) {
                    return true;
                }
                PsiElement testResult = psiElement2;
                if (unwrapAlias && !Intrinsics.areEqual((Object)groupByResult, (Object)testResult) && testResult instanceof SqlAsExpression) {
                    SqlExpression sqlExpression = ((SqlAsExpression)testResult).getExpression();
                    SqlReferenceExpression sqlReferenceExpression = sqlExpression instanceof SqlReferenceExpression ? (SqlReferenceExpression)sqlExpression : null;
                    if (sqlReferenceExpression == null || (sqlReferenceExpression = sqlReferenceExpression.resolve()) == null) {
                        return true;
                    }
                    testResult = sqlReferenceExpression;
                }
                return Intrinsics.areEqual((Object)groupByResult, (Object)testResult);
            }

            private final ObjectKind getEffectiveKind(SqlReferenceExpression $this$getEffectiveKind) {
                ObjectKind objectKind;
                block2: {
                    PsiElement target;
                    createAnnotationVisitor.1 var2_2 = this;
                    while ((target = $this$getEffectiveKind.resolve()) instanceof SqlAsExpression) {
                        SqlReferenceExpression sqlReferenceExpression;
                        Object object = ((SqlAsExpression)target).getExpression();
                        SqlReferenceExpression sqlReferenceExpression2 = sqlReferenceExpression = object instanceof SqlReferenceExpression ? (SqlReferenceExpression)object : null;
                        if (sqlReferenceExpression != null) {
                            object = var2_2;
                            SqlReferenceExpression sqlReferenceExpression3 = sqlReferenceExpression;
                            var2_2 = object;
                            $this$getEffectiveKind = sqlReferenceExpression3;
                            continue;
                        }
                        objectKind = null;
                        break block2;
                    }
                    objectKind = target instanceof PsiObject ? ((PsiObject)target).getKind() : null;
                }
                return objectKind;
            }

            public void visitSqlReferenceExpression(SqlReferenceExpression o) {
                block8: {
                    SqlQueryExpression sqlQueryExpression;
                    PsiElement psiElement;
                    block9: {
                        PsiElement targetElement;
                        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                        PsiElement immediateTarget = o.getReference().resolveImmediate();
                        Object object = immediateTarget instanceof SqlAsExpression ? (PsiElement)((SqlAsExpression)immediateTarget).getExpression() : (targetElement = immediateTarget instanceof SqlColumnSymbol ? ((SqlColumnSymbol)immediateTarget).getContextElement() : null);
                        if (!(targetElement instanceof SqlFunctionCallExpression) || !SqlPsiUtilCoreKt.isAggregateCall((SqlFunctionCallExpression)((SqlFunctionCallExpression)targetElement))) break block9;
                        SqlQueryExpression currentQuery = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)o), SqlQueryExpression.class);
                        SqlQueryExpression targetQuery = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)targetElement, SqlQueryExpression.class);
                        if (!Intrinsics.areEqual((Object)targetQuery, (Object)currentQuery)) break block8;
                        this.processAggregate((SqlExpression)o, (SqlFunctionCallExpression)targetElement);
                        break block8;
                    }
                    if (!Intrinsics.areEqual((Object)this.getEffectiveKind(o), (Object)ObjectKind.COLUMN) || (psiElement = (PsiElement)SqlImplUtil.sqlParents((PsiElement)((PsiElement)o)).takeWhile(arg_0 -> createAnnotationVisitor.1.visitSqlReferenceExpression$lambda$3(createAnnotationVisitor.1::visitSqlReferenceExpression$lambda$2, arg_0)).filter(arg_0 -> createAnnotationVisitor.1.visitSqlReferenceExpression$lambda$5(createAnnotationVisitor.1::visitSqlReferenceExpression$lambda$4, arg_0)).first()) == null) break block8;
                    PsiElement psiElement2 = psiElement;
                    Dbms dbms = this.$dbms;
                    PsiElement clause = psiElement2;
                    boolean bl = false;
                    PsiElement parent = clause.getParent();
                    SqlGroupByClause sqlGroupByClause = (SqlGroupByClause)PsiTreeUtil.getChildOfType((PsiElement)parent, SqlGroupByClause.class);
                    if (sqlGroupByClause != null || ((sqlQueryExpression = parent instanceof SqlQueryExpression ? (SqlQueryExpression)parent : null) != null && (sqlQueryExpression = sqlQueryExpression.getTableExpression()) != null ? sqlQueryExpression.getGroupByClause() : (sqlGroupByClause = null)) != null) {
                        SqlGroupByClause groupByClause = sqlGroupByClause;
                        if (!this.getGroupByPrimaryKeys().contains(groupByClause)) {
                            SqlExpression[] sqlExpressionArray = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)groupByClause), SqlExpression.class);
                            if (sqlExpressionArray != null) {
                                SqlExpression[] expressions = sqlExpressionArray;
                                boolean isOrderBy = clause instanceof SqlOrderByClause;
                                boolean hasRef = false;
                                for (SqlExpression expression : expressions) {
                                    if (expression instanceof SqlReferenceExpression) {
                                        if (hasRef || !this.maybeSameRefs((SqlReferenceExpression)expression, o, isOrderBy)) continue;
                                        hasRef = true;
                                        continue;
                                    }
                                    break block8;
                                }
                                if (!hasRef) {
                                    if (dbms.isSqlite() || dbms.isH2()) {
                                        PsiElement psiElement3 = (PsiElement)o;
                                        Object[] objectArray = new Object[]{o.getName()};
                                        String string = SqlBundle.message((String)"inspection.message.nondeterministic.value.column.neither.aggregated.nor.mentioned.in.group.by.clause", (Object[])objectArray);
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                        this.reportWarning(psiElement3, string);
                                    } else {
                                        PsiElement psiElement4 = (PsiElement)o;
                                        Object[] objectArray = new Object[]{o.getName()};
                                        String string = SqlBundle.message((String)"inspection.message.column.must.be.either.aggregated.or.mentioned.in.group.by.clause", (Object[])objectArray);
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                        this.reportError(psiElement4, string);
                                    }
                                }
                            }
                        }
                    }
                }
            }

            public void visitSqlFunctionCallExpression(SqlFunctionCallExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (SqlPsiUtilCoreKt.isAggregateCall((SqlFunctionCallExpression)o)) {
                    this.processAggregate((SqlExpression)o, o);
                }
                super.visitSqlElement((SqlElement)o);
            }

            public void visitSqlQueryExpression(SqlQueryExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                this.checkIfGroupedByPrimaryKey(o);
                super.visitSqlQueryExpression(o);
            }

            public void elementFinished(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof SqlHavingClause && !this.getClausesWithAggregates().contains(element)) {
                    SqlGroupByClause groupBy = (SqlGroupByClause)PsiTreeUtil.getChildOfType((PsiElement)((SqlHavingClause)element).getParent(), SqlGroupByClause.class);
                    if (groupBy != null && this.hasMultipleGroupingSets(groupBy)) {
                        return;
                    }
                    PsiElement psiElement = PsiTreeUtil.findSiblingForward((PsiElement)((SqlHavingClause)element).getFirstChild(), (IElementType)((IElementType)SqlCommonKeywords.SQL_HAVING), (boolean)false, null);
                    String string = SqlBundle.message((String)"inspection.message.using.aggregate.free.condition.s.in.having.clause.might.be.inefficient.consider.moving.them.to.where", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.reportWarning(psiElement, string);
                }
            }

            private final boolean hasMultipleGroupingSets(SqlGroupByClause $this$hasMultipleGroupingSets) {
                boolean bl;
                block3: {
                    JBIterable jBIterable = SqlImplUtil.sqlChildren((PsiElement)((PsiElement)$this$hasMultipleGroupingSets));
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"sqlChildren(...)");
                    Iterable $this$any$iv = (Iterable)jBIterable;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            PsiElement[] psiElementArray;
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl2 = false;
                            IElementType type = PsiUtilCore.getElementType((PsiElement)it);
                            if (!(Intrinsics.areEqual((Object)type, (Object)SqlCommonKeywords.SQL_CUBE) || Intrinsics.areEqual((Object)type, (Object)SqlCommonKeywords.SQL_ROLLUP) || Intrinsics.areEqual((Object)type, (Object)SqlCommonKeywords.SQL_GROUPING) && !((psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)$this$hasMultipleGroupingSets), SqlExpression.class)) == null || psiElementArray.length == 0))) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            /*
             * WARNING - void declaration
             */
            private final void checkIfGroupedByPrimaryKey(SqlQueryExpression query) {
                Collection destination$iv;
                SqlTableExpression sqlTableExpression = query.getTableExpression();
                if (sqlTableExpression == null || (sqlTableExpression = sqlTableExpression.getFromClause()) == null) {
                    return;
                }
                SqlTableExpression fromClause = sqlTableExpression;
                SqlGroupByClause sqlGroupByClause = (SqlGroupByClause)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)query), SqlGroupByClause.class, (boolean)true, SqlQueryExpression.class);
                if (sqlGroupByClause == null) {
                    return;
                }
                SqlGroupByClause groupByClause = sqlGroupByClause;
                SqlExpression[] sqlExpressionArray = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)groupByClause), SqlExpression.class);
                if (sqlExpressionArray != null) {
                    void $this$mapNotNullTo$iv;
                    SqlExpression[] sqlExpressionArray2 = sqlExpressionArray;
                    destination$iv = new HashSet<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                    boolean $i$f$forEach = false;
                    int n = ((void)$this$forEach$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        DasTypedObject it$iv;
                        void element$iv$iv;
                        void element$iv = element$iv$iv = $this$forEach$iv$iv[i];
                        boolean bl = false;
                        void it = element$iv;
                        boolean bl2 = false;
                        SqlReferenceExpression sqlReferenceExpression = it instanceof SqlReferenceExpression ? (SqlReferenceExpression)it : null;
                        Object object = sqlReferenceExpression != null ? sqlReferenceExpression.resolve() : null;
                        if ((object instanceof DasTypedObject ? (DasTypedObject)object : null) == null) continue;
                        it$iv = it$iv;
                        boolean bl3 = false;
                        destination$iv.add(it$iv);
                    }
                } else {
                    return;
                }
                HashSet groupByColumns = (HashSet)destination$iv;
                if (groupByColumns.isEmpty()) {
                    return;
                }
                for (SqlReferenceExpression ref : PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)fromClause), SqlReferenceExpression.class)) {
                    boolean bl;
                    block11: {
                        Object primaryKeyColumns;
                        DasTable table;
                        PsiElement $i$f$mapNotNullTo;
                        if (!Intrinsics.areEqual((Object)ref.getReferenceElementType().getTargetKind(), (Object)ObjectKind.TABLE) || (($i$f$mapNotNullTo = ref.resolve()) instanceof DasTable ? (DasTable)$i$f$mapNotNullTo : null) == null) continue;
                        Object object = DasUtil.getPrimaryKey((DasTable)(table = table));
                        if (object == null || (object = object.getColumnsRef()) == null || (object = object.resolveObjects()) == null) {
                            return;
                        }
                        Object $this$any$iv = primaryKeyColumns = object;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            Iterator<T> iterator = $this$any$iv.iterator();
                            while (iterator.hasNext()) {
                                T element$iv = iterator.next();
                                DasTypedObject it = (DasTypedObject)element$iv;
                                boolean bl4 = false;
                                if (!(!groupByColumns.contains(it))) continue;
                                bl = true;
                                break block11;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    return;
                }
                ((Collection)this.getGroupByPrimaryKeys()).add(groupByClause);
            }

            /*
             * WARNING - void declaration
             */
            private final void processAggregate(SqlExpression e, SqlFunctionCallExpression aggregateCall) {
                block7: {
                    Object v5;
                    PsiElement psiElement;
                    block6: {
                        void $this$firstOrNull$iv;
                        PsiElement permittedClause2;
                        JBIterable jBIterable = SqlImplUtil.sqlParents((PsiElement)e.getParent()).takeWhile(arg_0 -> createAnnotationVisitor.1.processAggregate$lambda$11(createAnnotationVisitor.1::processAggregate$lambda$10, arg_0));
                        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"takeWhile(...)");
                        JBIterable parents = jBIterable;
                        psiElement = permittedClause2 = (PsiElement)parents.filter(arg_0 -> createAnnotationVisitor.1.processAggregate$lambda$12((Function1)new Function1<PsiElement, Boolean>((Object)this.$dialect){

                            public final Boolean invoke(PsiElement p0) {
                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                return ((SqlLanguageDialectEx)this.receiver).allowsAggregateCalls(p0);
                            }
                        }, arg_0)).first();
                        if (psiElement == null) {
                            PsiElement psiElement2 = (PsiElement)e;
                            String string = SqlBundle.message((String)"inspection.message.aggregate.calls.are.not.allowed.here", (Object[])new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            this.reportError(psiElement2, string);
                        } else if (psiElement instanceof SqlHavingClause || psiElement instanceof SqlSelectClause) {
                            HashSet<SqlClause> hashSet = this.getClausesWithAggregates();
                            PsiElement psiElement3 = permittedClause2;
                            Intrinsics.checkNotNull((Object)psiElement3, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlClause");
                            hashSet.add((SqlClause)psiElement3);
                        }
                        if (this.getHasAnalyticClause(aggregateCall) || this.$dbms.isOracle()) break block7;
                        Iterable iterable = (Iterable)parents;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl = false;
                            if (!(it instanceof SqlFunctionCallExpression && SqlPsiUtilCoreKt.isAggregateCall((SqlFunctionCallExpression)((SqlFunctionCallExpression)it)))) continue;
                            v5 = element$iv;
                            break block6;
                        }
                        v5 = null;
                    }
                    psiElement = v5;
                    if (psiElement != null) {
                        PsiElement it = psiElement;
                        boolean bl = false;
                        if (!this.getHasAnalyticClause((SqlFunctionCallExpression)it)) {
                            PsiElement psiElement4 = (PsiElement)e;
                            String string = SqlBundle.message((String)"inspection.message.nested.aggregate.calls.are.not.allowed", (Object[])new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            this.reportError(psiElement4, string);
                        }
                    }
                }
            }

            private final void reportError(PsiElement element, @InspectionMessage String message) {
                this.reportProblem(element, message, ProblemHighlightType.GENERIC_ERROR);
            }

            private final void reportWarning(PsiElement element, @InspectionMessage String message) {
                this.reportProblem(element, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }

            private final void reportProblem(PsiElement element, @InspectionMessage String message, ProblemHighlightType highlightType) {
                PsiElement psiElement = element instanceof SqlFunctionCallExpression ? (PsiElement)((SqlFunctionCallExpression)element).getNameElement() : element;
                if (psiElement == null) {
                    return;
                }
                PsiElement anchor = psiElement;
                this.addDescriptor(this.myManager.createProblemDescriptor(anchor, anchor, message, highlightType, this.$onTheFly, new LocalQuickFix[0]));
            }

            private static final HashSet clausesWithAggregates_delegate$lambda$0() {
                return new HashSet<E>();
            }

            private static final HashSet groupByPrimaryKeys_delegate$lambda$1() {
                return new HashSet<E>();
            }

            private static final boolean visitSqlReferenceExpression$lambda$2(PsiElement it) {
                return (!(it instanceof SqlFunctionCallExpression) || !SqlPsiUtilCoreKt.isAggregateCall((SqlFunctionCallExpression)((SqlFunctionCallExpression)it))) && !(it instanceof SqlQueryExpression);
            }

            private static final boolean visitSqlReferenceExpression$lambda$3(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final boolean visitSqlReferenceExpression$lambda$4(PsiElement it) {
                return it instanceof SqlHavingClause || it instanceof SqlOrderByClause;
            }

            private static final boolean visitSqlReferenceExpression$lambda$5(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final boolean processAggregate$lambda$10(PsiElement it) {
                return !(it instanceof SqlQueryExpression);
            }

            private static final boolean processAggregate$lambda$11(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final boolean processAggregate$lambda$12(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        };
    }
}

