/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.database.ConnDatabaseNotifications;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelExternalData;
import com.intellij.database.model.ModelExternalDataUtils;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.intentions.JoinUtilsKt;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J!\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\b\u0010\u0013\u001a\u00020\nH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/intentions/SqlAddExternalRelationIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "startInWriteAction", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlAddExternalRelationIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlAddExternalRelationIntention.kt\ncom/intellij/sql/intentions/SqlAddExternalRelationIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1586#2:63\n1661#2,3:64\n1586#2:67\n1661#2,3:68\n*S KotlinDebug\n*F\n+ 1 SqlAddExternalRelationIntention.kt\ncom/intellij/sql/intentions/SqlAddExternalRelationIntention\n*L\n46#1:63\n46#1:64,3\n48#1:67\n48#1:68,3\n*E\n"})
public final class SqlAddExternalRelationIntention
extends SqlBaseElementAtCaretIntentionAction
implements HighPriorityAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.store.table.relation", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Couple couple = JoinUtilsKt.getRelationInfo((PsiElement)element);
        if (couple == null) {
            return false;
        }
        Couple couple2 = couple;
        Pair t1 = (Pair)JoinUtilsKt.component1((Couple)couple2);
        Pair t2 = (Pair)JoinUtilsKt.component2((Couple)couple2);
        Object object = t1.getFirst();
        DbTable dbTable = object instanceof DbTable ? (DbTable)object : null;
        if (dbTable == null) {
            return false;
        }
        DbTable dbT1 = dbTable;
        Object object2 = t2.getFirst();
        DbTable dbTable2 = object2 instanceof DbTable ? (DbTable)object2 : null;
        if (dbTable2 == null) {
            return false;
        }
        DbTable dbT2 = dbTable2;
        if (!Intrinsics.areEqual((Object)dbT1.getDataSource(), (Object)dbT2.getDataSource()) || DbImplUtil.getMaybeLocalDataSource((DasDataSource)((DasDataSource)dbT1.getDataSource())) == null) {
            return false;
        }
        Set c1 = CollectionsKt.toSet((Iterable)((Iterable)t1.getSecond()));
        Set c2 = CollectionsKt.toSet((Iterable)((Iterable)t2.getSecond()));
        return ModelRelationManager.getForeignKeys((Project)project, (DasTable)((DasTable)dbT1), (DasTable)((DasTable)t2.getFirst())).filter(arg_0 -> SqlAddExternalRelationIntention.isAvailable$lambda$1(arg_0 -> SqlAddExternalRelationIntention.isAvailable$lambda$0(c1, c2, arg_0), arg_0)).isEmpty();
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Couple couple = JoinUtilsKt.getRelationInfo((PsiElement)element);
        if (couple == null) {
            return;
        }
        Couple info = couple;
        Object[] objectArray = ((Pair)info.first).getFirst();
        DbTable dbTable = objectArray instanceof DbTable ? (DbTable)objectArray : null;
        LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)((DasDataSource)(dbTable != null ? dbTable.getDataSource() : null)));
        if (localDataSource == null) {
            return;
        }
        LocalDataSource ds = localDataSource;
        ModelExternalDataUtils.modifyExternalData((Project)project, (LocalDataSource)ds, arg_0 -> SqlAddExternalRelationIntention.invoke$lambda$1(arg_0 -> SqlAddExternalRelationIntention.invoke$lambda$0(info, arg_0), arg_0));
        String path = ModelExternalData.getExternalDataPath((LocalDataSource)ds);
        if (path != null) {
            NotificationGroup notificationGroup = ConnDatabaseNotifications.GENERAL_BALLOON_GROUP();
            objectArray = new Object[]{((DasTable)((Pair)info.first).getFirst()).getName(), ((DasTable)((Pair)info.second).getFirst()).getName(), path};
            String string = SqlBundle.message((String)"notification.content.relation.between.stored.in", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            notificationGroup.createNotification(string, NotificationType.INFORMATION).setDisplayId("SqlAddExternalRelationIntention.stored").notify(project);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isAvailable$lambda$0(Set $c1, Set $c2, DasForeignKey fk) {
        Iterable iterable = fk.getColumnsRef().resolveObjects();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"resolveObjects(...)");
        if (!Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)iterable), (Object)$c1)) return false;
        Iterable iterable2 = fk.getRefColumns().resolveObjects();
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"resolveObjects(...)");
        if (!Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)iterable2), (Object)$c2)) return false;
        return true;
    }

    private static final boolean isAvailable$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit invoke$lambda$0(Couple $info, ModelExternalData.Data data) {
        Collection<String> collection;
        DasColumn it;
        Collection<String> collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = (Iterable)((Pair)$info.first).getSecond();
        String string = null;
        ObjectPath objectPath = ObjectPaths.of((DasObject)((DasObject)((Pair)$info.first).getFirst()));
        MultiMap multiMap = data.objSet;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DasColumn dasColumn = (DasColumn)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getName());
        }
        collection2 = (List)destination$iv$iv;
        $this$map$iv = (Iterable)((Pair)$info.second).getSecond();
        ObjectPath objectPath2 = ObjectPaths.of((DasObject)((DasObject)((Pair)$info.second).getFirst()));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (DasColumn)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        Collection<String> collection3 = collection = (List)destination$iv$iv;
        ObjectPath objectPath3 = objectPath2;
        Collection<String> collection4 = collection2;
        String string2 = string;
        multiMap.putValue((Object)objectPath, (Object)new ModelExternalData.FkDesc(string2, collection4, objectPath3, collection3));
        return Unit.INSTANCE;
    }

    private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

