/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;

public final class SpringBootReplacementTokenStorage {
    private final List<String> myTokens = new SmartList();

    public void deserialize(String input) {
        this.myTokens.clear();
        this.myTokens.addAll(StringUtil.split((String)input, (String)" "));
    }

    public String serialize() {
        return StringUtil.join(this.myTokens, (String)" ");
    }

    public List<String> getTokens() {
        return this.myTokens;
    }

    public List<Couple<String>> getReplacementTokens() {
        ArrayList<Couple<String>> tokenList = new ArrayList<Couple<String>>(this.myTokens.size());
        for (String value : this.myTokens) {
            if (StringUtil.isEmptyOrSpaces((String)value)) continue;
            if (StringUtil.containsChar((String)value, (char)'*')) {
                String prefix = StringUtil.substringBefore((String)value, (String)"*");
                String suffix = StringUtil.substringAfter((String)value, (String)"*");
                if (StringUtil.isEmptyOrSpaces((String)prefix) || StringUtil.isEmptyOrSpaces((String)suffix)) continue;
                tokenList.add((Couple<String>)Couple.of((Object)prefix, (Object)suffix));
                continue;
            }
            tokenList.add((Couple<String>)Couple.of((Object)value, (Object)value));
        }
        return tokenList;
    }
}

