/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.console.EelCoroutineService;
import com.intellij.database.console.JdbcConsoleRunContext;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.RemoteConsoleProcessSupport;
import com.intellij.database.console.ssh.DatabaseSshTunnelsManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactContext;
import com.intellij.database.remote.jdbc.RemoteDriverFactory;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelTunnelsApi;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.utils.IjentTunnelsUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.UShort;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\b\u001a\u00020\u0010H\u0014J\u0015\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0002H\u0014J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\"\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J \u0010!\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u0003H\u0014J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020\u0002H\u0014J$\u0010&\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0014J\u001c\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00020(2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0002J*\u0010-\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020/0.2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00022\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0014J\u0010\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020,H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00062"}, d2={"Lcom/intellij/database/console/JdbcRemoteConsoleProcessSupport;", "Lcom/intellij/database/console/RemoteConsoleProcessSupport;", "Lcom/intellij/database/dataSource/LocalDataSource;", "Lcom/intellij/database/remote/jdbc/RemoteDriverFactory;", "project", "Lcom/intellij/openapi/project/Project;", "mySshManager", "Lcom/intellij/database/console/ssh/DatabaseSshTunnelsManager;", "fireModificationCountChanged", "Ljava/lang/Runnable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/console/ssh/DatabaseSshTunnelsManager;Ljava/lang/Runnable;)V", "eel", "Lcom/intellij/platform/eel/EelApi;", "getEel", "()Lcom/intellij/platform/eel/EelApi;", "", "getName", "", "Lorg/jetbrains/annotations/NotNull;", "target", "createRunContext", "Lcom/intellij/database/run/ConsoleRunConfiguration$RunContext;", "getRunProfileState", "Lcom/intellij/execution/configurations/RunProfileState;", "configuration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "executor", "Lcom/intellij/execution/Executor;", "acquire", "dataSource", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "onCreated", "result", "publishPort", "", "port", "logText", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "passDebuggerAttachMessage", "", "acquireInProcessFactory", "Lcom/intellij/openapi/util/ThrowableComputable;", "Ljava/lang/Exception;", "stopAll", "waitFor", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nJdbcRemoteConsoleProcessSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcRemoteConsoleProcessSupport.kt\ncom/intellij/database/console/JdbcRemoteConsoleProcessSupport\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,101:1\n30#2,2:102\n106#3:104\n78#3,29:105\n*S KotlinDebug\n*F\n+ 1 JdbcRemoteConsoleProcessSupport.kt\ncom/intellij/database/console/JdbcRemoteConsoleProcessSupport\n*L\n66#1:102,2\n77#1:104\n77#1:105,29\n*E\n"})
public final class JdbcRemoteConsoleProcessSupport
extends RemoteConsoleProcessSupport<LocalDataSource, RemoteDriverFactory> {
    @NotNull
    private final Project project;
    @NotNull
    private final DatabaseSshTunnelsManager mySshManager;
    @NotNull
    private final Runnable fireModificationCountChanged;

    public JdbcRemoteConsoleProcessSupport(@NotNull Project project, @NotNull DatabaseSshTunnelsManager mySshManager, @NotNull Runnable fireModificationCountChanged) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mySshManager, (String)"mySshManager");
        Intrinsics.checkNotNullParameter((Object)fireModificationCountChanged, (String)"fireModificationCountChanged");
        super(RemoteDriverFactory.class);
        this.project = project;
        this.mySshManager = mySshManager;
        this.fireModificationCountChanged = fireModificationCountChanged;
    }

    private final EelApi getEel() {
        return EelProviderUtil.toEelApiBlocking((EelDescriptor)EelProviderUtil.getEelDescriptor((Project)this.project));
    }

    protected void fireModificationCountChanged() {
        this.fireModificationCountChanged.run();
    }

    @NotNull
    protected String getName(@NotNull LocalDataSource target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        String string = target.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Override
    @NotNull
    protected ConsoleRunConfiguration.RunContext createRunContext(@NotNull LocalDataSource target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new JdbcConsoleRunContext(target, this.project);
    }

    @Override
    @NotNull
    protected RunProfileState getRunProfileState(@NotNull LocalDataSource target, @NotNull ConsoleRunConfiguration configuration, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        RunProfileState state = super.getRunProfileState(target, configuration, executor);
        this.mySshManager.createTunnels(target);
        Intrinsics.checkNotNull((Object)state);
        return state;
    }

    @Override
    @NotNull
    public RemoteDriverFactory acquire(@NotNull LocalDataSource dataSource, @NotNull ConsoleRunConfiguration configuration, @Nullable ProgressIndicator indicator) throws Exception {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        RemoteDriverFactory driverFactory = (RemoteDriverFactory)super.acquire(dataSource, configuration, indicator);
        this.mySshManager.validateSshTunnels(dataSource);
        Intrinsics.checkNotNull((Object)driverFactory);
        return driverFactory;
    }

    protected void onCreated(@NotNull LocalDataSource dataSource, @NotNull ConsoleRunConfiguration configuration, @NotNull RemoteDriverFactory result) throws Exception {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        MessageBus messageBus = this.project.getMessageBus();
        Topic<JdbcDriverManager.Listener> topic = JdbcDriverManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        ((JdbcDriverManager.Listener)messageBus.syncPublisher(topic)).onStarted(dataSource, configuration);
    }

    protected int publishPort(int port, @NotNull LocalDataSource target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        boolean useEel = DatabaseArtifactContext.Companion.getInstance(this.project, target).useEel();
        if (!useEel) {
            return super.publishPort(port, (Object)target);
        }
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<EelCoroutineService> serviceClass$iv = EelCoroutineService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        CoroutineScope coroutineScope = ((EelCoroutineService)object).getCoroutineScope();
        EelTunnelsApi eelTunnelsApi = this.getEel().getTunnels();
        EelTunnelsApi.HostAddress.Builder builder = EelTunnelsApi.HostAddress.Companion.Builder-xj2QHRw(UShort.constructor-impl((short)((short)port)));
        String string = this.getRemoteHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRemoteHost(...)");
        IjentTunnelsUtil.forwardLocalPort((CoroutineScope)coroutineScope, (EelTunnelsApi)eelTunnelsApi, (int)port, (EelTunnelsApi.HostAddress)builder.hostname(string).build());
        return port;
    }

    /*
     * WARNING - void declaration
     */
    protected void logText(@NotNull ConsoleRunConfiguration configuration, @NotNull ProcessEvent event, @NotNull Key<?> outputType) {
        String text;
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        if (this.passDebuggerAttachMessage(event, outputType)) {
            return;
        }
        String string = event.getText();
        if (string == null) {
            string = text = "";
        }
        if (outputType == ProcessOutputTypes.STDERR) {
            void $this$trim$iv;
            String string2 = text;
            Logger logger = RemoteConsoleProcessSupport.LOG;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            logger.warn(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
        } else {
            String $this$trim$iv = text;
            Logger logger = RemoteConsoleProcessSupport.LOG;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim3 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            logger.info(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
        }
    }

    private final boolean passDebuggerAttachMessage(ProcessEvent event, Key<?> outputType) {
        if (outputType != ProcessOutputTypes.STDOUT) {
            return false;
        }
        String string = event.getText();
        if (string == null) {
            return false;
        }
        String text = string;
        if (!StringsKt.startsWith$default((String)text, (String)"Listening for transport ", (boolean)false, (int)2, null) || !StringsKt.contains$default((CharSequence)text, (CharSequence)" at address: ", (boolean)false, (int)2, null)) {
            return false;
        }
        System.out.println((Object)("Remote JDBC process is ready for debug: " + text));
        return true;
    }

    @Override
    @NotNull
    protected ThrowableComputable<RemoteDriverFactory, Exception> acquireInProcessFactory(@Nullable LocalDataSource target, @Nullable ConsoleRunConfiguration configuration) throws Exception {
        ThrowableComputable throwableComputable = super.acquireInProcessFactory(target, configuration);
        Intrinsics.checkNotNullExpressionValue(throwableComputable, (String)"acquireInProcessFactory(...)");
        ThrowableComputable res = throwableComputable;
        LocalDataSource localDataSource = target;
        Intrinsics.checkNotNull((Object)localDataSource);
        this.mySshManager.createTunnels(localDataSource);
        return res;
    }

    public void stopAll(boolean waitFor2) {
        super.stopAll(waitFor2);
        this.mySshManager.destroyAllTunnels();
    }
}

