/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.history;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.history.DataSourceFromHistoryKt;
import com.intellij.database.dataSource.history.StateHolder;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\fB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\b\u0010\u000fJ\u0006\u0010\u0014\u001a\u00020\u000bJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u0017\u001a\u00020\u0016J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\u0018\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/dataSource/history/DataSourceFromHistory;", "", "project", "Lcom/intellij/openapi/project/Project;", "uniqueId", "", "isRemovedFromProject", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Z)V", "state", "Lorg/jdom/Element;", "(Lcom/intellij/openapi/project/Project;Lorg/jdom/Element;Z)V", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;)V", "getUniqueId", "()Ljava/lang/String;", "stateHolder", "Lcom/intellij/database/dataSource/history/StateHolder;", "getState", "bindProjectDataSource", "", "unbindProjectDataSource", "getDataSource", "Companion", "intellij.database.connectivity"})
public final class DataSourceFromHistory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String uniqueId;
    private boolean isRemovedFromProject;
    private StateHolder stateHolder;

    private DataSourceFromHistory(Project project, String uniqueId, boolean isRemovedFromProject) {
        this.project = project;
        this.uniqueId = uniqueId;
        this.isRemovedFromProject = isRemovedFromProject;
    }

    @NotNull
    public final String getUniqueId() {
        return this.uniqueId;
    }

    public DataSourceFromHistory(@NotNull Project project, @NotNull Element state, boolean isRemovedFromProject) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        String string = StringKt.nullize((String)state.getAttributeValue("uuid"), (boolean)true);
        Intrinsics.checkNotNull((Object)string);
        this(project, string, isRemovedFromProject);
        this.stateHolder = StateHolder.Companion.create(project, state);
    }

    public DataSourceFromHistory(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        String string = dataSource.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        this(project, string, false);
        this.stateHolder = StateHolder.Companion.create(project, dataSource);
    }

    @NotNull
    public final Element getState() {
        Element element = new Element("DataSourceFromHistory");
        element.setAttribute("isRemovedFromProject", String.valueOf(this.isRemovedFromProject));
        StateHolder stateHolder = this.stateHolder;
        if (stateHolder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stateHolder");
            stateHolder = null;
        }
        stateHolder.writeStateTo(element);
        return element;
    }

    public final void bindProjectDataSource(@NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        this.stateHolder = StateHolder.Companion.create(this.project, dataSource);
        this.isRemovedFromProject = false;
    }

    public final void unbindProjectDataSource() {
        List list = this.getState().getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        Object object = CollectionsKt.first((List)list);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jdom.Element");
        this.stateHolder = StateHolder.Companion.create(this.project, (Element)object);
        this.isRemovedFromProject = true;
    }

    public final boolean isRemovedFromProject() {
        return this.isRemovedFromProject;
    }

    @NotNull
    public final LocalDataSource getDataSource() {
        StateHolder stateHolder = this.stateHolder;
        if (stateHolder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stateHolder");
            stateHolder = null;
        }
        return stateHolder.resolveDataSource();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dataSource/history/DataSourceFromHistory$Companion;", "", "<init>", "()V", "splitOnDataSourcesState", "", "Lcom/intellij/database/dataSource/history/DataSourceFromHistory;", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lorg/jdom/Element;", "intellij.database.connectivity"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<DataSourceFromHistory> splitOnDataSourcesState(@NotNull Project project, @NotNull Element state) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            List result = new ArrayList();
            for (Content content : state.getContent()) {
                Boolean isRemovedFromProject;
                if (!(content instanceof Element) || !Intrinsics.areEqual((Object)((Element)content).getName(), (Object)"DataSourceFromHistory")) {
                    DataSourceFromHistoryKt.access$getLog$p().warn("Unexpected content: " + content.getClass().getName());
                    continue;
                }
                String string = ((Element)content).getAttributeValue("isRemovedFromProject");
                Boolean bl = isRemovedFromProject = string != null ? Boolean.valueOf(Boolean.parseBoolean(string)) : null;
                if (isRemovedFromProject == null) {
                    DataSourceFromHistoryKt.access$getLog$p().warn("Missing attribute: isRemovedFromProject");
                    continue;
                }
                List list = ((Element)content).getContent();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
                Content dsState = (Content)CollectionsKt.firstOrNull((List)list);
                if (dsState == null || !(dsState instanceof Element)) {
                    DataSourceFromHistoryKt.access$getLog$p().warn("No data source state");
                    continue;
                }
                result.add(new DataSourceFromHistory(project, (Element)dsState, (boolean)isRemovedFromProject));
            }
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

