/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.audit;

import com.intellij.database.ConnDatabaseNotifications;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.connection.throwable.info.WarningInfo;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.audit.MeasuringDataAuditor;
import com.intellij.database.run.session.LogView;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.ide.ui.IdeUiService;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.content.Content;
import com.intellij.util.ModalityUiUtil;
import java.lang.ref.WeakReference;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SessionLogger
extends MeasuringDataAuditor {
    protected final LogView<?> myView;

    public SessionLogger(@NotNull LogView<?> view) {
        if (view == null) {
            SessionLogger.$$$reportNull$$$0(0);
        }
        this.myView = view;
    }

    public void jobSubmitted(@NotNull DataRequest request2, @NotNull DataProducer producer) {
        if (request2 == null) {
            SessionLogger.$$$reportNull$$$0(1);
        }
        if (producer == null) {
            SessionLogger.$$$reportNull$$$0(2);
        }
        super.jobSubmitted(request2, producer);
        if (!this.skipJob(request2)) {
            this.showView(request2);
        }
    }

    protected boolean skipJob(@NotNull DataRequest request2) {
        if (request2 == null) {
            SessionLogger.$$$reportNull$$$0(3);
        }
        return false;
    }

    public void print(@NotNull DataRequest.Context context, @NlsSafe @Nullable String message) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)message)) {
            return;
        }
        this.myView.getHistoryLogger().print(context, message);
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myView.getProject());
        if (statusBar != null) {
            statusBar.setInfo(message, this.myView.getController().id());
        }
    }

    public void warn(@NotNull DataRequest.Context context, @NotNull WarningInfo warningInfo) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(5);
        }
        if (warningInfo == null) {
            SessionLogger.$$$reportNull$$$0(6);
        }
        this.myView.getHistoryLogger().warn(context, warningInfo);
        this.bringAttentionToOutput(context, LogView.OutputType.QUERY_OUTPUT);
    }

    @Override
    public void error(@NotNull DataRequest.Context context, @NotNull ErrorInfo errorInfo) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(7);
        }
        if (errorInfo == null) {
            SessionLogger.$$$reportNull$$$0(8);
        }
        super.error(context, errorInfo);
        this.myView.getHistoryLogger().error(context, errorInfo);
        this.bringAttentionToOutput(context, LogView.OutputType.ERROR);
    }

    @Override
    public void beforeStatement(@NotNull DataRequest.Context context) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(9);
        }
        super.beforeStatement(context);
        this.myView.addRequestToHistory(context);
    }

    @Override
    protected void bringAttentionToOutput(@NotNull DataRequest.Context context, @Nullable LogView.OutputType outputType) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(10);
        }
        DbImplUtilCore.invokeLaterIfNeeded(() -> {
            Object owner = this.myView.getTarget();
            if (!owner.isValid()) {
                return;
            }
            boolean focusOnError = this.shouldFocusOnError(context);
            boolean wasShowing = this.myView.isShowing();
            boolean isError = outputType == LogView.OutputType.ERROR;
            Runnable runnable = () -> {
                boolean focus;
                if (!owner.isValid()) {
                    return;
                }
                Content content = this.myView.getOutputContent();
                if (content == null) {
                    return;
                }
                this.myView.getUi().setBouncing(content, true);
                boolean bl = focus = !wasShowing || isError && focusOnError;
                if (!focus) {
                    return;
                }
                this.myView.getUi().selectAndFocus(content, false, false);
                this.myView.getHistoryLogger().scrollToEnd();
            };
            if (this.shouldShowOnAttention(context)) {
                this.myView.show(this.shouldActivate(context.request), false, outputType).onSuccess(__ -> DbImplUtilCore.invokeLaterIfNeeded((Runnable)runnable));
                return;
            }
            runnable.run();
        });
    }

    @Override
    protected void bringAttentionByNotification(@NotNull DataRequest.Context context) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(11);
        }
        MeasuringDataAuditor.Stat queryStat = this.getStat(context);
        boolean hasErrors = queryStat.errorCount > 0L;
        NotificationType type = hasErrors ? NotificationType.ERROR : NotificationType.INFORMATION;
        String query = context.getQuery();
        String text = DatabaseBundle.message((String)"notification.content.choice.request.href.choice.failed.completed", (Object[])new Object[]{StringUtil.trimMiddle((String)query, (int)60), query.isEmpty() ? 0 : 1, hasErrors ? 0 : 1});
        SessionLogger.fireBackToConsoleNotification(this.myView, type, text);
    }

    protected boolean shouldFocusOnError(@NotNull DataRequest.Context context) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(12);
        }
        return true;
    }

    protected boolean shouldShowOnAttention(@NotNull DataRequest.Context context) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(13);
        }
        return false;
    }

    private static void fireBackToConsoleNotification(@NotNull LogView<?> view, @NotNull NotificationType type, @NlsContexts.NotificationContent @NotNull String text) {
        if (view == null) {
            SessionLogger.$$$reportNull$$$0(14);
        }
        if (type == null) {
            SessionLogger.$$$reportNull$$$0(15);
        }
        if (text == null) {
            SessionLogger.$$$reportNull$$$0(16);
        }
        String title = view.getTitle();
        final WeakReference viewRef = new WeakReference(view);
        ConnDatabaseNotifications.DATABASE_LONG_RUNNING_GROUP().createNotification(title, text, type).setListener((NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                LogView view;
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((view = (LogView)viewRef.get()) != null) {
                    view.show(true, false);
                } else {
                    notification.expire();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/run/audit/SessionLogger$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).setDisplayId("SessionLogger.query.finished").notify(view.getProject());
        IdeUiService.getInstance().systemNotify(title, text);
    }

    private void showView(@NotNull DataRequest request2) {
        if (request2 == null) {
            SessionLogger.$$$reportNull$$$0(17);
        }
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
            if (!this.myView.getTarget().isValid()) {
                return;
            }
            if (this.myView.getContent().getManager() == null) {
                this.myView.show(this.shouldActivate(request2), false, LogView.OutputType.LOG);
            }
        });
    }

    protected boolean shouldActivate(@NotNull DataRequest request2) {
        if (request2 == null) {
            SessionLogger.$$$reportNull$$$0(18);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: 
            case 3: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warningInfo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/audit/SessionLogger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "jobSubmitted";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "skipJob";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "print";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "warn";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeStatement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "bringAttentionToOutput";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "bringAttentionByNotification";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldFocusOnError";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldShowOnAttention";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "fireBackToConsoleNotification";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "showView";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldActivate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

