/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.dev.export;

import com.intellij.code.provenance.AuthorshipExportHandler;
import com.intellij.code.provenance.core.ProvenanceRegistry;
import com.intellij.code.provenance.core.events.utils.UtilsKt;
import com.intellij.code.provenance.dev.ProvenanceDevBundle;
import com.intellij.code.provenance.dev.ProvenanceDevRegistry;
import com.intellij.code.provenance.dev.export.DevAuthorshipExportHandler;
import com.intellij.code.provenance.dev.report.Report_builderKt;
import com.intellij.code.provenance.info.ChangedAuthorshipInfo;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J&\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000bH\u0082@\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/code/provenance/dev/export/DevAuthorshipExportHandler;", "Lcom/intellij/code/provenance/AuthorshipExportHandler;", "<init>", "()V", "exportAuthorship", "", "project", "Lcom/intellij/openapi/project/Project;", "eventName", "", "startTs", "", "endTs", "authorshipInfo", "", "Lcom/intellij/code/provenance/info/ChangedAuthorshipInfo;", "createScratchFile", "content", "timestamp", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.code.provenance.dev"})
public final class DevAuthorshipExportHandler
implements AuthorshipExportHandler {
    public void exportAuthorship(@NotNull Project project, @NotNull String eventName, long startTs, long endTs, @NotNull List<? extends ChangedAuthorshipInfo> authorshipInfo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Intrinsics.checkNotNullParameter(authorshipInfo, (String)"authorshipInfo");
        if (!ProvenanceRegistry.INSTANCE.isProvenanceEnabled() || !ProvenanceDevRegistry.INSTANCE.getShouldExportAnonymousAuthorshipOnVcs()) {
            return;
        }
        UtilsKt.runInSuspendContext((Project)project, (String)ProvenanceDevBundle.INSTANCE.message("provenance.dev.export.authorship.branch.switch.progress.title", new Object[0]), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(authorshipInfo, startTs, endTs, eventName, this, project, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ List<ChangedAuthorshipInfo> $authorshipInfo;
            final /* synthetic */ long $startTs;
            final /* synthetic */ long $endTs;
            final /* synthetic */ String $eventName;
            final /* synthetic */ DevAuthorshipExportHandler this$0;
            final /* synthetic */ Project $project;
            {
                this.$authorshipInfo = $authorshipInfo;
                this.$startTs = $startTs;
                this.$endTs = $endTs;
                this.$eventName = $eventName;
                this.this$0 = $receiver;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$filterNotTo$iv$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        Iterable $this$filterNot$iv = this.$authorshipInfo;
                        boolean $i$f$filterNot = false;
                        Iterable iterable = $this$filterNot$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterNotTo = false;
                        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                            ChangedAuthorshipInfo it = (ChangedAuthorshipInfo)element$iv$iv;
                            boolean bl = false;
                            if (ScratchUtil.isScratch((VirtualFile)it.getVirtualFile())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List authorshipInfoList = (List)destination$iv$iv;
                        String content = Report_builderKt.buildAuthorshipReport(authorshipInfoList, this.$startTs, this.$endTs, "Code Authorship Report - Context Switch Event", "Context Switch Event: " + this.$eventName);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)authorshipInfoList);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)content);
                        this.label = 1;
                        Object object2 = DevAuthorshipExportHandler.access$createScratchFile(this.this$0, this.$project, content, this.$endTs, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        String content = (String)this.L$1;
                        List authorshipInfoList = (List)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final Object createScratchFile(Project project, String content, long timestamp, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(timestamp, content, project, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ long $timestamp;
            final /* synthetic */ String $content;
            final /* synthetic */ Project $project;
            {
                this.$timestamp = $timestamp;
                this.$content = $content;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss", Locale.getDefault());
                        String fileName = "authorship-report-" + dateFormat.format(new Date(this.$timestamp)) + ".txt";
                        VirtualFile virtualFile = ScratchFileService.getInstance().findFile((RootType)ScratchRootType.getInstance(), fileName, ScratchFileService.Option.create_if_missing);
                        if (virtualFile == null) {
                            return Unit.INSTANCE;
                        }
                        VirtualFile scratchFile = virtualFile;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)dateFormat);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)fileName);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)scratchFile);
                        this.label = 1;
                        Object object2 = CoroutinesKt.edtWriteAction(() -> createScratchFile.2.invokeSuspend$lambda$0(scratchFile, this.$content, this.$project), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        VirtualFile scratchFile = (VirtualFile)this.L$2;
                        String fileName = (String)this.L$1;
                        SimpleDateFormat dateFormat = (SimpleDateFormat)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final FileEditor[] invokeSuspend$lambda$0(VirtualFile $scratchFile, String $content, Project $project) {
                byte[] byArray = $content.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                $scratchFile.setBinaryContent(byArray);
                return FileEditorManager.getInstance((Project)$project).openFile($scratchFile, true);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$createScratchFile(DevAuthorshipExportHandler $this, Project project, String content, long timestamp, Continuation $completion) {
        return $this.createScratchFile(project, content, timestamp, (Continuation<? super Unit>)$completion);
    }
}

