/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import com.intellij.openapi.roots.impl.RootFileValidityChecker;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSet;
import com.intellij.openapi.vfs.VirtualFileSetFactory;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.Stack;
import com.intellij.workspaceModel.core.fileIndex.impl.FileTypeAssocTableUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

@ApiStatus.Internal
public final class RootIndex {
    static final Comparator<OrderEntry> BY_OWNER_MODULE = (o1, o2) -> {
        String name1 = o1.getOwnerModule().getName();
        String name2 = o2.getOwnerModule().getName();
        return name1.compareTo(name2);
    };
    private static final Logger LOG = Logger.getInstance(RootIndex.class);
    private static final FileTypeRegistry ourFileTypes = FileTypeRegistry.getInstance();
    @NotNull
    private final Project myProject;
    private final Lazy<OrderEntryGraph> myOrderEntryGraphLazy;

    public RootIndex(@NotNull Project project, @Nullable OrderEntryGraph graph) {
        if (project == null) {
            RootIndex.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myOrderEntryGraphLazy = graph == null ? LazyKt.lazy(() -> this.calculateOrderEntryGraph()) : LazyKt.lazyOf((Object)graph);
    }

    RootIndex(@NotNull Project project) {
        WorkspaceModelTopics workspaceModelTopics;
        if (project == null) {
            RootIndex.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        ThreadingAssertions.assertReadAccess();
        if (project.isDefault()) {
            LOG.error("Directory index may not be queried for default project");
        }
        if ((workspaceModelTopics = (WorkspaceModelTopics)project.getService(WorkspaceModelTopics.class)) != null) {
            LOG.assertTrue(workspaceModelTopics.getModulesAreLoaded(), (Object)"Directory index can only be queried after project initialization");
        }
        this.myOrderEntryGraphLazy = LazyKt.lazy(() -> this.calculateOrderEntryGraph());
    }

    /*
     * Could not resolve type clashes
     */
    @NotNull
    private RootInfo buildRootInfo(@NotNull Project project) {
        Sdk sdk;
        if (project == null) {
            RootIndex.$$$reportNull$$$0(2);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Start building root info " + String.valueOf(Thread.currentThread()));
        }
        RootInfo info = new RootInfo();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        boolean includeProjectJdk = true;
        for (Module module : moduleManager.getModules()) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            for (ContentEntry contentEntry : moduleRootManager.getContentEntries()) {
                for (Object excludeRoot : contentEntry.getExcludeFolderFiles()) {
                    if (!RootIndex.ensureValid((VirtualFile)excludeRoot, contentEntry)) continue;
                    info.excludedFromModule.put((VirtualFile)excludeRoot, module);
                }
                VirtualFile contentRoot = contentEntry.getFile();
                if (contentRoot != null && RootIndex.ensureValid(contentRoot, module)) {
                    List patterns;
                    if (!info.contentRootOf.containsKey(contentRoot)) {
                        info.contentRootOf.put(contentRoot, module);
                    }
                    if (!(patterns = contentEntry.getExcludePatterns()).isEmpty()) {
                        Object excludeRoot;
                        FileTypeAssocTable table = FileTypeAssocTableUtil.newScalableFileTypeAssocTable();
                        excludeRoot = patterns.iterator();
                        while (excludeRoot.hasNext()) {
                            String pattern = (String)excludeRoot.next();
                            table.addAssociation(FileNameMatcherFactory.getInstance().createMatcher(pattern), (Object)Boolean.TRUE);
                        }
                        info.excludeFromContentRootTables.put(contentRoot, table);
                    }
                }
                for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
                    VirtualFile sourceFolderRoot = sourceFolder.getFile();
                    if (sourceFolderRoot == null || !RootIndex.ensureValid(sourceFolderRoot, sourceFolder)) continue;
                    info.classAndSourceRoots.add(sourceFolderRoot);
                    info.sourceRootOf.putValue((Object)sourceFolderRoot, (Object)module);
                }
            }
            for (ContentEntry orderEntry : moduleRootManager.getOrderEntries()) {
                if (!(orderEntry instanceof LibraryOrSdkOrderEntry)) continue;
                LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
                VirtualFile[] sourceRoots = entry.getRootFiles(OrderRootType.SOURCES);
                VirtualFile[] classRoots = entry.getRootFiles(OrderRootType.CLASSES);
                RootIndex.fillIndexWithLibraryRoots(info, entry, sourceRoots, classRoots);
                if (orderEntry instanceof LibraryOrderEntry) {
                    Library library = ((LibraryOrderEntry)orderEntry).getLibrary();
                    if (library == null) continue;
                    for (VirtualFile root : ((LibraryEx)library).getExcludedRoots()) {
                        if (!RootIndex.ensureValid(root, library)) continue;
                        info.excludedFromLibraries.putValue((Object)root, (Object)library);
                    }
                    for (VirtualFile root : sourceRoots) {
                        if (!RootIndex.ensureValid(root, library)) continue;
                        info.sourceOfLibraries.putValue((Object)root, (Object)library);
                    }
                    for (VirtualFile root : classRoots) {
                        if (!RootIndex.ensureValid(root, library)) continue;
                        info.classOfLibraries.putValue((Object)root, (Object)library);
                    }
                    continue;
                }
                includeProjectJdk = false;
            }
        }
        if (includeProjectJdk && (sdk = ProjectRootManager.getInstance((Project)project).getProjectSdk()) != null) {
            RootIndex.fillIndexWithLibraryRoots(info, sdk, sdk.getRootProvider().getFiles(OrderRootType.SOURCES), sdk.getRootProvider().getFiles(OrderRootType.CLASSES));
        }
        for (AdditionalLibraryRootsProvider provider : AdditionalLibraryRootsProvider.EP_NAME.getExtensionList()) {
            Collection libraries = provider.getAdditionalProjectLibraries(project);
            for (SyntheticLibrary library : libraries) {
                for (VirtualFile sourceRoot : library.getSourceRoots()) {
                    if ((sourceRoot = RootFileValidityChecker.correctRoot(sourceRoot, library, provider)) == null) continue;
                    info.libraryOrSdkSources.add(sourceRoot);
                    info.classAndSourceRoots.add(sourceRoot);
                    info.sourceOfLibraries.putValue((Object)sourceRoot, (Object)library);
                }
                for (VirtualFile classRoot : library.getBinaryRoots()) {
                    if ((classRoot = RootFileValidityChecker.correctRoot(classRoot, library, provider)) == null) continue;
                    info.libraryOrSdkClasses.add(classRoot);
                    info.classAndSourceRoots.add(classRoot);
                    info.classOfLibraries.putValue((Object)classRoot, (Object)library);
                }
                for (VirtualFile file2 : library.getExcludedRoots()) {
                    if ((file2 = RootFileValidityChecker.correctRoot(file2, library, provider)) == null) continue;
                    info.excludedFromLibraries.putValue((Object)file2, (Object)library);
                }
            }
        }
        for (DirectoryIndexExcludePolicy policy : DirectoryIndexExcludePolicy.EP_NAME.getExtensions((AreaInstance)project)) {
            List files = ContainerUtil.mapNotNull((Object[])policy.getExcludeUrlsForProject(), url -> VirtualFileManager.getInstance().findFileByUrl(url));
            info.excludedFromProject.addAll(ContainerUtil.filter((Collection)files, file -> RootFileValidityChecker.ensureValid(file, project, policy)));
            Function<Sdk, List<VirtualFile>> fun = policy.getExcludeSdkRootsStrategy();
            if (fun == null) continue;
            Set<Sdk> sdks = this.collectSdks();
            Set<VirtualFile> roots = RootIndex.collectSdkClasses(sdks);
            for (Sdk sdk2 : sdks) {
                for (VirtualFile file3 : (List)fun.fun((Object)sdk2)) {
                    if (roots.contains(file3)) continue;
                    ContainerUtil.addIfNotNull(info.excludedFromSdkRoots, (Object)RootFileValidityChecker.correctRoot(file3, sdk2, policy));
                }
            }
        }
        for (UnloadedModuleDescription description : moduleManager.getUnloadedModuleDescriptions()) {
            for (VirtualFilePointer contentRootPointer : description.getContentRoots()) {
                VirtualFile contentRoot = contentRootPointer.getFile();
                if (contentRoot == null || !RootIndex.ensureValid(contentRoot, description)) continue;
                info.contentRootOfUnloaded.put(contentRoot, description.getName());
            }
        }
        RootInfo rootInfo = info;
        if (rootInfo == null) {
            RootIndex.$$$reportNull$$$0(3);
        }
        return rootInfo;
    }

    @NotNull
    private static Set<VirtualFile> collectSdkClasses(@NotNull Set<? extends Sdk> sdks) {
        if (sdks == null) {
            RootIndex.$$$reportNull$$$0(4);
        }
        HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
        for (Sdk sdk : sdks) {
            roots.addAll(Arrays.asList(sdk.getRootProvider().getFiles(OrderRootType.CLASSES)));
        }
        HashSet<VirtualFile> hashSet = roots;
        if (hashSet == null) {
            RootIndex.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @NotNull
    private Set<Sdk> collectSdks() {
        HashSet<Sdk> sdks = new HashSet<Sdk>();
        for (Module m : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            Sdk sdk = ModuleRootManager.getInstance((Module)m).getSdk();
            if (sdk == null) continue;
            sdks.add(sdk);
        }
        HashSet<Sdk> hashSet = sdks;
        if (hashSet == null) {
            RootIndex.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    private static void fillIndexWithLibraryRoots(@NotNull RootInfo info, @NotNull Object container, VirtualFile @NotNull [] sourceRoots, VirtualFile @NotNull [] classRoots) {
        if (info == null) {
            RootIndex.$$$reportNull$$$0(7);
        }
        if (container == null) {
            RootIndex.$$$reportNull$$$0(8);
        }
        if (sourceRoots == null) {
            RootIndex.$$$reportNull$$$0(9);
        }
        if (classRoots == null) {
            RootIndex.$$$reportNull$$$0(10);
        }
        for (VirtualFile sourceRoot : sourceRoots) {
            if (!RootIndex.ensureValid(sourceRoot, container)) continue;
            info.classAndSourceRoots.add(sourceRoot);
            info.libraryOrSdkSources.add(sourceRoot);
        }
        for (VirtualFile classRoot : classRoots) {
            if (!RootIndex.ensureValid(classRoot, container)) continue;
            info.classAndSourceRoots.add(classRoot);
            info.libraryOrSdkClasses.add(classRoot);
        }
    }

    private static boolean ensureValid(@NotNull VirtualFile file, @NotNull Object container) {
        if (file == null) {
            RootIndex.$$$reportNull$$$0(11);
        }
        if (container == null) {
            RootIndex.$$$reportNull$$$0(12);
        }
        return RootFileValidityChecker.ensureValid(file, container, null);
    }

    @ApiStatus.Internal
    @NotNull
    public OrderEntryGraph getOrderEntryGraph() {
        OrderEntryGraph orderEntryGraph = (OrderEntryGraph)this.myOrderEntryGraphLazy.getValue();
        if (orderEntryGraph == null) {
            RootIndex.$$$reportNull$$$0(13);
        }
        return orderEntryGraph;
    }

    @NotNull
    private OrderEntryGraph calculateOrderEntryGraph() {
        RootInfo rootInfo = this.buildRootInfo(this.myProject);
        Couple<@NotNull MultiMap<VirtualFile, OrderEntry>> pair = this.initLibraryClassSourceRoots();
        return new OrderEntryGraph(this.myProject, rootInfo, (MultiMap<VirtualFile, OrderEntry>)((MultiMap)pair.first), (MultiMap<VirtualFile, OrderEntry>)((MultiMap)pair.second));
    }

    @NotNull
    private @NotNull Couple<@NotNull MultiMap<VirtualFile, OrderEntry>> initLibraryClassSourceRoots() {
        MultiMap libClassRootEntries = new MultiMap();
        MultiMap libSourceRootEntries = new MultiMap();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
                if (!(orderEntry instanceof LibraryOrSdkOrderEntry)) continue;
                LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
                for (VirtualFile sourceRoot : entry.getRootFiles(OrderRootType.SOURCES)) {
                    libSourceRootEntries.putValue((Object)sourceRoot, (Object)orderEntry);
                }
                for (VirtualFile classRoot : entry.getRootFiles(OrderRootType.CLASSES)) {
                    libClassRootEntries.putValue((Object)classRoot, (Object)orderEntry);
                }
            }
        }
        Couple couple = Couple.of((Object)libClassRootEntries, (Object)libSourceRootEntries);
        if (couple == null) {
            RootIndex.$$$reportNull$$$0(14);
        }
        return couple;
    }

    @Nullable(value="returns null only if dir is under ignored folder")
    private static @Nullable(value="returns null only if dir is under ignored folder") List<VirtualFile> getHierarchy(@NotNull VirtualFile deepDir, @NotNull Set<? extends VirtualFile> allRoots, @NotNull RootInfo info) {
        if (deepDir == null) {
            RootIndex.$$$reportNull$$$0(15);
        }
        if (allRoots == null) {
            RootIndex.$$$reportNull$$$0(16);
        }
        if (info == null) {
            RootIndex.$$$reportNull$$$0(17);
        }
        ArrayList<VirtualFile> hierarchy = new ArrayList<VirtualFile>();
        boolean hasContentRoots = false;
        for (VirtualFile dir = deepDir; dir != null; dir = dir.getParent()) {
            if (!(hasContentRoots |= info.contentRootOf.get(dir) != null) && ourFileTypes.isFileIgnored(dir)) {
                return null;
            }
            if (!allRoots.contains(dir)) continue;
            hierarchy.add(dir);
        }
        return hierarchy;
    }

    @NotNull
    List<OrderEntry> getOrderEntries(@NotNull VirtualFile root) {
        if (root == null) {
            RootIndex.$$$reportNull$$$0(18);
        }
        List<OrderEntry> list = this.getOrderEntryGraph().getOrderEntries(root);
        if (list == null) {
            RootIndex.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    Set<String> getDependentUnloadedModules(@NotNull Module module) {
        if (module == null) {
            RootIndex.$$$reportNull$$$0(20);
        }
        Set<String> set = this.getOrderEntryGraph().getDependentUnloadedModules(module);
        if (set == null) {
            RootIndex.$$$reportNull$$$0(21);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 13, 14, 19, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/RootIndex";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classRoots";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deepDir";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRoots";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRootInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSdkClasses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSdks";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntryGraph";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "initLibraryClassSourceRoots";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentUnloadedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildRootInfo";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 19: 
            case 21: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectSdkClasses";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fillIndexWithLibraryRoots";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "ensureValid";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchy";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntries";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDependentUnloadedModules";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 13, 14, 19, 21 -> new IllegalStateException(string);
        };
    }

    private static class RootInfo {
        @NotNull
        private final Set<VirtualFile> classAndSourceRoots = new LinkedHashSet<VirtualFile>();
        @NotNull
        private final Set<VirtualFile> libraryOrSdkSources = new HashSet<VirtualFile>();
        @NotNull
        private final Set<VirtualFile> libraryOrSdkClasses = new HashSet<VirtualFile>();
        @NotNull
        private final Map<VirtualFile, Module> contentRootOf = new HashMap<VirtualFile, Module>();
        @NotNull
        private final Map<VirtualFile, String> contentRootOfUnloaded = new HashMap<VirtualFile, String>();
        @NotNull
        private final MultiMap<VirtualFile, Module> sourceRootOf = MultiMap.createSet();
        @NotNull
        private final MultiMap<VirtualFile, Object> excludedFromLibraries = MultiMap.createSet();
        @NotNull
        private final MultiMap<VirtualFile, Object> classOfLibraries = MultiMap.createSet();
        @NotNull
        private final MultiMap<VirtualFile, Object> sourceOfLibraries = MultiMap.createSet();
        @NotNull
        private final Map<WorkspaceEntity, Condition<VirtualFile>> customEntitiesExcludeConditions = new HashMap<WorkspaceEntity, Condition<VirtualFile>>();
        @NotNull
        private final Set<VirtualFile> excludedFromProject = new HashSet<VirtualFile>();
        @NotNull
        private final Set<VirtualFile> excludedFromSdkRoots = new HashSet<VirtualFile>();
        @NotNull
        private final Map<VirtualFile, Module> excludedFromModule = new HashMap<VirtualFile, Module>();
        @NotNull
        private final Map<VirtualFile, FileTypeAssocTable<Boolean>> excludeFromContentRootTables = new HashMap<VirtualFile, FileTypeAssocTable<Boolean>>();

        private RootInfo() {
        }

        @NotNull
        private Set<VirtualFile> getAllRoots() {
            VirtualFileSet result = VirtualFileSetFactory.getInstance().createCompactVirtualFileSet();
            result.addAll(this.classAndSourceRoots);
            result.addAll(this.contentRootOf.keySet());
            result.addAll(this.contentRootOfUnloaded.keySet());
            result.addAll((Collection)this.excludedFromLibraries.keySet());
            result.addAll(this.excludedFromModule.keySet());
            result.addAll(this.excludedFromProject);
            result.addAll(this.excludedFromSdkRoots);
            Set set = result.freezed();
            if (set == null) {
                RootInfo.$$$reportNull$$$0(0);
            }
            return set;
        }

        @Nullable
        private VirtualFile findNearestContentRoot(@NotNull List<? extends VirtualFile> hierarchy) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(1);
            }
            Collection sourceRootOwners = null;
            boolean underExcludedSourceRoot = false;
            for (VirtualFile virtualFile : hierarchy) {
                Collection modulesForSourceRoot;
                FileTypeAssocTable<Boolean> table;
                Module module = this.contentRootOf.get(virtualFile);
                Module excludedFrom = this.excludedFromModule.get(virtualFile);
                if (module != null && (table = this.excludeFromContentRootTables.get(virtualFile)) != null && RootInfo.isExcludedByPattern(virtualFile, hierarchy, table)) {
                    excludedFrom = module;
                }
                if (module != null && (excludedFrom != module || underExcludedSourceRoot && sourceRootOwners.contains(module))) {
                    return virtualFile;
                }
                if (excludedFrom != null || this.excludedFromProject.contains(virtualFile) || this.contentRootOfUnloaded.containsKey(virtualFile)) {
                    if (sourceRootOwners == null) {
                        return null;
                    }
                    underExcludedSourceRoot = true;
                }
                if (underExcludedSourceRoot || !this.sourceRootOf.containsKey((Object)virtualFile) || (modulesForSourceRoot = this.sourceRootOf.get((Object)virtualFile)).isEmpty()) continue;
                sourceRootOwners = sourceRootOwners == null ? modulesForSourceRoot : ContainerUtil.union((Collection)sourceRootOwners, (Collection)modulesForSourceRoot);
            }
            return null;
        }

        private static boolean isExcludedByPattern(@NotNull VirtualFile contentRoot, @NotNull List<? extends VirtualFile> hierarchy, @NotNull FileTypeAssocTable<Boolean> table) {
            if (contentRoot == null) {
                RootInfo.$$$reportNull$$$0(2);
            }
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(3);
            }
            if (table == null) {
                RootInfo.$$$reportNull$$$0(4);
            }
            for (VirtualFile virtualFile : hierarchy) {
                if (table.findAssociatedFileType(virtualFile.getNameSequence()) != null) {
                    return true;
                }
                if (!virtualFile.equals(contentRoot)) continue;
                break;
            }
            return false;
        }

        @Nullable
        private Pair<VirtualFile, List<Condition<? super VirtualFile>>> findLibraryRootInfo(@NotNull List<? extends VirtualFile> hierarchy, boolean source) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(5);
            }
            Set<Object> librariesToIgnore = RootInfo.createLibrarySet();
            for (VirtualFile virtualFile : hierarchy) {
                List<Condition<? super VirtualFile>> found;
                librariesToIgnore.addAll(this.excludedFromLibraries.get((Object)virtualFile));
                if (!(source && this.libraryOrSdkSources.contains(virtualFile) ? (found = RootInfo.findInLibraryProducers(virtualFile, this.sourceOfLibraries, librariesToIgnore, this.customEntitiesExcludeConditions)) != null : !source && this.libraryOrSdkClasses.contains(virtualFile) && (found = RootInfo.findInLibraryProducers(virtualFile, this.classOfLibraries, librariesToIgnore, this.customEntitiesExcludeConditions)) != null)) continue;
                return Pair.create((Object)virtualFile, found);
            }
            return null;
        }

        @NotNull
        private static Set<Object> createLibrarySet() {
            Set set = CollectionFactory.createCustomHashingStrategySet((HashingStrategy)new HashingStrategy<Object>(){

                public int hashCode(Object object) {
                    return Objects.hashCode(object instanceof Library ? ((Library)object).getName() : object);
                }

                public boolean equals(Object o1, Object o2) {
                    return Objects.equals(o1, o2);
                }
            });
            if (set == null) {
                RootInfo.$$$reportNull$$$0(6);
            }
            return set;
        }

        private static List<Condition<? super VirtualFile>> findInLibraryProducers(@NotNull VirtualFile root, @NotNull MultiMap<VirtualFile, Object> libraryRoots, @NotNull Set<Object> librariesToIgnore, @NotNull Map<WorkspaceEntity, Condition<VirtualFile>> customEntitiesExcludeConditions) {
            if (root == null) {
                RootInfo.$$$reportNull$$$0(7);
            }
            if (libraryRoots == null) {
                RootInfo.$$$reportNull$$$0(8);
            }
            if (librariesToIgnore == null) {
                RootInfo.$$$reportNull$$$0(9);
            }
            if (customEntitiesExcludeConditions == null) {
                RootInfo.$$$reportNull$$$0(10);
            }
            if (!libraryRoots.containsKey((Object)root)) {
                return Collections.emptyList();
            }
            Collection producers = libraryRoots.get((Object)root);
            HashSet libraries = new HashSet(producers.size());
            SmartList exclusions = new SmartList();
            for (Object library : producers) {
                Condition<VirtualFile> condition;
                if (librariesToIgnore.contains(library)) continue;
                if (library instanceof SyntheticLibrary) {
                    Condition exclusion = ((SyntheticLibrary)library).getUnitedExcludeCondition();
                    if (exclusion != null) {
                        exclusions.add(exclusion);
                        if (exclusion.value((Object)root)) {
                            continue;
                        }
                    }
                } else if (library instanceof WorkspaceEntity && (condition = customEntitiesExcludeConditions.get(library)) != null) {
                    exclusions.add(condition);
                    if (condition.value((Object)root)) continue;
                }
                libraries.add(library);
            }
            if (!libraries.isEmpty()) {
                return exclusions;
            }
            return null;
        }

        @NotNull
        private Set<OrderEntry> getLibraryOrderEntries(@NotNull List<? extends VirtualFile> hierarchy, @Nullable VirtualFile libraryClassRoot, @Nullable VirtualFile librarySourceRoot, @NotNull MultiMap<VirtualFile, OrderEntry> libClassRootEntries, @NotNull MultiMap<VirtualFile, OrderEntry> libSourceRootEntries) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(11);
            }
            if (libClassRootEntries == null) {
                RootInfo.$$$reportNull$$$0(12);
            }
            if (libSourceRootEntries == null) {
                RootInfo.$$$reportNull$$$0(13);
            }
            LinkedHashSet<OrderEntry> orderEntries = new LinkedHashSet<OrderEntry>();
            for (VirtualFile virtualFile : hierarchy) {
                if (virtualFile.equals(libraryClassRoot) && !this.sourceRootOf.containsKey((Object)virtualFile)) {
                    orderEntries.addAll(libClassRootEntries.get((Object)virtualFile));
                }
                if (virtualFile.equals(librarySourceRoot) && libraryClassRoot == null) {
                    orderEntries.addAll(libSourceRootEntries.get((Object)virtualFile));
                }
                if (!libClassRootEntries.containsKey((Object)virtualFile) && (!this.sourceRootOf.containsKey((Object)virtualFile) || librarySourceRoot != null)) continue;
                break;
            }
            LinkedHashSet<OrderEntry> linkedHashSet = orderEntries;
            if (linkedHashSet == null) {
                RootInfo.$$$reportNull$$$0(14);
            }
            return linkedHashSet;
        }

        @Nullable
        private ModuleSourceOrderEntry getModuleSourceEntry(@NotNull List<? extends VirtualFile> hierarchy, @NotNull VirtualFile moduleContentRoot, @NotNull MultiMap<VirtualFile, OrderEntry> libClassRootEntries) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(15);
            }
            if (moduleContentRoot == null) {
                RootInfo.$$$reportNull$$$0(16);
            }
            if (libClassRootEntries == null) {
                RootInfo.$$$reportNull$$$0(17);
            }
            Module module = this.contentRootOf.get(moduleContentRoot);
            for (VirtualFile virtualFile : hierarchy) {
                if (this.sourceRootOf.get((Object)virtualFile).contains(module)) {
                    return (ModuleSourceOrderEntry)ContainerUtil.findInstance((Object[])ModuleRootManager.getInstance((Module)module).getOrderEntries(), ModuleSourceOrderEntry.class);
                }
                if (!libClassRootEntries.containsKey((Object)virtualFile)) continue;
                return null;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/RootIndex$RootInfo";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 11: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hierarchy";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentRoot";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryRoots";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "librariesToIgnore";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "customEntitiesExcludeConditions";
                    break;
                }
                case 12: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libClassRootEntries";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libSourceRootEntries";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleContentRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllRoots";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex$RootInfo";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLibrarySet";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryOrderEntries";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findNearestContentRoot";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isExcludedByPattern";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findLibraryRootInfo";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "findInLibraryProducers";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraryOrderEntries";
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleSourceEntry";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17 -> new IllegalArgumentException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static class OrderEntryGraph {
        private final Project myProject;
        private final RootInfo myRootInfo;
        private final Set<VirtualFile> myAllRoots;
        private final Graph myGraph;
        private final MultiMap<VirtualFile, Node> myRoots;
        private final SynchronizedSLRUCache<VirtualFile, List<OrderEntry>> myCache;
        private final SynchronizedSLRUCache<Module, Set<String>> myDependentUnloadedModulesCache;
        private final MultiMap<VirtualFile, OrderEntry> myLibClassRootEntries;
        private final MultiMap<VirtualFile, OrderEntry> myLibSourceRootEntries;

        OrderEntryGraph(@NotNull Project project, @NotNull RootInfo rootInfo, @NotNull MultiMap<VirtualFile, OrderEntry> libClassRootEntries, @NotNull MultiMap<VirtualFile, OrderEntry> libSourceRootEntries) {
            if (project == null) {
                OrderEntryGraph.$$$reportNull$$$0(0);
            }
            if (rootInfo == null) {
                OrderEntryGraph.$$$reportNull$$$0(1);
            }
            if (libClassRootEntries == null) {
                OrderEntryGraph.$$$reportNull$$$0(2);
            }
            if (libSourceRootEntries == null) {
                OrderEntryGraph.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myRootInfo = rootInfo;
            this.myAllRoots = rootInfo.getAllRoots();
            int cacheSize = Math.max(100, this.myAllRoots.size() / 3);
            this.myCache = new SynchronizedSLRUCache<VirtualFile, List<OrderEntry>>(cacheSize, cacheSize){

                @Override
                @NotNull
                public @Unmodifiable List<OrderEntry> createValue(@NotNull VirtualFile key) {
                    if (key == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    List<OrderEntry> list = this.collectOrderEntries(key);
                    if (list == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "key";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createValue";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createValue";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            };
            int dependentUnloadedModulesCacheSize = ModuleManager.getInstance((Project)project).getModules().length / 2;
            this.myDependentUnloadedModulesCache = new SynchronizedSLRUCache<Module, Set<String>>(dependentUnloadedModulesCacheSize, dependentUnloadedModulesCacheSize){

                @Override
                @NotNull
                public Set<String> createValue(@NotNull Module key) {
                    if (key == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    Set<String> set = this.collectDependentUnloadedModules(key);
                    if (set == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return set;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "key";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createValue";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createValue";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            };
            Pair<Graph, MultiMap<VirtualFile, Node>> pair = this.initGraphRoots();
            this.myGraph = (Graph)pair.getFirst();
            this.myRoots = (MultiMap)pair.getSecond();
            this.myLibClassRootEntries = libClassRootEntries;
            this.myLibSourceRootEntries = libSourceRootEntries;
        }

        @NotNull
        private Pair<Graph, MultiMap<VirtualFile, Node>> initGraphRoots() {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
            Module[] modules = moduleManager.getModules();
            Graph graph = new Graph(modules.length);
            MultiMap roots = new MultiMap();
            for (Module module : modules) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                List<OrderEnumerationHandler> handlers = OrderEnumeratorBase.getCustomHandlers(module);
                for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
                    ModuleOrderEntry moduleOrderEntry;
                    Module depModule;
                    if (!(orderEntry instanceof ModuleOrderEntry) || (depModule = (moduleOrderEntry = (ModuleOrderEntry)orderEntry).getModule()) == null) continue;
                    Node node = graph.myNodes.get(depModule);
                    OrderEnumerator en = OrderEnumerator.orderEntries((Module)depModule).exportedOnly();
                    if (node == null) {
                        VirtualFile[] importedSourceRoots;
                        VirtualFile[] importedClassRoots;
                        node = new Node(depModule);
                        graph.myNodes.put(depModule, node);
                        for (VirtualFile importedClassRoot : importedClassRoots = en.classes().usingCache().getRoots()) {
                            roots.putValue((Object)importedClassRoot, (Object)node);
                        }
                        for (VirtualFile sourceRoot : importedSourceRoots = en.sources().usingCache().getRoots()) {
                            roots.putValue((Object)sourceRoot, (Object)node);
                        }
                    }
                    boolean shouldRecurse = en.recursively().shouldRecurse(moduleOrderEntry, handlers);
                    node.myEdges.add(new Edge(module, moduleOrderEntry, shouldRecurse));
                }
            }
            for (UnloadedModuleDescription description : moduleManager.getUnloadedModuleDescriptions()) {
                for (String depName : description.getDependencyModuleNames()) {
                    Module depModule = moduleManager.findModuleByName(depName);
                    if (depModule == null) continue;
                    Node node = graph.myNodes.get(depModule);
                    if (node == null) {
                        node = new Node(depModule);
                        graph.myNodes.put(depModule, node);
                    }
                    if (node.myUnloadedDependentModules == null) {
                        node.myUnloadedDependentModules = new LinkedHashSet<String>();
                    }
                    node.myUnloadedDependentModules.add(description.getName());
                }
            }
            Pair pair = Pair.create((Object)graph, (Object)roots);
            if (pair == null) {
                OrderEntryGraph.$$$reportNull$$$0(4);
            }
            return pair;
        }

        @NotNull
        private List<OrderEntry> getOrderEntries(@NotNull VirtualFile file) {
            if (file == null) {
                OrderEntryGraph.$$$reportNull$$$0(5);
            }
            List<OrderEntry> list = this.myCache.get(file);
            if (list == null) {
                OrderEntryGraph.$$$reportNull$$$0(6);
            }
            return list;
        }

        @NotNull
        private @Unmodifiable List<OrderEntry> collectOrderEntries(@NotNull VirtualFile file) {
            List<VirtualFile> roots;
            if (file == null) {
                OrderEntryGraph.$$$reportNull$$$0(7);
            }
            if ((roots = RootIndex.getHierarchy(file, this.myAllRoots, this.myRootInfo)) == null) {
                List<OrderEntry> list = Collections.emptyList();
                if (list == null) {
                    OrderEntryGraph.$$$reportNull$$$0(8);
                }
                return list;
            }
            Stack stack = new Stack(roots.size());
            for (VirtualFile root : roots) {
                Collection nodes = this.myRoots.get((Object)root);
                for (Node node : nodes) {
                    stack.push((Object)node);
                }
            }
            HashSet<Node> seen = new HashSet<Node>(stack.size());
            ArrayList<Object> result = new ArrayList<Object>(stack.size());
            while (!stack.isEmpty()) {
                Node node = (Node)stack.pop();
                if (!seen.add(node)) continue;
                for (Edge edge : node.myEdges) {
                    Node targetNode;
                    result.add(edge.myOrderEntry);
                    if (!edge.myRecursive || (targetNode = this.myGraph.myNodes.get(edge.myKey)) == null) continue;
                    stack.push((Object)targetNode);
                }
            }
            Pair<VirtualFile, List<Condition<? super VirtualFile>>> libraryClassRootInfo = this.myRootInfo.findLibraryRootInfo(roots, false);
            Pair<VirtualFile, List<Condition<? super VirtualFile>>> librarySourceRootInfo = this.myRootInfo.findLibraryRootInfo(roots, true);
            result.addAll(this.myRootInfo.getLibraryOrderEntries(roots, (VirtualFile)Pair.getFirst(libraryClassRootInfo), (VirtualFile)Pair.getFirst(librarySourceRootInfo), this.myLibClassRootEntries, this.myLibSourceRootEntries));
            VirtualFile moduleContentRoot = this.myRootInfo.findNearestContentRoot(roots);
            if (moduleContentRoot != null) {
                ContainerUtil.addIfNotNull(result, (Object)this.myRootInfo.getModuleSourceEntry(roots, moduleContentRoot, this.myLibClassRootEntries));
            }
            result.sort(BY_OWNER_MODULE);
            List<OrderEntry> list = List.copyOf(result);
            if (list == null) {
                OrderEntryGraph.$$$reportNull$$$0(9);
            }
            return list;
        }

        @NotNull
        Set<String> getDependentUnloadedModules(@NotNull Module module) {
            if (module == null) {
                OrderEntryGraph.$$$reportNull$$$0(10);
            }
            Set<String> set = this.myDependentUnloadedModulesCache.get(module);
            if (set == null) {
                OrderEntryGraph.$$$reportNull$$$0(11);
            }
            return set;
        }

        @NotNull
        private Set<String> collectDependentUnloadedModules(@NotNull Module module) {
            Node start2;
            if (module == null) {
                OrderEntryGraph.$$$reportNull$$$0(12);
            }
            if ((start2 = this.myGraph.myNodes.get(module)) == null) {
                Set<String> set = Collections.emptySet();
                if (set == null) {
                    OrderEntryGraph.$$$reportNull$$$0(13);
                }
                return set;
            }
            ArrayDeque<Node> stack = new ArrayDeque<Node>();
            stack.push(start2);
            HashSet<Node> seen = new HashSet<Node>();
            Set<String> result = null;
            while (!stack.isEmpty()) {
                Node node = (Node)stack.pop();
                if (!seen.add(node)) continue;
                if (node.myUnloadedDependentModules != null) {
                    if (result == null) {
                        result = new LinkedHashSet<String>(node.myUnloadedDependentModules);
                    } else {
                        result.addAll(node.myUnloadedDependentModules);
                    }
                }
                for (Edge edge : node.myEdges) {
                    Node targetNode;
                    if (!edge.myRecursive || (targetNode = this.myGraph.myNodes.get(edge.myKey)) == null) continue;
                    stack.push(targetNode);
                }
            }
            Set<String> set = result != null ? result : Collections.emptySet();
            if (set == null) {
                OrderEntryGraph.$$$reportNull$$$0(14);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 6, 8, 9, 11, 13, 14 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootInfo";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libClassRootEntries";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libSourceRootEntries";
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 9: 
                case 11: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "initGraphRoots";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrderEntries";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectOrderEntries";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependentUnloadedModules";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectDependentUnloadedModules";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 9: 
                case 11: 
                case 13: 
                case 14: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrderEntries";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "collectOrderEntries";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependentUnloadedModules";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "collectDependentUnloadedModules";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 6, 8, 9, 11, 13, 14 -> new IllegalStateException(string);
            };
        }

        private static class Graph {
            private final Map<Module, Node> myNodes;

            Graph(int moduleCount) {
                this.myNodes = new HashMap<Module, Node>(moduleCount);
            }
        }

        private static final class Node {
            private final Module myKey;
            private final List<Edge> myEdges;
            private Set<String> myUnloadedDependentModules;

            private Node(@NotNull Module key) {
                if (key == null) {
                    Node.$$$reportNull$$$0(0);
                }
                this.myEdges = new ArrayList<Edge>();
                this.myKey = key;
            }

            public String toString() {
                return this.myKey.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$Node", "<init>"));
            }
        }

        private static class Edge {
            private final Module myKey;
            @NotNull
            private final ModuleOrderEntry myOrderEntry;
            private final boolean myRecursive;

            Edge(@NotNull Module key, @NotNull ModuleOrderEntry orderEntry, boolean recursive) {
                if (key == null) {
                    Edge.$$$reportNull$$$0(0);
                }
                if (orderEntry == null) {
                    Edge.$$$reportNull$$$0(1);
                }
                this.myKey = key;
                this.myOrderEntry = orderEntry;
                this.myRecursive = recursive;
            }

            public String toString() {
                return this.myOrderEntry.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "orderEntry";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$Edge";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    static abstract class SynchronizedSLRUCache<K, V>
    extends SLRUMap<K, V> {
        private final Object myLock = ObjectUtils.sentinel((String)"Root index lock");

        SynchronizedSLRUCache(int protectedQueueSize, int probationalQueueSize) {
            super(protectedQueueSize, probationalQueueSize);
        }

        @NotNull
        public abstract V createValue(@NotNull K var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        public V get(K key) {
            Object value;
            Object object = this.myLock;
            synchronized (object) {
                value = super.get(key);
                if (value != null) {
                    Object object2 = value;
                    // MONITOREXIT @DISABLED, blocks:[3, 7] lbl6 : MonitorExitStatement: MONITOREXIT : var3_2
                    if (object2 == null) {
                        SynchronizedSLRUCache.$$$reportNull$$$0(0);
                    }
                    return (V)object2;
                }
            }
            value = this.createValue(key);
            object = this.myLock;
            synchronized (object) {
                this.put(key, value);
            }
            Object object3 = value;
            if (object3 == null) {
                SynchronizedSLRUCache.$$$reportNull$$$0(1);
            }
            return (V)object3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex$SynchronizedSLRUCache", "get"));
        }
    }
}

