/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.ide.todo.FileTree;
import com.intellij.ide.todo.SmartTodoItemPointer;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoImplementationChooserKt;
import com.intellij.ide.todo.TodoNodeVisitor;
import com.intellij.ide.todo.TodoTreeBuilderCoroutineHelper;
import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.ide.todo.nodes.TodoFileNode;
import com.intellij.ide.todo.nodes.TodoItemNode;
import com.intellij.ide.todo.nodes.TodoTreeHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadConstraint;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.usageView.UsageTreeColorsScheme;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.swing.JTree;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class TodoTreeBuilder
implements Disposable {
    public static final Comparator<NodeDescriptor<?>> NODE_DESCRIPTOR_COMPARATOR = Comparator.comparingInt(NodeDescriptor::getWeight).thenComparingInt(NodeDescriptor::getIndex);
    @NotNull
    protected final Project myProject;
    @ApiStatus.Internal
    @NotNull
    protected final FileTree myFileTree;
    protected final Set<VirtualFile> myDirtyFileSet;
    protected final Map<VirtualFile, EditorHighlighter> myFile2Highlighter;
    @NotNull
    private final JTree myTree;
    private volatile boolean myUpdatable;
    private final MyFileStatusListener myFileStatusListener;
    private TodoTreeStructure myTreeStructure;
    private StructureTreeModel<? extends TodoTreeStructure> myModel;
    private boolean myDisposed;
    private final TodoTreeBuilderCoroutineHelper myCoroutineHelper;
    private final List<CompletableFuture<?>> myFutures;

    public TodoTreeBuilder(@NotNull JTree tree, @NotNull Project project) {
        if (tree == null) {
            TodoTreeBuilder.$$$reportNull$$$0(0);
        }
        if (project == null) {
            TodoTreeBuilder.$$$reportNull$$$0(1);
        }
        this.myFileTree = new FileTree();
        this.myDirtyFileSet = ConcurrentHashMap.newKeySet();
        this.myFile2Highlighter = ContainerUtil.createConcurrentSoftValueMap();
        this.myFileStatusListener = new MyFileStatusListener();
        this.myCoroutineHelper = new TodoTreeBuilderCoroutineHelper(this);
        this.myFutures = new SmartList();
        this.myTree = tree;
        this.myProject = project;
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)new MyPsiTreeChangeListener(), (Disposable)this);
    }

    @NotNull
    protected PsiTodoSearchHelper getSearchHelper() {
        PsiTodoSearchHelper psiTodoSearchHelper = PsiTodoSearchHelper.getInstance((Project)this.myProject);
        if (psiTodoSearchHelper == null) {
            TodoTreeBuilder.$$$reportNull$$$0(2);
        }
        return psiTodoSearchHelper;
    }

    @NotNull
    protected final Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            TodoTreeBuilder.$$$reportNull$$$0(3);
        }
        return project;
    }

    @NotNull
    protected final JTree getTree() {
        JTree jTree = this.myTree;
        if (jTree == null) {
            TodoTreeBuilder.$$$reportNull$$$0(4);
        }
        return jTree;
    }

    @ApiStatus.Internal
    @NotNull
    protected final TodoTreeBuilderCoroutineHelper getCoroutineHelper() {
        TodoTreeBuilderCoroutineHelper todoTreeBuilderCoroutineHelper = this.myCoroutineHelper;
        if (todoTreeBuilderCoroutineHelper == null) {
            TodoTreeBuilder.$$$reportNull$$$0(5);
        }
        return todoTreeBuilderCoroutineHelper;
    }

    @NotNull
    protected final StructureTreeModel<? extends TodoTreeStructure> getModel() {
        StructureTreeModel<? extends TodoTreeStructure> structureTreeModel = this.myModel;
        if (structureTreeModel == null) {
            TodoTreeBuilder.$$$reportNull$$$0(6);
        }
        return structureTreeModel;
    }

    protected final void setModel(@NotNull StructureTreeModel<? extends TodoTreeStructure> model) {
        if (model == null) {
            TodoTreeBuilder.$$$reportNull$$$0(7);
        }
        this.myModel = model;
    }

    public final void init() {
        this.myTreeStructure = this.createTreeStructure();
        this.myTreeStructure.setTreeBuilder(this);
        try {
            this.rebuildCache();
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        FileStatusManager.getInstance((Project)this.myProject).addFileStatusListener((FileStatusListener)this.myFileStatusListener, (Disposable)this);
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public final void dispose() {
        this.myDisposed = true;
    }

    protected final boolean isUpdatable() {
        return this.myUpdatable;
    }

    protected final void setUpdatable(boolean updatable) {
        if (this.myUpdatable != updatable) {
            this.myUpdatable = updatable;
            if (updatable) {
                this.updateTree();
            }
        }
    }

    @ApiStatus.Internal
    @NotNull
    protected abstract TodoTreeStructure createTreeStructure();

    @ApiStatus.Internal
    public final TodoTreeStructure getTodoTreeStructure() {
        return this.myTreeStructure;
    }

    public Iterator<PsiFile> getAllFiles() {
        final Iterator<VirtualFile> iterator = this.myFileTree.getFileIterator();
        return new Iterator<PsiFile>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            @Nullable
            public PsiFile next() {
                VirtualFile vFile = (VirtualFile)iterator.next();
                if (vFile == null || !vFile.isValid()) {
                    return null;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)TodoTreeBuilder.this.myProject).findFile(vFile);
                if (psiFile == null || !psiFile.isValid()) {
                    return null;
                }
                return psiFile;
            }

            @Override
            public void remove() {
                throw new IllegalArgumentException();
            }
        };
    }

    public Iterator<PsiFile> getFiles(PsiDirectory psiDirectory) {
        return this.getFiles(psiDirectory, true);
    }

    public Iterator<PsiFile> getFiles(PsiDirectory psiDirectory, boolean skip) {
        List<VirtualFile> files = this.myFileTree.getFiles(psiDirectory.getVirtualFile());
        ArrayList<PsiFile> psiFileList = new ArrayList<PsiFile>(files.size());
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile file : files) {
            PsiDirectory directory;
            PsiFile psiFile;
            boolean isInContent;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiDirectory);
            if (module != null && !(isInContent = ModuleRootManager.getInstance((Module)module).getFileIndex().isInContent(file)) || !file.isValid() || (psiFile = psiManager.findFile(file)) == null || (directory = psiFile.getContainingDirectory()) != null && skip && TodoTreeHelper.getInstance(this.myProject).skipDirectory(directory)) continue;
            psiFileList.add(psiFile);
        }
        return psiFileList.iterator();
    }

    public Iterator<PsiFile> getFilesUnderDirectory(PsiDirectory psiDirectory) {
        List<VirtualFile> files = this.myFileTree.getFilesUnderDirectory(psiDirectory.getVirtualFile());
        ArrayList<PsiFile> psiFileList = new ArrayList<PsiFile>(files.size());
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile file : files) {
            PsiFile psiFile;
            boolean isInContent;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiDirectory);
            if (module != null && !(isInContent = ModuleRootManager.getInstance((Module)module).getFileIndex().isInContent(file)) || !file.isValid() || (psiFile = psiManager.findFile(file)) == null) continue;
            psiFileList.add(psiFile);
        }
        return psiFileList.iterator();
    }

    public Iterator<PsiFile> getFiles(Module module) {
        VirtualFile[] contentRoots;
        if (module.isDisposed()) {
            return Collections.emptyIterator();
        }
        ArrayList<PsiFile> psiFileList = new ArrayList<PsiFile>();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        for (VirtualFile virtualFile : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            List<VirtualFile> files = this.myFileTree.getFiles(virtualFile);
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            for (VirtualFile file : files) {
                PsiFile psiFile;
                if (fileIndex.getModuleForFile(file) != module || !file.isValid() || (psiFile = psiManager.findFile(file)) == null) continue;
                psiFileList.add(psiFile);
            }
        }
        return psiFileList.iterator();
    }

    private boolean canContainTodoItems(PsiFile psiFile) {
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        VirtualFile vFile = psiFile.getVirtualFile();
        return this.myFileTree.contains(vFile) || this.myDirtyFileSet.contains(vFile);
    }

    @RequiresBackgroundThread
    protected final void markFileAsDirty(@NotNull VirtualFile file) {
        if (file == null) {
            TodoTreeBuilder.$$$reportNull$$$0(8);
        }
        ThreadingAssertions.assertBackgroundThread();
        if (!(file instanceof LightVirtualFile)) {
            this.myDirtyFileSet.add(file);
        }
    }

    @NotNull
    protected final synchronized CompletableFuture<?> rebuildCache() {
        for (CompletableFuture<?> future : this.myFutures) {
            future.cancel(true);
        }
        this.myFutures.clear();
        CompletableFuture<?> future = this.myCoroutineHelper.scheduleCacheAndTreeUpdate(new ReadConstraint[0]);
        this.myFutures.add(future);
        CompletableFuture<?> completableFuture = future;
        if (completableFuture == null) {
            TodoTreeBuilder.$$$reportNull$$$0(9);
        }
        return completableFuture;
    }

    @RequiresBackgroundThread
    protected void collectFiles(@NotNull @NotNull Consumer<? super @NotNull PsiFile> consumer) {
        if (consumer == null) {
            TodoTreeBuilder.$$$reportNull$$$0(10);
        }
        ThreadingAssertions.assertBackgroundThread();
        if (TodoImplementationChooserKt.shouldUseSplitTodo()) {
            this.myCoroutineHelper.collectFilesFromFlow(this.getTodoTreeStructure().getTodoFilter(), consumer);
        } else {
            TodoTreeStructure treeStructure = this.getTodoTreeStructure();
            PsiTodoSearchHelper searchHelper = this.getSearchHelper();
            searchHelper.processFilesWithTodoItems(psiFile -> {
                if (searchHelper.getTodoItemsCount(psiFile) > 0 && treeStructure.accept((PsiFile)psiFile)) {
                    consumer.accept((PsiFile)psiFile);
                }
                return true;
            });
        }
    }

    @RequiresBackgroundThread
    protected final void clearCache() {
        ThreadingAssertions.assertBackgroundThread();
        this.myFileTree.clear();
        this.myDirtyFileSet.clear();
        this.myFile2Highlighter.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean hasDirtyFiles() {
        Set<VirtualFile> set = this.myDirtyFileSet;
        synchronized (set) {
            if (this.myDirtyFileSet.isEmpty()) {
                return false;
            }
            this.validateCache();
            return true;
        }
    }

    @RequiresEdt
    private void withLoadingPanel(@NotNull Consumer<? super JBLoadingPanel> consumer) {
        if (consumer == null) {
            TodoTreeBuilder.$$$reportNull$$$0(11);
        }
        ThreadingAssertions.assertEventDispatchThread();
        JBLoadingPanel loadingPanel = (JBLoadingPanel)UIUtil.getParentOfType(JBLoadingPanel.class, (Component)this.myTree);
        if (loadingPanel != null) {
            consumer.accept((JBLoadingPanel)loadingPanel);
        }
    }

    private void validateCache() {
        TodoTreeStructure treeStructure = this.getTodoTreeStructure();
        for (VirtualFile file : this.myDirtyFileSet) {
            PsiFile psiFile;
            PsiFile psiFile2 = psiFile = file.isValid() ? PsiManager.getInstance((Project)this.myProject).findFile(file) : null;
            if (psiFile == null || !treeStructure.accept(psiFile)) {
                if (!this.myFileTree.contains(file)) continue;
                this.myFileTree.removeFile(file);
                this.myFile2Highlighter.remove(file);
                continue;
            }
            this.myFileTree.removeFile(file);
            this.myFileTree.add(file);
            EditorHighlighter highlighter = this.myFile2Highlighter.get(file);
            if (highlighter == null) continue;
            highlighter.setText(PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiFile).getCharsSequence());
        }
        this.myDirtyFileSet.clear();
    }

    protected boolean isAutoExpandNode(NodeDescriptor descriptor) {
        return this.getTodoTreeStructure().isAutoExpandNode(descriptor);
    }

    public TodoItemNode getFirstPointerForElement(@Nullable Object element) {
        if (element instanceof TodoItemNode) {
            return (TodoItemNode)element;
        }
        if (!(element instanceof AbstractTreeNode)) {
            return null;
        }
        Object[] children = this.getTodoTreeStructure().getChildElements(element);
        if (children.length == 0) {
            return null;
        }
        Object firstChild = children[0];
        if (firstChild instanceof TodoItemNode) {
            return (TodoItemNode)firstChild;
        }
        return this.getFirstPointerForElement(firstChild);
    }

    public TodoItemNode getLastPointerForElement(Object element) {
        if (element instanceof TodoItemNode) {
            return (TodoItemNode)element;
        }
        Object[] children = this.getTodoTreeStructure().getChildElements(element);
        if (children.length == 0) {
            return null;
        }
        Object firstChild = children[children.length - 1];
        if (firstChild instanceof TodoItemNode) {
            return (TodoItemNode)firstChild;
        }
        return this.getLastPointerForElement(firstChild);
    }

    @NotNull
    public final Promise<?> updateTree() {
        Promise promise = this.myUpdatable ? Promises.asPromise(this.myCoroutineHelper.scheduleUpdateTree()) : Promises.resolvedPromise();
        if (promise == null) {
            TodoTreeBuilder.$$$reportNull$$$0(12);
        }
        return promise;
    }

    @VisibleForTesting
    @RequiresEdt
    protected void onUpdateStarted() {
        ThreadingAssertions.assertEventDispatchThread();
        this.withLoadingPanel(JBLoadingPanel::startLoading);
    }

    @VisibleForTesting
    @RequiresEdt
    protected void onUpdateFinished() {
        ThreadingAssertions.assertEventDispatchThread();
        this.withLoadingPanel(JBLoadingPanel::stopLoading);
    }

    public void select(Object obj) {
        TodoNodeVisitor visitor = TodoTreeBuilder.getVisitorFor(obj);
        if (visitor == null) {
            TreeUtil.promiseSelectFirst((JTree)this.myTree);
        } else {
            TreeUtil.promiseSelect((JTree)this.myTree, (TreeVisitor)visitor).onError(error -> TreeUtil.promiseSelectFirst((JTree)this.myTree));
        }
    }

    @ApiStatus.Internal
    @Nullable
    protected static TodoNodeVisitor getVisitorFor(@NotNull Object obj) {
        if (obj == null) {
            TodoTreeBuilder.$$$reportNull$$$0(13);
        }
        if (obj instanceof TodoItemNode) {
            SmartTodoItemPointer value = (SmartTodoItemPointer)((TodoItemNode)obj).getValue();
            if (value != null) {
                return new TodoNodeVisitor(value::getTodoItem, value.getTodoItem().getFile().getVirtualFile());
            }
            return null;
        }
        Object o = obj instanceof AbstractTreeNode ? ((AbstractTreeNode)obj).getValue() : null;
        return new TodoNodeVisitor(() -> obj instanceof AbstractTreeNode ? ((AbstractTreeNode)obj).getValue() : obj, o instanceof PsiElement ? PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)o)) : null);
    }

    @Nullable
    static PsiFile getFileForNodeDescriptor(@NotNull NodeDescriptor<?> obj) {
        if (obj == null) {
            TodoTreeBuilder.$$$reportNull$$$0(14);
        }
        if (obj instanceof TodoFileNode) {
            return (PsiFile)((TodoFileNode)obj).getValue();
        }
        if (obj instanceof TodoItemNode) {
            SmartTodoItemPointer pointer = (SmartTodoItemPointer)((TodoItemNode)obj).getValue();
            return pointer.getTodoItem().getFile();
        }
        return null;
    }

    void setShowPackages(boolean state) {
        this.getTodoTreeStructure().setShownPackages(state);
        this.rebuildTreeOnSettingChange();
    }

    void setFlattenPackages(boolean state) {
        this.getTodoTreeStructure().setFlattenPackages(state);
        this.rebuildTreeOnSettingChange();
    }

    void setShowModules(boolean state) {
        this.getTodoTreeStructure().setShownModules(state);
        this.rebuildTreeOnSettingChange();
    }

    private void rebuildTreeOnSettingChange() {
        this.myCoroutineHelper.scheduleCacheValidationAndTreeUpdate();
    }

    void setTodoFilter(TodoFilter filter) {
        this.getTodoTreeStructure().setTodoFilter(filter);
        try {
            this.rebuildCache();
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    public TodoItemNode getNextPointer(TodoItemNode pointer) {
        Object sibling = this.getNextSibling(pointer);
        if (sibling == null) {
            return null;
        }
        if (sibling instanceof TodoItemNode) {
            return (TodoItemNode)sibling;
        }
        return this.getFirstPointerForElement(sibling);
    }

    Object getNextSibling(Object obj) {
        Object parent = this.getTodoTreeStructure().getParentElement(obj);
        if (parent == null) {
            return null;
        }
        Object[] children = this.getTodoTreeStructure().getChildElements(parent);
        Arrays.sort(children, NODE_DESCRIPTOR_COMPARATOR);
        int idx = -1;
        for (int i = 0; i < children.length; ++i) {
            if (!obj.equals(children[i])) continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            return null;
        }
        if (idx < children.length - 1) {
            return children[idx + 1];
        }
        return this.getNextSibling(parent);
    }

    public TodoItemNode getPreviousPointer(TodoItemNode pointer) {
        Object sibling = this.getPreviousSibling(pointer);
        if (sibling == null) {
            return null;
        }
        if (sibling instanceof TodoItemNode) {
            return (TodoItemNode)sibling;
        }
        return this.getLastPointerForElement(sibling);
    }

    Object getPreviousSibling(Object obj) {
        Object parent = this.getTodoTreeStructure().getParentElement(obj);
        if (parent == null) {
            return null;
        }
        Object[] children = this.getTodoTreeStructure().getChildElements(parent);
        Arrays.sort(children, NODE_DESCRIPTOR_COMPARATOR);
        int idx = -1;
        for (int i = 0; i < children.length; ++i) {
            if (!obj.equals(children[i])) continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            return null;
        }
        if (idx > 0) {
            return children[idx - 1];
        }
        return this.getPreviousSibling(parent);
    }

    public EditorHighlighter getHighlighter(PsiFile psiFile, Document document) {
        VirtualFile file = psiFile.getVirtualFile();
        EditorHighlighter highlighter = this.myFile2Highlighter.get(file);
        if (highlighter == null) {
            highlighter = HighlighterFactory.createHighlighter((EditorColorsScheme)UsageTreeColorsScheme.getInstance().getScheme(), (String)file.getName(), (Project)this.myProject);
            highlighter.setText(document.getCharsSequence());
            this.myFile2Highlighter.put(file, highlighter);
        }
        return highlighter;
    }

    public boolean isDirectoryEmpty(@NotNull PsiDirectory psiDirectory) {
        if (psiDirectory == null) {
            TodoTreeBuilder.$$$reportNull$$$0(15);
        }
        return this.myFileTree.isDirectoryEmpty(psiDirectory.getVirtualFile());
    }

    @TestOnly
    @ApiStatus.Internal
    @NotNull
    public CompletableFuture<?> rebuildCacheTestAccessor() {
        return this.rebuildCache();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 9, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/TodoTreeBuilder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/TodoTreeBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchHelper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoroutineHelper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "rebuildCache";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "updateTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "markFileAsDirty";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "withLoadingPanel";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getVisitorFor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFileForNodeDescriptor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDirectoryEmpty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 9, 12 -> new IllegalStateException(string);
        };
    }

    private final class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public void fileStatusesChanged() {
            TodoTreeBuilder.this.updateTree();
        }

        public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
            PsiFile psiFile;
            if (virtualFile == null) {
                MyFileStatusListener.$$$reportNull$$$0(0);
            }
            if ((psiFile = PsiManager.getInstance((Project)TodoTreeBuilder.this.myProject).findFile(virtualFile)) != null && TodoTreeBuilder.this.canContainTodoItems(psiFile)) {
                TodoTreeBuilder.this.updateTree();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/ide/todo/TodoTreeBuilder$MyFileStatusListener", "fileStatusChanged"));
        }
    }

    private final class MyPsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        private MyPsiTreeChangeListener() {
        }

        public void childAdded(@NotNull PsiTreeChangeEvent e) {
            PsiFile file;
            if (e == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(0);
            }
            if ((file = e.getFile()) != null) {
                this.scheduleMarkFileAsDirtyAndUpdateTree(file);
                return;
            }
            PsiElement child = e.getChild();
            if (child instanceof PsiFile) {
                PsiFile psiFile = (PsiFile)child;
                this.scheduleMarkFileAsDirtyAndUpdateTree(psiFile);
            }
        }

        public void beforeChildRemoval(@NotNull PsiTreeChangeEvent e) {
            PsiFile file;
            if (e == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(1);
            }
            if ((file = e.getFile()) != null) {
                this.scheduleMarkFileAsDirtyAndUpdateTree(file);
                return;
            }
            PsiElement child = e.getChild();
            if (child instanceof PsiFile) {
                PsiFile psiFile = (PsiFile)child;
                this.scheduleMarkFileAsDirtyAndUpdateTree(psiFile);
                return;
            }
            if (child instanceof PsiDirectory) {
                PsiDirectory psiDirectory = (PsiDirectory)child;
                List<VirtualFile> files = TodoTreeBuilder.this.myFileTree.getFiles(psiDirectory.getVirtualFile());
                TodoTreeBuilder.this.myCoroutineHelper.scheduleMarkFilesAsDirtyAndUpdateTree(files);
            } else if (PsiTreeUtil.getParentOfType((PsiElement)child, PsiComment.class, (boolean)false) != null) {
                this.scheduleMarkFileAsDirtyAndUpdateTree(child.getContainingFile());
            }
        }

        public void childMoved(@NotNull PsiTreeChangeEvent e) {
            PsiFile file;
            if (e == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(2);
            }
            if ((file = e.getFile()) != null) {
                this.scheduleMarkFileAsDirtyAndUpdateTree(file);
                return;
            }
            PsiElement child = e.getChild();
            if (child instanceof PsiFile) {
                PsiFile psiFile = (PsiFile)child;
                if (TodoTreeBuilder.this.canContainTodoItems(psiFile)) {
                    this.scheduleMarkFileAsDirtyAndUpdateTree(psiFile);
                }
                return;
            }
            if (child instanceof PsiDirectory) {
                PsiDirectory psiDirectory = (PsiDirectory)child;
                ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
                Iterator<PsiFile> i = TodoTreeBuilder.this.getAllFiles();
                while (i.hasNext()) {
                    VirtualFile virtualFile;
                    PsiFile psiFile = i.next();
                    if (psiFile == null || !psiFile.isValid() || !PsiTreeUtil.isAncestor((PsiElement)psiDirectory, (PsiElement)psiFile, (boolean)true) || (virtualFile = psiFile.getVirtualFile()) == null) continue;
                    files.add(virtualFile);
                }
                TodoTreeBuilder.this.myCoroutineHelper.scheduleMarkFilesAsDirtyAndUpdateTree(files);
            }
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent e) {
            if (e == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(3);
            }
            this.scheduleMarkFileAsDirtyAndUpdateTree(e.getFile());
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent e) {
            if (e == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(4);
            }
            this.scheduleMarkFileAsDirtyAndUpdateTree(e.getFile());
        }

        public void propertyChanged(@NotNull PsiTreeChangeEvent e) {
            if (e == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(5);
            }
            switch (e.getPropertyName()) {
                case "roots": {
                    TodoTreeBuilder.this.rebuildCache();
                    break;
                }
                case "writable": 
                case "fileName": {
                    PsiFile psiFile = (PsiFile)e.getElement();
                    if (!TodoTreeBuilder.this.canContainTodoItems(psiFile)) {
                        return;
                    }
                    TodoTreeBuilder.this.updateTree();
                    break;
                }
                case "directoryName": {
                    PsiDirectory psiDirectory = (PsiDirectory)e.getElement();
                    Iterator<PsiFile> iterator = TodoTreeBuilder.this.getFiles(psiDirectory);
                    if (!iterator.hasNext()) break;
                    TodoTreeBuilder.this.updateTree();
                }
            }
        }

        private void scheduleMarkFileAsDirtyAndUpdateTree(@Nullable PsiFile file) {
            VirtualFile virtualFile;
            VirtualFile virtualFile2 = virtualFile = file != null ? file.getVirtualFile() : null;
            if (virtualFile != null) {
                TodoTreeBuilder.this.myCoroutineHelper.scheduleMarkFilesAsDirtyAndUpdateTree(List.of(virtualFile));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/todo/TodoTreeBuilder$MyPsiTreeChangeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildRemoval";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childMoved";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenChanged";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

