/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.codeInsight;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.search.PsiTodoSearchHelperImpl;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.TodoPattern;
import com.intellij.xml.util.XmlStringUtil;
import java.util.List;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;

final class TodoHighlightVisitor
implements HighlightVisitor {
    TodoHighlightVisitor() {
    }

    public boolean suitableForFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            TodoHighlightVisitor.$$$reportNull$$$0(0);
        }
        return true;
    }

    public boolean analyze(@NotNull PsiFile psiFile, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action) {
        if (psiFile == null) {
            TodoHighlightVisitor.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            TodoHighlightVisitor.$$$reportNull$$$0(2);
        }
        if (action == null) {
            TodoHighlightVisitor.$$$reportNull$$$0(3);
        }
        action.run();
        TodoHighlightVisitor.highlightTodos(psiFile, psiFile.getText(), holder);
        return true;
    }

    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            TodoHighlightVisitor.$$$reportNull$$$0(4);
        }
    }

    @NotNull
    public HighlightVisitor clone() {
        return new TodoHighlightVisitor();
    }

    private static void highlightTodos(@NotNull PsiFile file, @NotNull CharSequence text, @NotNull HighlightInfoHolder holder) {
        PsiTodoSearchHelper helper;
        if (file == null) {
            TodoHighlightVisitor.$$$reportNull$$$0(5);
        }
        if (text == null) {
            TodoHighlightVisitor.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            TodoHighlightVisitor.$$$reportNull$$$0(7);
        }
        if ((helper = PsiTodoSearchHelper.getInstance((Project)file.getProject())) == null || !TodoHighlightVisitor.shouldHighlightTodos(helper, file)) {
            return;
        }
        TodoItem[] todoItems = helper.findTodoItems(file);
        boolean isNavigationEnabled = Registry.is((String)"todo.navigation");
        for (TodoItem todoItem : todoItems) {
            int offset;
            String wordToHighlight;
            ProgressManager.checkCanceled();
            TodoPattern todoPattern = todoItem.getPattern();
            if (todoPattern == null) continue;
            TextRange textRange = todoItem.getTextRange();
            List additionalRanges = todoItem.getAdditionalTextRanges();
            String description = TodoHighlightVisitor.formatDescription(text, textRange, additionalRanges);
            String tooltip = XmlStringUtil.escapeString((String)StringUtil.shortenPathWithEllipsis((String)description, (int)1024)).replace("\n", "<br>");
            TextAttributes attributes = todoPattern.getAttributes().getTextAttributes();
            TodoHighlightVisitor.addTodoItem(holder, attributes, description, tooltip, textRange);
            if (!additionalRanges.isEmpty()) {
                TextAttributes attributesForAdditionalLines = attributes.clone();
                attributesForAdditionalLines.setErrorStripeColor(null);
                for (TextRange range : additionalRanges) {
                    TodoHighlightVisitor.addTodoItem(holder, attributesForAdditionalLines, description, tooltip, range);
                }
            }
            if (!isNavigationEnabled || (wordToHighlight = todoPattern.getIndexPattern().getWordToHighlight()) == null || (offset = Strings.indexOfIgnoreCase((CharSequence)text, (CharSequence)wordToHighlight, (int)textRange.getStartOffset(), (int)textRange.getEndOffset())) < 0) continue;
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).range(offset, offset + wordToHighlight.length()).textAttributes(CodeInsightColors.INACTIVE_HYPERLINK_ATTRIBUTES).createUnconditionally();
            holder.add(info);
        }
    }

    @NlsSafe
    private static String formatDescription(@NotNull CharSequence text, @NotNull TextRange textRange, @NotNull List<? extends TextRange> additionalRanges) {
        if (text == null) {
            TodoHighlightVisitor.$$$reportNull$$$0(8);
        }
        if (textRange == null) {
            TodoHighlightVisitor.$$$reportNull$$$0(9);
        }
        if (additionalRanges == null) {
            TodoHighlightVisitor.$$$reportNull$$$0(10);
        }
        StringJoiner joiner = new StringJoiner("\n");
        joiner.add(textRange.subSequence(text));
        for (TextRange textRange2 : additionalRanges) {
            joiner.add(textRange2.subSequence(text));
        }
        return joiner.toString();
    }

    private static void addTodoItem(@NotNull HighlightInfoHolder holder, @NotNull TextAttributes attributes, @NlsContexts.DetailedDescription @NotNull String description, @NlsContexts.Tooltip @NotNull String tooltip, @NotNull TextRange range) {
        if (holder == null) {
            TodoHighlightVisitor.$$$reportNull$$$0(11);
        }
        if (attributes == null) {
            TodoHighlightVisitor.$$$reportNull$$$0(12);
        }
        if (description == null) {
            TodoHighlightVisitor.$$$reportNull$$$0(13);
        }
        if (tooltip == null) {
            TodoHighlightVisitor.$$$reportNull$$$0(14);
        }
        if (range == null) {
            TodoHighlightVisitor.$$$reportNull$$$0(15);
        }
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.TODO).range(range).textAttributes(attributes).description(description).escapedToolTip(tooltip).createUnconditionally();
        holder.add(info);
    }

    private static boolean shouldHighlightTodos(@NotNull PsiTodoSearchHelper helper, @NotNull PsiFile file) {
        if (helper == null) {
            TodoHighlightVisitor.$$$reportNull$$$0(16);
        }
        if (file == null) {
            TodoHighlightVisitor.$$$reportNull$$$0(17);
        }
        return helper instanceof PsiTodoSearchHelperImpl && ((PsiTodoSearchHelperImpl)helper).shouldHighlightInEditor(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalRanges";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/todo/codeInsight/TodoHighlightVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "suitableForFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "analyze";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visit";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightTodos";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "formatDescription";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "addTodoItem";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldHighlightTodos";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

