/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.youtrack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.CustomTaskProperty;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.impl.LocalTaskImpl;
import com.intellij.tasks.youtrack.YouTrackRepository;
import com.intellij.tasks.youtrack.model.YouTrackIssue;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YouTrackTask
extends Task {
    private final YouTrackRepository myRepository;
    private final YouTrackIssue myIssue;
    private final TaskType myType;
    private final TaskState myIssueState;
    private final Map<String, CustomTaskProperty> myProperties;
    public static final String PROP_PRIORITY = "priority";
    public static final String PROP_TYPE = "type";
    public static final String PROP_STATE = "state";
    public static final String PROP_ASSIGNEE = "assignee";
    private static final List<String> PROPERTIES_TO_SHOW_IN_PREVIEW = List.of("priority", "type", "state", "assignee");

    public YouTrackTask(@NotNull YouTrackRepository repository, @NotNull YouTrackIssue issue) {
        if (repository == null) {
            YouTrackTask.$$$reportNull$$$0(0);
        }
        if (issue == null) {
            YouTrackTask.$$$reportNull$$$0(1);
        }
        this.myRepository = repository;
        this.myIssue = issue;
        this.myIssueState = this.mapIssueStateToPredefinedValue();
        this.myType = this.mapIssueTypeToPredefinedValue();
        this.myProperties = this.buildProperties();
    }

    @NotNull
    public TaskType getType() {
        TaskType taskType = this.myType;
        if (taskType == null) {
            YouTrackTask.$$$reportNull$$$0(2);
        }
        return taskType;
    }

    @NotNull
    private TaskType mapIssueTypeToPredefinedValue() {
        String typeName = this.getCustomFieldStringValue("Type");
        if (typeName != null) {
            TaskType taskType;
            try {
                taskType = TaskType.valueOf((String)StringUtil.toUpperCase((String)typeName));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (taskType == null) {
                YouTrackTask.$$$reportNull$$$0(3);
            }
            return taskType;
        }
        TaskType taskType = TaskType.OTHER;
        if (taskType == null) {
            YouTrackTask.$$$reportNull$$$0(4);
        }
        return taskType;
    }

    @Nullable
    public TaskState getState() {
        return this.myIssueState;
    }

    @Nullable
    private TaskState mapIssueStateToPredefinedValue() {
        String stateName = this.getCustomFieldStringValue("State");
        if (stateName == null) {
            return null;
        }
        if (stateName.equals("Fixed")) {
            return TaskState.RESOLVED;
        }
        try {
            return TaskState.valueOf((String)StringUtil.toUpperCase((String)stateName));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return TaskState.OTHER;
        }
    }

    @Nullable
    private String getCustomFieldStringValue(@NotNull String fieldName) {
        YouTrackIssue.CustomField stateField;
        if (fieldName == null) {
            YouTrackTask.$$$reportNull$$$0(5);
        }
        if ((stateField = (YouTrackIssue.CustomField)ContainerUtil.find(this.myIssue.getCustomFields(), cf -> cf.getName().equals(fieldName))) != null) {
            List<JsonObject> elements;
            JsonElement fieldValueElem = stateField.getValue();
            if (fieldValueElem == null) {
                return null;
            }
            if (fieldValueElem.isJsonArray()) {
                elements = ContainerUtil.filterIsInstance((Collection)fieldValueElem.getAsJsonArray().asList(), JsonObject.class);
            } else if (fieldValueElem.isJsonObject()) {
                elements = Collections.singletonList(fieldValueElem.getAsJsonObject());
            } else {
                return null;
            }
            List<String> result = elements.stream().map(it -> it.get("name")).filter(it -> it != null && it.isJsonPrimitive() && it.getAsJsonPrimitive().isString()).map(JsonElement::getAsString).toList();
            if (result.isEmpty()) {
                return null;
            }
            return StringUtil.join(result, (String)", ");
        }
        return null;
    }

    @NotNull
    public String getId() {
        String string = this.myIssue.getId();
        if (string == null) {
            YouTrackTask.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public TaskRepository getRepository() {
        YouTrackRepository youTrackRepository = this.myRepository;
        if (youTrackRepository == null) {
            YouTrackTask.$$$reportNull$$$0(7);
        }
        return youTrackRepository;
    }

    @Nls
    @NotNull
    public String getSummary() {
        String string = this.myIssue.getSummary();
        if (string == null) {
            YouTrackTask.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDescription() {
        String string = this.myIssue.getDescription();
        if (string == null) {
            YouTrackTask.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public @NotNull Map<@NotNull String, @NotNull CustomTaskProperty> getCustomProperties() {
        Map<String, CustomTaskProperty> map = this.myProperties;
        if (map == null) {
            YouTrackTask.$$$reportNull$$$0(10);
        }
        return map;
    }

    @NotNull
    public @NotNull List<@NotNull String> getPropertiesToShowInPreview() {
        List<String> list = PROPERTIES_TO_SHOW_IN_PREVIEW;
        if (list == null) {
            YouTrackTask.$$$reportNull$$$0(11);
        }
        return list;
    }

    public Comment @NotNull [] getComments() {
        if (Comment.EMPTY_ARRAY == null) {
            YouTrackTask.$$$reportNull$$$0(12);
        }
        return Comment.EMPTY_ARRAY;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = LocalTaskImpl.getIconFromType((TaskType)this.getType(), (boolean)true);
        if (icon == null) {
            YouTrackTask.$$$reportNull$$$0(13);
        }
        return icon;
    }

    @NotNull
    public Date getUpdated() {
        return new Date(this.myIssue.getUpdated());
    }

    @NotNull
    public Date getCreated() {
        return new Date(this.myIssue.getCreated());
    }

    public boolean isClosed() {
        return this.myIssue.getResolved() != 0L;
    }

    public boolean isIssue() {
        return true;
    }

    @NotNull
    public String getIssueUrl() {
        String string = this.myRepository.getUrl() + "/issue/" + this.getId();
        if (string == null) {
            YouTrackTask.$$$reportNull$$$0(14);
        }
        return string;
    }

    private Map<String, CustomTaskProperty> buildProperties() {
        LinkedHashMap<String, CustomTaskProperty> properties = new LinkedHashMap<String, CustomTaskProperty>();
        this.addCustomField(properties, PROP_STATE, "State", TaskBundle.message((String)"task.preview.state", (Object[])new Object[0]));
        this.addCustomField(properties, PROP_TYPE, "Type", TaskBundle.message((String)"task.preview.type", (Object[])new Object[0]));
        this.addCustomField(properties, PROP_PRIORITY, "Priority", TaskBundle.message((String)"task.preview.priority", (Object[])new Object[0]));
        this.addCustomField(properties, PROP_ASSIGNEE, "Assignee", TaskBundle.message((String)"task.preview.assignee", (Object[])new Object[0]));
        return Collections.unmodifiableMap(properties);
    }

    private void addCustomField(HashMap<String, CustomTaskProperty> properties, String propertyName, String fieldName, @Nls String displayName) {
        String value = this.getCustomFieldStringValue(fieldName);
        if (value != null) {
            properties.put(propertyName, new CustomTaskProperty(displayName, value, null));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/youtrack/YouTrackTask";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/youtrack/YouTrackTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "mapIssueTypeToPredefinedValue";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepository";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSummary";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomProperties";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesToShowInPreview";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getComments";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssueUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCustomFieldStringValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14 -> new IllegalStateException(string);
        };
    }
}

