/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.remoteController;

import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bouncycastle.crypto.generators.SCrypt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0007J\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\b\u001a\u00020\u0007J\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\b\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/remoteController/UnattendedHostPasswordUtil;", "", "<init>", "()V", "random", "Ljava/security/SecureRandom;", "hashPassword", "", "password", "salt", "", "hashPasswordCreateSalt", "Lkotlin/Pair;", "intellij.platform.remoteController"})
public final class UnattendedHostPasswordUtil {
    @NotNull
    public static final UnattendedHostPasswordUtil INSTANCE = new UnattendedHostPasswordUtil();
    @NotNull
    private static final SecureRandom random = new SecureRandom();

    private UnattendedHostPasswordUtil() {
    }

    @NotNull
    public final byte[] hashPassword(@NotNull byte[] password, @NotNull byte[] salt) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        byte[] byArray = SCrypt.generate((byte[])password, (byte[])salt, (int)32768, (int)16, (int)1, (int)256);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"generate(...)");
        return byArray;
    }

    @NotNull
    public final byte[] hashPassword(@NotNull String password, @NotNull byte[] salt) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        byte[] byArray = password.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.hashPassword(byArray, salt);
    }

    @NotNull
    public final Pair<byte[], byte[]> hashPasswordCreateSalt(@NotNull byte[] password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        byte[] salt = new byte[16];
        random.nextBytes(salt);
        return TuplesKt.to((Object)this.hashPassword(password, salt), (Object)salt);
    }

    @NotNull
    public final Pair<byte[], byte[]> hashPasswordCreateSalt(@NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        byte[] byArray = password.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.hashPasswordCreateSalt(byArray);
    }
}

