/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.codereview.editor;

import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.codereview.editor.CodeReviewActiveRangesTracker;
import com.intellij.collaboration.ui.codereview.editor.CodeReviewComponentInlayRenderer;
import com.intellij.collaboration.ui.codereview.editor.CodeReviewEditorInlayRangeOutlineUtilsKt;
import com.intellij.collaboration.ui.codereview.editor.LineRangeEdge;
import com.intellij.collaboration.ui.codereview.editor.ResizableOutlineHandler;
import com.intellij.diff.util.LineRange;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u0000 ?2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0003?@ABt\b\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012!\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u000b\u00126\u0010\u0011\u001a2\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00150\u0012\u00a2\u0006\u0004\b\u0016\u0010\u0017J\b\u0010 \u001a\u00020\u0015H\u0016J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010%\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010+\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010,\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010.\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\b\u0010/\u001a\u00020\u0010H\u0002J\u0017\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u00103J\u0016\u00104\u001a\u0004\u0018\u00010\u001f*\u00020\u001f2\u0006\u00102\u001a\u00020\fH\u0002J \u00105\u001a\u00020\u00152\n\b\u0002\u00106\u001a\u0004\u0018\u0001072\n\b\u0002\u00108\u001a\u0004\u0018\u000109H\u0002J\u0012\u0010:\u001a\u0004\u0018\u00010\u00132\u0006\u00108\u001a\u000209H\u0002J\u0012\u0010;\u001a\u00020\u00152\b\u0010<\u001a\u0004\u0018\u00010\u0019H\u0002J\u0018\u0010=\u001a\u00020\u00152\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0002J\b\u0010>\u001a\u00020\u0015H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0011\u001a2\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00150\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/intellij/collaboration/ui/codereview/editor/ResizableOutlineHandler;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "Lcom/intellij/openapi/editor/event/VisibleAreaListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "currentRange", "Lcom/intellij/diff/util/LineRange;", "canCreateComment", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "editorLine", "", "onDragFinished", "Lkotlin/Function2;", "Lcom/intellij/collaboration/ui/codereview/editor/LineRangeEdge;", "edge", "", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/diff/util/LineRange;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)V", "resizeCursor", "Ljava/awt/Cursor;", "kotlin.jvm.PlatformType", "currentTooltip", "Lcom/intellij/ide/IdeTooltip;", "dragState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/collaboration/ui/codereview/editor/ResizableOutlineHandler$DragState;", "dispose", "mousePressed", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "mouseDragged", "visibleAreaChanged", "Lcom/intellij/openapi/editor/event/VisibleAreaEvent;", "documentChanged", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "mouseReleased", "mouseEntered", "mouseMoved", "mouseExited", "startDragging", "finishDragging", "adjustDragRange", "Lcom/intellij/collaboration/ui/codereview/editor/ResizableOutlineHandler$DragOutcome;", "y", "(Ljava/lang/Integer;)Lcom/intellij/collaboration/ui/codereview/editor/ResizableOutlineHandler$DragOutcome;", "withLineUnderYIfCommentable", "updateCursorAndTooltip", "component", "Ljava/awt/Component;", "point", "Ljava/awt/Point;", "getEdgeAt", "setEditorCursor", "cursor", "showTooltip", "hideTooltip", "Companion", "DragOutcome", "DragState", "intellij.platform.collaborationTools"})
@SourceDebugExtension(value={"SMAP\nCodeReviewEditorInlayRangeOutlineUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeReviewEditorInlayRangeOutlineUtils.kt\ncom/intellij/collaboration/ui/codereview/editor/ResizableOutlineHandler\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,493:1\n214#2,5:494\n1#3:499\n*S KotlinDebug\n*F\n+ 1 CodeReviewEditorInlayRangeOutlineUtils.kt\ncom/intellij/collaboration/ui/codereview/editor/ResizableOutlineHandler\n*L\n265#1:494,5\n*E\n"})
final class ResizableOutlineHandler
implements EditorMouseListener,
EditorMouseMotionListener,
VisibleAreaListener,
DocumentListener,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final LineRange currentRange;
    @NotNull
    private final Function1<Integer, Boolean> canCreateComment;
    @NotNull
    private final Function2<LineRangeEdge, Integer, Unit> onDragFinished;
    private final Cursor resizeCursor;
    @Nullable
    private IdeTooltip currentTooltip;
    @NotNull
    private final MutableStateFlow<DragState> dragState;

    private ResizableOutlineHandler(EditorEx editor, LineRange currentRange, Function1<? super Integer, Boolean> canCreateComment, Function2<? super LineRangeEdge, ? super Integer, Unit> onDragFinished) {
        Cursor cursor;
        ResizableOutlineHandler resizableOutlineHandler;
        this.editor = editor;
        this.currentRange = currentRange;
        this.canCreateComment = canCreateComment;
        this.onDragFinished = onDragFinished;
        ResizableOutlineHandler resizableOutlineHandler2 = this;
        try {
            resizableOutlineHandler = resizableOutlineHandler2;
            cursor = Cursor.getPredefinedCursor(8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            resizableOutlineHandler = resizableOutlineHandler2;
            cursor = Cursor.getDefaultCursor();
        }
        resizableOutlineHandler.resizeCursor = cursor;
        this.dragState = StateFlowKt.MutableStateFlow(null);
        this.editor.addEditorMouseMotionListener((EditorMouseMotionListener)this);
        this.editor.addEditorMouseListener((EditorMouseListener)this);
        this.editor.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)this);
        this.editor.getDocument().addDocumentListener((DocumentListener)this, (Disposable)this);
    }

    public void dispose() {
        this.editor.removeEditorMouseListener((EditorMouseListener)this);
        this.editor.removeEditorMouseMotionListener((EditorMouseMotionListener)this);
        this.editor.getScrollingModel().removeVisibleAreaListener((VisibleAreaListener)this);
        ResizableOutlineHandler.updateCursorAndTooltip$default(this, null, null, 3, null);
    }

    public void mousePressed(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.isConsumed()) {
            return;
        }
        Point point = e.getMouseEvent().getPoint();
        if (point == null) {
            return;
        }
        Point point2 = point;
        LineRangeEdge lineRangeEdge = this.getEdgeAt(point2);
        if (lineRangeEdge == null) {
            return;
        }
        LineRangeEdge edge = lineRangeEdge;
        this.startDragging(edge);
        e.consume();
    }

    public void mouseDragged(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.isConsumed()) {
            return;
        }
        this.updateCursorAndTooltip(e.getMouseEvent().getComponent(), e.getMouseEvent().getPoint());
        if (this.adjustDragRange(e.getMouseEvent().getY()) == DragOutcome.SUCCESS) {
            e.consume();
        }
    }

    public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
        Integer y;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Rectangle rectangle = e.getOldRectangle();
        if (rectangle == null) {
            return;
        }
        Rectangle oldRect = rectangle;
        if (oldRect.y == e.getNewRectangle().y) {
            return;
        }
        Point point = this.editor.getGutterComponentEx().getMousePosition();
        if (point != null) {
            v2 = point.y;
        } else {
            Point point2 = this.editor.getContentComponent().getMousePosition();
            v2 = y = point2 != null ? Integer.valueOf(point2.y) : null;
        }
        if (this.adjustDragRange(y) == DragOutcome.INVALID) {
            this.finishDragging();
        }
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        Integer y;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Point point = this.editor.getGutterComponentEx().getMousePosition();
        if (point != null) {
            v1 = point.y;
        } else {
            Point point2 = this.editor.getContentComponent().getMousePosition();
            v1 = y = point2 != null ? Integer.valueOf(point2.y) : null;
        }
        if (this.adjustDragRange(y) == DragOutcome.INVALID) {
            this.finishDragging();
        }
    }

    public void mouseReleased(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.isConsumed()) {
            return;
        }
        if (this.finishDragging()) {
            e.consume();
        }
    }

    public void mouseEntered(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.updateCursorAndTooltip(e.getMouseEvent().getComponent(), e.getMouseEvent().getPoint());
    }

    public void mouseMoved(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.updateCursorAndTooltip(e.getMouseEvent().getComponent(), e.getMouseEvent().getPoint());
    }

    public void mouseExited(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ResizableOutlineHandler.updateCursorAndTooltip$default(this, null, null, 3, null);
    }

    private final void startDragging(LineRangeEdge edge) {
        int line = CodeReviewEditorInlayRangeOutlineUtilsKt.access$getLineAt(this.currentRange, edge);
        this.dragState.setValue((Object)new DragState(edge, line));
    }

    private final boolean finishDragging() {
        Object nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<DragState> $this$getAndUpdate$iv = this.dragState;
        boolean $i$f$getAndUpdate = false;
        do {
            prevValue$iv = $this$getAndUpdate$iv.getValue();
            DragState it = (DragState)prevValue$iv;
            boolean bl = false;
        } while (!$this$getAndUpdate$iv.compareAndSet(prevValue$iv, nextValue$iv = null));
        DragState dragState = (DragState)prevValue$iv;
        if (dragState == null) {
            return false;
        }
        DragState state = dragState;
        this.onDragFinished.invoke((Object)state.getEdge(), (Object)state.getLine());
        ResizableOutlineHandler.updateCursorAndTooltip$default(this, null, null, 3, null);
        return true;
    }

    private final DragOutcome adjustDragRange(Integer y) {
        DragState dragState = (DragState)this.dragState.getValue();
        if (dragState == null) {
            return DragOutcome.UNCHANGED;
        }
        DragState currentState = dragState;
        if (y == null || currentState.getEdge() == LineRangeEdge.END && currentState.getLine() >= this.editor.getDocument().getLineCount() || this.currentRange.end >= this.editor.getDocument().getLineCount()) {
            this.dragState.setValue(null);
            return DragOutcome.INVALID;
        }
        DragState dragState2 = this.withLineUnderYIfCommentable(currentState, y);
        if (dragState2 == null) {
            return DragOutcome.UNCHANGED;
        }
        DragState newState = dragState2;
        if (!this.dragState.compareAndSet((Object)currentState, (Object)newState)) {
            return DragOutcome.UNCHANGED;
        }
        return !Intrinsics.areEqual((Object)currentState, (Object)newState) ? DragOutcome.SUCCESS : DragOutcome.UNCHANGED;
    }

    private final DragState withLineUnderYIfCommentable(DragState $this$withLineUnderYIfCommentable, int y) {
        DragState dragState;
        boolean isCurrentBoundary;
        int lineUnderY = this.editor.xyToLogicalPosition((Point)new Point((int)0, (int)y)).line;
        boolean bl = isCurrentBoundary = lineUnderY == $this$withLineUnderYIfCommentable.getLine();
        if (!((Boolean)this.canCreateComment.invoke((Object)lineUnderY)).booleanValue() && !isCurrentBoundary) {
            return null;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[$this$withLineUnderYIfCommentable.getEdge().ordinal()]) {
            case 1: {
                Integer n = lineUnderY;
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                Integer n2 = it <= this.currentRange.end ? n : null;
                if (n2 == null) {
                    return null;
                }
                int newStart = n2;
                dragState = DragState.copy$default($this$withLineUnderYIfCommentable, null, newStart, 1, null);
                break;
            }
            case 2: {
                Integer n = lineUnderY;
                int it = ((Number)n).intValue();
                boolean bl3 = false;
                Integer n3 = it >= this.currentRange.start ? n : null;
                if (n3 == null) {
                    return null;
                }
                int newEnd = n3;
                dragState = DragState.copy$default($this$withLineUnderYIfCommentable, null, newEnd, 1, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return dragState;
    }

    private final void updateCursorAndTooltip(Component component, Point point) {
        boolean onEdge;
        if (component == null || point == null) {
            this.hideTooltip();
            this.setEditorCursor(null);
            return;
        }
        if (this.dragState.getValue() != null) {
            this.hideTooltip();
            this.setEditorCursor(this.resizeCursor);
            return;
        }
        boolean bl = onEdge = this.getEdgeAt(point) != null;
        if (onEdge) {
            this.showTooltip(component, point);
            this.setEditorCursor(this.resizeCursor);
        } else {
            this.hideTooltip();
            this.setEditorCursor(null);
        }
    }

    static /* synthetic */ void updateCursorAndTooltip$default(ResizableOutlineHandler resizableOutlineHandler, Component component, Point point, int n, Object object) {
        if ((n & 1) != 0) {
            component = null;
        }
        if ((n & 2) != 0) {
            point = null;
        }
        resizableOutlineHandler.updateCursorAndTooltip(component, point);
    }

    private final LineRangeEdge getEdgeAt(Point point) {
        IntRange yBorders = CodeReviewEditorInlayRangeOutlineUtilsKt.yRangeForLogicalLineRange((Editor)this.editor, this.currentRange.start, this.currentRange.end);
        float topY = yBorders.getFirst();
        float botY = yBorders.getLast();
        float f = this.editor.getContentComponent().getWidth();
        float f2 = point.x;
        if (!(0.0f <= f2 ? f2 <= f : false)) {
            return null;
        }
        f = RangesKt.coerceAtLeast((float)(topY - (float)3), (float)0.0f);
        f2 = topY + (float)this.editor.getLineHeight() * 0.3f;
        float f3 = point.y;
        boolean bl = f <= f3 ? f3 <= f2 : false;
        if (bl) {
            return LineRangeEdge.START;
        }
        f = botY - (float)this.editor.getLineHeight() * 0.3f;
        f2 = botY + (float)3;
        f3 = point.y;
        boolean bl2 = f <= f3 ? f3 <= f2 : false;
        if (bl2) {
            return LineRangeEdge.END;
        }
        return null;
    }

    private final void setEditorCursor(Cursor cursor) {
        this.editor.setCustomCursor((Object)this, cursor);
        try {
            IdeGlassPaneUtil.find((Component)((Component)this.editor.getGutterComponentEx())).setCursor(cursor, (Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void showTooltip(Component component, Point point) {
        Point offsetPoint = new Point(point.x, point.y + this.editor.getLineHeight());
        IdeTooltip ideTooltip = this.currentTooltip;
        if (ideTooltip != null) {
            IdeTooltip it = ideTooltip;
            boolean bl = false;
            it.setComponent(component);
            it.setPoint(offsetPoint);
        }
        if (this.currentTooltip == null) {
            JLabel label = new JLabel(CollaborationToolsBundle.message("review.comments.code.outline.tooltip", new Object[0]));
            this.currentTooltip = new IdeTooltip(component, offsetPoint, (JComponent)label, new Object[0]).setPreferredPosition(Balloon.Position.below).setShowCallout(false);
        }
        IdeTooltipManager ideTooltipManager = IdeTooltipManager.Companion.getInstance();
        IdeTooltip ideTooltip2 = this.currentTooltip;
        Intrinsics.checkNotNull((Object)ideTooltip2);
        IdeTooltipManager.show$default((IdeTooltipManager)ideTooltipManager, (IdeTooltip)ideTooltip2, (boolean)false, (boolean)false, (int)4, null);
    }

    private final void hideTooltip() {
        IdeTooltip ideTooltip = this.currentTooltip;
        if (ideTooltip != null) {
            IdeTooltip it = ideTooltip;
            boolean bl = false;
            IdeTooltipManager.Companion.getInstance().hide(it);
        }
        this.currentTooltip = null;
    }

    public /* synthetic */ ResizableOutlineHandler(EditorEx editor, LineRange currentRange, Function1 canCreateComment, Function2 onDragFinished, DefaultConstructorMarker $constructor_marker) {
        this(editor, currentRange, (Function1<? super Integer, Boolean>)canCreateComment, (Function2<? super LineRangeEdge, ? super Integer, Unit>)onDragFinished);
    }

    public static final /* synthetic */ void access$updateCursorAndTooltip(ResizableOutlineHandler $this, Component component, Point point) {
        $this.updateCursorAndTooltip(component, point);
    }

    public static final /* synthetic */ Cursor access$getResizeCursor$p(ResizableOutlineHandler $this) {
        return $this.resizeCursor;
    }

    public static final /* synthetic */ MutableStateFlow access$getDragState$p(ResizableOutlineHandler $this) {
        return $this.dragState;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0089\u0001\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\u000f26\u0010\u0015\u001a2\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00190\u0016H\u0086@\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/intellij/collaboration/ui/codereview/editor/ResizableOutlineHandler$Companion;", "", "<init>", "()V", "showResizableOutline", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "inlayRenderer", "Lcom/intellij/collaboration/ui/codereview/editor/CodeReviewComponentInlayRenderer;", "activeRangesTracker", "Lcom/intellij/collaboration/ui/codereview/editor/CodeReviewActiveRangesTracker;", "initialRange", "Lcom/intellij/diff/util/LineRange;", "canCreateComment", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "editorLine", "", "onDragFinished", "Lkotlin/Function2;", "Lcom/intellij/collaboration/ui/codereview/editor/LineRangeEdge;", "edge", "", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/collaboration/ui/codereview/editor/CodeReviewComponentInlayRenderer;Lcom/intellij/collaboration/ui/codereview/editor/CodeReviewActiveRangesTracker;Lcom/intellij/diff/util/LineRange;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.collaborationTools"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object showResizableOutline(@NotNull EditorEx editor, @NotNull CodeReviewComponentInlayRenderer inlayRenderer, @NotNull CodeReviewActiveRangesTracker activeRangesTracker, @NotNull LineRange initialRange, @NotNull Function1<? super Integer, Boolean> canCreateComment, @NotNull Function2<? super LineRangeEdge, ? super Integer, Unit> onDragFinished, @NotNull Continuation<?> $completion) {
            if (!($completion instanceof showResizableOutline.1)) ** GOTO lbl-1000
            var9_8 = $completion;
            if ((var9_8.label & -2147483648) != 0) {
                var9_8.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.showResizableOutline(null, null, null, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var10_10 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)editor);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)inlayRenderer);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)activeRangesTracker);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)initialRange);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)canCreateComment);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)onDragFinished);
                    $continuation.label = 1;
                    v0 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getUiImmediate((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<?>, Object>(editor, initialRange, (Function1<? super Integer, Boolean>)canCreateComment, (Function2<? super LineRangeEdge, ? super Integer, Unit>)onDragFinished, inlayRenderer, activeRangesTracker, null){
                        Object L$0;
                        int label;
                        final /* synthetic */ EditorEx $editor;
                        final /* synthetic */ LineRange $initialRange;
                        final /* synthetic */ Function1<Integer, Boolean> $canCreateComment;
                        final /* synthetic */ Function2<LineRangeEdge, Integer, Unit> $onDragFinished;
                        final /* synthetic */ CodeReviewComponentInlayRenderer $inlayRenderer;
                        final /* synthetic */ CodeReviewActiveRangesTracker $activeRangesTracker;
                        {
                            this.$editor = $editor;
                            this.$initialRange = $initialRange;
                            this.$canCreateComment = $canCreateComment;
                            this.$onDragFinished = $onDragFinished;
                            this.$inlayRenderer = $inlayRenderer;
                            this.$activeRangesTracker = $activeRangesTracker;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object $result) {
                            var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    handler = new ResizableOutlineHandler(this.$editor, this.$initialRange, this.$canCreateComment, this.$onDragFinished, null);
                                    var3_4 = this.$editor.getGutterComponentEx().getMousePosition();
                                    var4_5 = this.$editor;
                                    it = var3_4;
                                    $i$a$-let-ResizableOutlineHandler$Companion$showResizableOutline$2$1 = false;
                                    ResizableOutlineHandler.access$updateCursorAndTooltip(handler, (Component)var4_5.getGutterComponentEx(), it);
                                    var4_5.getGutterComponentEx().setCursor(ResizableOutlineHandler.access$getResizeCursor$p(handler));
                                    this.L$0 = handler;
                                    this.label = 1;
                                    v0 = CoroutineUtilKt.collectScoped((Flow)ResizableOutlineHandler.access$getDragState$p(handler), (Function3)new Function3<CoroutineScope, DragState, Continuation<? super Unit>, Object>(this.$inlayRenderer, this.$editor, this.$activeRangesTracker, this.$initialRange, null){
                                        Object L$1;
                                        int label;
                                        /* synthetic */ Object L$0;
                                        final /* synthetic */ CodeReviewComponentInlayRenderer $inlayRenderer;
                                        final /* synthetic */ EditorEx $editor;
                                        final /* synthetic */ CodeReviewActiveRangesTracker $activeRangesTracker;
                                        final /* synthetic */ LineRange $initialRange;
                                        {
                                            this.$inlayRenderer = $inlayRenderer;
                                            this.$editor = $editor;
                                            this.$activeRangesTracker = $activeRangesTracker;
                                            this.$initialRange = $initialRange;
                                            super(3, $completion);
                                        }

                                        /*
                                         * WARNING - void declaration
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        public final Object invokeSuspend(Object $result) {
                                            void dragState;
                                            DragState dragState2 = (DragState)this.L$0;
                                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    if (dragState != null) break;
                                                    this.$inlayRenderer.setVisible(true);
                                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)dragState);
                                                    this.label = 1;
                                                    Object object2 = CodeReviewEditorInlayRangeOutlineUtilsKt.access$showOutline(this.$editor, this.$activeRangesTracker, this.$initialRange, (Continuation)this);
                                                    if (object2 != object) throw new KotlinNothingValueException();
                                                    return object;
                                                }
                                                case 1: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    Object object2 = $result;
                                                    throw new KotlinNothingValueException();
                                                }
                                            }
                                            this.$inlayRenderer.setVisible(false);
                                            LineRange newRange = switch (showResizableOutline.WhenMappings.$EnumSwitchMapping$0[dragState.getEdge().ordinal()]) {
                                                case 1 -> CodeReviewEditorInlayRangeOutlineUtilsKt.copy$default(this.$initialRange, Boxing.boxInt((int)dragState.getLine()), null, 2, null);
                                                case 2 -> CodeReviewEditorInlayRangeOutlineUtilsKt.copy$default(this.$initialRange, null, Boxing.boxInt((int)dragState.getLine()), 1, null);
                                                default -> throw new NoWhenBranchMatchedException();
                                            };
                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)dragState);
                                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)newRange);
                                            this.label = 2;
                                            Object object3 = CodeReviewEditorInlayRangeOutlineUtilsKt.access$showOutline(this.$editor, this.$activeRangesTracker, newRange, (Continuation)this);
                                            if (object3 != object) throw new KotlinNothingValueException();
                                            return object;
                                            {
                                                case 2: {
                                                    newRange = (LineRange)this.L$1;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    object3 = $result;
                                                    throw new KotlinNothingValueException();
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Object invoke(CoroutineScope p1, DragState p2, Continuation<? super Unit> p3) {
                                            var var4_4 = new /* invalid duplicate definition of identical inner class */;
                                            var4_4.L$0 = p2;
                                            return var4_4.invokeSuspend(Unit.INSTANCE);
                                        }
                                    }, (Continuation<? super Unit>)((Continuation)this));
                                    ** if (v0 != var7_2) goto lbl21
lbl20:
                                    // 1 sources

                                    return var7_2;
lbl21:
                                    // 1 sources

                                    ** GOTO lbl28
                                }
                                case 1: {
                                    handler = (ResizableOutlineHandler)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl28:
                                    // 2 sources

                                    this.L$0 = handler;
                                    this.label = 2;
                                    v1 = DelayKt.awaitCancellation((Continuation)((Continuation)this));
                                    ** if (v1 != var7_2) goto lbl33
lbl32:
                                    // 1 sources

                                    return var7_2;
lbl33:
                                    // 1 sources

                                    ** GOTO lbl40
                                }
                                case 2: {
                                    handler = (ResizableOutlineHandler)this.L$0;
                                    try {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl40:
                                        // 2 sources

                                        throw new KotlinNothingValueException();
                                    }
                                    catch (Throwable var4_6) {
                                        Disposer.dispose((Disposable)handler);
                                        throw var4_6;
                                    }
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<?> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v0 == var10_10) {
                        return var10_10;
                    }
                    ** GOTO lbl32
                }
                case 1: {
                    onDragFinished = (Function2)$continuation.L$5;
                    canCreateComment = (Function1)$continuation.L$4;
                    initialRange = (LineRange)$continuation.L$3;
                    activeRangesTracker = (CodeReviewActiveRangesTracker)$continuation.L$2;
                    inlayRenderer = (CodeReviewComponentInlayRenderer)$continuation.L$1;
                    editor = (EditorEx)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl32:
                    // 2 sources

                    throw new KotlinNothingValueException();
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/collaboration/ui/codereview/editor/ResizableOutlineHandler$DragOutcome;", "", "<init>", "(Ljava/lang/String;I)V", "SUCCESS", "UNCHANGED", "INVALID", "intellij.platform.collaborationTools"})
    private static final class DragOutcome
    extends Enum<DragOutcome> {
        public static final /* enum */ DragOutcome SUCCESS = new DragOutcome();
        public static final /* enum */ DragOutcome UNCHANGED = new DragOutcome();
        public static final /* enum */ DragOutcome INVALID = new DragOutcome();
        private static final /* synthetic */ DragOutcome[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DragOutcome[] values() {
            return (DragOutcome[])$VALUES.clone();
        }

        public static DragOutcome valueOf(String value) {
            return Enum.valueOf(DragOutcome.class, value);
        }

        @NotNull
        public static EnumEntries<DragOutcome> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = dragOutcomeArray = new DragOutcome[]{DragOutcome.SUCCESS, DragOutcome.UNCHANGED, DragOutcome.INVALID};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0005H\u00d6\u0081\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/collaboration/ui/codereview/editor/ResizableOutlineHandler$DragState;", "", "edge", "Lcom/intellij/collaboration/ui/codereview/editor/LineRangeEdge;", "line", "", "<init>", "(Lcom/intellij/collaboration/ui/codereview/editor/LineRangeEdge;I)V", "getEdge", "()Lcom/intellij/collaboration/ui/codereview/editor/LineRangeEdge;", "getLine", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.collaborationTools"})
    private static final class DragState {
        @NotNull
        private final LineRangeEdge edge;
        private final int line;

        public DragState(@NotNull LineRangeEdge edge, int line) {
            Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
            this.edge = edge;
            this.line = line;
        }

        @NotNull
        public final LineRangeEdge getEdge() {
            return this.edge;
        }

        public final int getLine() {
            return this.line;
        }

        @NotNull
        public final LineRangeEdge component1() {
            return this.edge;
        }

        public final int component2() {
            return this.line;
        }

        @NotNull
        public final DragState copy(@NotNull LineRangeEdge edge, int line) {
            Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
            return new DragState(edge, line);
        }

        public static /* synthetic */ DragState copy$default(DragState dragState, LineRangeEdge lineRangeEdge, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                lineRangeEdge = dragState.edge;
            }
            if ((n2 & 2) != 0) {
                n = dragState.line;
            }
            return dragState.copy(lineRangeEdge, n);
        }

        @NotNull
        public String toString() {
            return "DragState(edge=" + this.edge + ", line=" + this.line + ")";
        }

        public int hashCode() {
            int result = this.edge.hashCode();
            result = result * 31 + Integer.hashCode(this.line);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DragState)) {
                return false;
            }
            DragState dragState = (DragState)other;
            if (this.edge != dragState.edge) {
                return false;
            }
            return this.line == dragState.line;
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LineRangeEdge.values().length];
            try {
                nArray[LineRangeEdge.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineRangeEdge.END.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

