/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;

public final class FontUtil {
    public static Font getMenuFont() {
        return UIManager.getFont("Menu.font");
    }

    public static String @NotNull [] getValidFontNames(boolean familyName) {
        TreeSet<String> result = new TreeSet<String>();
        for (Font font : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            try {
                if (!FontUtil.isValidFont(font)) continue;
                result.add(familyName ? font.getFamily() : font.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Font labelFont = StartupUiUtil.getLabelFont();
        if (FontUtil.isValidFont(labelFont)) {
            result.add(familyName ? labelFont.getFamily() : labelFont.getName());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result);
        if (stringArray == null) {
            FontUtil.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    @NotNull
    public static String leftArrow(@NotNull Font font) {
        if (font == null) {
            FontUtil.$$$reportNull$$$0(1);
        }
        return FontUtil.canDisplay(font, '\u2190', "<-");
    }

    @NotNull
    @NlsSafe
    public static String rightArrow(@NotNull Font font) {
        if (font == null) {
            FontUtil.$$$reportNull$$$0(2);
        }
        return FontUtil.canDisplay(font, '\u2192', "->");
    }

    public static boolean isValidFont(@NotNull Font font) {
        if (font == null) {
            FontUtil.$$$reportNull$$$0(3);
        }
        try {
            return font.canDisplay('a') && font.canDisplay('z') && font.canDisplay('A') && font.canDisplay('Z') && font.canDisplay('0') && font.canDisplay('1');
        }
        catch (Exception e) {
            return false;
        }
    }

    @NotNull
    public static String upArrow(@NotNull Font font, @NotNull String defaultValue) {
        if (font == null) {
            FontUtil.$$$reportNull$$$0(4);
        }
        if (defaultValue == null) {
            FontUtil.$$$reportNull$$$0(5);
        }
        return FontUtil.canDisplay(font, '\u2191', defaultValue);
    }

    @NotNull
    public static String canDisplay(@NotNull Font font, char value, @NotNull String defaultValue) {
        if (font == null) {
            FontUtil.$$$reportNull$$$0(6);
        }
        if (defaultValue == null) {
            FontUtil.$$$reportNull$$$0(7);
        }
        String string = font.canDisplay(value) ? String.valueOf(value) : defaultValue;
        if (string == null) {
            FontUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String spaceAndThinSpace() {
        String string = " " + FontUtil.thinSpace();
        if (string == null) {
            FontUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String thinSpace() {
        return FontUtil.canDisplay(StartupUiUtil.getLabelFont(), '\u2009', " ");
    }

    @NotNull
    public static Font minusOne(@NotNull Font font) {
        if (font == null) {
            FontUtil.$$$reportNull$$$0(10);
        }
        Font font2 = font.deriveFont((float)font.getSize() - 1.0f);
        if (font2 == null) {
            FontUtil.$$$reportNull$$$0(11);
        }
        return font2;
    }

    @NotNull
    public static Font deriveFont(@NotNull Font oldFont, @NotNull Map<? extends AttributedCharacterIterator.Attribute, ?> attributes) {
        if (oldFont == null) {
            FontUtil.$$$reportNull$$$0(12);
        }
        if (attributes == null) {
            FontUtil.$$$reportNull$$$0(13);
        }
        Font newFont = oldFont.deriveFont(attributes);
        Font font = oldFont instanceof UIResource ? new FontUIResource(newFont) : newFont;
        if (font == null) {
            FontUtil.$$$reportNull$$$0(14);
        }
        return font;
    }

    @NotNull
    public static Font disableKerning(@NotNull Font font) {
        if (font == null) {
            FontUtil.$$$reportNull$$$0(15);
        }
        return FontUtil.deriveFont(font, DisableKerning.LAZY);
    }

    @NotNull
    public static Font enableKerning(@NotNull Font font) {
        if (font == null) {
            FontUtil.$$$reportNull$$$0(16);
        }
        return FontUtil.deriveFont(font, EnableKerning.LAZY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 10, 12, 13, 15, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/FontUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFont";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidFontNames";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/FontUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "canDisplay";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "spaceAndThinSpace";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "minusOne";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "deriveFont";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "leftArrow";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "rightArrow";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidFont";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "upArrow";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canDisplay";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "minusOne";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deriveFont";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "disableKerning";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "enableKerning";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 10, 12, 13, 15, 16 -> new IllegalArgumentException(string);
        };
    }

    private static final class DisableKerning {
        private static final Map<AttributedCharacterIterator.Attribute, Integer> LAZY = Collections.singletonMap(TextAttribute.KERNING, null);

        private DisableKerning() {
        }
    }

    private static final class EnableKerning {
        private static final Map<AttributedCharacterIterator.Attribute, Integer> LAZY = Collections.singletonMap(TextAttribute.KERNING, TextAttribute.KERNING_ON);

        private EnableKerning() {
        }
    }
}

