/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules;

import ai.grazie.rules.MatchingResult;
import ai.grazie.rules.NodeRuleMatch;
import ai.grazie.rules.Rule;
import ai.grazie.rules.document.DocumentRule;
import ai.grazie.rules.document.DocumentSentence;
import ai.grazie.rules.tree.AccessedParameters;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.PatternSet;
import ai.grazie.rules.tree.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;

public class RuleSet {
    private final PatternSet hinted;
    public final List<? extends Rule> rules;
    private final List<Rule> nonHinted = new ArrayList<Rule>();
    private final int[] nonHintedIndexMapping;
    private final int[] hintedIndexMapping;
    private final boolean allSupportFlatTrees;

    public RuleSet(List<? extends Rule> rules) {
        this.rules = rules;
        this.allSupportFlatTrees = rules.stream().allMatch(Rule::supportsFlatTrees);
        ArrayList<NodePattern> hinted = new ArrayList<NodePattern>();
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<Integer> hintedIndexToFull = new ArrayList<Integer>();
        ArrayList<Integer> nonHintedIndexToFull = new ArrayList<Integer>();
        for (int i = 0; i < rules.size(); ++i) {
            Rule rule = rules.get(i);
            if (rule instanceof Rule.PatternRule) {
                Rule.PatternRule pr = (Rule.PatternRule)rule;
                if (!(pr.pattern().hint.allowsEverything() || !this.allSupportFlatTrees && pr.supportsFlatTrees())) {
                    hintedIndexToFull.add(i);
                    hinted.add(pr.pattern());
                    ids.add(rule.id);
                    continue;
                }
            }
            this.nonHinted.add(rule);
            nonHintedIndexToFull.add(i);
        }
        this.hinted = new PatternSet(hinted, ids);
        this.hintedIndexMapping = hintedIndexToFull.stream().mapToInt(Integer::intValue).toArray();
        this.nonHintedIndexMapping = nonHintedIndexToFull.stream().mapToInt(Integer::intValue).toArray();
    }

    public List<MatchingResult> checkSeparateSentences(List<Tree> trees) {
        return trees.stream().map(tree -> MatchingResult.concat((Iterable<MatchingResult>)this.matchSeparately((Tree)tree).map(PatternSet.IndexedMatch::match))).toList();
    }

    public MatchingResult checkAsDocument(List<Tree> trees) {
        return this.checkDocument(trees.stream().map(t -> new DocumentSentence.Parsed((Tree)t)).toList());
    }

    public MatchingResult checkDocument(List<DocumentSentence.Parsed> sentences) {
        return this.checkDocument(sentences, this.checkSeparateSentences(sentences.stream().map(s -> s.tree).toList()));
    }

    public MatchingResult checkDocument(List<DocumentSentence.Parsed> sentences, List<MatchingResult> perSentenceMatches) {
        Collection<MatchingResult> docMatches = this.runDocumentRules(sentences, perSentenceMatches).values();
        return MatchingResult.concat((Iterable<MatchingResult>)StreamEx.of(perSentenceMatches).append(docMatches).map(mr -> mr.withoutMetadata()));
    }

    public Map<Rule, MatchingResult> runDocumentRules(List<DocumentSentence.Parsed> sentences, List<MatchingResult> perSentenceMatches) {
        List doc = StreamEx.zip(sentences, perSentenceMatches, (sentence, match) -> sentence.withMetadata(match.metadata)).toList();
        return ((StreamEx)StreamEx.of(this.rules).filter(r -> r instanceof DocumentRule)).mapToEntry(r -> ((DocumentRule)((Object)r)).checkDocument(doc)).toCustomMap(LinkedHashMap::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamEx<PatternSet.IndexedMatch<MatchingResult>> matchSeparately(Tree tree) {
        List<PatternSet.IndexedMatch<NodeMatch>> matches;
        ArrayList<PatternSet.IndexedMatch<MatchingResult>> results = new ArrayList<PatternSet.IndexedMatch<MatchingResult>>();
        if (this.hintedIndexMapping.length > 0 && !(matches = this.hinted.matchTree(this.allSupportFlatTrees && tree.nodes().isEmpty() ? tree.getFlatTree() : tree)).isEmpty()) {
            Map byHintedIndex = StreamEx.of(matches).groupingBy(im -> im.index());
            for (Map.Entry entry : byHintedIndex.entrySet()) {
                int ruleIndex = this.hintedIndexMapping[(Integer)entry.getKey()];
                Rule.PatternRule rule = (Rule.PatternRule)this.rules.get(ruleIndex);
                List ruleMatches = StreamEx.of((Collection)((Collection)entry.getValue())).map(im -> new NodeRuleMatch((Rule)rule, ((NodeMatch)im.match()).checkStubbedEquivalent(rule.pattern(), rule))).toList();
                results.add(new PatternSet.IndexedMatch<MatchingResult>(ruleIndex, MatchingResult.from(ruleMatches)));
            }
        }
        if (!this.nonHinted.isEmpty()) {
            AccessedParameters current = AccessedParameters.current();
            String prevId = current == null ? null : current.ruleId;
            try {
                for (int i = 0; i < this.nonHinted.size(); ++i) {
                    boolean needsFlat;
                    MatchingResult mr;
                    Rule rule = this.nonHinted.get(i);
                    if (current != null) {
                        current.ruleId = rule.id;
                    }
                    if ((mr = rule.match((needsFlat = rule instanceof Rule.PatternRule && rule.supportsFlatTrees()) && tree.nodes().isEmpty() ? tree.getFlatTree() : tree)).isEmpty()) continue;
                    results.add(new PatternSet.IndexedMatch<MatchingResult>(this.nonHintedIndexMapping[i], mr));
                }
            }
            finally {
                if (current != null) {
                    current.ruleId = prevId;
                }
            }
        }
        return (StreamEx)StreamEx.of(results).sorted(Comparator.comparing(PatternSet.IndexedMatch::index));
    }
}

