/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.core;

import com.intellij.liquibase.core.extension.LiquibaseFrameworkContextProvider;
import com.intellij.liquibase.core.extension.LiquibaseSearcher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.PlaceholderTextRanges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0018\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0010\u0010\n\u001a\u00020\u00012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\r\u001a\u00020\u000e\u001a\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\r\u001a\u00020\u000e\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u001a\u001a\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u0013H\u0000\u001a\f\u0010\u001c\u001a\u0004\u0018\u00010\u0010*\u00020\b\u001a\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u0013*\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020 \u001a\u0014\u0010!\u001a\u0004\u0018\u00010\u0003*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001aO\u0010\"\u001a\u00020\u0001\"\u0004\b\u0000\u0010#2\u0006\u0010$\u001a\u0002H#2\u0014\u0010%\u001a\u0010\u0012\u0004\u0012\u0002H#\u0012\u0006\u0012\u0004\u0018\u00010\u00130&2\u0014\u0010'\u001a\u0010\u0012\u0004\u0012\u0002H#\u0012\u0006\u0012\u0004\u0018\u0001H#0&2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010(\u00a8\u0006)"}, d2={"isMainChangeLog", "", "changeLogFile", "Lcom/intellij/psi/PsiFile;", "getLiquibasePlaceHolderRanges", "", "Lcom/intellij/openapi/util/TextRange;", "psiElement", "Lcom/intellij/psi/PsiElement;", "isInLiquibaseXmlChangelog", "isUnderDbChangelogDir", "currentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "currentDirectory", "Lcom/intellij/psi/PsiDirectory;", "findAllContexts", "", "", "findAllLabels", "getContainingTag", "Lcom/intellij/psi/xml/XmlTag;", "xmlElement", "Lcom/intellij/psi/xml/XmlElement;", "formatPropertyValue", "value", "dbms", "getSourceRoot", "getClassPathRelativePath", "Lcom/intellij/psi/PsiFileSystemItem;", "separatorChar", "", "toPsiFile", "isUnderChangelogRootDir", "T", "dir", "nameFun", "Lkotlin/Function1;", "parentFun", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lcom/intellij/openapi/project/Project;)Z", "intellij.liquibase.core"})
@SourceDebugExtension(value={"SMAP\nLiquibaseUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiquibaseUtil.kt\ncom/intellij/liquibase/core/LiquibaseUtilKt\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n19#2:152\n1391#3:153\n1480#3,5:154\n1391#3:159\n1480#3,5:160\n1391#3:165\n1480#3,5:166\n1391#3:171\n1480#3,5:172\n777#3:177\n873#3,2:178\n*S KotlinDebug\n*F\n+ 1 LiquibaseUtil.kt\ncom/intellij/liquibase/core/LiquibaseUtilKt\n*L\n37#1:152\n62#1:153\n62#1:154,5\n65#1:159\n65#1:160,5\n70#1:165\n70#1:166,5\n73#1:171\n73#1:172,5\n138#1:177\n138#1:178,2\n*E\n"})
public final class LiquibaseUtilKt {
    public static final boolean isMainChangeLog(@NotNull PsiFile changeLogFile) {
        VirtualFile virtualFile;
        block1: {
            Intrinsics.checkNotNullParameter((Object)changeLogFile, (String)"changeLogFile");
            Project project = changeLogFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            for (LiquibaseFrameworkContextProvider it : (Iterable)LiquibaseFrameworkContextProvider.Companion.getEP_NAME().getExtensionList()) {
                boolean bl = false;
                VirtualFile virtualFile2 = it.findMainChangeLogFile(project2);
                if (virtualFile2 == null) continue;
                virtualFile = virtualFile2;
                break block1;
            }
            virtualFile = null;
        }
        VirtualFile mainChangeLogFile = virtualFile;
        return Intrinsics.areEqual(mainChangeLogFile, (Object)changeLogFile.getVirtualFile());
    }

    @NotNull
    public static final Set<TextRange> getLiquibasePlaceHolderRanges(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Set set = PlaceholderTextRanges.getPlaceholderRanges((String)psiElement.getText(), (String)"${", (String)"}");
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getPlaceholderRanges(...)");
        return set;
    }

    public static final boolean isInLiquibaseXmlChangelog(@NotNull PsiElement psiElement) {
        XmlFile xmlFile;
        XmlFile xmlFile2;
        XmlTag rootTag;
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        PsiFile $this$asSafely$iv = psiElement.getContainingFile();
        boolean $i$f$asSafely = false;
        PsiFile psiFile = $this$asSafely$iv;
        if (!(psiFile instanceof XmlFile)) {
            psiFile = null;
        }
        XmlTag xmlTag = rootTag = (xmlFile2 = (xmlFile = (XmlFile)psiFile)) != null && (xmlFile2 = xmlFile2.getDocument()) != null ? xmlFile2.getRootTag() : null;
        return Intrinsics.areEqual((Object)(xmlTag != null ? xmlTag.getName() : null), (Object)"databaseChangeLog");
    }

    public static final boolean isUnderDbChangelogDir(@NotNull VirtualFile currentFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile vFile = currentFile;
        while (vFile.getParent() != null) {
            if (LiquibaseUtilKt.isUnderChangelogRootDir(vFile, LiquibaseUtilKt::isUnderDbChangelogDir$lambda$0, LiquibaseUtilKt::isUnderDbChangelogDir$lambda$1, project)) {
                return true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)vFile.getParent(), (String)"getParent(...)");
        }
        return false;
    }

    public static final boolean isUnderDbChangelogDir(@Nullable PsiDirectory currentDirectory) {
        if (currentDirectory == null) {
            return false;
        }
        for (PsiDirectory directory = currentDirectory; directory != null && directory.getParentDirectory() != null; directory = directory.getParentDirectory()) {
            Function1 function1 = LiquibaseUtilKt::isUnderDbChangelogDir$lambda$2;
            Function1 function12 = LiquibaseUtilKt::isUnderDbChangelogDir$lambda$3;
            Project project = currentDirectory.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (!LiquibaseUtilKt.isUnderChangelogRootDir(directory, function1, function12, project)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> findAllContexts(@NotNull Project project) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$flatMap$iv = LiquibaseFrameworkContextProvider.Companion.getEP_NAME().getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            LiquibaseFrameworkContextProvider it = (LiquibaseFrameworkContextProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getSettingsContexts(project);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List settingsContexts = (List)destination$iv$iv;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        Iterable $this$flatMap$iv2 = LiquibaseSearcher.Companion.getAllImplementations(project);
        boolean $i$f$flatMap2 = false;
        destination$iv$iv = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            LiquibaseSearcher it = (LiquibaseSearcher)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.findAllContexts(scope);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)CollectionsKt.union((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv2)), (Iterable)settingsContexts));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> findAllLabels(@NotNull Project project) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$flatMap$iv = LiquibaseFrameworkContextProvider.Companion.getEP_NAME().getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            LiquibaseFrameworkContextProvider it = (LiquibaseFrameworkContextProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getSettingsLabels(project);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List settingsLabels = (List)destination$iv$iv;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        Iterable $this$flatMap$iv2 = LiquibaseSearcher.Companion.getAllImplementations(project);
        boolean $i$f$flatMap2 = false;
        destination$iv$iv = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            LiquibaseSearcher it = (LiquibaseSearcher)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.findAllLabels(scope);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)CollectionsKt.union((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv2)), (Iterable)settingsLabels));
    }

    @Nullable
    public static final XmlTag getContainingTag(@Nullable XmlElement xmlElement) {
        PsiElement element;
        for (element = (PsiElement)xmlElement; element != null && !(element instanceof XmlTag); element = element.getParent()) {
            PsiElement parent = element.getParent();
            if (parent instanceof XmlElement || element instanceof CompositePsiElement && ((CompositePsiElement)element).getElementType() == XmlElementType.XML_CDATA) {
                continue;
            }
            return null;
        }
        return (XmlTag)element;
    }

    @NotNull
    public static final String formatPropertyValue(@NotNull String value, @Nullable String dbms) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CharSequence charSequence = dbms;
        return charSequence == null || charSequence.length() == 0 ? value : value + " (" + dbms + ")";
    }

    @Nullable
    public static final PsiDirectory getSourceRoot(@NotNull PsiElement $this$getSourceRoot) {
        PsiFileSystemItem psiFileSystemItem;
        Intrinsics.checkNotNullParameter((Object)$this$getSourceRoot, (String)"<this>");
        if ($this$getSourceRoot instanceof PsiDirectory) {
            psiFileSystemItem = (PsiFileSystemItem)$this$getSourceRoot;
        } else {
            PsiFile psiFile = $this$getSourceRoot.getContainingFile();
            if (psiFile == null) {
                return null;
            }
            psiFileSystemItem = (PsiFileSystemItem)psiFile;
        }
        PsiFileSystemItem fileSystemItem = psiFileSystemItem;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)fileSystemItem));
        if (module == null) {
            return null;
        }
        Module module2 = module;
        ContentEntry[] contentEntryArray = ModuleRootManager.getInstance((Module)module2).getContentEntries();
        Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray, (String)"getContentEntries(...)");
        return (PsiDirectory)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])contentEntryArray), LiquibaseUtilKt::getSourceRoot$lambda$0), arg_0 -> LiquibaseUtilKt.getSourceRoot$lambda$1(fileSystemItem, arg_0)), arg_0 -> LiquibaseUtilKt.getSourceRoot$lambda$2($this$getSourceRoot, arg_0)));
    }

    @Nullable
    public static final String getClassPathRelativePath(@NotNull PsiFileSystemItem $this$getClassPathRelativePath, char separatorChar) {
        Intrinsics.checkNotNullParameter((Object)$this$getClassPathRelativePath, (String)"<this>");
        PsiDirectory sourceRoot = LiquibaseUtilKt.getSourceRoot((PsiElement)$this$getClassPathRelativePath);
        if (sourceRoot != null) {
            return VfsUtil.findRelativePath((VirtualFile)sourceRoot.getVirtualFile(), (VirtualFile)$this$getClassPathRelativePath.getVirtualFile(), (char)separatorChar);
        }
        if ($this$getClassPathRelativePath.getVirtualFile().isInLocalFileSystem() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        return VfsUtil.findRelativePath((VirtualFile)VfsUtil.getRootFile((VirtualFile)$this$getClassPathRelativePath.getVirtualFile()), (VirtualFile)$this$getClassPathRelativePath.getVirtualFile(), (char)separatorChar);
    }

    public static /* synthetic */ String getClassPathRelativePath$default(PsiFileSystemItem psiFileSystemItem, char c, int n, Object object) {
        if ((n & 1) != 0) {
            c = (char)47;
        }
        return LiquibaseUtilKt.getClassPathRelativePath(psiFileSystemItem, c);
    }

    @Nullable
    public static final PsiFile toPsiFile(@NotNull VirtualFile $this$toPsiFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$toPsiFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return PsiManager.getInstance((Project)project).findFile($this$toPsiFile);
    }

    private static final <T> boolean isUnderChangelogRootDir(T dir, Function1<? super T, String> nameFun, Function1<? super T, ? extends T> parentFun, Project project) {
        for (LiquibaseFrameworkContextProvider provider : LiquibaseFrameworkContextProvider.Companion.getEP_NAME().getExtensionList()) {
            for (String pattern : provider.changelogDirPatterns(project)) {
                if (!LiquibaseUtilKt.isUnderChangelogRootDir$checkPattern(dir, nameFun, parentFun, pattern)) continue;
                return true;
            }
        }
        return false;
    }

    private static final String isUnderDbChangelogDir$lambda$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final VirtualFile isUnderDbChangelogDir$lambda$1(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    private static final String isUnderDbChangelogDir$lambda$2(PsiDirectory it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final PsiDirectory isUnderDbChangelogDir$lambda$3(PsiDirectory it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    private static final VirtualFile getSourceRoot$lambda$0$0(SourceFolder it) {
        return it.getFile();
    }

    private static final Sequence getSourceRoot$lambda$0(ContentEntry contentEntry) {
        SourceFolder[] sourceFolderArray = contentEntry.getSourceFolders();
        Intrinsics.checkNotNullExpressionValue((Object)sourceFolderArray, (String)"getSourceFolders(...)");
        return SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])sourceFolderArray), LiquibaseUtilKt::getSourceRoot$lambda$0$0);
    }

    private static final boolean getSourceRoot$lambda$1(PsiFileSystemItem $fileSystemItem, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return VfsUtil.isAncestor((VirtualFile)it, (VirtualFile)$fileSystemItem.getVirtualFile(), (boolean)false);
    }

    private static final PsiDirectory getSourceRoot$lambda$2(PsiElement $this_getSourceRoot, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PsiManager.getInstance((Project)$this_getSourceRoot.getProject()).findDirectory(it);
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> boolean isUnderChangelogRootDir$checkPattern(T $dir, Function1<? super T, String> $nameFun, Function1<? super T, ? extends T> $parentFun, String pattern) {
        void $this$filterTo$iv$iv;
        Object dirTmp = $dir;
        char[] cArray = new char[]{'/'};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)pattern, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (String patternPart : CollectionsKt.reversed((Iterable)((List)destination$iv$iv))) {
            if (dirTmp == null) {
                return false;
            }
            String string = (String)$nameFun.invoke(dirTmp);
            if (!(string != null ? StringsKt.equals((String)string, (String)patternPart, (boolean)true) : false)) {
                return false;
            }
            dirTmp = $parentFun.invoke(dirTmp);
        }
        return true;
    }
}

