/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.maven;

import com.intellij.micronaut.run.MnRunConfigurationService;
import com.intellij.micronaut.settings.MicronautSettings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.importing.MavenAfterImportConfigurator;
import org.jetbrains.idea.maven.importing.MavenApplicableConfigurator;
import org.jetbrains.idea.maven.importing.MavenConfiguratorsKt;
import org.jetbrains.idea.maven.importing.MavenWorkspaceConfigurator;
import org.jetbrains.idea.maven.project.MavenProject;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/micronaut/maven/MnMavenImporter;", "Lorg/jetbrains/idea/maven/importing/MavenApplicableConfigurator;", "Lorg/jetbrains/idea/maven/importing/MavenAfterImportConfigurator;", "<init>", "()V", "isApplicable", "", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "afterImport", "", "context", "Lorg/jetbrains/idea/maven/importing/MavenAfterImportConfigurator$Context;", "createRunConfigurationsFor", "project", "Lcom/intellij/openapi/project/Project;", "mavenProjectWithModule", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "Lcom/intellij/openapi/module/Module;", "intellij.micronaut.maven"})
@SourceDebugExtension(value={"SMAP\nMnMavenImporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnMavenImporter.kt\ncom/intellij/micronaut/maven/MnMavenImporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class MnMavenImporter
extends MavenApplicableConfigurator
implements MavenAfterImportConfigurator {
    public MnMavenImporter() {
        super("io.micronaut.build", "micronaut-maven-plugin");
    }

    public boolean isApplicable(@NotNull MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        return !((Collection)mavenProject.findDependencies("io.micronaut", "micronaut-core")).isEmpty();
    }

    public void afterImport(@NotNull MavenAfterImportConfigurator.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!MicronautSettings.Companion.getInstance(context.getProject()).getAutoCreateRunConfiguration()) {
            return;
        }
        Sequence applicableChangedProjectsWithModules = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)context.getMavenProjectsWithModules(), arg_0 -> MnMavenImporter.afterImport$lambda$0(this, arg_0)), MnMavenImporter::afterImport$lambda$1);
        this.createRunConfigurationsFor(context.getProject(), (Sequence<? extends Pair<MavenProject, ? extends Module>>)applicableChangedProjectsWithModules);
    }

    private final void createRunConfigurationsFor(Project project, Sequence<? extends Pair<MavenProject, ? extends Module>> mavenProjectWithModule) {
        for (Pair pair : mavenProjectWithModule) {
            MavenProject mavenProject = (MavenProject)pair.component1();
            Module module = (Module)pair.component2();
            Supplier<String> supplier = () -> MnMavenImporter.createRunConfigurationsFor$lambda$0(this, mavenProject, project);
            MnRunConfigurationService.Companion.getInstance(project).createRunConfiguration(module, supplier);
        }
    }

    private static final boolean afterImport$lambda$0(MnMavenImporter this$0, MavenWorkspaceConfigurator.MavenProjectWithModules it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return MavenConfiguratorsKt.hasChanges((MavenWorkspaceConfigurator.MavenProjectWithModules)it) && this$0.isApplicable(it.getMavenProject());
    }

    private static final Pair afterImport$lambda$1(MavenWorkspaceConfigurator.MavenProjectWithModules it) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Iterable iterable = it.getModules();
            for (Object t : iterable) {
                MavenWorkspaceConfigurator.ModuleWithType moduleWithType = (MavenWorkspaceConfigurator.ModuleWithType)t;
                boolean bl = false;
                if (!moduleWithType.getType().getContainsMain()) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        MavenWorkspaceConfigurator.ModuleWithType moduleWithType = v0;
        Module moduleWithMainSources = moduleWithType != null ? (Module)moduleWithType.getModule() : null;
        return moduleWithMainSources != null ? TuplesKt.to((Object)it.getMavenProject(), (Object)moduleWithMainSources) : null;
    }

    private static final String createRunConfigurationsFor$lambda$0(MnMavenImporter this$0, MavenProject $mavenProject, Project $project) {
        String configValue = this$0.findConfigValue($mavenProject, "mainClass");
        CharSequence charSequence = configValue;
        if (!(charSequence == null || charSequence.length() == 0)) {
            return configValue;
        }
        MavenDomProjectModel mavenDomProjectModel = MavenDomUtil.getMavenDomProjectModel((Project)$project, (VirtualFile)$mavenProject.getFile());
        if (mavenDomProjectModel == null) {
            return null;
        }
        MavenDomProjectModel mavenDomProjectModel2 = mavenDomProjectModel;
        XmlTag xmlTag = MavenDomProjectProcessorUtils.searchProperty((String)"exec.mainClass", (MavenDomProjectModel)mavenDomProjectModel2, (Project)$project);
        if (xmlTag == null) {
            return null;
        }
        XmlTag pomXmlProperty = xmlTag;
        return pomXmlProperty.getValue().getTrimmedText();
    }
}

