/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider;

import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlPksParser;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PartiallyKnownString;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH\u0000\"\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"transformClientContext", "Lcom/intellij/microservices/url/references/UrlPathContext;", "client", "Lorg/jetbrains/uast/UAnnotation;", "findClientAnnotationFromCall", "clientCall", "Lorg/jetbrains/uast/UCallExpression;", "mnMimeTypeAnnotationValuePattern", "Lcom/intellij/patterns/ElementPattern;", "Lorg/jetbrains/uast/UExpression;", "CLIENT_METHOD_NAMES", "", "", "intellij.micronaut"})
public final class MnWebReferenceContributorKt {
    @NotNull
    private static final List<String> CLIENT_METHOD_NAMES;

    private static final UrlPathContext transformClientContext(UrlPathContext $this$transformClientContext, UAnnotation client) {
        String path;
        String value;
        if (client == null || !((Collection)$this$transformClientContext.getAuthorities()).isEmpty()) {
            return $this$transformClientContext;
        }
        UExpression uExpression = client.findAttributeValue("value");
        String string = value = uExpression != null ? UastUtils.evaluateString((UExpression)uExpression) : null;
        if (value != null) {
            UrlPksParser parser = new UrlPksParser(null, null, false, 3, null);
            parser.setShouldHaveScheme(false);
            UrlPksParser.ParsedPksUrl root = parser.parseFullUrl(new PartiallyKnownString(value));
            PartiallyKnownString partiallyKnownString = root.getAuthority();
            String rootAuthority = partiallyKnownString != null ? partiallyKnownString.getConcatenationOfKnown() : null;
            UrlPathContext nestedContext = $this$transformClientContext.subContext(root.getUrlPath());
            CharSequence charSequence = rootAuthority;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return nestedContext;
            }
            return nestedContext.withAuthorities(SetsKt.setOf((Object)rootAuthority));
        }
        UExpression uExpression2 = client.findAttributeValue("path");
        String string2 = path = uExpression2 != null ? UastUtils.evaluateString((UExpression)uExpression2) : null;
        if (path != null) {
            UrlPksParser parser = new UrlPksParser(null, null, false, 3, null);
            UrlPksParser.ParsedPksUrlPath parsedPath = parser.parseUrlPath(new PartiallyKnownString(path));
            return $this$transformClientContext.subContext(parsedPath.getUrlPath());
        }
        return $this$transformClientContext;
    }

    private static final UAnnotation findClientAnnotationFromCall(UCallExpression clientCall) {
        if (clientCall.isMethodNameOneOf((Collection)CLIENT_METHOD_NAMES)) {
            UElement variableOrField;
            UExpression receiver;
            String qualifiedName;
            PsiMethod psiMethod = clientCall.resolve();
            String string = psiMethod != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : (qualifiedName = null);
            if ((Intrinsics.areEqual((Object)qualifiedName, (Object)"io.micronaut.http.client.HttpClient") || Intrinsics.areEqual((Object)qualifiedName, (Object)"io.micronaut.http.client.BlockingHttpClient")) && (receiver = clientCall.getReceiver()) instanceof UReferenceExpression && (variableOrField = UResolvableKt.resolveToUElement((UResolvable)((UResolvable)receiver))) instanceof UField) {
                return ((UField)variableOrField).findAnnotation("io.micronaut.http.client.annotation.Client");
            }
        }
        return null;
    }

    @NotNull
    public static final ElementPattern<? extends UExpression> mnMimeTypeAnnotationValuePattern() {
        String[] stringArray = new String[]{"consumes", "produces", "processes"};
        StringPattern stringPattern = StandardPatterns.string().oneOf(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern, (String)"oneOf(...)");
        StringPattern mimeProcessingAttrs = stringPattern;
        UExpressionPattern.Capture expr = (UExpressionPattern.Capture)UastPatterns.uExpression().filter(MnWebReferenceContributorKt::mnMimeTypeAnnotationValuePattern$lambda$0);
        ElementPattern[] elementPatternArray = new ElementPattern[4];
        String[] stringArray2 = new String[]{"io.micronaut.http.annotation.Produces", "io.micronaut.http.annotation.Consumes"};
        StringPattern stringPattern2 = StandardPatterns.string().oneOf(stringArray2);
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern2, (String)"oneOf(...)");
        elementPatternArray[0] = expr.annotationParam((ElementPattern)stringPattern2, "value");
        Object[] objectArray = new String[]{"io.micronaut.http.annotation.Get", "io.micronaut.http.annotation.Post", "io.micronaut.http.annotation.Put", "io.micronaut.http.annotation.Patch", "io.micronaut.http.annotation.Delete", "io.micronaut.http.annotation.CustomHttpMethod"};
        elementPatternArray[1] = expr.annotationParams(CollectionsKt.listOf((Object[])objectArray), (ElementPattern)mimeProcessingAttrs);
        elementPatternArray[2] = expr.annotationParam("io.micronaut.http.annotation.Options", "consumes");
        stringArray2 = new String[]{"consumes", "produces"};
        StringPattern stringPattern3 = StandardPatterns.string().oneOf(stringArray2);
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern3, (String)"oneOf(...)");
        elementPatternArray[3] = expr.annotationParams("io.micronaut.http.annotation.Controller", (ElementPattern)stringPattern3);
        stringArray = StandardPatterns.or((ElementPattern[])elementPatternArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"or(...)");
        return stringArray;
    }

    private static final boolean mnMimeTypeAnnotationValuePattern$lambda$0(UExpression expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        return !(expr.getUastParent() instanceof UPolyadicExpression);
    }

    public static final /* synthetic */ UAnnotation access$findClientAnnotationFromCall(UCallExpression clientCall) {
        return MnWebReferenceContributorKt.findClientAnnotationFromCall(clientCall);
    }

    public static final /* synthetic */ UrlPathContext access$transformClientContext(UrlPathContext $receiver, UAnnotation client) {
        return MnWebReferenceContributorKt.transformClientContext($receiver, client);
    }

    static {
        Object[] objectArray = new String[]{"retrieve", "exchange"};
        CLIENT_METHOD_NAMES = CollectionsKt.listOf((Object[])objectArray);
    }
}

