/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.management;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.micronaut.jam.management.MnManagementConstants;
import com.intellij.micronaut.jam.management.MnManagementEndpoint;
import com.intellij.micronaut.jam.management.MnManagementMethod;
import com.intellij.micronaut.jam.management.MnManagementSelector;
import com.intellij.micronaut.provider.beans.MicronautBeanUtilsKt;
import com.intellij.microservices.utils.UrlMappingBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0011H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0011H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0011H\u0002\u001a-\u0010\u0014\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00160\u00152\u0010\u0010\u0018\u001a\f\u0012\u0004\u0012\u00020\u001a\u0012\u0002\b\u00030\u0019H\u0000\u00a2\u0006\u0002\u0010\u001b\u00a8\u0006\u001c"}, d2={"hasManagementLibrary", "", "project", "Lcom/intellij/openapi/project/Project;", "isMappedManagementMethod", "element", "Lcom/intellij/psi/PsiMethod;", "containingClass", "Lcom/intellij/psi/PsiClass;", "getManagementResourcePath", "", "method", "Lcom/intellij/micronaut/jam/management/MnManagementMethod;", "endpoint", "Lcom/intellij/micronaut/jam/management/MnManagementEndpoint;", "getParentResourcePath", "hasManagementImplicitRead", "Lcom/intellij/psi/PsiElement;", "hasManagementImplicitUsage", "isManagementAnnotatedMethod", "getManagementPropertyPatterns", "", "Lcom/intellij/patterns/ElementPattern;", "Lorg/jetbrains/uast/UElement;", "injection", "Lcom/intellij/patterns/uast/UExpressionPattern;", "Lorg/jetbrains/uast/UExpression;", "(Lcom/intellij/patterns/uast/UExpressionPattern;)[Lcom/intellij/patterns/ElementPattern;", "intellij.micronaut"})
@JvmName(name="MnManagementUtils")
@SourceDebugExtension(value={"SMAP\nMnManagementUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnManagementUtils.kt\ncom/intellij/micronaut/provider/management/MnManagementUtils\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,104:1\n19#2:105\n13225#3,2:106\n*S KotlinDebug\n*F\n+ 1 MnManagementUtils.kt\ncom/intellij/micronaut/provider/management/MnManagementUtils\n*L\n80#1:105\n80#1:106,2\n*E\n"})
public final class MnManagementUtils {
    public static final boolean hasManagementLibrary(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtil.hasLibraryClass((Project)project, (String)"io.micronaut.management.endpoint.annotation.Endpoint");
    }

    public static final boolean isMappedManagementMethod(@NotNull PsiMethod element, @NotNull PsiClass containingClass) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
        return !element.isConstructor() && !element.hasModifierProperty("abstract") && !element.hasModifierProperty("static") && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), (Collection)MnManagementConstants.getMN_MANAGEMENT_METHODS(), (int)0) && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)containingClass), (String)"io.micronaut.management.endpoint.annotation.Endpoint", (int)0);
    }

    @Nullable
    public static final String getManagementResourcePath(@NotNull MnManagementMethod method) {
        PsiParameter firstParam;
        MnManagementSelector selector;
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        UrlMappingBuilder builder = new UrlMappingBuilder();
        builder.appendSegment(MnManagementUtils.getParentResourcePath(method));
        PsiParameterList psiParameterList = ((PsiMethod)method.getPsiElement()).getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"getParameterList(...)");
        PsiParameterList parameterList = psiParameterList;
        if (parameterList.getParametersCount() > 0 && (selector = (MnManagementSelector)MnManagementSelector.META.getJamElement((PsiModifierListOwner)(firstParam = parameterList.getParameters()[0]))) != null) {
            String firstParamName;
            PsiParameter psiParameter = firstParam;
            String string = firstParamName = psiParameter != null ? psiParameter.getName() : null;
            if (firstParamName != null) {
                builder.appendSegment("/{" + firstParamName + "}");
            }
        }
        return builder.buildOrNull();
    }

    @Nullable
    public static final String getManagementResourcePath(@NotNull MnManagementEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Object path = endpoint.getResourceValue();
        if (path != null && !StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
            path = "/" + (String)path;
        }
        return path;
    }

    private static final String getParentResourcePath(MnManagementMethod method) {
        PsiElement psiElement = method.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
        PsiMethod psiMethod = (PsiMethod)psiElement;
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        PsiClass containingClass = psiClass;
        MnManagementEndpoint mnManagementEndpoint = (MnManagementEndpoint)MnManagementEndpoint.META.getJamElement((PsiModifierListOwner)containingClass);
        if (mnManagementEndpoint == null) {
            return null;
        }
        MnManagementEndpoint endpoint = mnManagementEndpoint;
        return MnManagementUtils.getManagementResourcePath(endpoint);
    }

    public static final boolean hasManagementImplicitRead(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return MnManagementUtils.isManagementAnnotatedMethod(element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasManagementImplicitUsage(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (MnManagementUtils.isManagementAnnotatedMethod(element)) return true;
        PsiElement $this$asSafely$iv = element;
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof PsiClass)) {
            psiElement = null;
        }
        PsiMethod[] psiMethodArray = (PsiMethod[])psiElement;
        PsiMethod[] psiMethodArray2 = psiMethodArray;
        if (psiMethodArray == null) return false;
        PsiMethod[] psiMethodArray3 = psiMethodArray2.getMethods();
        psiMethodArray2 = psiMethodArray3;
        if (psiMethodArray3 == null) return false;
        PsiMethod[] $this$any$iv = psiMethodArray2;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            PsiMethod element$iv = $this$any$iv[n];
            PsiElement p0 = (PsiElement)element$iv;
            boolean bl = false;
            if (MnManagementUtils.isManagementAnnotatedMethod(p0)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static final boolean isManagementAnnotatedMethod(PsiElement element) {
        block7: {
            block6: {
                if (!(element instanceof PsiMethod)) break block6;
                PsiAnnotation[] psiAnnotationArray = ((PsiMethod)element).getModifierList().getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getAnnotations(...)");
                if (!(((Object[])psiAnnotationArray).length == 0)) break block7;
            }
            return false;
        }
        PsiClass psiClass = ((PsiMethod)element).getContainingClass();
        if (psiClass == null) {
            return false;
        }
        PsiClass psiClass2 = psiClass;
        if (!MicronautBeanUtilsKt.isBeanCandidateClass(psiClass2)) {
            return false;
        }
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), (Collection)MnManagementConstants.getMN_MANAGEMENT_METHODS(), (int)0)) {
            return false;
        }
        return MnManagementEndpoint.META.getJamElement((PsiModifierListOwner)psiClass2) != null;
    }

    @NotNull
    public static final ElementPattern<? extends UElement>[] getManagementPropertyPatterns(@NotNull UExpressionPattern<UExpression, ?> injection) {
        Intrinsics.checkNotNullParameter(injection, (String)"injection");
        ElementPattern[] elementPatternArray = new ElementPattern[]{injection.annotationParam("io.micronaut.management.endpoint.annotation.Endpoint", "prefix")};
        return elementPatternArray;
    }
}

