/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.syntax.lexer;

import com.intellij.platform.syntax.CancellationProvider;
import com.intellij.platform.syntax.Logger;
import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.lexer.Lexer;
import com.intellij.platform.syntax.lexer.TokenListImpl;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u001a\u001a\u00020\u001bJ \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001fH\u0002J\u000e\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0019\u00a8\u0006$"}, d2={"Lcom/intellij/platform/syntax/lexer/Builder;", "", "text", "", "lexer", "Lcom/intellij/platform/syntax/lexer/Lexer;", "cancellationProvider", "Lcom/intellij/platform/syntax/CancellationProvider;", "logger", "Lcom/intellij/platform/syntax/Logger;", "<init>", "(Ljava/lang/CharSequence;Lcom/intellij/platform/syntax/lexer/Lexer;Lcom/intellij/platform/syntax/CancellationProvider;Lcom/intellij/platform/syntax/Logger;)V", "getText", "()Ljava/lang/CharSequence;", "getLexer", "()Lcom/intellij/platform/syntax/lexer/Lexer;", "getCancellationProvider", "()Lcom/intellij/platform/syntax/CancellationProvider;", "getLogger", "()Lcom/intellij/platform/syntax/Logger;", "lexStarts", "", "lexTypes", "", "Lcom/intellij/platform/syntax/SyntaxElementType;", "[Lcom/intellij/platform/syntax/SyntaxElementType;", "performLexing", "Lcom/intellij/platform/syntax/lexer/TokenListImpl;", "reportDescendingOffsets", "", "tokenIndex", "", "offset", "tokenStart", "resizeLexemes", "newSize", "intellij.platform.syntax"})
public final class Builder {
    @NotNull
    private final CharSequence text;
    @NotNull
    private final Lexer lexer;
    @Nullable
    private final CancellationProvider cancellationProvider;
    @Nullable
    private final Logger logger;
    @NotNull
    private int[] lexStarts;
    @NotNull
    private SyntaxElementType[] lexTypes;

    public Builder(@NotNull CharSequence text, @NotNull Lexer lexer, @Nullable CancellationProvider cancellationProvider, @Nullable Logger logger) {
        this.text = text;
        this.lexer = lexer;
        this.cancellationProvider = cancellationProvider;
        this.logger = logger;
        int approxLexCount = (int)Math.max(10.0, (double)(this.text.length() / 5));
        this.lexStarts = new int[approxLexCount];
        this.lexTypes = new SyntaxElementType[approxLexCount];
    }

    @NotNull
    public final CharSequence getText() {
        return this.text;
    }

    @NotNull
    public final Lexer getLexer() {
        return this.lexer;
    }

    @Nullable
    public final CancellationProvider getCancellationProvider() {
        return this.cancellationProvider;
    }

    @Nullable
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final TokenListImpl performLexing() {
        SyntaxElementType type;
        this.lexer.start(this.text);
        int i = 0;
        int offset = 0;
        while ((type = this.lexer.getTokenType()) != null) {
            int tokenStart;
            if (i % 20 == 0) {
                CancellationProvider cancellationProvider = this.cancellationProvider;
                if (cancellationProvider != null) {
                    cancellationProvider.checkCancelled();
                }
            }
            if (i >= this.lexTypes.length - 1) {
                this.resizeLexemes(i * 3 / 2);
            }
            if ((tokenStart = this.lexer.getTokenStart()) < offset) {
                this.reportDescendingOffsets(i, offset, tokenStart);
            }
            this.lexStarts[i] = offset = tokenStart;
            this.lexTypes[i] = type;
            ++i;
            this.lexer.advance();
        }
        this.lexStarts[i] = this.text.length();
        return new TokenListImpl(this.lexStarts, this.lexTypes, i, this.text, 0, 16, null);
    }

    private final void reportDescendingOffsets(int tokenIndex, int offset, int tokenStart) {
        if (this.logger == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        SyntaxElementType tokenType = this.lexer.getTokenType();
        sb.append("Token sequence broken").append("\n  this: '").append(this.lexer.getTokenText()).append("' (").append(tokenType).append(") ").append(tokenStart).append(":").append(this.lexer.getTokenEnd());
        if (tokenIndex > 0) {
            int prevStart = this.lexStarts[tokenIndex - 1];
            sb.append("\n  prev: '").append(this.text.subSequence(prevStart, offset)).append("' (").append(this.lexTypes[tokenIndex - 1]).append(") ").append(prevStart).append(":").append(offset);
        }
        int quoteStart = Math.max(tokenStart - 256, 0);
        int quoteEnd = Math.min(tokenStart + 256, this.text.length());
        sb.append("\n  quote: [").append(quoteStart).append(':').append(quoteEnd).append("] '").append(this.text.subSequence(quoteStart, quoteEnd)).append('\'');
        this.logger.error(sb.toString());
    }

    public final void resizeLexemes(int newSize) {
        int[] nArray = Arrays.copyOf(this.lexStarts, newSize);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
        this.lexStarts = nArray;
        SyntaxElementType[] syntaxElementTypeArray = Arrays.copyOf(this.lexTypes, newSize);
        Intrinsics.checkNotNullExpressionValue((Object)syntaxElementTypeArray, (String)"copyOf(...)");
        this.lexTypes = syntaxElementTypeArray;
    }
}

