/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiConsistencyAssertions;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.PsiDocumentManagerEx;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.file.PsiFileImplUtil;
import com.intellij.psi.impl.file.impl.FileManagerEx;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.impl.source.FileTrees;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.StubbedSpine;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.AstSpine;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.LanguageStubDescriptor;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubElementRegistryService;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.ReadOnlyLightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.CharTable;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PatchedWeakReference;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiFileImpl
extends ElementBase
implements PsiFileEx,
PsiFileWithStubSupport,
Queryable,
Cloneable {
    private static final CharTable NON_INTERNING_CHAR_TABLE = new CharTable(){

        @NotNull
        public CharSequence intern(@NotNull CharSequence text) {
            if (text == null) {
                1.$$$reportNull$$$0(0);
            }
            CharSequence charSequence = text;
            if (charSequence == null) {
                1.$$$reportNull$$$0(1);
            }
            return charSequence;
        }

        @NotNull
        public CharSequence intern(@NotNull CharSequence baseText, int startOffset, int endOffset) {
            if (baseText == null) {
                1.$$$reportNull$$$0(2);
            }
            return new CharSequenceSubSequence(baseText, startOffset, endOffset);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/PsiFileImpl$1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/PsiFileImpl$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "intern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "intern";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final Logger LOG = Logger.getInstance(PsiFileImpl.class);
    @NonNls
    static final String STUB_PSI_MISMATCH = "stub-psi mismatch";
    private IElementType myElementType;
    protected IElementType myContentElementType;
    private long myModificationStamp;
    protected PsiFile myOriginalFile;
    private final AbstractFileViewProvider myViewProvider;
    private volatile FileTrees myTrees;
    private volatile boolean myPossiblyInvalidated;
    protected final PsiManagerEx myManager;
    public static final Key<Boolean> BUILDING_STUB = new Key("Don't use stubs mark!");
    private final PsiLock myPsiLock;
    private volatile boolean myLoadingAst;
    private static final Comparator<PsiFile> FILE_BY_LANGUAGE_ID = Comparator.comparing(o -> o.getLanguage().getID());

    protected PsiFileImpl(@NotNull IElementType elementType, IElementType contentElementType, @NotNull FileViewProvider provider) {
        if (elementType == null) {
            PsiFileImpl.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            PsiFileImpl.$$$reportNull$$$0(1);
        }
        this(provider);
        this.init(elementType, contentElementType);
    }

    protected PsiFileImpl(@NotNull FileViewProvider provider) {
        if (provider == null) {
            PsiFileImpl.$$$reportNull$$$0(2);
        }
        this.myTrees = FileTrees.noStub(null, this);
        this.myManager = (PsiManagerEx)provider.getManager();
        this.myViewProvider = (AbstractFileViewProvider)provider;
        this.myPsiLock = this.myViewProvider.getFilePsiLock();
    }

    public void setContentElementType(@NotNull IElementType contentElementType) {
        if (contentElementType == null) {
            PsiFileImpl.$$$reportNull$$$0(3);
        }
        LOG.assertTrue(contentElementType instanceof ILazyParseableElementType, (Object)contentElementType);
        this.myContentElementType = contentElementType;
    }

    public IElementType getContentElementType() {
        return this.myContentElementType;
    }

    protected void init(@NotNull IElementType elementType, @NotNull IElementType contentElementType) {
        if (elementType == null) {
            PsiFileImpl.$$$reportNull$$$0(4);
        }
        if (contentElementType == null) {
            PsiFileImpl.$$$reportNull$$$0(5);
        }
        this.myElementType = elementType;
        this.setContentElementType(contentElementType);
    }

    public TreeElement createContentLeafElement(CharSequence leafText) {
        if (this.myContentElementType instanceof ILazyParseableElementType) {
            return ASTFactory.lazy((ILazyParseableElementType)this.myContentElementType, leafText);
        }
        return ASTFactory.leaf(this.myContentElementType, leafText);
    }

    public boolean isDirectory() {
        return false;
    }

    @Nullable
    public FileElement getTreeElement() {
        FileElement node = this.derefTreeElement();
        if (node != null) {
            return node;
        }
        if (!this.getViewProvider().isPhysical()) {
            return this.loadTreeElement();
        }
        return null;
    }

    FileElement derefTreeElement() {
        return this.myTrees.derefTreeElement();
    }

    public VirtualFile getVirtualFile() {
        VirtualFile indexingFile = (VirtualFile)IndexingDataKeys.VIRTUAL_FILE.get((UserDataHolder)this);
        if (indexingFile != null) {
            return indexingFile;
        }
        return this.getViewProvider().isEventSystemEnabled() ? this.getViewProvider().getVirtualFile() : null;
    }

    public boolean processChildren(@NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
        if (processor == null) {
            PsiFileImpl.$$$reportNull$$$0(6);
        }
        return true;
    }

    public boolean isValid() {
        if (this.myManager.getProject().isDisposed()) {
            return false;
        }
        if (!this.myViewProvider.getVirtualFile().isValid()) {
            return false;
        }
        if (!this.myPossiblyInvalidated) {
            return true;
        }
        if (((FileManagerEx)this.myManager.getFileManager()).evaluateValidity(this)) {
            this.myPossiblyInvalidated = false;
            PsiInvalidElementAccessException.setInvalidationTrace((UserDataHolder)this, null);
            return true;
        }
        return false;
    }

    @Override
    public final void markInvalidated() {
        this.myPossiblyInvalidated = true;
        DebugUtil.onInvalidated((PsiElement)this);
    }

    @Override
    public boolean isContentsLoaded() {
        return this.derefTreeElement() != null;
    }

    protected void assertReadAccessAllowed() {
        if (this.myViewProvider.getVirtualFile() instanceof ReadOnlyLightVirtualFile) {
            return;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private FileElement loadTreeElement() {
        FileElement treeElement;
        FileViewProvider viewProvider;
        block13: {
            FileElement fileElement;
            VirtualFile vFile;
            this.assertReadAccessAllowed();
            if (this.myPossiblyInvalidated) {
                PsiUtilCore.ensureValid((PsiElement)this);
            }
            if ((viewProvider = this.getViewProvider()).isPhysical()) {
                vFile = viewProvider.getVirtualFile();
                AstLoadingFilter.assertTreeLoadingAllowed((VirtualFile)vFile);
                if (this.myManager.isAssertOnFileLoading(vFile)) {
                    PsiFileImpl.reportProhibitedAstAccess(vFile);
                }
            }
            try {
                vFile = this.myPsiLock;
                // MONITORENTER : vFile
                treeElement = this.derefTreeElement();
                if (treeElement == null) break block13;
                fileElement = treeElement;
                // MONITOREXIT : vFile
            }
            catch (StubTreeLoader.StubTreeAndIndexUnmatchCoarseException e) {
                throw e.createCompleteException();
            }
            if (fileElement != null) return fileElement;
            PsiFileImpl.$$$reportNull$$$0(7);
            return fileElement;
        }
        treeElement = this.createFileElement(viewProvider.getContents());
        treeElement.setPsi((PsiElement)this);
        this.myLoadingAst = true;
        try {
            this.updateTrees(this.myTrees.withAst(this.createTreeElementPointer(treeElement)));
        }
        finally {
            this.myLoadingAst = false;
        }
        if (LOG.isDebugEnabled() && viewProvider.isPhysical()) {
            LOG.debug("Loaded text for file " + viewProvider.getVirtualFile().getPresentableUrl());
        }
        FileElement fileElement = treeElement;
        // MONITOREXIT : vFile
        if (fileElement != null) return fileElement;
        PsiFileImpl.$$$reportNull$$$0(8);
        return fileElement;
    }

    private static void reportProhibitedAstAccess(VirtualFile vFile) {
        LOG.error("Access to tree elements not allowed for '" + vFile.getPresentableUrl() + "'.\nTry using stub-based PSI API to avoid expensive AST loading for files that aren't already opened in the editor.\nConsult this method's javadoc for more details.");
    }

    @Override
    @NotNull
    public StubbedSpine getStubbedSpine() {
        StubbedSpine stubbedSpine = this.withGreenStubTreeOrAst(stubTree -> stubTree.getSpine(), ast -> {
            AstSpine astSpine = ast.getStubbedSpine();
            if (!this.myTrees.useSpineRefs()) {
                PsiLock psiLock = this.myPsiLock;
                synchronized (psiLock) {
                    this.updateTrees(this.myTrees.switchToSpineRefs(FileTrees.getAllSpinePsi(astSpine)));
                }
            }
            return astSpine;
        });
        if (stubbedSpine == null) {
            PsiFileImpl.$$$reportNull$$$0(9);
        }
        return stubbedSpine;
    }

    @Deprecated
    @Nullable
    public IStubFileElementType<?> getElementTypeForStubBuilder() {
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.getLanguage());
        IFileElementType type = definition == null ? null : definition.getFileNodeType();
        return type instanceof IStubFileElementType ? (IStubFileElementType)type : null;
    }

    @ApiStatus.Experimental
    @Nullable
    public LanguageStubDescriptor getStubDescriptor() {
        return StubElementRegistryService.getInstance().getStubDescriptor(this.getLanguage());
    }

    @NotNull
    protected FileElement createFileElement(CharSequence docText) {
        FileElement treeElement;
        TreeElement contentLeaf = this.createContentLeafElement(docText);
        if (contentLeaf instanceof FileElement) {
            treeElement = (FileElement)contentLeaf;
            if (this.isIndexingFileCopy()) {
                treeElement.setCharTable(NON_INTERNING_CHAR_TABLE);
            }
        } else {
            CompositeElement xxx = ASTFactory.composite(this.myElementType);
            assert (xxx instanceof FileElement) : "BUMM";
            treeElement = (FileElement)xxx;
            treeElement.rawAddChildrenWithoutNotifications(contentLeaf);
        }
        FileElement fileElement = treeElement;
        if (fileElement == null) {
            PsiFileImpl.$$$reportNull$$$0(10);
        }
        return fileElement;
    }

    public void clearCaches() {
        ++this.myModificationStamp;
    }

    public String getText() {
        FileElement tree = this.derefTreeElement();
        if (!this.isValid()) {
            ProgressManager.checkCanceled();
            if (tree != null) {
                return tree.getText();
            }
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        String string = this.getViewProvider().getContents().toString();
        if (tree != null && string.length() != tree.getTextLength()) {
            PsiConsistencyAssertions.assertNoFileTextMismatch((PsiFile)this, tree, string);
        }
        return string;
    }

    public int getTextLength() {
        FileElement tree = this.derefTreeElement();
        if (tree != null) {
            return tree.getTextLength();
        }
        PsiUtilCore.ensureValid((PsiElement)this);
        return this.getViewProvider().getContents().length();
    }

    public TextRange getTextRange() {
        return new TextRange(0, this.getTextLength());
    }

    public PsiElement getNextSibling() {
        return SharedPsiElementImplUtil.getNextSibling((PsiElement)this);
    }

    public PsiElement getPrevSibling() {
        return SharedPsiElementImplUtil.getPrevSibling((PsiElement)this);
    }

    public long getModificationStamp() {
        PsiElement context = this.getContext();
        PsiFile contextFile = context == null || !context.isValid() ? null : context.getContainingFile();
        long contextStamp = contextFile == null ? 0L : contextFile.getModificationStamp();
        return this.myModificationStamp + contextStamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtreeChanged() {
        FileElement tree = this.getTreeElement();
        if (tree != null) {
            tree.clearCaches();
        }
        PsiLock psiLock = this.myPsiLock;
        synchronized (psiLock) {
            if (this.myTrees.useSpineRefs()) {
                LOG.error("Somebody has requested stubbed spine during PSI operations; not only is this expensive, but will also cause stub PSI invalidation");
            }
            this.updateTrees(this.myTrees.clearStub("subtreeChanged"));
        }
        this.clearCaches();
        this.getViewProvider().rootChanged((PsiFile)this);
    }

    protected PsiFileImpl clone() {
        FileViewProvider viewProvider = this.getViewProvider();
        FileViewProvider providerCopy = viewProvider.clone();
        Language language = this.getLanguage();
        if (providerCopy == null) {
            throw new AssertionError((Object)("Unable to clone the view provider: " + viewProvider + "; " + language));
        }
        PsiFileImpl clone = BlockSupportImpl.getFileCopy(this, providerCopy);
        this.copyCopyableDataTo(clone);
        if (this.getTreeElement() != null) {
            FileElement treeClone = (FileElement)this.calcTreeElement().clone();
            clone.setTreeElementPointer(treeClone);
            treeClone.setPsi((PsiElement)clone);
        } else {
            clone.setTreeElementPointer(null);
        }
        if (viewProvider.isEventSystemEnabled()) {
            clone.myOriginalFile = this;
        } else if (this.myOriginalFile != null) {
            clone.myOriginalFile = this.myOriginalFile;
        }
        FileManagerImpl.clearPsiCaches(providerCopy);
        return clone;
    }

    @NotNull
    public String getName() {
        String string = this.getViewProvider().getVirtualFile().getName();
        if (string == null) {
            PsiFileImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PsiFileImpl.$$$reportNull$$$0(12);
        }
        this.checkSetName(name);
        return PsiFileImplUtil.setName(this, name);
    }

    public void checkSetName(String name) {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            return;
        }
        PsiFileImplUtil.checkSetName(this, name);
    }

    public boolean isWritable() {
        return this.getViewProvider().getVirtualFile().isWritable();
    }

    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    @Nullable
    public PsiDirectory getContainingDirectory() {
        VirtualFile file = this.getViewProvider().getVirtualFile();
        VirtualFile parentFile = file.getParent();
        if (parentFile == null) {
            return null;
        }
        if (!parentFile.isValid()) {
            LOG.error("Invalid parent: " + parentFile + " of file " + file + ", file.valid=" + file.isValid());
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @NotNull
    public PsiFile getContainingFile() {
        PsiFileImpl psiFileImpl = this;
        if (psiFileImpl == null) {
            PsiFileImpl.$$$reportNull$$$0(13);
        }
        return psiFileImpl;
    }

    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        PsiFileImplUtil.doDelete(this);
    }

    public void checkDelete() throws IncorrectOperationException {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            if (PsiFileImplUtil.canDeleteNonPhysicalFile(this)) {
                return;
            }
            throw new IncorrectOperationException();
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    @NotNull
    public PsiFile getOriginalFile() {
        PsiFileImpl psiFileImpl = this.myOriginalFile == null ? this : this.myOriginalFile;
        if (psiFileImpl == null) {
            PsiFileImpl.$$$reportNull$$$0(14);
        }
        return psiFileImpl;
    }

    public void setOriginalFile(@NotNull PsiFile originalFile) {
        if (originalFile == null) {
            PsiFileImpl.$$$reportNull$$$0(15);
        }
        this.myOriginalFile = originalFile.getOriginalFile();
        FileViewProvider original = this.myOriginalFile.getViewProvider();
        ((AbstractFileViewProvider)original).registerAsCopy(this.myViewProvider);
    }

    public PsiFile @NotNull [] getPsiRoots() {
        FileViewProvider viewProvider = this.getViewProvider();
        Set languages = viewProvider.getLanguages();
        PsiFile[] roots = new PsiFile[languages.size()];
        int i = 0;
        for (Language language : languages) {
            PsiFile psi = viewProvider.getPsi(language);
            if (psi == null) {
                LOG.error("PSI is null for " + language + "; in file: " + this);
            }
            roots[i++] = psi;
        }
        if (roots.length > 1) {
            Arrays.sort(roots, FILE_BY_LANGUAGE_ID);
        }
        if (roots == null) {
            PsiFileImpl.$$$reportNull$$$0(16);
        }
        return roots;
    }

    public boolean isPhysical() {
        return this.getViewProvider().isEventSystemEnabled();
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myElementType.getLanguage();
        if (language == null) {
            PsiFileImpl.$$$reportNull$$$0(17);
        }
        return language;
    }

    @Nullable
    public IFileElementType getFileElementType() {
        return this.myElementType instanceof IFileElementType ? (IFileElementType)this.myElementType : (IFileElementType)ObjectUtils.tryCast((Object)this.myContentElementType, IFileElementType.class);
    }

    @NotNull
    public FileViewProvider getViewProvider() {
        AbstractFileViewProvider abstractFileViewProvider = this.myViewProvider;
        if (abstractFileViewProvider == null) {
            PsiFileImpl.$$$reportNull$$$0(18);
        }
        return abstractFileViewProvider;
    }

    @NotNull
    public final Document getFileDocument() {
        Document document = PsiFileEx.super.getFileDocument();
        if (document == null) {
            PsiFileImpl.$$$reportNull$$$0(19);
        }
        return document;
    }

    public void setTreeElementPointer(@Nullable FileElement element) {
        this.updateTrees(FileTrees.noStub(element, this));
    }

    public PsiElement findElementAt(int offset) {
        return this.getViewProvider().findElementAt(offset);
    }

    public PsiReference findReferenceAt(int offset) {
        return this.getViewProvider().findReferenceAt(offset);
    }

    public char @NotNull [] textToCharArray() {
        char[] cArray = CharArrayUtil.fromSequence((CharSequence)this.getViewProvider().getContents());
        if (cArray == null) {
            PsiFileImpl.$$$reportNull$$$0(20);
        }
        return cArray;
    }

    public <T> T @NotNull [] findChildrenByClass(Class<T> aClass) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement child : this.getChildren()) {
            if (!aClass.isInstance(child)) continue;
            result.add(child);
        }
        Object[] objectArray = result.toArray(ArrayUtil.newArray(aClass, (int)result.size()));
        if (objectArray == null) {
            PsiFileImpl.$$$reportNull$$$0(21);
        }
        return objectArray;
    }

    @Nullable
    public <T> T findChildByClass(Class<T> aClass) {
        for (PsiElement child : this.getChildren()) {
            if (!aClass.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    public boolean isTemplateDataFile() {
        return false;
    }

    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }

    @Override
    public void onContentReload() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.clearContent("onContentReload");
    }

    final void clearContent(String reason) {
        DebugUtil.performPsiModification(reason, () -> {
            PsiLock psiLock = this.myPsiLock;
            synchronized (psiLock) {
                FileElement treeElement = this.derefTreeElement();
                if (treeElement != null) {
                    treeElement.detachFromFile();
                    DebugUtil.onInvalidated(treeElement);
                }
                this.updateTrees(this.myTrees.clearStub(reason));
                this.setTreeElementPointer(null);
            }
        });
        this.clearCaches();
    }

    @Nullable
    public StubElement<?> getStub() {
        StubTree stubHolder = this.getStubTree();
        return stubHolder != null ? stubHolder.getRoot() : null;
    }

    @Deprecated
    @Nullable
    public final StubElement<?> getGreenStub() {
        StubTree stubHolder = this.getGreenStubTree();
        return stubHolder != null ? stubHolder.getRoot() : null;
    }

    @Deprecated
    @Nullable
    public final StubTree getGreenStubTree() {
        return (StubTree)this.getStubTreeOrFileElement().first;
    }

    public final <T> T withGreenStubOrAst(Function<PsiFileStub<?>, T> stubProcessor, Function<FileElement, T> astProcessor) {
        return this.withGreenStubOrAst(PsiFileStub.class, stubProcessor, astProcessor);
    }

    public final <T, S extends PsiFileStub<?>> T withGreenStubOrAst(Class<S> stubClass, Function<S, T> stubProcessor, Function<FileElement, T> astProcessor) {
        PsiFileStub<?> stubElement;
        Pair<@Nullable StubTree, @Nullable FileElement> result = this.getStubTreeOrFileElement();
        PsiFileStub<?> psiFileStub = stubElement = result.first != null ? ((StubTree)result.first).getRoot() : null;
        if (stubElement != null && !stubClass.isAssignableFrom(stubElement.getClass())) {
            LanguageStubDescriptor descriptor = this.getStubDescriptor();
            String elementTypeName = descriptor != null ? descriptor.getFileElementSerializer().getExternalId() : null;
            Logger.getInstance(PsiFileImpl.class).error("stub: " + stubElement.getClass().getName() + "; file: " + elementTypeName);
            stubElement = null;
        }
        if (stubElement != null) {
            return stubProcessor.apply(stubElement);
        }
        FileElement fileElement = (FileElement)result.second;
        if (fileElement == null) {
            fileElement = this.calcTreeElement();
        }
        return astProcessor.apply(fileElement);
    }

    public final <T> T withGreenStubTreeOrAst(Function<StubTree, T> stubProcessor, Function<FileElement, T> astProcessor) {
        Pair<@Nullable StubTree, @Nullable FileElement> result = this.getStubTreeOrFileElement();
        if (result.first != null) {
            return stubProcessor.apply((StubTree)result.first);
        }
        FileElement fileElement = (FileElement)result.second;
        if (fileElement == null) {
            fileElement = this.calcTreeElement();
        }
        return astProcessor.apply(fileElement);
    }

    @Override
    @Nullable
    public StubTree getStubTree() {
        Pair<StubTree, FileElement> result = this.getStubTreeOrFileElement();
        return result.second == null ? (StubTree)result.first : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public @NotNull Pair<@Nullable StubTree, @Nullable FileElement> getStubTreeOrFileElement() {
        Pair pair;
        Object[] stubRoots;
        List<Pair<LanguageStubDescriptor, PsiFile>> roots;
        FileViewProvider viewProvider;
        block15: {
            PsiFileStubImpl baseRoot;
            block14: {
                ObjectStubTree<?> tree;
                block13: {
                    this.assertReadAccessAllowed();
                    StubTree deref = this.derefStub();
                    FileElement treeElement = this.getTreeElement();
                    if (deref != null || treeElement != null) {
                        Pair pair2 = Pair.create((Object)deref, (Object)treeElement);
                        if (pair2 != null) return pair2;
                        PsiFileImpl.$$$reportNull$$$0(22);
                        return pair2;
                    }
                    if (Boolean.TRUE.equals(this.getUserData(BUILDING_STUB)) || this.myLoadingAst || this.getStubDescriptor() == null) {
                        Pair pair3 = Pair.empty();
                        if (pair3 != null) return pair3;
                        PsiFileImpl.$$$reportNull$$$0(23);
                        return pair3;
                    }
                    VirtualFile vFile = this.getVirtualFile();
                    tree = StubTreeLoader.getInstance().readOrBuild(this.getProject(), vFile, this);
                    if (!(tree instanceof StubTree)) {
                        Pair pair4 = Pair.empty();
                        if (pair4 != null) return pair4;
                        PsiFileImpl.$$$reportNull$$$0(24);
                        return pair4;
                    }
                    viewProvider = this.getViewProvider();
                    roots = StubTreeBuilder.getStubbedRootDescriptors(viewProvider);
                    PsiLock psiLock = this.myPsiLock;
                    // MONITORENTER : psiLock
                    FileElement treeElementOnLock = this.getTreeElement();
                    StubTree dereferencedOnLock = this.derefStub();
                    if (dereferencedOnLock == null && treeElementOnLock == null) break block13;
                    Pair pair5 = Pair.create((Object)dereferencedOnLock, (Object)treeElementOnLock);
                    // MONITOREXIT : psiLock
                    if (pair5 != null) return pair5;
                    PsiFileImpl.$$$reportNull$$$0(25);
                    return pair5;
                }
                baseRoot = (PsiFileStubImpl)((StubTree)tree).getRoot();
                if (baseRoot.rootsAreSet()) break block14;
                LOG.error("Stub roots must be set when stub tree was read or built with StubTreeLoader");
                Pair pair6 = Pair.empty();
                // MONITOREXIT : psiLock
                if (pair6 != null) return pair6;
                PsiFileImpl.$$$reportNull$$$0(26);
                return pair6;
            }
            stubRoots = baseRoot.getStubRoots();
            if (stubRoots.length == roots.size()) break block15;
            com.intellij.util.Function stubToString = stub -> "{" + stub.getClass().getSimpleName() + " " + stub.getFileElementType().getLanguage() + "}";
            LOG.error("readOrBuilt roots = " + StringUtil.join((Object[])stubRoots, (com.intellij.util.Function)stubToString, (String)", ") + "; " + StubTreeLoader.getFileViewProviderMismatchDiagnostics(viewProvider));
            this.rebuildStub();
            Pair pair7 = Pair.empty();
            // MONITOREXIT : psiLock
            if (pair7 != null) return pair7;
            PsiFileImpl.$$$reportNull$$$0(27);
            return pair7;
        }
        try {
            StubTree result = null;
            for (int i = 0; i < roots.size(); ++i) {
                PsiFileImpl eachPsiRoot = (PsiFileImpl)roots.get((int)i).second;
                if (eachPsiRoot.derefStub() != null) continue;
                StubTree stubTree = eachPsiRoot.setStubTree((PsiFileStub<?>)stubRoots[i]);
                if (eachPsiRoot != this) continue;
                result = stubTree;
            }
            assert (result != null) : "Current file not in root list: " + roots + ", vp=" + viewProvider;
            pair = Pair.create(result, null);
            // MONITOREXIT : psiLock
        }
        catch (StubTreeLoader.StubTreeAndIndexUnmatchCoarseException e) {
            throw e.createCompleteException();
        }
        if (pair != null) return pair;
        PsiFileImpl.$$$reportNull$$$0(28);
        return pair;
    }

    @NotNull
    private StubTree setStubTree(PsiFileStub<?> root) throws StubTreeLoader.StubTreeAndIndexUnmatchCoarseException {
        ((StubBase)root).setPsi((PsiElement)this);
        StubTree stubTree = new StubTree(root);
        FileElement fileElement = this.getTreeElement();
        stubTree.setDebugInfo("created in getStubTree(), with AST = " + (fileElement != null));
        this.updateTrees(this.myTrees.withStub(stubTree, fileElement));
        StubTree stubTree2 = stubTree;
        if (stubTree2 == null) {
            PsiFileImpl.$$$reportNull$$$0(29);
        }
        return stubTree2;
    }

    @ApiStatus.Internal
    @Nullable
    public final StubTree derefStub() {
        return this.myTrees.derefStub();
    }

    private void updateTrees(@NotNull FileTrees trees) {
        if (trees == null) {
            PsiFileImpl.$$$reportNull$$$0(30);
        }
        this.myTrees = trees;
    }

    protected PsiFileImpl cloneImpl(FileElement treeElementClone) {
        PsiFileImpl clone = (PsiFileImpl)super.clone();
        clone.setTreeElementPointer(treeElementClone);
        treeElementClone.setPsi((PsiElement)clone);
        return clone;
    }

    private boolean isKeepTreeElementByHardReference() {
        return !this.getViewProvider().isEventSystemEnabled();
    }

    @NotNull
    private Supplier<FileElement> createTreeElementPointer(@NotNull FileElement treeElement) {
        if (treeElement == null) {
            PsiFileImpl.$$$reportNull$$$0(31);
        }
        if (this.isKeepTreeElementByHardReference()) {
            Supplier<FileElement> supplier = () -> treeElement;
            if (supplier == null) {
                PsiFileImpl.$$$reportNull$$$0(32);
            }
            return supplier;
        }
        return this.myManager.isBatchFilesProcessingMode() ? new PatchedWeakReference<FileElement>(treeElement) : new SoftReference((Object)treeElement);
    }

    public final PsiManager getManager() {
        return this.myManager;
    }

    public PsiElement getNavigationElement() {
        return this;
    }

    public PsiElement getOriginalElement() {
        return this.getOriginalFile();
    }

    @NotNull
    public final FileElement calcTreeElement() {
        FileElement treeElement = this.getTreeElement();
        return treeElement != null ? treeElement : this.loadTreeElement();
    }

    public PsiElement @NotNull [] getChildren() {
        PsiElement[] psiElementArray = this.calcTreeElement().getChildrenAsPsiElements(null, ARRAY_FACTORY);
        if (psiElementArray == null) {
            PsiFileImpl.$$$reportNull$$$0(33);
        }
        return psiElementArray;
    }

    public PsiElement getFirstChild() {
        return SharedImplUtil.getFirstChild((ASTNode)this.getNode());
    }

    public PsiElement getLastChild() {
        return SharedImplUtil.getLastChild((ASTNode)this.getNode());
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiFileImpl.$$$reportNull$$$0(34);
        }
        SharedImplUtil.acceptChildren(visitor, (ASTNode)this.getNode());
    }

    public int getStartOffsetInParent() {
        return 0;
    }

    public int getTextOffset() {
        return 0;
    }

    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            PsiFileImpl.$$$reportNull$$$0(35);
        }
        return this.calcTreeElement().textMatches(text);
    }

    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            PsiFileImpl.$$$reportNull$$$0(36);
        }
        return this.calcTreeElement().textMatches(element);
    }

    public boolean textContains(char c) {
        return this.calcTreeElement().textContains(c);
    }

    public final PsiElement copy() {
        return this.clone();
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiFileImpl.$$$reportNull$$$0(37);
        }
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, null, null);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            PsiFileImpl.$$$reportNull$$$0(38);
        }
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            PsiFileImpl.$$$reportNull$$$0(39);
        }
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public final void checkAdd(@NotNull PsiElement element) {
        if (element == null) {
            PsiFileImpl.$$$reportNull$$$0(40);
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return SharedImplUtil.addRange((PsiElement)this, first, last, null, null);
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            PsiFileImpl.$$$reportNull$$$0(41);
        }
        if (last == null) {
            PsiFileImpl.$$$reportNull$$$0(42);
        }
        return SharedImplUtil.addRange((PsiElement)this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return SharedImplUtil.addRange((PsiElement)this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        if (first == null) {
            LOG.assertTrue(last == null);
            return;
        }
        ASTNode firstElement = SourceTreeToPsiMap.psiElementToTree(first);
        ASTNode lastElement = SourceTreeToPsiMap.psiElementToTree(last);
        FileElement treeElement = this.calcTreeElement();
        LOG.assertTrue(firstElement.getTreeParent() == treeElement);
        LOG.assertTrue(lastElement.getTreeParent() == treeElement);
        CodeEditUtil.removeChildren(treeElement, firstElement, lastElement);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            PsiFileImpl.$$$reportNull$$$0(43);
        }
        FileElement treeElement = this.calcTreeElement();
        return SharedImplUtil.doReplace((PsiElement)this, treeElement, newElement);
    }

    public PsiReference getReference() {
        return null;
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences((PsiElement)this);
        if (psiReferenceArray == null) {
            PsiFileImpl.$$$reportNull$$$0(44);
        }
        return psiReferenceArray;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiFileImpl.$$$reportNull$$$0(45);
        }
        if (state2 == null) {
            PsiFileImpl.$$$reportNull$$$0(46);
        }
        if (place == null) {
            PsiFileImpl.$$$reportNull$$$0(47);
        }
        return true;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementResolveScope((PsiElement)this);
        if (globalSearchScope == null) {
            PsiFileImpl.$$$reportNull$$$0(48);
        }
        return globalSearchScope;
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementUseScope((PsiElement)this);
        if (globalSearchScope == null) {
            PsiFileImpl.$$$reportNull$$$0(49);
        }
        return globalSearchScope;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return PsiFileImpl.this.getName();
            }

            public String getLocationString() {
                VirtualFile file = PsiFileImpl.this.getViewProvider().getVirtualFile().getParent();
                if (file != null && file.isValid() && file.isDirectory()) {
                    return file.getPresentableUrl();
                }
                return null;
            }

            public Icon getIcon(boolean open) {
                return PsiFileImpl.this.getIcon(0);
            }
        };
    }

    public void navigate(boolean requestFocus) {
        assert (this.canNavigate()) : "Couldn't navigate to " + this + ": isValid=" + this.isValid() + "; getVirtualFile()=" + this.getVirtualFile() + "; getOriginalFile()=" + this.getOriginalFile();
        PsiNavigationSupport.getInstance().getDescriptor((PsiElement)this).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate((PsiElement)this);
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public final Project getProject() {
        Project project = this.getManager().getProject();
        if (project == null) {
            PsiFileImpl.$$$reportNull$$$0(50);
        }
        return project;
    }

    @NotNull
    public FileASTNode getNode() {
        return this.calcTreeElement();
    }

    @Nullable
    public FileASTNode getNodeIfLoaded() {
        return this.getTreeElement();
    }

    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public StubTree calcStubTree() {
        StubTree stubTree;
        StubTree tree = this.derefStub();
        if (tree != null) {
            StubTree stubTree2 = tree;
            if (stubTree2 == null) {
                PsiFileImpl.$$$reportNull$$$0(51);
            }
            return stubTree2;
        }
        FileElement fileElement = this.calcTreeElement();
        try {
            PsiLock psiLock = this.myPsiLock;
            synchronized (psiLock) {
                tree = this.derefStub();
                if (tree == null) {
                    this.assertReadAccessAllowed();
                    LanguageStubDescriptor stubDescriptor = this.getStubDescriptor();
                    if (stubDescriptor == null) {
                        VirtualFile vFile = this.getVirtualFile();
                        String message = "ContentElementType: " + this.getContentElementType() + "; file: " + this + (vFile.isValid() ? "" : " (" + vFile + " invalid)") + "\n\tBoolean.TRUE.equals(getUserData(BUILDING_STUB)) = " + Boolean.TRUE.equals(this.getUserData(BUILDING_STUB)) + "\n\tgetTreeElement() = " + this.getTreeElement() + "\n\tvFile instanceof VirtualFileWithId = " + (vFile instanceof VirtualFileWithId) + "\n\tStubUpdatingIndex.canHaveStub(vFile) = " + StubTreeLoader.getInstance().canHaveStub(vFile);
                        this.rebuildStub();
                        throw new AssertionError((Object)message);
                    }
                    StubElement currentStubTree = stubDescriptor.getStubDefinition().getBuilder().buildStubTree((PsiFile)this);
                    if (currentStubTree == null) {
                        throw new AssertionError((Object)("Stub tree wasn't built for " + stubDescriptor + "; file: " + this));
                    }
                    tree = new StubTree((PsiFileStub)currentStubTree);
                    tree.setDebugInfo("created in calcStubTree");
                    this.updateTrees(this.myTrees.withStub(tree, fileElement));
                }
                stubTree = tree;
            }
        }
        catch (StubTreeLoader.StubTreeAndIndexUnmatchCoarseException e) {
            throw e.createCompleteException();
        }
        if (stubTree == null) {
            PsiFileImpl.$$$reportNull$$$0(52);
        }
        return stubTree;
    }

    final void rebuildStub() {
        AppUIExecutor.onWriteThread((ModalityState)ModalityState.nonModal()).later().submit(() -> {
            VirtualFile vFile;
            if (!this.myManager.isDisposed()) {
                this.myManager.dropPsiCaches();
            }
            if ((vFile = this.getVirtualFile()) != null && vFile.isValid()) {
                Document doc = FileDocumentManager.getInstance().getCachedDocument(vFile);
                if (doc != null) {
                    FileDocumentManager.getInstance().saveDocument(doc);
                }
                FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{vFile});
                StubTreeLoader.getInstance().rebuildStubTree(vFile);
            }
        });
    }

    public void putInfo(@NotNull Map<? super String, ? super String> info) {
        if (info == null) {
            PsiFileImpl.$$$reportNull$$$0(53);
        }
        PsiFileImpl.putInfo(this, info);
    }

    public static void putInfo(@NotNull PsiFile psiFile, @NotNull Map<? super String, ? super String> info) {
        if (psiFile == null) {
            PsiFileImpl.$$$reportNull$$$0(54);
        }
        if (info == null) {
            PsiFileImpl.$$$reportNull$$$0(55);
        }
        info.put("fileName", psiFile.getName());
        info.put("fileType", psiFile.getFileType().toString());
    }

    public String toString() {
        return this.myElementType.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void beforeAstChange() {
        this.checkWritable();
        PsiLock psiLock = this.myPsiLock;
        synchronized (psiLock) {
            FileTrees updated = this.myTrees.switchToStrongRefs();
            if (updated != this.myTrees) {
                this.updateTrees(updated);
            }
        }
    }

    private void checkWritable() {
        PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)this.getProject());
        if (docManager instanceof PsiDocumentManagerEx && !((PsiDocumentManagerEx)docManager).isCommitInProgress() && !(this.myViewProvider instanceof FreeThreadedFileViewProvider)) {
            CheckUtil.checkWritable((PsiElement)this);
        }
    }

    @ApiStatus.Internal
    public boolean isIndexingFileCopy() {
        return this.getUserData(IndexingDataKeys.VIRTUAL_FILE) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentElementType";
                break;
            }
            case 6: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiFileImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trees";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeElement";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiFileImpl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTreeElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubbedSpine";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileElement";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiRoots";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewProvider";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileDocument";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findChildrenByClass";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubTreeOrFileElement";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "setStubTree";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreeElementPointer";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "calcStubTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setContentElementType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setOriginalFile";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "updateTrees";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createTreeElementPointer";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "checkAdd";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addRangeBefore";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

