/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.report;

import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.report.ReportParser;
import org.jetbrains.qodana.report.ReportReader;
import org.jetbrains.qodana.report.ReportValidator;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001b\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"getReportFileErrorNotificationContent", "", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "reportPath", "Ljava/nio/file/Path;", "readerError", "Lorg/jetbrains/qodana/report/ReportReader$ReaderError;", "intellij.qodana"})
public final class FromFileReportDescriptorBuilderKt {
    @NotNull
    public static final String getReportFileErrorNotificationContent(@NotNull Path reportPath2, @NotNull ReportReader.ReaderError readerError) {
        String string;
        Intrinsics.checkNotNullParameter((Object)reportPath2, (String)"reportPath");
        Intrinsics.checkNotNullParameter((Object)readerError, (String)"readerError");
        ReportReader.ReaderError readerError2 = readerError;
        if (readerError2 instanceof ReportReader.FailedValidation) {
            ReportValidator.ValidatorError validatorError = ((ReportReader.FailedValidation)readerError).getValidatorError();
            Object[] objectArray = new Object[]{reportPath2};
            String string2 = QodanaBundle.message("notification.content.failed.validation.report.from.file", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            string = ReportValidator.INSTANCE.getNotificationContentFromSource(validatorError, string2);
        } else if (readerError2 instanceof ReportReader.FailedParsing) {
            String string3;
            ReportParser.ParserError parserError = ((ReportReader.FailedParsing)readerError).getParserError();
            if (Intrinsics.areEqual((Object)parserError, (Object)ReportParser.FileNotExists.INSTANCE)) {
                var5_5 = new Object[]{reportPath2};
                string3 = QodanaBundle.message("notification.content.report.file.does.not.exist", var5_5);
            } else if (parserError instanceof ReportParser.JsonParseFailed) {
                var5_5 = new Object[]{reportPath2, ((ReportParser.JsonParseFailed)((ReportReader.FailedParsing)readerError).getParserError()).getMessage()};
                string3 = QodanaBundle.message("notification.content.cant.parse.report.from.file", var5_5);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String string4 = string3;
            Intrinsics.checkNotNull((Object)string4);
            string = string4;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }
}

