/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.profile;

import com.intellij.codeInspection.ex.EnabledInspectionsProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaCancellationException;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaGlobalInspectionContext;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaScopeModifier;
import org.jetbrains.qodana.staticAnalysis.profile.GroupState;
import org.jetbrains.qodana.staticAnalysis.profile.NamedInspectionGroup;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfile;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfileManager;
import org.jetbrains.qodana.staticAnalysis.profile.StateWithThreshold;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00060\u0007R\u00020\u00002\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup;", "Lorg/jetbrains/qodana/staticAnalysis/profile/NamedInspectionGroup;", "profile", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "<init>", "(Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;)V", "createState", "Lorg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup$State;", "context", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;", "applyConfig", "config", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "project", "Lcom/intellij/openapi/project/Project;", "addDefaultExclude", "", "State", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nMainInspectionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainInspectionGroup.kt\norg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1915#2,2:62\n1915#2,2:64\n*S KotlinDebug\n*F\n+ 1 MainInspectionGroup.kt\norg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup\n*L\n56#1:62,2\n57#1:64,2\n*E\n"})
public final class MainInspectionGroup
extends NamedInspectionGroup {
    public MainInspectionGroup(@NotNull QodanaInspectionProfile profile2) {
        Intrinsics.checkNotNullParameter((Object)((Object)profile2), (String)"profile");
        super("", profile2);
    }

    @Override
    @NotNull
    public State createState(@NotNull QodanaGlobalInspectionContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        return new State(context);
    }

    @Override
    @NotNull
    public MainInspectionGroup applyConfig(@NotNull QodanaConfig config, @NotNull Project project, boolean addDefaultExclude) {
        QodanaScopeModifier it;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super.applyConfig(config, project, addDefaultExclude);
        List<QodanaScopeModifier> excludeModifiers = config.getExcludeModifiers(addDefaultExclude, project);
        List<QodanaScopeModifier> includeModifiers = config.getIncludeModifiers();
        if (excludeModifiers.isEmpty() && includeModifiers.isEmpty()) {
            return this;
        }
        QodanaInspectionProfileManager profileManager = QodanaInspectionProfileManager.Companion.getInstance(project);
        QodanaInspectionProfile newProfile = QodanaInspectionProfile.Companion.clone(this.getProfile(), "qodana.main.profile(base:" + this.getProfile().getName() + ")", profileManager);
        Iterable $this$forEach$iv = excludeModifiers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (QodanaScopeModifier)element$iv;
            boolean bl = false;
            it.updateProfileScopes(newProfile, project, config.getProjectPath());
        }
        $this$forEach$iv = includeModifiers;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (QodanaScopeModifier)element$iv;
            boolean bl = false;
            it.updateProfileScopes(newProfile, project, config.getProjectPath());
        }
        return new MainInspectionGroup(newProfile);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup$State;", "Lorg/jetbrains/qodana/staticAnalysis/profile/GroupState;", "context", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;", "<init>", "(Lorg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup;Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;)V", "thresholdState", "Lorg/jetbrains/qodana/staticAnalysis/profile/StateWithThreshold;", "getThresholdState", "()Lorg/jetbrains/qodana/staticAnalysis/profile/StateWithThreshold;", "problemsCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "onConsumeProblem", "", "inspectionId", "", "relativePath", "module", "onFinish", "", "shouldSkip", "file", "Lcom/intellij/psi/PsiFile;", "wrappers", "Lcom/intellij/codeInspection/ex/EnabledInspectionsProvider$ToolWrappers;", "getCount", "", "intellij.qodana"})
    public final class State
    extends GroupState {
        @Nullable
        private final StateWithThreshold thresholdState;
        @NotNull
        private final AtomicInteger problemsCounter;

        public State(QodanaGlobalInspectionContext context) {
            Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
            super(context, MainInspectionGroup.this);
            this.thresholdState = context.getConfig().getForceThresholdsOnMainProfile() ? new StateWithThreshold(context, MainInspectionGroup.this) : null;
            this.problemsCounter = new AtomicInteger();
        }

        @Nullable
        public final StateWithThreshold getThresholdState() {
            return this.thresholdState;
        }

        @Override
        public boolean onConsumeProblem(@NotNull String inspectionId, @Nullable String relativePath, @Nullable String module) {
            Boolean keepConsuming;
            Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
            StateWithThreshold stateWithThreshold = this.thresholdState;
            Boolean bl = keepConsuming = stateWithThreshold != null ? Boolean.valueOf(stateWithThreshold.onConsumeProblem(inspectionId, relativePath, module)) : null;
            if (Intrinsics.areEqual((Object)keepConsuming, (Object)false)) {
                return false;
            }
            if (this.getContext().getConfig().isAboveStopThreshold(this.problemsCounter.get())) {
                String errorMessage = "Analysis cancelled since stopThreshold " + this.getContext().getConfig().getStopThreshold() + " is surpassed.";
                CoroutineScopeKt.cancel((CoroutineScope)this.getContext().getQodanaRunScope(), (CancellationException)new QodanaCancellationException(errorMessage));
                return false;
            }
            this.problemsCounter.incrementAndGet();
            return super.onConsumeProblem(inspectionId, relativePath, module);
        }

        @Override
        public void onFinish() {
            StateWithThreshold stateWithThreshold = this.thresholdState;
            if (stateWithThreshold != null) {
                stateWithThreshold.onFinish();
            }
            super.onFinish();
        }

        @Override
        public boolean shouldSkip(@NotNull String inspectionId, @NotNull PsiFile file2, @NotNull EnabledInspectionsProvider.ToolWrappers wrappers) {
            Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)wrappers, (String)"wrappers");
            StateWithThreshold stateWithThreshold = this.thresholdState;
            return stateWithThreshold != null ? stateWithThreshold.shouldSkip(inspectionId, file2, wrappers) : false;
        }

        public final int getCount() {
            return this.problemsCounter.get();
        }
    }
}

