/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.ide.util.frameworkSupport.FrameworkRole;
import com.intellij.ide.util.projectWizard.AbstractModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilderFactory;
import com.intellij.ide.util.projectWizard.ModuleBuilderListener;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.util.projectWizard.WizardInputField;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ModalityUiUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Unit;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleBuilder
extends AbstractModuleBuilder {
    public static final int JVM_WEIGHT = 2000;
    public static final int KOTLIN_WEIGHT = 1900;
    public static final int GROOVY_WEIGHT = 1800;
    public static final int SCALA_WEIGHT = 1700;
    public static final int WEB_WEIGHT = 1600;
    public static final int PYTHON_WEIGHT = 1500;
    public static final int RUST_WEIGHT = 1400;
    public static final int PHP_WEIGHT = 1300;
    public static final int RUBY_WEIGHT = 1200;
    public static final int GO_WEIGHT = 1100;
    @Deprecated
    public static final int IJ_PLUGIN_WEIGHT = 1000;
    public static final int OTHER_WEIGHT = 900;
    private static final ExtensionPointName<ModuleBuilderFactory> EP_NAME = new ExtensionPointName("com.intellij.moduleBuilder");
    private static final Logger LOG = Logger.getInstance(ModuleBuilder.class);
    private final Set<ModuleConfigurationUpdater> updaters = new HashSet<ModuleConfigurationUpdater>();
    private final EventDispatcher<ModuleBuilderListener> dispatcher = EventDispatcher.create(ModuleBuilderListener.class);
    protected Sdk myJdk;
    private String name;
    @NonNls
    private String moduleFilePath;
    private String myContentEntryPath;

    @NotNull
    public List<Class<? extends ModuleWizardStep>> getIgnoredSteps() {
        List<Class<? extends ModuleWizardStep>> list = Collections.emptyList();
        if (list == null) {
            ModuleBuilder.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public static List<ModuleBuilder> getAllBuilders() {
        ArrayList<ModuleBuilder> result = new ArrayList<ModuleBuilder>();
        for (ModuleType<?> moduleType : ModuleTypeManager.getInstance().getRegisteredTypes()) {
            Object builder = moduleType.createModuleBuilder();
            if (!((ModuleBuilder)builder).isAvailable()) continue;
            result.add((ModuleBuilder)builder);
        }
        EP_NAME.processWithPluginDescriptor((bean, pluginDescriptor) -> {
            ModuleBuilder builder;
            try {
                builder = (ModuleBuilder)ApplicationManager.getApplication().instantiateClass(bean.builderClass, pluginDescriptor);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return Unit.INSTANCE;
            }
            if (builder.isAvailable()) {
                result.add(builder);
            }
            return Unit.INSTANCE;
        });
        ArrayList<ModuleBuilder> arrayList = result;
        if (arrayList == null) {
            ModuleBuilder.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public static void deleteModuleFile(String moduleFilePath) {
        VirtualFile file;
        File moduleFile = new File(moduleFilePath);
        if (moduleFile.exists()) {
            FileUtil.delete((File)moduleFile);
        }
        if ((file = LocalFileSystem.getInstance().findFileByIoFile(moduleFile)) != null) {
            file.refresh(false, false);
        }
    }

    public boolean isAvailable() {
        return true;
    }

    @Nullable
    protected static String acceptParameter(String param) {
        return param != null && !param.isEmpty() ? param : null;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = ModuleBuilder.acceptParameter(name);
    }

    @Override
    @Nullable
    @NonNls
    public String getBuilderId() {
        ModuleType<?> moduleType = this.getModuleType();
        return moduleType == null ? null : moduleType.getId();
    }

    @Override
    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        ModuleType<?> moduleType;
        if (wizardContext == null) {
            ModuleBuilder.$$$reportNull$$$0(2);
        }
        if (modulesProvider == null) {
            ModuleBuilder.$$$reportNull$$$0(3);
        }
        return (moduleType = this.getModuleType()) == null ? ModuleWizardStep.EMPTY_ARRAY : moduleType.createWizardSteps(wizardContext, this, modulesProvider);
    }

    @Override
    @Nullable
    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            ModuleBuilder.$$$reportNull$$$0(4);
        }
        return this.modifyStep(settingsStep);
    }

    public ModuleWizardStep modifyStep(SettingsStep settingsStep) {
        ModuleType<?> type = this.getModuleType();
        if (type == null) {
            return null;
        }
        final ModuleWizardStep step = type.modifySettingsStep(settingsStep, this);
        final List<WizardInputField<?>> fields = this.getAdditionalFields();
        for (WizardInputField<?> field : fields) {
            field.addToSettings(settingsStep);
        }
        return new ModuleWizardStep(this){

            @Override
            public JComponent getComponent() {
                return null;
            }

            @Override
            public void updateDataModel() {
                if (step != null) {
                    step.updateDataModel();
                }
            }

            @Override
            public boolean validate() throws ConfigurationException {
                for (WizardInputField field : fields) {
                    if (field.validate()) continue;
                    return false;
                }
                return step == null || step.validate();
            }
        };
    }

    @Override
    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep) {
        ModuleType<?> type;
        if (settingsStep == null) {
            ModuleBuilder.$$$reportNull$$$0(5);
        }
        return (type = this.getModuleType()) == null ? null : type.modifyProjectTypeStep(settingsStep, this);
    }

    @NotNull
    protected List<WizardInputField<?>> getAdditionalFields() {
        List<WizardInputField<?>> list = Collections.emptyList();
        if (list == null) {
            ModuleBuilder.$$$reportNull$$$0(6);
        }
        return list;
    }

    public String getModuleFilePath() {
        return this.moduleFilePath;
    }

    @Override
    public void setModuleFilePath(@NonNls String path) {
        this.moduleFilePath = ModuleBuilder.acceptParameter(path);
    }

    public void addModuleConfigurationUpdater(ModuleConfigurationUpdater updater) {
        this.updaters.add(updater);
    }

    @Nullable
    public String getContentEntryPath() {
        if (this.myContentEntryPath == null) {
            String directory = this.getModuleFileDirectory();
            if (directory == null) {
                return null;
            }
            new File(directory).mkdirs();
            return directory;
        }
        return this.myContentEntryPath;
    }

    @Override
    public void setContentEntryPath(String moduleRootPath) {
        String path = ModuleBuilder.acceptParameter(moduleRootPath);
        if (path != null) {
            try {
                this.myContentEntryPath = FileUtil.resolveShortWindowsName((String)path);
            }
            catch (IOException e) {
                this.myContentEntryPath = path;
            }
        } else {
            this.myContentEntryPath = null;
        }
        if (this.myContentEntryPath != null) {
            this.myContentEntryPath = this.myContentEntryPath.replace(File.separatorChar, '/');
        }
    }

    @Nullable
    protected ContentEntry doAddContentEntry(ModifiableRootModel modifiableRootModel) {
        String contentEntryPath = this.getContentEntryPath();
        if (contentEntryPath == null) {
            return null;
        }
        new File(contentEntryPath).mkdirs();
        VirtualFile moduleContentRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(contentEntryPath.replace('\\', '/'));
        if (moduleContentRoot == null) {
            return null;
        }
        return modifiableRootModel.addContentEntry(moduleContentRoot);
    }

    @Nullable
    public String getModuleFileDirectory() {
        if (this.moduleFilePath == null) {
            return null;
        }
        String parent = new File(this.moduleFilePath).getParent();
        if (parent == null) {
            return null;
        }
        return parent.replace(File.separatorChar, '/');
    }

    @NotNull
    public Module createModule(@NotNull ModifiableModuleModel moduleModel) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists, ConfigurationException, JDOMException {
        if (moduleModel == null) {
            ModuleBuilder.$$$reportNull$$$0(7);
        }
        LOG.assertTrue(this.name != null);
        LOG.assertTrue(this.moduleFilePath != null);
        ModuleBuilder.deleteModuleFile(this.moduleFilePath);
        ModuleType<?> moduleType = this.getModuleType();
        Module module = moduleModel.newModule(this.moduleFilePath, moduleType.getId());
        this.setupModule(module);
        Module module2 = module;
        if (module2 == null) {
            ModuleBuilder.$$$reportNull$$$0(8);
        }
        return module2;
    }

    protected void setupModule(Module module) throws ConfigurationException {
        ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        this.setupRootModel(modifiableModel);
        for (ModuleConfigurationUpdater updater : this.updaters) {
            updater.update(module, modifiableModel);
        }
        modifiableModel.commit();
        this.setProjectType(module);
    }

    private void onModuleInitialized(Module module) {
        ((ModuleBuilderListener)this.dispatcher.getMulticaster()).moduleCreated(module);
    }

    public void setupRootModel(@NotNull ModifiableRootModel modifiableRootModel) throws ConfigurationException {
        if (modifiableRootModel == null) {
            ModuleBuilder.$$$reportNull$$$0(9);
        }
    }

    public abstract ModuleType<?> getModuleType();

    protected ProjectType getProjectType() {
        return null;
    }

    protected void setProjectType(Module module) {
        ProjectType projectType = this.getProjectType();
        if (projectType != null && ProjectTypeService.getProjectType((Project)module.getProject()) == null) {
            ProjectTypeService.setProjectType((Project)module.getProject(), (ProjectType)projectType);
        }
    }

    @NotNull
    public Module createAndCommitIfNeeded(@NotNull Project project, @Nullable ModifiableModuleModel model, boolean runFromProjectWizard) throws InvalidDataException, ConfigurationException, IOException, JDOMException, ModuleWithNameAlreadyExists {
        if (project == null) {
            ModuleBuilder.$$$reportNull$$$0(10);
        }
        ModifiableModuleModel moduleModel = model != null ? model : ModuleManager.getInstance((Project)project).getModifiableModel();
        Module module = this.createModule(moduleModel);
        if (model == null) {
            moduleModel.commit();
        }
        if (runFromProjectWizard) {
            StartupManager.getInstance((Project)module.getProject()).runAfterOpened(() -> ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.nonModal(), (Condition)module.getDisposed(), () -> ApplicationManager.getApplication().runWriteAction(() -> this.onModuleInitialized(module))));
        } else {
            this.onModuleInitialized(module);
        }
        Module module2 = module;
        if (module2 == null) {
            ModuleBuilder.$$$reportNull$$$0(11);
        }
        return module2;
    }

    public void addListener(ModuleBuilderListener listener) {
        this.dispatcher.addListener((EventListener)listener);
    }

    public void removeListener(ModuleBuilderListener listener) {
        this.dispatcher.removeListener((EventListener)listener);
    }

    public boolean canCreateModule() {
        return true;
    }

    @Override
    @Nullable
    public List<Module> commit(@NotNull Project project, ModifiableModuleModel model, ModulesProvider modulesProvider) {
        Module module;
        if (project == null) {
            ModuleBuilder.$$$reportNull$$$0(12);
        }
        return (module = this.commitModule(project, model)) != null ? Collections.singletonList(module) : null;
    }

    @Nullable
    public Module commitModule(@NotNull Project project, @Nullable ModifiableModuleModel model) {
        if (project == null) {
            ModuleBuilder.$$$reportNull$$$0(13);
        }
        if (!this.canCreateModule()) {
            return null;
        }
        if (this.name == null) {
            this.name = project.getName();
        }
        if (this.moduleFilePath == null) {
            this.moduleFilePath = project.getBasePath() + File.separator + this.name + ".iml";
        }
        try {
            return (Module)ApplicationManager.getApplication().runWriteAction(() -> this.createAndCommitIfNeeded(project, model, true));
        }
        catch (Exception ex) {
            LOG.warn((Throwable)ex);
            MessagesService.getInstance().showErrorDialog(project, IdeCoreBundle.message((String)"error.adding.module.to.project", (Object[])new Object[]{ex.getMessage()}), IdeCoreBundle.message((String)"title.add.module", (Object[])new Object[0]));
            return null;
        }
    }

    @Override
    public Icon getNodeIcon() {
        return this.getModuleType().getNodeIcon(false);
    }

    @NlsContexts.DetailedDescription
    public String getDescription() {
        return this.getModuleType().getDescription();
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getPresentableName() {
        return this.getModuleTypeName();
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    protected String getModuleTypeName() {
        String name = this.getModuleType().getName();
        return StringUtil.trimEnd((String)name, (String)" Module");
    }

    public String getGroupName() {
        return this.getPresentableName().split(" ")[0];
    }

    public String getParentGroup() {
        return null;
    }

    public int getWeight() {
        return 0;
    }

    public boolean isTemplate() {
        return false;
    }

    public boolean isTemplateBased() {
        return false;
    }

    public void updateFrom(ModuleBuilder from) {
        this.name = from.getName();
        this.myContentEntryPath = from.getContentEntryPath();
        this.moduleFilePath = from.getModuleFilePath();
    }

    public Sdk getModuleJdk() {
        return this.myJdk;
    }

    public void setModuleJdk(Sdk jdk) {
        this.myJdk = jdk;
    }

    @NotNull
    public FrameworkRole getDefaultAcceptableRole() {
        FrameworkRole frameworkRole = this.getModuleType().getDefaultAcceptableRole();
        if (frameworkRole == null) {
            ModuleBuilder.$$$reportNull$$$0(14);
        }
        return frameworkRole;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 7, 9, 10, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/projectWizard/ModuleBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizardContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableRootModel";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredSteps";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBuilders";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/projectWizard/ModuleBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalFields";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndCommitIfNeeded";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultAcceptableRole";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createWizardSteps";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "modifySettingsStep";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "modifyProjectTypeStep";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setupRootModel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createAndCommitIfNeeded";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "commitModule";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 7, 9, 10, 12, 13 -> new IllegalArgumentException(string);
        };
    }

    public static abstract class ModuleConfigurationUpdater {
        public abstract void update(@NotNull Module var1, @NotNull ModifiableRootModel var2);
    }
}

