/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dcl.lang.ide;

import com.android.tools.idea.gradle.dcl.lang.parser.DeclarativeElementTypeHolder;
import com.android.tools.idea.gradle.dcl.lang.parser.DeclarativeTokenSets;
import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0016\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/gradle/dcl/lang/ide/DeclarativeQuoteHandler;", "Lcom/intellij/codeInsight/editorActions/SimpleTokenSetQuoteHandler;", "Lcom/intellij/codeInsight/editorActions/MultiCharQuoteHandler;", "<init>", "()V", "isClosingQuote", "", "iterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "offset", "", "getClosingQuote", "", "hasNonClosedLiteral", "editor", "Lcom/intellij/openapi/editor/Editor;", "insertClosingQuote", "", "file", "Lcom/intellij/psi/PsiFile;", "closingQuote", "intellij.android.gradle.declarative.lang.ide"})
public final class DeclarativeQuoteHandler
extends SimpleTokenSetQuoteHandler
implements MultiCharQuoteHandler {
    public DeclarativeQuoteHandler() {
        super(DeclarativeTokenSets.INSTANCE.getSTRING_LITERALS());
    }

    public boolean isClosingQuote(@NotNull HighlighterIterator iterator, int offset) {
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        if (iterator.getTokenType() == DeclarativeElementTypeHolder.MULTILINE_STRING_LITERAL) {
            int start = iterator.getStart();
            int end = iterator.getEnd();
            return end - start >= 5 && offset >= end - 3;
        }
        return super.isClosingQuote(iterator, offset);
    }

    @Nullable
    public CharSequence getClosingQuote(@NotNull HighlighterIterator iterator, int offset) {
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        return iterator.getTokenType() == DeclarativeElementTypeHolder.MULTILINE_STRING_LITERAL && offset == iterator.getStart() + 3 ? (CharSequence)"\"\"\"" : null;
    }

    public boolean hasNonClosedLiteral(@NotNull Editor editor, @NotNull HighlighterIterator iterator, int offset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        if (iterator.getTokenType() == DeclarativeElementTypeHolder.MULTILINE_STRING_LITERAL) {
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            String string = document2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String text = string;
            String string2 = text.substring(iterator.getStart(), offset + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            boolean hasOpenQuotes = StringUtil.equals((CharSequence)string2, (CharSequence)"\"\"\"");
            if (hasOpenQuotes) {
                String string3 = text.substring(offset + 1, iterator.getEnd());
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                boolean hasCloseQuotes = StringUtil.contains((CharSequence)string3, (CharSequence)"\"\"\"");
                if (!hasCloseQuotes) {
                    return true;
                }
                String string4 = text.substring(iterator.getEnd());
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                int nTextBlockQuotes = StringUtil.getOccurrenceCount((String)string4, (String)"\"\"\"");
                return nTextBlockQuotes % 2 != 0;
            }
        }
        return super.hasNonClosedLiteral(editor, iterator, offset);
    }

    public void insertClosingQuote(@NotNull Editor editor, int offset, @NotNull PsiFile file, @NotNull CharSequence closingQuote) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)closingQuote, (String)"closingQuote");
        editor.getDocument().insertString(offset, (CharSequence)"\"\"\"");
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement == null) {
            return;
        }
        PsiElement token = psiElement;
        PsiElement psiElement2 = token.getParent();
        if (psiElement2 == null) {
            return;
        }
        PsiElement parent = psiElement2;
        if (Intrinsics.areEqual((Object)parent.getNode().getElementType(), (Object)DeclarativeElementTypeHolder.MULTILINE_STRING_LITERAL)) {
            CodeStyleManager.getInstance((Project)project2).reformat(parent);
            editor.getCaretModel().moveToOffset(parent.getTextRange().getEndOffset() - 3);
        }
    }
}

