/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.diff;

import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.api.ValueMetricPrinter;
import com.intellij.profiler.api.ValueMetricPrinterWithUnits;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.diff.DiffCallTreeNode;
import com.intellij.profiler.model.diff.DiffCallWithValue;
import com.intellij.profiler.ui.BaseCallStackElementRenderer;
import com.intellij.profiler.ui.ProfilerUIUtilsKt;
import com.intellij.profiler.ui.callusage.FlameChartColorsRenderer;
import com.intellij.profiler.ui.callusage.UIVisibleCallTreeNodeInfo;
import com.intellij.profiler.ui.diff.DifferentialFlameGraphCellRenderer;
import com.intellij.profiler.ui.flamechart.FlameChartColorScheme;
import com.intellij.profiler.ui.flamechart.FlameChartColors;
import com.intellij.profiler.ui.flamegraph.FlameGraphNode;
import com.intellij.profiler.ui.flamegraph.FlameGraphPanel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.RectangularShape;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJH\u0010\f\u001a\u00020\r2\u0016\u0010\u000e\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00110\u0010j\u0002`\u00120\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0016\u0010\u0017\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00110\u0010j\u0002`\u00120\u0018H\u0014J8\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0016\u0010\u001b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00110\u0010j\u0002`\u00120\u00182\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u001dH\u0014J\u0015\u0010\u001f\u001a\u00070 \u00a2\u0006\u0002\b!2\u0006\u0010\"\u001a\u00020#H\u0014J\u0011\u0010$\u001a\u00070 \u00a2\u0006\u0002\b!*\u00020%H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/profiler/ui/diff/DifferentialFlameGraphRenderer;", "Lcom/intellij/profiler/ui/callusage/FlameChartColorsRenderer;", "cellRenderer", "Lcom/intellij/profiler/ui/diff/DifferentialFlameGraphCellRenderer;", "baseRenderer", "Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "<init>", "(Lcom/intellij/profiler/ui/diff/DifferentialFlameGraphCellRenderer;Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;Lcom/intellij/profiler/api/ValueMetric;)V", "metricPrinter", "Lcom/intellij/profiler/api/ValueMetricPrinterWithUnits;", "paintInnerRectangle", "", "component", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "Lcom/intellij/profiler/model/CallTreeNode;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lcom/intellij/profiler/ui/callusage/CallUsageNode;", "g", "Ljava/awt/Graphics2D;", "innerRectangle", "Ljava/awt/geom/RectangularShape;", "bounds", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphNode;", "getColor", "Ljava/awt/Color;", "node", "colorFunction", "Lkotlin/Function1;", "Lcom/intellij/profiler/ui/flamechart/FlameChartColorScheme;", "getTooltipText", "", "Lorg/jetbrains/annotations/Nls;", "uiInfo", "Lcom/intellij/profiler/ui/callusage/UIVisibleCallTreeNodeInfo;", "getDifferenceTooltipText", "Lcom/intellij/profiler/ui/callusage/UIVisibleCallTreeNodeInfo$Diff;", "createFrameMetricsComponent", "Ljavax/swing/JComponent;", "intellij.profiler.common"})
public final class DifferentialFlameGraphRenderer
extends FlameChartColorsRenderer {
    @NotNull
    private final DifferentialFlameGraphCellRenderer cellRenderer;
    @NotNull
    private final ValueMetricPrinterWithUnits metricPrinter;

    public DifferentialFlameGraphRenderer(@NotNull DifferentialFlameGraphCellRenderer cellRenderer, @NotNull BaseCallStackElementRenderer baseRenderer, @NotNull ValueMetric metric) {
        Intrinsics.checkNotNullParameter((Object)cellRenderer, (String)"cellRenderer");
        Intrinsics.checkNotNullParameter((Object)baseRenderer, (String)"baseRenderer");
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        super(baseRenderer, metric);
        this.cellRenderer = cellRenderer;
        this.metricPrinter = new ValueMetricPrinterWithUnits(ValueMetricPrinter.Default.INSTANCE);
    }

    @Override
    protected void paintInnerRectangle(@NotNull FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component, @NotNull Graphics2D g, @NotNull RectangularShape innerRectangle, @NotNull FlameGraphNode<CallTreeNode<BaseCallStackElement>> bounds) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)innerRectangle, (String)"innerRectangle");
        Intrinsics.checkNotNullParameter(bounds, (String)"bounds");
        super.paintInnerRectangle(component, g, innerRectangle, bounds);
        if (this.shouldBeFilteredOut(component, bounds)) {
            return;
        }
        CallTreeNode<BaseCallStackElement> node = bounds.getContent();
        if (node instanceof DiffCallTreeNode && ((DiffCallTreeNode)node).getData() != null) {
            Object object = ((DiffCallTreeNode)node).getData();
            Intrinsics.checkNotNull((Object)object);
            this.cellRenderer.paintDiffRectangle(g, innerRectangle, (DiffCallWithValue<?>)object, this.backgroundType(component, bounds));
        }
    }

    @Override
    @Nullable
    protected Color getColor(@NotNull FlameGraphNode<CallTreeNode<BaseCallStackElement>> node, @NotNull Function1<? super FlameChartColorScheme, ? extends Color> colorFunction) {
        Color color;
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Intrinsics.checkNotNullParameter(colorFunction, (String)"colorFunction");
        if (!(node.getContent() instanceof DiffCallTreeNode)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        CallTreeNode<BaseCallStackElement> callTreeNode = node.getContent();
        Intrinsics.checkNotNull(callTreeNode, (String)"null cannot be cast to non-null type com.intellij.profiler.model.diff.DiffCallTreeNode<*>");
        Object object = ((DiffCallTreeNode)callTreeNode).getData();
        if (object != null) {
            Object it = object;
            boolean bl = false;
            color = this.cellRenderer.getRequiresMixedColor() ? (Color)colorFunction.invoke((Object)new FlameChartColors.Diff(((DiffCallWithValue)it).getBaselineValue(), ((DiffCallWithValue)it).getNewValue())) : super.getColor(node, colorFunction);
        } else {
            color = null;
        }
        return color;
    }

    @Override
    @NotNull
    protected String getTooltipText(@NotNull UIVisibleCallTreeNodeInfo uiInfo) {
        Intrinsics.checkNotNullParameter((Object)uiInfo, (String)"uiInfo");
        if (!(uiInfo instanceof UIVisibleCallTreeNodeInfo.Diff)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.getDifferenceTooltipText((UIVisibleCallTreeNodeInfo.Diff)uiInfo);
    }

    private final String getDifferenceTooltipText(UIVisibleCallTreeNodeInfo.Diff $this$getDifferenceTooltipText) {
        String string;
        if ($this$getDifferenceTooltipText.getValue() == 0L) {
            string = CommonProfilerBundleKt.profilerMessage("ui.flamechart.tooltip.removed", new Object[0]);
        } else if ($this$getDifferenceTooltipText.getBaselineValue() == 0L) {
            string = CommonProfilerBundleKt.profilerMessage("ui.flamechart.tooltip.added", new Object[0]);
        } else {
            double fraction = (double)($this$getDifferenceTooltipText.getValue() - $this$getDifferenceTooltipText.getBaselineValue()) / (double)$this$getDifferenceTooltipText.getBaselineValue();
            string = ProfilerUIUtilsKt.fractionToString$default(fraction, 0.0, true, false, 8, null);
        }
        String result2 = string;
        Object[] objectArray = new Object[]{"<b>" + result2 + "</b>", this.metricPrinter.print(this.getMetric(), $this$getDifferenceTooltipText.getBaselineValue()), this.metricPrinter.print(this.getMetric(), $this$getDifferenceTooltipText.getValue())};
        return CommonProfilerBundleKt.profilerMessage("ui.flamechart.tooltip.difference", objectArray);
    }

    @Override
    @NotNull
    public JComponent createFrameMetricsComponent(@NotNull UIVisibleCallTreeNodeInfo uiInfo) {
        Intrinsics.checkNotNullParameter((Object)uiInfo, (String)"uiInfo");
        if (!(uiInfo instanceof UIVisibleCallTreeNodeInfo.Diff)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return (JComponent)this.label(this.toHtml(this.getDifferenceTooltipText((UIVisibleCallTreeNodeInfo.Diff)uiInfo)));
    }
}

