/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunProfileState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SingleAlarm;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.plugins.reactnative.PackagerState;
import com.jetbrains.plugins.reactnative.ProcessRunnerFactory;
import com.jetbrains.plugins.reactnative.ReactNativePackagerConfiguration;
import com.jetbrains.plugins.reactnative.ReactNativePackagerKt;
import com.jetbrains.plugins.reactnative.ReactNativeProgramRunnerKt;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfigurationKt;
import com.jetbrains.plugins.reactnative.TerminalProcessRunnerFactory;
import com.jetbrains.plugins.reactnative.ViewerProcessRunnerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0001\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\nH\u0002J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\nH\u0002J6\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001e\u001a\u00020\u0001H\u0002J\b\u0010\u001f\u001a\u00020\u000eH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R,\u0010\b\u001a \u0012\u0004\u0012\u00020\n\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativePackager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "packagers", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lkotlin/Pair;", "Lcom/intellij/execution/process/ProcessHandler;", "Ljava/util/concurrent/CompletableFuture;", "", "startPackager", "Lcom/jetbrains/plugins/reactnative/PackagerState;", "reactNativeRunConfiguration", "Lcom/jetbrains/plugins/reactnative/ReactNativeRunConfiguration;", "createListener", "Lcom/intellij/execution/process/ProcessListener;", "future", "workingDir", "getStartedPackager", "waitForPackagerOpensPort", "waitMillis", "", "host", "", "port", "disposable", "dispose", "findStartedPackager", "Companion", "intellij.javascript.reactNativeDebugger"})
@SourceDebugExtension(value={"SMAP\nReactNativePackager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactNativePackager.kt\ncom/jetbrains/plugins/reactnative/ReactNativePackager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1#2:177\n*E\n"})
public final class ReactNativePackager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<VirtualFile, Pair<ProcessHandler, CompletableFuture<Unit>>> packagers;

    public ReactNativePackager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.packagers = new HashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final PackagerState startPackager(@NotNull ReactNativeRunConfiguration reactNativeRunConfiguration) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactNativeRunConfiguration), (String)"reactNativeRunConfiguration");
        ReactNativePackagerConfiguration configuration = ReactNativePackagerConfiguration.Companion.getInstance(this.project);
        String effectiveWorkingDirectory = ReactNativeRunConfigurationKt.findEffectiveWorkingDirectory(configuration.getWorkingDirectory(), this.project);
        VirtualFile workingDir = LocalFileSystem.getInstance().findFileByPath(effectiveWorkingDirectory);
        Map<VirtualFile, Pair<ProcessHandler, CompletableFuture<Unit>>> map = this.packagers;
        synchronized (map) {
            boolean bl = false;
            PackagerState packagerState = this.getStartedPackager(workingDir);
            if (packagerState != null) {
                PackagerState it = packagerState;
                boolean bl2 = false;
                return it;
            }
            CompletableFuture<Unit> future = new CompletableFuture<Unit>();
            NodeJsInterpreter nodeJsInterpreter = configuration.getNodeInterpreter().resolveNotNull(this.project);
            Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreter, (String)"resolveNotNull(...)");
            NodeJsInterpreter nodeInterpreter = nodeJsInterpreter;
            List<String> scripts = configuration.getScripts();
            String arguments = configuration.getArguments();
            ProcessRunnerFactory processRunnerFactory = null;
            NodeTargetRun targetRun = null;
            if (!scripts.isEmpty()) {
                processRunnerFactory = TerminalProcessRunnerFactory.INSTANCE;
                targetRun = new NodeTargetRun(nodeInterpreter, this.project, null, NodeTargetRunOptions.Companion.of$default((NodeTargetRunOptions.Companion)NodeTargetRunOptions.Companion, (Boolean)true, null, null, (int)6, null), null, 16, null);
                NodePackageRef nodePackageRef = NpmUtil.createProjectPackageManagerPackageRef();
                Intrinsics.checkNotNullExpressionValue((Object)nodePackageRef, (String)"createProjectPackageManagerPackageRef(...)");
                String[] stringArray = new String[]{effectiveWorkingDirectory, "package.json"};
                String string = FileUtil.join((String[])stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
                String string2 = arguments;
                if (string2 == null) {
                    string2 = "";
                }
                EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.create((Map)MapsKt.mapOf((Pair)new Pair((Object)"REACT_DEBUGGER", (Object)":")), (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"create(...)");
                NpmRunProfileState.Companion.configureCommandLine$default((NpmRunProfileState.Companion)NpmRunProfileState.Companion, (NodeTargetRun)targetRun, (String)"", (NodePackageRef)nodePackageRef, (String)string, (NpmCommand)NpmCommand.RUN_SCRIPT, scripts, (String)string2, (EnvironmentVariablesData)environmentVariablesData, null, null, (int)512, null);
            } else {
                processRunnerFactory = ViewerProcessRunnerFactory.INSTANCE;
                targetRun = new NodeTargetRun(nodeInterpreter, this.project, null, NodeTargetRunOptions.Companion.of$default((NodeTargetRunOptions.Companion)NodeTargetRunOptions.Companion, (Boolean)false, null, null, (int)6, null), null, 16, null);
                TargetedCommandLineBuilder commandLine = targetRun.getCommandLineBuilder();
                commandLine.addEnvironmentVariable("REACT_DEBUGGER", ":");
                NodePackage nodePackage = configuration.getReactNativePackage();
                if (nodePackage == null && (nodePackage = reactNativeRunConfiguration.getReactNativePackage()) == null) {
                    return null;
                }
                NodePackage reactNativePackage = nodePackage;
                commandLine.addParameter(targetRun.path(ReactNativeProgramRunnerKt.reactNativePackageToNodeArgument(reactNativePackage)));
                commandLine.addParameter("start");
                commandLine.setWorkingDirectory(targetRun.path(effectiveWorkingDirectory));
                CharSequence charSequence = arguments;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    List list = ParametersListUtil.parse((String)((Object)StringsKt.trim((CharSequence)arguments)).toString());
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parse(...)");
                    commandLine.addParameters(list);
                }
                targetRun.setEnvData(configuration.getEnvData());
            }
            ProcessHandler processHandler = targetRun.startProcess();
            processHandler.putUserData(ReactNativePackagerKt.getPROCESS_RUNNER_FACTORY(), (Object)processRunnerFactory);
            processHandler.addProcessListener(this.createListener(future, workingDir));
            if (workingDir != null) {
                this.packagers.put(workingDir, (Pair<ProcessHandler, CompletableFuture<Unit>>)new Pair((Object)processHandler, future));
            }
            this.waitForPackagerOpensPort(50, reactNativeRunConfiguration.getPackagerHost(), reactNativeRunConfiguration.getPackagerPort(), future, this);
            return new PackagerState(processHandler, false, future);
        }
    }

    private final ProcessListener createListener(CompletableFuture<Unit> future, VirtualFile workingDir) {
        return (ProcessListener)new ProcessAdapter(future, workingDir, this){
            final /* synthetic */ CompletableFuture<Unit> $future;
            final /* synthetic */ VirtualFile $workingDir;
            final /* synthetic */ ReactNativePackager this$0;
            {
                this.$future = $future;
                this.$workingDir = $workingDir;
                this.this$0 = $receiver;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                block4: {
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                        String string = event.getText();
                        if (string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"React packager ready.", (boolean)false, (int)2, null) : false) break block3;
                        String string2 = event.getText();
                        if (string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"Metro Bundler ready.", (boolean)false, (int)2, null) : false) break block3;
                        String string3 = event.getText();
                        if (string3 != null ? StringsKt.contains$default((CharSequence)string3, (CharSequence)"Packager started!", (boolean)false, (int)2, null) : false) break block3;
                        String string4 = event.getText();
                        if (string4 != null ? StringsKt.contains$default((CharSequence)string4, (CharSequence)"Welcome to React Native!", (boolean)false, (int)2, null) : false) break block3;
                        String string5 = event.getText();
                        if (string5 != null ? StringsKt.contains$default((CharSequence)string5, (CharSequence)"Welcome to Metro!", (boolean)false, (int)2, null) : false) break block3;
                        String string6 = event.getText();
                        if (string6 != null ? StringsKt.contains$default((CharSequence)string6, (CharSequence)"Ready at ", (boolean)false, (int)2, null) : false) break block3;
                        String string7 = event.getText();
                        boolean bl = string7 != null ? StringsKt.contains$default((CharSequence)string7, (CharSequence)"Loading dependency graph, done.", (boolean)false, (int)2, null) : false;
                        if (!bl) break block4;
                    }
                    this.$future.complete(Unit.INSTANCE);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processTerminated(ProcessEvent event) {
                String string;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.$workingDir != null) {
                    Map map = ReactNativePackager.access$getPackagers$p(this.this$0);
                    ReactNativePackager reactNativePackager = this.this$0;
                    VirtualFile virtualFile = this.$workingDir;
                    Map map2 = map;
                    synchronized (map2) {
                        boolean bl = false;
                        Pair pair = (Pair)ReactNativePackager.access$getPackagers$p(reactNativePackager).remove(virtualFile);
                    }
                }
                if ((string = event.getText()) == null) {
                    string = "";
                }
                this.$future.completeExceptionally(new Throwable(string));
            }
        };
    }

    private final PackagerState getStartedPackager(VirtualFile workingDir) {
        if (workingDir == null) {
            return null;
        }
        Pair<ProcessHandler, CompletableFuture<Unit>> packager = this.packagers.get(workingDir);
        return packager != null && !((ProcessHandler)packager.getFirst()).isProcessTerminated() ? new PackagerState((ProcessHandler)packager.getFirst(), true, (CompletableFuture)packager.getSecond()) : null;
    }

    private final void waitForPackagerOpensPort(int waitMillis, String host, int port, CompletableFuture<Unit> future, Disposable disposable) {
        SingleAlarm.cancelAndRequest$default((SingleAlarm)SingleAlarm.Companion.pooledThreadSingleAlarm(waitMillis, disposable, () -> ReactNativePackager.waitForPackagerOpensPort$lambda$0(future, host, port, this, waitMillis, disposable)), (boolean)false, (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<VirtualFile, Pair<ProcessHandler, CompletableFuture<Unit>>> map = this.packagers;
        synchronized (map) {
            boolean bl = false;
            Iterator<Pair<ProcessHandler, CompletableFuture<Unit>>> iterator = this.packagers.values().iterator();
            while (iterator.hasNext()) {
                ProcessHandler process = (ProcessHandler)iterator.next().component1();
                if (process.isProcessTerminated()) continue;
                process.destroyProcess();
            }
            this.packagers.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final PackagerState findStartedPackager(@Nullable VirtualFile workingDir) {
        Map<VirtualFile, Pair<ProcessHandler, CompletableFuture<Unit>>> map = this.packagers;
        synchronized (map) {
            block4: {
                boolean bl = false;
                PackagerState packagerState = this.getStartedPackager(workingDir);
                if (packagerState == null) break block4;
                PackagerState it = packagerState;
                boolean bl2 = false;
                PackagerState packagerState2 = it;
                return packagerState2;
            }
            Object var3_4 = null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit waitForPackagerOpensPort$lambda$0(CompletableFuture $future, String $host, int $port, ReactNativePackager this$0, int $waitMillis, Disposable $disposable) {
        if (!$future.isDone()) {
            try {
                Closeable closeable = new Socket($host, $port);
                Throwable throwable = null;
                try {
                    Socket it = (Socket)closeable;
                    boolean bl = false;
                    boolean bl2 = $future.complete(Unit.INSTANCE);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                this$0.waitForPackagerOpensPort((int)((double)$waitMillis * 1.1), $host, $port, $future, $disposable);
            }
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Map access$getPackagers$p(ReactNativePackager $this) {
        return $this.packagers;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativePackager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/plugins/reactnative/ReactNativePackager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.reactNativeDebugger"})
    @SourceDebugExtension(value={"SMAP\nReactNativePackager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactNativePackager.kt\ncom/jetbrains/plugins/reactnative/ReactNativePackager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,176:1\n30#2,2:177\n*S KotlinDebug\n*F\n+ 1 ReactNativePackager.kt\ncom/jetbrains/plugins/reactnative/ReactNativePackager$Companion\n*L\n36#1:177,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReactNativePackager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ReactNativePackager> serviceClass$iv = ReactNativePackager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ReactNativePackager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

