/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.LookupElementWithEffectiveInsertHandler;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.model.Symbol;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class LookupElementBuilder
extends LookupElement
implements LookupElementWithEffectiveInsertHandler {
    @NotNull
    private final String myLookupString;
    @NotNull
    private final Object myObject;
    @Nullable
    private final SmartPsiElementPointer<?> myPsiElement;
    private final boolean myCaseSensitive;
    @Nullable
    private final InsertHandler<LookupElement> myInsertHandler;
    @Nullable
    private final LookupElementRenderer<LookupElement> myRenderer;
    @Nullable
    private final LookupElementRenderer<LookupElement> myExpensiveRenderer;
    @Nullable
    private final LookupElementPresentation myHardcodedPresentation;
    @NotNull
    private final Set<String> myAllLookupStrings;

    private LookupElementBuilder(@NotNull String lookupString, @NotNull Object object, @Nullable InsertHandler<LookupElement> insertHandler, @Nullable LookupElementRenderer<LookupElement> renderer, @Nullable LookupElementRenderer<LookupElement> expensiveRenderer, @Nullable LookupElementPresentation hardcodedPresentation, @Nullable SmartPsiElementPointer<?> psiElement, @NotNull Set<String> allLookupStrings, boolean caseSensitive) {
        if (lookupString == null) {
            LookupElementBuilder.$$$reportNull$$$0(0);
        }
        if (object == null) {
            LookupElementBuilder.$$$reportNull$$$0(1);
        }
        if (allLookupStrings == null) {
            LookupElementBuilder.$$$reportNull$$$0(2);
        }
        this.myLookupString = LookupElementBuilder.validate(lookupString);
        this.myObject = object;
        this.myInsertHandler = insertHandler;
        this.myRenderer = renderer;
        this.myExpensiveRenderer = expensiveRenderer;
        this.myHardcodedPresentation = hardcodedPresentation;
        this.myPsiElement = psiElement;
        this.myAllLookupStrings = Collections.unmodifiableSet(allLookupStrings);
        this.myCaseSensitive = caseSensitive;
    }

    private static String validate(String string) {
        StringUtil.assertValidSeparators((CharSequence)string);
        return string;
    }

    private LookupElementBuilder(@NotNull String lookupString, @NotNull Object object) {
        if (lookupString == null) {
            LookupElementBuilder.$$$reportNull$$$0(3);
        }
        if (object == null) {
            LookupElementBuilder.$$$reportNull$$$0(4);
        }
        this(lookupString, object, null, null, null, null, null, Collections.singleton(lookupString), true);
    }

    @NotNull
    public static LookupElementBuilder create(@NotNull String lookupString) {
        if (lookupString == null) {
            LookupElementBuilder.$$$reportNull$$$0(5);
        }
        return new LookupElementBuilder(lookupString, lookupString);
    }

    @NotNull
    public static LookupElementBuilder create(@NotNull Object object) {
        if (object == null) {
            LookupElementBuilder.$$$reportNull$$$0(6);
        }
        return new LookupElementBuilder(object.toString(), object);
    }

    @NotNull
    public static LookupElementBuilder createWithSmartPointer(@NotNull String lookupString, @NotNull PsiElement element) {
        if (lookupString == null) {
            LookupElementBuilder.$$$reportNull$$$0(7);
        }
        if (element == null) {
            LookupElementBuilder.$$$reportNull$$$0(8);
        }
        PsiUtilCore.ensureValid((PsiElement)element);
        return new LookupElementBuilder(lookupString, SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element));
    }

    @NotNull
    public static LookupElementBuilder createWithSymbolPointer(@NotNull String lookupString, @NotNull Symbol symbol) {
        if (lookupString == null) {
            LookupElementBuilder.$$$reportNull$$$0(9);
        }
        if (symbol == null) {
            LookupElementBuilder.$$$reportNull$$$0(10);
        }
        return new LookupElementBuilder(lookupString, symbol.createPointer());
    }

    @NotNull
    public static LookupElementBuilder create(@NotNull PsiNamedElement element) {
        if (element == null) {
            LookupElementBuilder.$$$reportNull$$$0(11);
        }
        PsiUtilCore.ensureValid((PsiElement)element);
        return new LookupElementBuilder(StringUtil.notNullize((String)element.getName()), element);
    }

    @NotNull
    public static LookupElementBuilder createWithIcon(@NotNull PsiNamedElement element) {
        if (element == null) {
            LookupElementBuilder.$$$reportNull$$$0(12);
        }
        PsiUtilCore.ensureValid((PsiElement)element);
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create(element).withIcon(element.getIcon(0));
        if (lookupElementBuilder == null) {
            LookupElementBuilder.$$$reportNull$$$0(13);
        }
        return lookupElementBuilder;
    }

    @NotNull
    public static LookupElementBuilder create(@NotNull Object lookupObject, @NotNull String lookupString) {
        if (lookupObject == null) {
            LookupElementBuilder.$$$reportNull$$$0(14);
        }
        if (lookupString == null) {
            LookupElementBuilder.$$$reportNull$$$0(15);
        }
        if (lookupObject instanceof PsiElement) {
            PsiElement psiElement = (PsiElement)lookupObject;
            PsiUtilCore.ensureValid((PsiElement)psiElement);
        }
        return new LookupElementBuilder(lookupString, lookupObject);
    }

    @NotNull
    private LookupElementBuilder cloneWithUserData(@NotNull String lookupString, @NotNull Object object, @Nullable InsertHandler<LookupElement> insertHandler, @Nullable LookupElementRenderer<LookupElement> renderer, @Nullable LookupElementRenderer<LookupElement> expensiveRenderer, @Nullable LookupElementPresentation hardcodedPresentation, @Nullable SmartPsiElementPointer<?> psiElement, @NotNull Set<String> allLookupStrings, boolean caseSensitive) {
        if (lookupString == null) {
            LookupElementBuilder.$$$reportNull$$$0(16);
        }
        if (object == null) {
            LookupElementBuilder.$$$reportNull$$$0(17);
        }
        if (allLookupStrings == null) {
            LookupElementBuilder.$$$reportNull$$$0(18);
        }
        LookupElementBuilder result = new LookupElementBuilder(lookupString, object, insertHandler, renderer, expensiveRenderer, hardcodedPresentation, psiElement, allLookupStrings, caseSensitive);
        this.copyUserDataTo(result);
        LookupElementBuilder lookupElementBuilder = result;
        if (lookupElementBuilder == null) {
            LookupElementBuilder.$$$reportNull$$$0(19);
        }
        return lookupElementBuilder;
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder withInsertHandler(@Nullable InsertHandler<LookupElement> insertHandler) {
        return this.cloneWithUserData(this.myLookupString, this.myObject, insertHandler, this.myRenderer, this.myExpensiveRenderer, this.myHardcodedPresentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder withRenderer(@Nullable LookupElementRenderer<LookupElement> renderer) {
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, renderer, this.myExpensiveRenderer, this.myHardcodedPresentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder withExpensiveRenderer(@Nullable LookupElementRenderer<LookupElement> expensiveRenderer) {
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, this.myRenderer, expensiveRenderer, this.myHardcodedPresentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Override
    @NotNull
    public Set<String> getAllLookupStrings() {
        Set<String> set = this.myAllLookupStrings;
        if (set == null) {
            LookupElementBuilder.$$$reportNull$$$0(20);
        }
        return set;
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder withIcon(@Nullable Icon icon) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setIcon(icon);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, null, this.myExpensiveRenderer, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @NotNull
    private LookupElementPresentation copyPresentation() {
        LookupElementPresentation presentation = new LookupElementPresentation();
        if (this.myHardcodedPresentation != null) {
            presentation.copyFrom(this.myHardcodedPresentation);
        } else {
            presentation.setItemText(this.myLookupString);
        }
        LookupElementPresentation lookupElementPresentation = presentation;
        if (lookupElementPresentation == null) {
            LookupElementBuilder.$$$reportNull$$$0(21);
        }
        return lookupElementPresentation;
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder withLookupString(@NotNull String another) {
        if (another == null) {
            LookupElementBuilder.$$$reportNull$$$0(22);
        }
        HashSet<String> set = new HashSet<String>(this.myAllLookupStrings);
        set.add(another);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, this.myRenderer, this.myExpensiveRenderer, this.myHardcodedPresentation, this.myPsiElement, Collections.unmodifiableSet(set), this.myCaseSensitive);
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder withBaseLookupString(@NotNull String lookupString) {
        if (lookupString == null) {
            LookupElementBuilder.$$$reportNull$$$0(23);
        }
        return this.cloneWithUserData(lookupString, this.myObject, this.myInsertHandler, this.myRenderer, this.myExpensiveRenderer, this.myHardcodedPresentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder withLookupStrings(@NotNull @Unmodifiable Collection<String> another) {
        if (another == null) {
            LookupElementBuilder.$$$reportNull$$$0(24);
        }
        HashSet<String> set = new HashSet<String>(this.myAllLookupStrings.size() + another.size());
        set.addAll(this.myAllLookupStrings);
        set.addAll(another);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, this.myRenderer, this.myExpensiveRenderer, this.myHardcodedPresentation, this.myPsiElement, Collections.unmodifiableSet(set), this.myCaseSensitive);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder withCaseSensitivity(boolean caseSensitive) {
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, this.myRenderer, this.myExpensiveRenderer, this.myHardcodedPresentation, this.myPsiElement, this.myAllLookupStrings, caseSensitive);
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder withPsiElement(@Nullable PsiElement psi) {
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, this.myRenderer, this.myExpensiveRenderer, this.myHardcodedPresentation, psi == null ? null : SmartPointerManager.createPointer((PsiElement)psi), this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder withItemTextForeground(@NotNull Color itemTextForeground) {
        if (itemTextForeground == null) {
            LookupElementBuilder.$$$reportNull$$$0(25);
        }
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemTextForeground(itemTextForeground);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, null, this.myExpensiveRenderer, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder withItemTextUnderlined(boolean underlined) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemTextUnderlined(underlined);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, null, this.myExpensiveRenderer, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder withItemTextItalic(boolean italic) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemTextItalic(italic);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, null, this.myExpensiveRenderer, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder withTypeText(@Nullable String typeText) {
        LookupElementBuilder lookupElementBuilder = this.withTypeText(typeText, false);
        if (lookupElementBuilder == null) {
            LookupElementBuilder.$$$reportNull$$$0(26);
        }
        return lookupElementBuilder;
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder withTypeText(@Nullable String typeText, boolean grayed) {
        LookupElementBuilder lookupElementBuilder = this.withTypeText(typeText, null, grayed);
        if (lookupElementBuilder == null) {
            LookupElementBuilder.$$$reportNull$$$0(27);
        }
        return lookupElementBuilder;
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder withTypeText(@Nullable String typeText, @Nullable Icon typeIcon, boolean grayed) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setTypeText(typeText, typeIcon);
        presentation.setTypeGrayed(grayed);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, null, this.myExpensiveRenderer, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @NotNull
    public LookupElementBuilder withTypeIconRightAligned(boolean typeIconRightAligned) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setTypeIconRightAligned(typeIconRightAligned);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, null, this.myExpensiveRenderer, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder withPresentableText(@NotNull String presentableText) {
        if (presentableText == null) {
            LookupElementBuilder.$$$reportNull$$$0(28);
        }
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemText(presentableText);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, null, this.myExpensiveRenderer, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder bold() {
        LookupElementBuilder lookupElementBuilder = this.withBoldness(true);
        if (lookupElementBuilder == null) {
            LookupElementBuilder.$$$reportNull$$$0(29);
        }
        return lookupElementBuilder;
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder withBoldness(boolean bold) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemTextBold(bold);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, null, this.myExpensiveRenderer, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder strikeout() {
        LookupElementBuilder lookupElementBuilder = this.withStrikeoutness(true);
        if (lookupElementBuilder == null) {
            LookupElementBuilder.$$$reportNull$$$0(30);
        }
        return lookupElementBuilder;
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder withStrikeoutness(boolean strikeout) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setStrikeout(strikeout);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, null, this.myExpensiveRenderer, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder withTailText(@Nullable String tailText) {
        LookupElementBuilder lookupElementBuilder = this.withTailText(tailText, false);
        if (lookupElementBuilder == null) {
            LookupElementBuilder.$$$reportNull$$$0(31);
        }
        return lookupElementBuilder;
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder withTailText(@Nullable String tailText, boolean grayed) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setTailText(tailText, grayed);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, null, this.myExpensiveRenderer, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    @NotNull
    public LookupElementBuilder appendTailText(@NotNull String tailText, boolean grayed) {
        if (tailText == null) {
            LookupElementBuilder.$$$reportNull$$$0(32);
        }
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.appendTailText(tailText, grayed);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, null, this.myExpensiveRenderer, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    public LookupElement withAutoCompletionPolicy(AutoCompletionPolicy policy) {
        return policy.applyPolicy(this);
    }

    @Override
    @NotNull
    public String getLookupString() {
        String string = this.myLookupString;
        if (string == null) {
            LookupElementBuilder.$$$reportNull$$$0(33);
        }
        return string;
    }

    @Nullable
    public InsertHandler<LookupElement> getInsertHandler() {
        return this.myInsertHandler;
    }

    @Nullable
    public LookupElementRenderer<LookupElement> getRenderer() {
        return this.myRenderer;
    }

    @Override
    @Nullable
    public LookupElementRenderer<? extends LookupElement> getExpensiveRenderer() {
        return this.myExpensiveRenderer;
    }

    @Override
    @NotNull
    public Object getObject() {
        Object object = this.myObject;
        if (object == null) {
            LookupElementBuilder.$$$reportNull$$$0(34);
        }
        return object;
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        if (this.myPsiElement != null) {
            return this.myPsiElement.getElement();
        }
        return super.getPsiElement();
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context) {
        if (context == null) {
            LookupElementBuilder.$$$reportNull$$$0(35);
        }
        if (this.myInsertHandler != null) {
            this.myInsertHandler.handleInsert(context, this);
        }
    }

    @Override
    public void renderElement(@NotNull LookupElementPresentation presentation) {
        if (presentation == null) {
            LookupElementBuilder.$$$reportNull$$$0(36);
        }
        if (this.myRenderer != null) {
            this.myRenderer.renderElement(this, presentation);
        } else if (this.myHardcodedPresentation != null) {
            presentation.copyFrom(this.myHardcodedPresentation);
        } else {
            presentation.setItemText(this.myLookupString);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LookupElementBuilder that = (LookupElementBuilder)o;
        InsertHandler<LookupElement> insertHandler = that.myInsertHandler;
        if (this.myInsertHandler != null && insertHandler != null ? !this.myInsertHandler.getClass().equals(insertHandler.getClass()) : this.myInsertHandler != insertHandler) {
            return false;
        }
        if (!this.myLookupString.equals(that.myLookupString)) {
            return false;
        }
        if (!this.myObject.equals(that.myObject)) {
            return false;
        }
        LookupElementRenderer<LookupElement> renderer = that.myRenderer;
        return !(this.myRenderer != null && renderer != null ? !this.myRenderer.getClass().equals(renderer.getClass()) : this.myRenderer != renderer);
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public InsertHandler<?> getEffectiveInsertHandler() {
        return this.getInsertHandler();
    }

    @Override
    public String toString() {
        return "LookupElementBuilder: string=" + this.getLookupString() + "; handler=" + String.valueOf(this.myInsertHandler);
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.myInsertHandler != null ? this.myInsertHandler.getClass().hashCode() : 0);
        result = 31 * result + this.myLookupString.hashCode();
        result = 31 * result + this.myObject.hashCode();
        result = 31 * result + (this.myRenderer != null ? this.myRenderer.getClass().hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 19, 20, 21, 26, 27, 29, 30, 31, 33, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupString";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allLookupStrings";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/LookupElementBuilder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupObject";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "another";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemTextForeground";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableText";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tailText";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/LookupElementBuilder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createWithIcon";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithUserData";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLookupStrings";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "copyPresentation";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "withTypeText";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "bold";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "strikeout";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "withTailText";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createWithSmartPointer";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createWithSymbolPointer";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createWithIcon";
                break;
            }
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithUserData";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "withLookupString";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "withBaseLookupString";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "withLookupStrings";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "withItemTextForeground";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "withPresentableText";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "appendTailText";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "renderElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 19, 20, 21, 26, 27, 29, 30, 31, 33, 34 -> new IllegalStateException(string);
        };
    }
}

