/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.react.free;

import com.intellij.javascript.library.JSLibraryVersions;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.config.JSXNamespaceInfo;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.frameworks.jsx.JSXComponent;
import com.intellij.lang.javascript.frameworks.jsx.JSXImplementation;
import com.intellij.lang.javascript.frameworks.jsx.JSXXmlExtension;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXNamespaceReference;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXResolveUtil;
import com.intellij.lang.javascript.frameworks.jsx.tsx.TypeScriptJSXComponentUtil;
import com.intellij.lang.javascript.frameworks.jsx.tsx.TypeScriptJSXTagUtil;
import com.intellij.lang.javascript.frameworks.react.ReactUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSImportType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSQualifiedReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeWithDeclarations;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.imports.JSXNamespaceProvider;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.react.free.ReactComponent;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactJSXImplementation
implements JSXImplementation {
    @NotNull
    private static final List<JSXFramework> FRAMEWORKS = List.of(new JSXFramework("preact", "preact", "h"), new JSXFramework("solid-js", "solid-js", null));

    public ResolveResult @NotNull [] resolveTagOrComponent(@NotNull XmlTag context) {
        if (context == null) {
            ReactJSXImplementation.$$$reportNull$$$0(0);
        }
        if (JSXXmlExtension.hasQualifiedName((XmlTag)context)) {
            return ReactJSXImplementation.resolveQualifiedComponent(context);
        }
        return ReactJSXImplementation.resolveTopLevelTagOrComponent(context);
    }

    @NotNull
    public JSXComponent resolveComponent(@NotNull XmlTag context) {
        if (context == null) {
            ReactJSXImplementation.$$$reportNull$$$0(1);
        }
        JSXComponent jSXComponent = (JSXComponent)CachedValuesManager.getCachedValue((PsiElement)context, () -> CachedValueProvider.Result.create((Object)this.getComponentNoCache(context), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()}));
        if (jSXComponent == null) {
            ReactJSXImplementation.$$$reportNull$$$0(2);
        }
        return jSXComponent;
    }

    @NotNull
    public PsiElement getContext(@NotNull PsiElement localOrImported) {
        PsiElement context;
        if (localOrImported == null) {
            ReactJSXImplementation.$$$reportNull$$$0(3);
        }
        if (localOrImported instanceof JSImplicitElementImpl && (context = localOrImported.getContext()) instanceof JSCallExpression && ReactUtil.isReactComponentCall((JSExpression)((JSExpression)context))) {
            PsiElement psiElement = (PsiElement)ObjectUtils.coalesce((Object)context.getContext(), (Object)localOrImported);
            if (psiElement == null) {
                ReactJSXImplementation.$$$reportNull$$$0(4);
            }
            return psiElement;
        }
        PsiElement psiElement = localOrImported;
        if (psiElement == null) {
            ReactJSXImplementation.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    @NotNull
    public Set<VirtualFile> getLibraries() {
        Set set = JSCorePredefinedLibrariesProvider.getReactPredefinedLibraryFiles();
        if (set == null) {
            ReactJSXImplementation.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    public Collection<PsiElement> resolveCall(@NotNull JSCallExpression result) {
        if (result == null) {
            ReactJSXImplementation.$$$reportNull$$$0(7);
        }
        String componentName = ReactJSXImplementation.resolveCallComponentName(result);
        return ReactJSXImplementation.resolveCallExpressionForName(result, componentName);
    }

    public boolean isApplicable(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            ReactJSXImplementation.$$$reportNull$$$0(8);
        }
        return true;
    }

    @NotNull
    public JSType getJsxChildInstance(@NotNull PsiElement scopeElement, @NotNull String name) {
        if (scopeElement == null) {
            ReactJSXImplementation.$$$reportNull$$$0(9);
        }
        if (name == null) {
            ReactJSXImplementation.$$$reportNull$$$0(10);
        }
        return ReactJSXImplementation.withQualifier(this.createJsxSourceType(scopeElement), name);
    }

    @NotNull
    protected JSType createJsxSourceType(@NotNull PsiElement scope) {
        TypeScriptConfig config;
        JSType type;
        if (scope == null) {
            ReactJSXImplementation.$$$reportNull$$$0(11);
        }
        if (ReactJSXImplementation.isResolvedType(type = ReactJSXImplementation.createTypeForImportSource(scope, config = TypeScriptConfigUtil.getConfigForPsiFile((PsiFile)scope.getContainingFile())))) {
            JSType jSType = type;
            if (jSType == null) {
                ReactJSXImplementation.$$$reportNull$$$0(12);
            }
            return jSType;
        }
        type = ReactJSXImplementation.createTypeForJSXNamespace(scope);
        if (ReactJSXImplementation.isResolvedType(type)) {
            JSType jSType = type;
            if (jSType == null) {
                ReactJSXImplementation.$$$reportNull$$$0(13);
            }
            return jSType;
        }
        type = ReactJSXImplementation.createTypeForFrameworks(scope, config);
        if (ReactJSXImplementation.isResolvedType(type)) {
            JSType jSType = type;
            if (jSType == null) {
                ReactJSXImplementation.$$$reportNull$$$0(14);
            }
            return jSType;
        }
        type = JSNamedTypeFactory.createType((String)ReactJSXImplementation.getReactJSXNameSpace(scope), (JSTypeSource)JSTypeSourceFactory.createTypeSource((PsiElement)scope, (boolean)true), (JSTypeContext)JSTypeContext.STATIC);
        if (ReactJSXImplementation.isResolvedType(type)) {
            JSType jSType = type;
            if (jSType == null) {
                ReactJSXImplementation.$$$reportNull$$$0(15);
            }
            return jSType;
        }
        return this.createLibrarySourceType(scope);
    }

    @NotNull
    public JSXNamespaceInfo calcNamespaceInfo(@NotNull PsiElement context) {
        PsiFile file;
        if (context == null) {
            ReactJSXImplementation.$$$reportNull$$$0(16);
        }
        if ((file = context.getContainingFile()) == null) {
            return new JSXNamespaceInfo(null, null);
        }
        JSXNamespaceInfo jSXNamespaceInfo = (JSXNamespaceInfo)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            JSXFramework info;
            String fragment;
            ArrayList<Object> deps = new ArrayList<Object>();
            deps.add(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
            deps.add(file);
            deps.add(PackageJsonFileManager.getInstance((Project)file.getProject()).getModificationTracker());
            String flag = file instanceof JSFile ? (String)((JSFile)file).getPragmaFlags().get("@jsx") : null;
            String string = fragment = file instanceof JSFile ? (String)((JSFile)file).getPragmaFlags().get("@jsxFrag") : null;
            if (!StringUtil.isEmpty((String)flag)) {
                return CachedValueProvider.Result.create((Object)new JSXNamespaceInfo(flag, fragment), deps);
            }
            TypeScriptConfig config = TypeScriptConfigUtil.getConfigForPsiFile((PsiFile)file, (boolean)true);
            if (config != null) {
                deps.add(config.getConfigFile());
                fragment = fragment != null ? fragment : config.jsxFragmentFactory();
                String factory = config.jsxFactory();
                if (factory != null) {
                    String value = TypeScriptUtil.extractQualifierForJsxFactory((String)factory);
                    return CachedValueProvider.Result.create((Object)new JSXNamespaceInfo(value, fragment), deps);
                }
                String namespace = config.getRawCompilerOption("reactNamespace");
                if (!StringUtil.isEmpty((String)namespace)) {
                    return CachedValueProvider.Result.create((Object)new JSXNamespaceInfo(namespace, fragment), deps);
                }
            }
            if ((info = ReactJSXImplementation.findFrameworkPackage(file.getProject(), PsiUtilCore.getVirtualFile((PsiElement)file))) != null && info.namespaceName() != null) {
                return CachedValueProvider.Result.create((Object)new JSXNamespaceInfo(info.namespaceName(), fragment), deps);
            }
            return CachedValueProvider.Result.create((Object)new JSXNamespaceInfo(null, fragment), deps);
        });
        if (jSXNamespaceInfo == null) {
            ReactJSXImplementation.$$$reportNull$$$0(17);
        }
        return jSXNamespaceInfo;
    }

    public boolean isNamespaceImportRequired(@NotNull PsiElement context) {
        SemVer reactVersion;
        if (context == null) {
            ReactJSXImplementation.$$$reportNull$$$0(18);
        }
        return (reactVersion = JSLibraryVersions.getLibraryVersion((PsiElement)context, (String)"react")) == null || reactVersion.getMajor() <= 16;
    }

    @Nullable
    private static JSType createTypeForFrameworks(@NotNull PsiElement scope, @Nullable TypeScriptConfig config) {
        if (scope == null) {
            ReactJSXImplementation.$$$reportNull$$$0(19);
        }
        if (DialectDetector.isTypeScript((PsiElement)scope)) {
            return null;
        }
        Project project = scope.getProject();
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)scope.getContainingFile().getOriginalFile());
        if (file == null || config != null && config.jsxImportSource() != null) {
            return null;
        }
        JSXFramework info = ReactJSXImplementation.findFrameworkPackage(project, file);
        return info != null ? ReactJSXImplementation.buildImportTypeForSource("\"" + info.factoryPath() + "\"", scope) : null;
    }

    @Nullable
    private static JSXFramework findFrameworkPackage(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            ReactJSXImplementation.$$$reportNull$$$0(20);
        }
        if (file == null) {
            return null;
        }
        return (JSXFramework)PackageJsonUtil.processUpPackageJsonFilesAndFindFirst((Project)project, (VirtualFile)file, packageJson -> {
            PackageJsonData data = PackageJsonData.getOrCreate((VirtualFile)packageJson);
            for (JSXFramework info : FRAMEWORKS) {
                if (!data.isDependencyOfAnyType(info.dependency())) continue;
                return info;
            }
            return null;
        });
    }

    @Nullable
    private static JSType createTypeForImportSource(@NotNull PsiElement scope, @Nullable TypeScriptConfig config) {
        PsiFile file;
        String source;
        if (scope == null) {
            ReactJSXImplementation.$$$reportNull$$$0(21);
        }
        String string = source = (file = scope.getContainingFile()) instanceof JSFile ? (String)((JSFile)file).getPragmaFlags().get("@jsxImportSource") : null;
        if (source == null && config != null) {
            source = config.jsxImportSource();
        }
        if (source == null) {
            return null;
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)scope, (boolean)true);
        return new JSImportType("import('" + ReactJSXImplementation.getJSXRuntimeImport(source, config) + "').JSX", typeSource, JSTypeContext.STATIC);
    }

    @Nullable
    public static String resolveCallComponentName(@NotNull JSCallExpression result) {
        Map strings;
        JSElementIndexingData data;
        if (result == null) {
            ReactJSXImplementation.$$$reportNull$$$0(22);
        }
        if ((data = result.getIndexingData()) != null && (strings = data.getUserStrings()) != null) {
            return (String)strings.get("alt.default.name");
        }
        return null;
    }

    @NotNull
    public static Collection<PsiElement> resolveCallExpressionForName(@NotNull JSCallExpression result, String componentName) {
        if (result == null) {
            ReactJSXImplementation.$$$reportNull$$$0(23);
        }
        if (!StringUtil.isEmpty((String)componentName)) {
            PsiElement componentCandidate;
            PsiElement module = ES6PsiUtil.findExternalModule((PsiElement)result);
            if (module != null && (componentCandidate = JSStubBasedPsiTreeUtil.resolveLocally((String)componentName, (PsiElement)module)) != null) {
                List list = ContainerUtil.createMaybeSingletonList((Object)componentCandidate);
                if (list == null) {
                    ReactJSXImplementation.$$$reportNull$$$0(24);
                }
                return list;
            }
        } else if (result.getContext() instanceof ES6ExportDefaultAssignment) {
            List list = ContainerUtil.createMaybeSingletonList((Object)result);
            if (list == null) {
                ReactJSXImplementation.$$$reportNull$$$0(25);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            ReactJSXImplementation.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    private ReactComponent getComponentNoCache(@NotNull XmlTag context) {
        String name;
        if (context == null) {
            ReactJSXImplementation.$$$reportNull$$$0(27);
        }
        PsiReference reference = context.getReference();
        SmartList components = new SmartList();
        boolean isWeakResolve = false;
        boolean isResolvedComponent = true;
        JSElement firstComponent = null;
        if (reference != null) {
            PsiElement resolve = reference.resolve();
            Collection elements = JSXXmlExtension.expandElements((PsiElement)resolve, (boolean)false);
            for (PsiElement item : elements) {
                if (item instanceof JSCallExpression) {
                    isWeakResolve = true;
                    item = (PsiElement)ContainerUtil.getFirstItem(this.resolveCall((JSCallExpression)item));
                }
                if (ReactJSXImplementation.isRequireCall(item)) {
                    isResolvedComponent = false;
                    isWeakResolve = true;
                }
                if (item.getContext() instanceof ES6ExportDefaultAssignment) {
                    components.add((JSElement)item);
                }
                if (!(item instanceof JSQualifiedNamedElement) && !(item instanceof JSImplicitElement)) continue;
                firstComponent = firstComponent == null ? (JSElement)item : firstComponent;
                components.add((JSElement)item);
            }
        }
        if (firstComponent != null && firstComponent.getName() != null) {
            name = firstComponent.getName();
        } else {
            name = context.getName();
            isResolvedComponent = false;
            isWeakResolve = true;
        }
        String namespace = name + ".props";
        return new ReactComponent(context, (Collection<? extends PsiElement>)components, namespace, isWeakResolve, isResolvedComponent);
    }

    @Nullable
    private static JSType createTypeForJSXNamespace(@NotNull PsiElement scope) {
        if (scope == null) {
            ReactJSXImplementation.$$$reportNull$$$0(28);
        }
        JSXNamespaceInfo info = JSXNamespaceProvider.getDefaultNamespace((PsiElement)scope);
        String namespace = info.jsxFactory;
        String fragment = info.fragmentFactory;
        PsiElement element = null;
        if (namespace != null) {
            element = JSStubBasedPsiTreeUtil.resolveLocally((String)TypeScriptUtil.extractQualifierForJsxFactory((String)namespace), (PsiElement)scope);
        }
        if (element == null && fragment != null) {
            element = JSStubBasedPsiTreeUtil.resolveLocally((String)TypeScriptUtil.extractQualifierForJsxFactory((String)fragment), (PsiElement)scope);
        }
        if (!(element instanceof ES6ImportExportDeclarationPart)) {
            return null;
        }
        ES6ImportExportDeclaration declaration = ((ES6ImportExportDeclarationPart)element).getDeclaration();
        if (declaration == null) {
            return null;
        }
        ES6FromClause clause = declaration.getFromClause();
        if (clause == null) {
            return null;
        }
        return ReactJSXImplementation.buildImportTypeForSource(clause.getReferenceText(), scope);
    }

    @Nullable
    private static JSImportType buildImportTypeForSource(@Nullable String text, @NotNull PsiElement scope) {
        if (scope == null) {
            ReactJSXImplementation.$$$reportNull$$$0(29);
        }
        if (text == null) {
            return null;
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)scope, (boolean)true);
        return new JSImportType("import(" + text + ").JSX", typeSource, JSTypeContext.STATIC);
    }

    private static String getJSXRuntimeImport(@NotNull String source, @Nullable TypeScriptConfig config) {
        if (source == null) {
            ReactJSXImplementation.$$$reportNull$$$0(30);
        }
        boolean isDev = config != null && Objects.equals(config.jsx(), "react-jsxdev");
        return StringUtil.unquoteString((String)source) + "/" + (isDev ? "jsx-dev-runtime" : "jsx-runtime");
    }

    private static boolean isRequireCall(@Nullable PsiElement item) {
        if (!(item instanceof JSVariable)) {
            return false;
        }
        JSExpression initializer = ((JSVariable)item).getInitializerOrStub();
        return initializer instanceof JSCallExpression && ((JSCallExpression)initializer).isRequireCall();
    }

    @NotNull
    private JSType createLibrarySourceType(@NotNull PsiElement scopeElement) {
        if (scopeElement == null) {
            ReactJSXImplementation.$$$reportNull$$$0(31);
        }
        Project project = scopeElement.getProject();
        ArrayList psiElements = new ArrayList(JSClassResolver.getInstance().findElementsByQName("JSX", GlobalSearchScope.filesScope((Project)project, this.getLibraries()), project));
        for (PsiElement element : psiElements) {
            if (!(element instanceof TypeScriptModule)) continue;
            JSType jSType = JSNamedTypeFactory.createType((String)"JSX", (JSTypeSource)JSTypeSourceFactory.createTypeSource((PsiElement)element.getContainingFile(), (boolean)true), (JSTypeContext)JSTypeContext.STATIC);
            if (jSType == null) {
                ReactJSXImplementation.$$$reportNull$$$0(32);
            }
            return jSType;
        }
        return new JSRecordTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)scopeElement, (boolean)true), Collections.emptyList());
    }

    @NotNull
    public static JSType withQualifier(@NotNull JSType qualifier, @NotNull String referenceName) {
        if (qualifier == null) {
            ReactJSXImplementation.$$$reportNull$$$0(33);
        }
        if (referenceName == null) {
            ReactJSXImplementation.$$$reportNull$$$0(34);
        }
        if (qualifier instanceof JSImportType) {
            return new JSImportType(((JSImportType)qualifier).getSimpleText() + "." + referenceName, qualifier.getSource(), JSTypeContext.INSTANCE);
        }
        if (qualifier instanceof JSTypeImpl) {
            JSType jSType = JSNamedTypeFactory.createType((String)(qualifier.getTypeText() + "." + referenceName), (JSTypeSource)qualifier.getSource(), (JSTypeContext)JSTypeContext.INSTANCE);
            if (jSType == null) {
                ReactJSXImplementation.$$$reportNull$$$0(35);
            }
            return jSType;
        }
        return new JSQualifiedReferenceType(referenceName, qualifier, qualifier.getSource());
    }

    private static boolean isResolvedType(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof JSTypeWithDeclarations) {
            Collection declarations = ((JSTypeWithDeclarations)type).getDeclarations();
            return !declarations.isEmpty();
        }
        JSRecordType recordType = type.asRecordType();
        return recordType.hasMembers();
    }

    public static ResolveResult @NotNull [] resolveQualifiedComponent(@NotNull XmlTag tag) {
        JSXNamespaceReference parentRef;
        if (tag == null) {
            ReactJSXImplementation.$$$reportNull$$$0(36);
        }
        if ((parentRef = JSXXmlExtension.getQualifierReference((XmlTag)tag)) == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ReactJSXImplementation.$$$reportNull$$$0(37);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        String localName = tag.getLocalName();
        Collection elements = JSXResolveUtil.expandReferenceElements((PsiElement)tag, (JSXNamespaceReference)parentRef);
        if (elements.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ReactJSXImplementation.$$$reportNull$$$0(38);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] results = JSXResolveUtil.resolveNestedName((PsiElement)tag, (String)localName, (Collection)elements, (JSXNamespaceReference)parentRef);
        if (results.length == 0 && !DialectDetector.isTypeScript((PsiElement)tag)) {
            results = ReactJSXImplementation.resolveComponentForIndexes(tag, tag.getName());
        }
        return ReactJSXImplementation.resolveComponentNameForCandidates(tag, results);
    }

    public static ResolveResult @NotNull [] resolveTopLevelTagOrComponent(@NotNull XmlTag tag) {
        String tagName;
        boolean isComponentName;
        if (tag == null) {
            ReactJSXImplementation.$$$reportNull$$$0(39);
        }
        if (!(isComponentName = JSXResolveUtil.isComponentName((String)(tagName = tag.getName())))) {
            JSRecordType.PropertySignature element = TypeScriptJSXTagUtil.resolveTag((XmlTag)tag);
            ResolveResult[] resolveResultArray = JSResolveResult.toResolveResults((Collection)ContainerUtil.createMaybeSingletonList(element != null ? element.getMemberSource().getSingleElement() : null));
            if (resolveResultArray == null) {
                ReactJSXImplementation.$$$reportNull$$$0(40);
            }
            return resolveResultArray;
        }
        ResolveResult[] results = JSXResolveUtil.resolveTopLevelName((PsiElement)tag, (String)tagName);
        return ReactJSXImplementation.resolveComponentNameForCandidates(tag, results);
    }

    private static ResolveResult @NotNull [] resolveComponentForIndexes(@NotNull XmlTag tag, @NotNull String qualifiedName) {
        GlobalSearchScope scope;
        if (tag == null) {
            ReactJSXImplementation.$$$reportNull$$$0(41);
        }
        if (qualifiedName == null) {
            ReactJSXImplementation.$$$reportNull$$$0(42);
        }
        if ((scope = JSXXmlExtension.getResolveScopeForIndexProcessing((XmlTag)tag, (boolean)JSXXmlExtension.hasQualifiedName((XmlTag)tag))) == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ReactJSXImplementation.$$$reportNull$$$0(43);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        JSClassResolver.getInstance().processElementsByQNameIncludingImplicit(qualifiedName, scope, JSClassResolver.IncludeLocalMembersOptions.ALL, (Processor)processor);
        ResolveResult[] resolveResultArray = JSResolveResult.toResolveResults((Collection)processor.getResults());
        if (resolveResultArray == null) {
            ReactJSXImplementation.$$$reportNull$$$0(44);
        }
        return resolveResultArray;
    }

    private static ResolveResult @NotNull [] resolveComponentNameForCandidates(@NotNull XmlTag tag, ResolveResult @NotNull [] candidates) {
        if (tag == null) {
            ReactJSXImplementation.$$$reportNull$$$0(45);
        }
        if (candidates == null) {
            ReactJSXImplementation.$$$reportNull$$$0(46);
        }
        if (candidates.length == 0) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ReactJSXImplementation.$$$reportNull$$$0(47);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        HashSet<Object> visitedOverloadImplementations = new HashSet<Object>();
        ArrayList<ResolveResult> elements = new ArrayList<ResolveResult>();
        for (ResolveResult resolveResult : candidates) {
            PsiElement localOrImported = resolveResult.getElement();
            if (localOrImported instanceof TypeScriptCompileTimeType || localOrImported == null) continue;
            if ((localOrImported = JSXImplementation.getContextElement((PsiElement)localOrImported)) instanceof TypeScriptFunction) {
                if (((TypeScriptFunction)localOrImported).isOverloadDeclaration()) {
                    TypeScriptFunction implementation = TypeScriptPsiUtil.getOverloadImplementation((TypeScriptFunction)((TypeScriptFunction)localOrImported));
                    Object object = localOrImported = implementation == null ? localOrImported : implementation;
                    if (implementation != null && !visitedOverloadImplementations.add(implementation)) {
                        continue;
                    }
                } else if (((TypeScriptFunction)localOrImported).isOverloadImplementation() && !visitedOverloadImplementations.add(localOrImported)) continue;
            }
            PsiElement finalElement = localOrImported;
            elements.add(JSResolveResult.transformElement(el -> ReactJSXImplementation.resolveOverload(finalElement, tag), (ResolveResult)resolveResult));
        }
        ResolveResult[] resolveResultArray = elements.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            ReactJSXImplementation.$$$reportNull$$$0(48);
        }
        return resolveResultArray;
    }

    @NotNull
    private static PsiElement resolveOverload(@NotNull PsiElement candidate, @NotNull XmlTag tag) {
        PsiElement signatureElement;
        JSRecordTypeImpl recordType;
        JSResolveResult signature;
        if (candidate == null) {
            ReactJSXImplementation.$$$reportNull$$$0(49);
        }
        if (tag == null) {
            ReactJSXImplementation.$$$reportNull$$$0(50);
        }
        if (candidate instanceof TypeScriptFunction && ((TypeScriptFunction)candidate).isOverloadImplementation() && (signature = (JSResolveResult)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)tag, () -> ReactJSXImplementation.lambda$resolveOverload$4(candidate, recordType = TypeScriptJSXComponentUtil.createRecordTypeFromTag((XmlTag)tag, (PsiElement)candidate)))).isValidResult() && (signatureElement = signature.getElement()) != null) {
            PsiElement psiElement = signatureElement;
            if (psiElement == null) {
                ReactJSXImplementation.$$$reportNull$$$0(51);
            }
            return psiElement;
        }
        PsiElement psiElement = candidate;
        if (psiElement == null) {
            ReactJSXImplementation.$$$reportNull$$$0(52);
        }
        return psiElement;
    }

    @NotNull
    private static String getReactJSXNameSpace(PsiElement scope) {
        SemVer reactVersion = JSLibraryVersions.getLibraryVersion((PsiElement)scope, (String)"react");
        return reactVersion != null && reactVersion.getMajor() >= 19 ? "React.JSX" : "JSX";
    }

    private static /* synthetic */ JSResolveResult lambda$resolveOverload$4(PsiElement candidate, JSRecordTypeImpl recordType) {
        return TypeScriptSignatureChooser.getOverloadSignatureForImplementation((PsiElement)candidate, (List)ContainerUtil.createMaybeSingletonList((Object)recordType));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6, 12, 13, 14, 15, 17, 24, 25, 26, 32, 35, 37, 38, 40, 43, 44, 47, 48, 51, 52 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 24: 
            case 25: 
            case 26: 
            case 32: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/react/free/ReactJSXImplementation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localOrImported";
                break;
            }
            case 7: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 9: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 19: 
            case 21: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 36: 
            case 39: 
            case 41: 
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/react/free/ReactJSXImplementation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveComponent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createJsxSourceType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "calcNamespaceInfo";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveCallExpressionForName";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibrarySourceType";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "withQualifier";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveQualifiedComponent";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTopLevelTagOrComponent";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveComponentForIndexes";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveComponentNameForCandidates";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveOverload";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveTagOrComponent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveComponent";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 24: 
            case 25: 
            case 26: 
            case 32: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 51: 
            case 52: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveCall";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getJsxChildInstance";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createJsxSourceType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calcNamespaceInfo";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isNamespaceImportRequired";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createTypeForFrameworks";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findFrameworkPackage";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createTypeForImportSource";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveCallComponentName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveCallExpressionForName";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getComponentNoCache";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createTypeForJSXNamespace";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "buildImportTypeForSource";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getJSXRuntimeImport";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createLibrarySourceType";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "withQualifier";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "resolveQualifiedComponent";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "resolveTopLevelTagOrComponent";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "resolveComponentForIndexes";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "resolveComponentNameForCandidates";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "resolveOverload";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 12, 13, 14, 15, 17, 24, 25, 26, 32, 35, 37, 38, 40, 43, 44, 47, 48, 51, 52 -> new IllegalStateException(string);
        };
    }

    record JSXFramework(@NotNull String dependency, @NotNull String factoryPath, @Nullable String namespaceName) {
        @NotNull
        private final String dependency;
        @NotNull
        private final String factoryPath;

        JSXFramework(@NotNull String dependency, @NotNull String factoryPath, @Nullable String namespaceName) {
            if (dependency == null) {
                JSXFramework.$$$reportNull$$$0(0);
            }
            if (factoryPath == null) {
                JSXFramework.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public String dependency() {
            String string = this.dependency;
            if (string == null) {
                JSXFramework.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String factoryPath() {
            String string = this.factoryPath;
            if (string == null) {
                JSXFramework.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependency";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factoryPath";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/react/free/ReactJSXImplementation$JSXFramework";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/react/free/ReactJSXImplementation$JSXFramework";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "dependency";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "factoryPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

