/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.loops.IndexedGetHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.InitializerCallReplacer;
import org.jetbrains.kotlin.backend.common.lower.loops.JavaLikeCounterLoopBuilder;
import org.jetbrains.kotlin.backend.common.lower.loops.LoopReplacement;
import org.jetbrains.kotlin.backend.common.lower.loops.NumericForLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.NumericHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.handlers.IndexedGetIterationHandler;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrWhileLoopImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJF\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u00172\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/IndexedGetLoopHeader;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/NumericForLoopHeader;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/IndexedGetHeaderInfo;", "headerInfo", "builder", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/loops/IndexedGetHeaderInfo;Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "preferJavaLikeCounterLoop", "", "javaLikeCounterLoopBuilder", "Lorg/jetbrains/kotlin/backend/common/lower/loops/JavaLikeCounterLoopBuilder;", "loopInitStatements", "", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "getLoopInitStatements", "()Ljava/util/List;", "initializeIteration", "Lorg/jetbrains/kotlin/ir/IrStatement;", "loopVariables", "loopVariableComponents", "", "", "backendContext", "buildLoop", "Lorg/jetbrains/kotlin/backend/common/lower/loops/LoopReplacement;", "oldLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "newBody", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nIndexedGetLoopHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexedGetLoopHeader.kt\norg/jetbrains/kotlin/backend/common/lower/loops/IndexedGetLoopHeader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1#2:81\n1915#3,2:82\n*S KotlinDebug\n*F\n+ 1 IndexedGetLoopHeader.kt\norg/jetbrains/kotlin/backend/common/lower/loops/IndexedGetLoopHeader\n*L\n52#1:82,2\n*E\n"})
public final class IndexedGetLoopHeader
extends NumericForLoopHeader<IndexedGetHeaderInfo> {
    private final boolean preferJavaLikeCounterLoop;
    @NotNull
    private final JavaLikeCounterLoopBuilder javaLikeCounterLoopBuilder;
    @NotNull
    private final List<IrVariable> loopInitStatements;

    public IndexedGetLoopHeader(@NotNull IndexedGetHeaderInfo headerInfo, @NotNull DeclarationIrBuilder builder2, @NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)headerInfo, (String)"headerInfo");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super((NumericHeaderInfo)headerInfo, builder2, context2);
        this.preferJavaLikeCounterLoop = context2.getPreferJavaLikeCounterLoop();
        this.javaLikeCounterLoopBuilder = new JavaLikeCounterLoopBuilder(context2);
        Object[] objectArray = new IrVariable[]{headerInfo.getObjectVariable(), this.getInductionVariable(), this.getLastVariableIfCanCacheLast(), this.getStepVariable()};
        this.loopInitStatements = CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @NotNull
    public List<IrVariable> getLoopInitStatements() {
        return this.loopInitStatements;
    }

    @Override
    @NotNull
    public List<IrStatement> initializeIteration(@NotNull List<? extends IrVariable> loopVariables, @NotNull Map<Integer, ? extends List<? extends IrVariable>> loopVariableComponents, @NotNull DeclarationIrBuilder builder2, @NotNull CommonBackendContext backendContext) {
        Collection collection;
        Intrinsics.checkNotNullParameter(loopVariables, (String)"loopVariables");
        Intrinsics.checkNotNullParameter(loopVariableComponents, (String)"loopVariableComponents");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        DeclarationIrBuilder $this$initializeIteration_u24lambda_u240 = builder2;
        boolean bl = false;
        Object $this$initializeIteration_u24lambda_u240_u240 = ((IndexedGetHeaderInfo)this.getHeaderInfo()).getExpressionHandler();
        boolean bl2 = false;
        IrSimpleFunction indexedGetFun = ((IndexedGetIterationHandler)$this$initializeIteration_u24lambda_u240_u240).getGetFunction(((IndexedGetHeaderInfo)this.getHeaderInfo()).getObjectVariable().getType());
        Object $this$initializeIteration_u24lambda_u240_u241 = $this$initializeIteration_u24lambda_u240_u240 = ExpressionHelpersKt.irCall$default($this$initializeIteration_u24lambda_u240, indexedGetFun.getSymbol(), indexedGetFun.getReturnType(), 0, null, 12, null);
        boolean bl3 = false;
        ((IrMemberAccessExpression)$this$initializeIteration_u24lambda_u240_u241).getArguments().set(0, ExpressionHelpersKt.irGet($this$initializeIteration_u24lambda_u240, ((IndexedGetHeaderInfo)this.getHeaderInfo()).getObjectVariable()));
        ((IrMemberAccessExpression)$this$initializeIteration_u24lambda_u240_u241).getArguments().set(1, ExpressionHelpersKt.irGet($this$initializeIteration_u24lambda_u240, this.getInductionVariable()));
        IrExpression irExpression = (IrExpression)$this$initializeIteration_u24lambda_u240_u240;
        IrAnnotationContainer irAnnotationContainer = (IrVariable)CollectionsKt.firstOrNull(loopVariables);
        if (irAnnotationContainer == null || (irAnnotationContainer = irAnnotationContainer.getType()) == null) {
            irAnnotationContainer = indexedGetFun.getReturnType();
        }
        IrExpression get = IrUtilsKt.implicitCastIfNeededTo(irExpression, (IrType)irAnnotationContainer);
        IrVariable irVariable = (IrVariable)CollectionsKt.firstOrNull(loopVariables);
        if (irVariable != null) {
            IrVariable it = irVariable;
            boolean bl4 = false;
            IrExpression irExpression2 = it.getInitializer();
            it.setInitializer((IrExpression)(irExpression2 != null ? irExpression2.transform((IrTransformer)new InitializerCallReplacer(get), (Object)null) : null));
        }
        Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)loopVariables, (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrVariable it = (IrVariable)element$iv;
            boolean bl5 = false;
            it.setInitializer(ExpressionHelpersKt.irGet($this$initializeIteration_u24lambda_u240, (IrValueDeclaration)CollectionsKt.first(loopVariables)));
        }
        Collection collection2 = loopVariables;
        if (collection2.isEmpty()) {
            boolean bl6 = false;
            collection = CollectionsKt.listOf((Object)get);
        } else {
            collection = collection2;
        }
        return CollectionsKt.plus((Collection)collection, (Object)this.incrementInductionVariable($this$initializeIteration_u24lambda_u240));
    }

    @Override
    @NotNull
    public LoopReplacement buildLoop(@NotNull DeclarationIrBuilder builder2, @NotNull IrLoop oldLoop, @Nullable IrExpression newBody) {
        LoopReplacement loopReplacement;
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)oldLoop, (String)"oldLoop");
        DeclarationIrBuilder $this$buildLoop_u24lambda_u240 = builder2;
        boolean bl = false;
        IrExpression newLoopCondition = this.buildLoopCondition($this$buildLoop_u24lambda_u240);
        if (this.preferJavaLikeCounterLoop) {
            loopReplacement = this.javaLikeCounterLoopBuilder.buildJavaLikeDoWhileCounterLoop(oldLoop, newLoopCondition, newBody, null);
        } else {
            IrWhileLoopImpl irWhileLoopImpl;
            IrWhileLoopImpl $this$buildLoop_u24lambda_u240_u240 = irWhileLoopImpl = BuildersKt.IrWhileLoopImpl(oldLoop.getStartOffset(), oldLoop.getEndOffset(), oldLoop.getType(), oldLoop.getOrigin());
            boolean bl2 = false;
            $this$buildLoop_u24lambda_u240_u240.setLabel(oldLoop.getLabel());
            $this$buildLoop_u24lambda_u240_u240.setCondition(newLoopCondition);
            $this$buildLoop_u24lambda_u240_u240.setBody(newBody);
            IrWhileLoopImpl newLoop = irWhileLoopImpl;
            loopReplacement = new LoopReplacement(newLoop, newLoop);
        }
        return loopReplacement;
    }
}

