/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB#\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0014J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J$\u0010\u0013\u001a\u0004\u0018\u00010\u00122\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/intellij/vcs/log/ui/filter/TextFilterModel;", "Lcom/intellij/vcs/log/ui/filter/FilterModel$MultipleFilterModel;", "properties", "Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;Lcom/intellij/vcs/log/VcsLogFilterCollection;Lcom/intellij/openapi/Disposable;)V", "getFilterFromProperties", "text", "", "getText", "()Ljava/lang/String;", "getFilterValues", "", "filter", "Lcom/intellij/vcs/log/VcsLogFilter;", "createFilter", "key", "Lcom/intellij/vcs/log/VcsLogFilterCollection$FilterKey;", "values", "createTextFilter", "Lcom/intellij/vcs/log/VcsLogTextFilter;", "setFilterText", "", "Companion", "intellij.platform.vcs.log.impl"})
public final class TextFilterModel
extends FilterModel.MultipleFilterModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public TextFilterModel(@NotNull MainVcsLogUiProperties properties, @Nullable VcsLogFilterCollection filters, @NotNull Disposable parentDisposable) {
        VcsLogTextFilter textFilter;
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Object[] objectArray = new VcsLogFilterCollection.FilterKey[]{VcsLogFilterCollection.TEXT_FILTER, VcsLogFilterCollection.HASH_FILTER};
        super(CollectionsKt.listOf((Object[])objectArray), properties, filters);
        if (filters != null && (textFilter = (VcsLogTextFilter)filters.get(VcsLogFilterCollection.TEXT_FILTER)) != null) {
            VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty = MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE;
            Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty, (String)"TEXT_FILTER_MATCH_CASE");
            this.uiProperties.set(vcsLogUiProperty, textFilter.matchesCase());
            VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty2 = MainVcsLogUiProperties.TEXT_FILTER_REGEX;
            Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty2, (String)"TEXT_FILTER_REGEX");
            this.uiProperties.set(vcsLogUiProperty2, textFilter.isRegex());
        }
        VcsLogUiProperties.PropertiesChangeListener listener2 = new VcsLogUiProperties.PropertiesChangeListener(this){
            final /* synthetic */ TextFilterModel this$0;
            {
                this.this$0 = $receiver;
            }

            public <T> void onPropertyChanged(VcsLogUiProperties.VcsLogUiProperty<T> property) {
                Intrinsics.checkNotNullParameter(property, (String)"property");
                if (Intrinsics.areEqual(MainVcsLogUiProperties.TEXT_FILTER_REGEX, property) || Intrinsics.areEqual(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE, property)) {
                    VcsLogFilterCollection.FilterKey filterKey = VcsLogFilterCollection.TEXT_FILTER;
                    Intrinsics.checkNotNullExpressionValue((Object)filterKey, (String)"TEXT_FILTER");
                    if (this.this$0.getFilter(filterKey) != null) {
                        this.this$0._filter = this.this$0.getFilterFromProperties();
                        this.this$0.notifyFiltersChanged();
                    }
                }
            }
        };
        properties.addChangeListener(listener2, parentDisposable);
    }

    @Override
    @Nullable
    protected VcsLogFilterCollection getFilterFromProperties() {
        VcsLogFilterCollection filterCollection = super.getFilterFromProperties();
        if (filterCollection == null) {
            return null;
        }
        VcsLogTextFilter textFilter = (VcsLogTextFilter)filterCollection.get(VcsLogFilterCollection.TEXT_FILTER);
        VcsLogHashFilter hashFilter = (VcsLogHashFilter)filterCollection.get(VcsLogFilterCollection.HASH_FILTER);
        if (textFilter != null) {
            String string = textFilter.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.isBlank((CharSequence)string)) {
                LOG.warn("Saved text filter is empty. Removing.");
                textFilter = null;
            }
        }
        if (textFilter != null) {
            String string = textFilter.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            VcsLogHashFilter hashFilterFromText = VcsLogFilterObject.fromHash(string);
            if (!Intrinsics.areEqual((Object)hashFilter, (Object)hashFilterFromText)) {
                LOG.warn("Saved hash filter " + hashFilter + " is inconsistent with text filter. Replacing with " + hashFilterFromText);
                hashFilter = hashFilterFromText;
            }
        } else if (hashFilter != null && !hashFilter.getHashes().isEmpty()) {
            String string = StringUtil.join((Collection)hashFilter.getHashes(), (String)" ");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
            textFilter = this.createTextFilter(string);
            LOG.warn("Saved hash filter " + hashFilter + " is inconsistent with empty text filter. Using text filter " + textFilter);
        }
        VcsLogFilter[] vcsLogFilterArray = new VcsLogFilter[]{textFilter, hashFilter};
        return VcsLogFilterObject.collection(vcsLogFilterArray);
    }

    @NotNull
    public final String getText() {
        VcsLogFilterCollection.FilterKey filterKey = VcsLogFilterCollection.TEXT_FILTER;
        Intrinsics.checkNotNullExpressionValue((Object)filterKey, (String)"TEXT_FILTER");
        Object object = (VcsLogTextFilter)this.getFilter(filterKey);
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        return object;
    }

    @Override
    @Nullable
    protected List<String> getFilterValues(@NotNull VcsLogFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        VcsLogFilter vcsLogFilter = filter;
        return vcsLogFilter instanceof VcsLogTextFilter ? CollectionsKt.listOf((Object)((VcsLogTextFilter)filter).getText()) : (vcsLogFilter instanceof VcsLogHashFilter ? (List)new ArrayList(((VcsLogHashFilter)filter).getHashes()) : null);
    }

    @Override
    @Nullable
    protected VcsLogFilter createFilter(@NotNull VcsLogFilterCollection.FilterKey<?> key, @NotNull List<String> values) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        VcsLogFilterCollection.FilterKey<?> filterKey = key;
        return Intrinsics.areEqual(filterKey, (Object)VcsLogFilterCollection.TEXT_FILTER) ? (VcsLogFilter)this.createTextFilter((String)CollectionsKt.first(values)) : (Intrinsics.areEqual(filterKey, (Object)VcsLogFilterCollection.HASH_FILTER) ? (VcsLogFilter)VcsLogFilterObject.fromHashes((Collection<String>)values) : null);
    }

    private final VcsLogTextFilter createTextFilter(String text) {
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty = MainVcsLogUiProperties.TEXT_FILTER_REGEX;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty, (String)"TEXT_FILTER_REGEX");
        Boolean bl = this.uiProperties.get(vcsLogUiProperty);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        boolean bl2 = bl;
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty2 = MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty2, (String)"TEXT_FILTER_MATCH_CASE");
        Boolean bl3 = this.uiProperties.get(vcsLogUiProperty2);
        Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"get(...)");
        return VcsLogFilterObject.fromPattern(text, bl2, bl3);
    }

    public final void setFilterText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (StringsKt.isBlank((CharSequence)text)) {
            this.setFilter(null);
        } else {
            VcsLogFilter[] vcsLogFilterArray = new VcsLogFilter[]{this.createTextFilter(text), VcsLogFilterObject.fromHash(text)};
            this.setFilter(VcsLogFilterObject.collection(vcsLogFilterArray));
        }
    }

    static {
        Logger logger = Logger.getInstance(TextFilterModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/vcs/log/ui/filter/TextFilterModel$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

