/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.net.ssl.CertificateWrapper;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CertificateInfoPanel
extends JPanel {
    private static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(3);
    private final CertificateWrapper myCertificateWrapper;

    public CertificateInfoPanel(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            CertificateInfoPanel.$$$reportNull$$$0(0);
        }
        this.myCertificateWrapper = new CertificateWrapper(certificate);
        this.setLayout(new BorderLayout());
        FormBuilder builder = FormBuilder.createFormBuilder();
        CertificateInfoPanel.updateBuilderWithTitle(builder, IdeBundle.message("section.title.issued.to", new Object[0]));
        CertificateInfoPanel.updateBuilderWithPrincipalData(builder, this.myCertificateWrapper.getSubjectFields());
        CertificateInfoPanel.updateBuilderWithTitle(builder, IdeBundle.message("section.title.issued.by", new Object[0]));
        CertificateInfoPanel.updateBuilderWithPrincipalData(builder, this.myCertificateWrapper.getIssuerFields());
        CertificateInfoPanel.updateBuilderWithTitle(builder, IdeBundle.message("section.title.validity.period", new Object[0]));
        String notBefore = DATE_FORMAT.format(this.myCertificateWrapper.getNotBefore());
        String notAfter = DATE_FORMAT.format(this.myCertificateWrapper.getNotAfter());
        builder = builder.setFormLeftIndent(20).addLabeledComponent(IdeBundle.message("label.valid.from", new Object[0]), CertificateInfoPanel.createColoredComponent(notBefore, IdeBundle.message("label.certificate.not.yet.valid", new Object[0]), this.myCertificateWrapper.isNotYetValid())).addLabeledComponent(IdeBundle.message("label.valid.until", new Object[0]), CertificateInfoPanel.createColoredComponent(notAfter, IdeBundle.message("label.certificate.expired", new Object[0]), this.myCertificateWrapper.isExpired()));
        builder.setFormLeftIndent(0);
        CertificateInfoPanel.updateBuilderWithTitle(builder, IdeBundle.message("section.title.fingerprints", new Object[0]));
        builder.setFormLeftIndent(20);
        builder.addLabeledComponent("SHA-256:", CertificateInfoPanel.getTextPane(CertificateInfoPanel.formatHex(this.myCertificateWrapper.getSha256Fingerprint(), true)));
        builder.addLabeledComponent("SHA-1:", CertificateInfoPanel.getTextPane(CertificateInfoPanel.formatHex(this.myCertificateWrapper.getSha1Fingerprint(), true)));
        this.add((Component)builder.getPanel(), "North");
    }

    @NotNull
    @NlsSafe
    public static String formatHex(@NotNull String hex, boolean split) {
        if (hex == null) {
            CertificateInfoPanel.$$$reportNull$$$0(1);
        }
        if ("N/A".equals(hex)) {
            String string = hex;
            if (string == null) {
                CertificateInfoPanel.$$$reportNull$$$0(2);
            }
            return string;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < hex.length(); i += 2) {
            if (split && i == 32) {
                builder.append('\n');
            }
            builder.append(hex, i, i + 2);
            builder.append(' ');
        }
        if (!hex.isEmpty()) {
            builder.deleteCharAt(builder.length() - 1);
        }
        String string = StringUtil.toUpperCase((String)builder.toString());
        if (string == null) {
            CertificateInfoPanel.$$$reportNull$$$0(3);
        }
        return string;
    }

    public X509Certificate getCertificate() {
        return this.myCertificateWrapper.getCertificate();
    }

    private static void updateBuilderWithPrincipalData(FormBuilder builder, Map<String, @NlsSafe String> fields) {
        builder = builder.setFormLeftIndent(20);
        for (CertificateWrapper.CommonField field : CertificateWrapper.CommonField.values()) {
            String value2 = fields.get(field.getShortName());
            if (value2 == null) continue;
            String label2 = new HtmlBuilder().append(field.getShortName()).append(" (").append((HtmlChunk)HtmlChunk.text((String)field.getLongName()).bold()).append(")").wrapWith("html").toString();
            builder = builder.addLabeledComponent(label2, (JComponent)new JBLabel(value2));
        }
        builder.setFormLeftIndent(0);
    }

    private static void updateBuilderWithTitle(FormBuilder builder, @Nls String title) {
        builder.addComponent(new TitledSeparator(title), 7);
    }

    private static JComponent getTextPane(@Nls String text) {
        JTextPane pane = new JTextPane();
        pane.setOpaque(false);
        pane.setEditable(false);
        pane.setContentType("text/plain");
        pane.setText(text);
        return pane;
    }

    private static JComponent createColoredComponent(@NlsContexts.Label String mainText, @Nls String errorText, boolean hasError) {
        SimpleColoredComponent component = new SimpleColoredComponent();
        if (hasError) {
            component.append(mainText + " (" + errorText + ")", new SimpleTextAttributes(0, (Color)JBColor.RED));
        } else {
            component.append(mainText);
        }
        return component;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certificate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hex";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/net/ssl/CertificateInfoPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/net/ssl/CertificateInfoPanel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "formatHex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "formatHex";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

