/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.config.viewresolver;

import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.mvc.config.viewresolver.TemplateAvailabilityProvider;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class FreemarkerTemplateAvailabilityProvider
extends TemplateAvailabilityProvider {
    FreemarkerTemplateAvailabilityProvider() {
    }

    @Override
    public boolean isTemplateAvailable(ConditionalOnEvaluationContext context, String viewName) {
        if (SpringCommonUtils.findLibraryClass((Module)context.getModule(), (String)"freemarker.template.Configuration") == null) {
            return false;
        }
        String prefix = StringUtil.notNullize((String)FreemarkerTemplateAvailabilityProvider.getConfigurationOrDefaultValue(context, "spring.freemarker.prefix"), (String)"");
        String suffix = StringUtil.notNullize((String)FreemarkerTemplateAvailabilityProvider.getConfigurationOrDefaultValue(context, "spring.freemarker.suffix"), (String)".ftlh");
        for (String templateLoaderPath : FreemarkerTemplateAvailabilityProvider.getTemplateLoaderPaths(context)) {
            if (!FreemarkerTemplateAvailabilityProvider.isResourceAvailable(context, StringUtil.trim((String)templateLoaderPath) + prefix + viewName + suffix)) continue;
            return true;
        }
        return false;
    }

    private static List<String> getTemplateLoaderPaths(ConditionalOnEvaluationContext context) {
        MetaConfigKey configKey = FreemarkerTemplateAvailabilityProvider.findConfigurationKey(context, "spring.freemarker.template-loader-path");
        if (configKey == null) {
            return Collections.emptyList();
        }
        SmartList valueTexts = new SmartList();
        Processor processor = arg_0 -> FreemarkerTemplateAvailabilityProvider.lambda$getTemplateLoaderPaths$0((List)valueTexts, arg_0);
        context.processConfigurationValues(processor, true, configKey);
        if (valueTexts.isEmpty()) {
            ContainerUtil.addIfNotNull((Collection)valueTexts, (Object)configKey.getDefaultValue());
        }
        SmartList clean = new SmartList();
        for (String value : valueTexts) {
            value = value.replace('[', ' ').replace(']', ' ').replace('\"', ' ');
            clean.addAll(StringUtil.split((String)value, (String)","));
        }
        return clean;
    }

    private static /* synthetic */ boolean lambda$getTemplateLoaderPaths$0(List valueTexts, List results) {
        for (ConfigurationValueResult result : results) {
            ContainerUtil.addIfNotNull((Collection)valueTexts, (Object)result.getValueText());
        }
        return true;
    }
}

