/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.polySymbols.documentation.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.backend.documentation.DocumentationResult;
import com.intellij.polySymbols.PolySymbolApiStatus;
import com.intellij.polySymbols.PolySymbolsBundle;
import com.intellij.polySymbols.documentation.PolySymbolDocumentation;
import com.intellij.polySymbols.impl.PolySymbolsImplUtilsKt;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u009e\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\r\u0010\u0006\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u001c\u0010\u000f\u001a\u0018\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u0007\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u00070\u0010\u0012\r\u0010\u0011\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0007\u0012\r\u0010\u0012\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010(\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0012\u0010)\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u0016J\u0017\u0010*\u001a\u00020\u00012\r\u0010\u0006\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0007H\u0016J\u0012\u0010+\u001a\u00020\u00012\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010,\u001a\u00020\u00012\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010-\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010.\u001a\u00020\u00012\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010/\u001a\u00020\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u00100\u001a\u00020\u00012\b\b\u0001\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u00101\u001a\u00020\u0003H\u0016J&\u00102\u001a\u00020\u00012\u001c\u00103\u001a\u0018\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u0007\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u00070\u0010H\u0016J\u0014\u00104\u001a\u00020\u00012\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0016J\u0017\u00105\u001a\u00020\u00012\r\u0010\u0012\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0007H\u0016J\u001e\u00106\u001a\u0002072\u0014\u00108\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u000e09H\u0016J(\u0010:\u001a\u00060;j\u0002`<*\u00060;j\u0002`<2\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020?0>H\u0002J\u0014\u0010@\u001a\u00060;j\u0002`<*\u00060;j\u0002`<H\u0002J\u0014\u0010A\u001a\u00060;j\u0002`<*\u00060;j\u0002`<H\u0002J\u0014\u0010B\u001a\u00060;j\u0002`<*\u00060;j\u0002`<H\u0002J\u0014\u0010C\u001a\u00060;j\u0002`<*\u00060;j\u0002`<H\u0002J\u0014\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0010H\u0002J0\u0010E\u001a\u00060;j\u0002`<*\u00060;j\u0002`<2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020?0>H\u0002J6\u0010H\u001a\u00020\u0003*\u00020\u00032\u0014\u00108\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u000e092\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020?0>H\u0002J\t\u0010I\u001a\u00020\u0003H\u00c6\u0003J\t\u0010J\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010K\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010L\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0007H\u00c6\u0003J\u000b\u0010M\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010N\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010O\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010P\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010Q\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\u001f\u0010R\u001a\u0018\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u0007\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u00070\u0010H\u00c6\u0003J\u0010\u0010S\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0007H\u00c6\u0003J\u0010\u0010T\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0007H\u00c6\u0003J\u00b8\u0001\u0010U\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u000f\b\u0002\u0010\u0006\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\u001e\b\u0002\u0010\u000f\u001a\u0018\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u0007\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u00070\u00102\u000f\b\u0002\u0010\u0011\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00072\u000f\b\u0002\u0010\u0012\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0007H\u00c6\u0001J\u0014\u0010V\u001a\u00020&2\b\u0010W\u001a\u0004\u0018\u00010XH\u00d6\u0083\u0004J\n\u0010Y\u001a\u00020ZH\u00d6\u0081\u0004J\n\u0010[\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u001b\u0010\u0006\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0016R\u0016\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0016R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R*\u0010\u000f\u001a\u0018\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u0007\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u00070\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001b\u0010\u0011\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0016R\u001b\u0010\u0012\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0016R\u000e\u0010F\u001a\u00020GX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lcom/intellij/polySymbols/documentation/impl/PolySymbolDocumentationImpl;", "Lcom/intellij/polySymbols/documentation/PolySymbolDocumentation;", "name", "", "definition", "definitionDetails", "description", "Lorg/jetbrains/annotations/Nls;", "docUrl", "apiStatus", "Lcom/intellij/polySymbols/PolySymbolApiStatus;", "defaultValue", "library", "icon", "Ljavax/swing/Icon;", "descriptionSections", "", "footnote", "header", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/polySymbols/PolySymbolApiStatus;Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;Ljava/util/Map;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getDefinition", "getDefinitionDetails", "getDescription", "getDocUrl", "getApiStatus", "()Lcom/intellij/polySymbols/PolySymbolApiStatus;", "getDefaultValue", "getLibrary", "getIcon", "()Ljavax/swing/Icon;", "getDescriptionSections", "()Ljava/util/Map;", "getFootnote", "getHeader", "isNotEmpty", "", "withName", "withDefinition", "withDefinitionDetails", "withDescription", "withDocUrl", "withApiStatus", "withDefault", "withLibrary", "withIcon", "withDescriptionSection", "contents", "withDescriptionSections", "sections", "withFootnote", "withHeader", "build", "Lcom/intellij/platform/backend/documentation/DocumentationResult;", "iconProvider", "Lkotlin/Function1;", "appendDefinition", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "url2ImageMap", "", "Ljava/awt/Image;", "appendDescription", "appendSections", "appendFootnote", "appendHeader", "buildSections", "appendIcon", "imgSrcRegex", "Lkotlin/text/Regex;", "loadLocalImages", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.platform.polySymbols"})
@SourceDebugExtension(value={"SMAP\nPolySymbolDocumentationImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolySymbolDocumentationImpl.kt\ncom/intellij/polySymbols/documentation/impl/PolySymbolDocumentationImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,223:1\n1#2:224\n1915#3,2:225\n614#4:227\n*S KotlinDebug\n*F\n+ 1 PolySymbolDocumentationImpl.kt\ncom/intellij/polySymbols/documentation/impl/PolySymbolDocumentationImpl\n*L\n113#1:225,2\n207#1:227\n*E\n"})
public final class PolySymbolDocumentationImpl
implements PolySymbolDocumentation {
    @NotNull
    private final String name;
    @NotNull
    private final String definition;
    @Nullable
    private final String definitionDetails;
    @Nullable
    private final String description;
    @Nullable
    private final String docUrl;
    @Nullable
    private final PolySymbolApiStatus apiStatus;
    @Nullable
    private final String defaultValue;
    @Nullable
    private final String library;
    @Nullable
    private final Icon icon;
    @NotNull
    private final Map<String, String> descriptionSections;
    @Nullable
    private final String footnote;
    @Nullable
    private final String header;
    @NotNull
    private final Regex imgSrcRegex;

    public PolySymbolDocumentationImpl(@NotNull String name, @NotNull String definition, @Nullable String definitionDetails, @Nullable String description, @Nullable String docUrl, @Nullable PolySymbolApiStatus apiStatus, @Nullable String defaultValue, @Nullable String library, @Nullable Icon icon, @NotNull Map<String, String> descriptionSections, @Nullable String footnote, @Nullable String header) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        Intrinsics.checkNotNullParameter(descriptionSections, (String)"descriptionSections");
        this.name = name;
        this.definition = definition;
        this.definitionDetails = definitionDetails;
        this.description = description;
        this.docUrl = docUrl;
        this.apiStatus = apiStatus;
        this.defaultValue = defaultValue;
        this.library = library;
        this.icon = icon;
        this.descriptionSections = descriptionSections;
        this.footnote = footnote;
        this.header = header;
        this.imgSrcRegex = new Regex("<img [^>]*src\\s*=\\s*['\"]([^'\"]+)['\"]");
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDefinition() {
        return this.definition;
    }

    @Override
    @Nullable
    public String getDefinitionDetails() {
        return this.definitionDetails;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public String getDocUrl() {
        return this.docUrl;
    }

    @Override
    @Nullable
    public PolySymbolApiStatus getApiStatus() {
        return this.apiStatus;
    }

    @Override
    @Nullable
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    @Nullable
    public String getLibrary() {
        return this.library;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public Map<String, String> getDescriptionSections() {
        return this.descriptionSections;
    }

    @Override
    @Nullable
    public String getFootnote() {
        return this.footnote;
    }

    @Override
    @Nullable
    public String getHeader() {
        return this.header;
    }

    @Override
    public boolean isNotEmpty() {
        return !Intrinsics.areEqual((Object)this.getName(), (Object)this.getDefinition()) || this.getDescription() != null || this.getDocUrl() != null || this.getApiStatus() != null && !Intrinsics.areEqual((Object)this.getApiStatus(), (Object)PolySymbolApiStatus.Stable) || this.getDefaultValue() != null || this.getLibrary() != null || !this.getDescriptionSections().isEmpty() || this.getFootnote() != null || this.getHeader() != null;
    }

    @Override
    @NotNull
    public PolySymbolDocumentation withName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return PolySymbolDocumentationImpl.copy$default(this, name, null, null, null, null, null, null, null, null, null, null, null, 4094, null);
    }

    @Override
    @NotNull
    public PolySymbolDocumentation withDefinition(@NotNull String definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        return PolySymbolDocumentationImpl.copy$default(this, null, definition, null, null, null, null, null, null, null, null, null, null, 4093, null);
    }

    @Override
    @NotNull
    public PolySymbolDocumentation withDefinitionDetails(@Nullable String definitionDetails) {
        return PolySymbolDocumentationImpl.copy$default(this, null, null, definitionDetails, null, null, null, null, null, null, null, null, null, 4091, null);
    }

    @Override
    @NotNull
    public PolySymbolDocumentation withDescription(@Nullable String description) {
        return PolySymbolDocumentationImpl.copy$default(this, null, null, null, description, null, null, null, null, null, null, null, null, 4087, null);
    }

    @Override
    @NotNull
    public PolySymbolDocumentation withDocUrl(@Nullable String docUrl) {
        return PolySymbolDocumentationImpl.copy$default(this, null, null, null, null, docUrl, null, null, null, null, null, null, null, 4079, null);
    }

    @Override
    @NotNull
    public PolySymbolDocumentation withApiStatus(@Nullable PolySymbolApiStatus apiStatus) {
        return PolySymbolDocumentationImpl.copy$default(this, null, null, null, null, null, apiStatus, null, null, null, null, null, null, 4063, null);
    }

    @Override
    @NotNull
    public PolySymbolDocumentation withDefault(@Nullable String defaultValue) {
        return PolySymbolDocumentationImpl.copy$default(this, null, null, null, null, null, null, defaultValue, null, null, null, null, null, 4031, null);
    }

    @Override
    @NotNull
    public PolySymbolDocumentation withLibrary(@Nullable String library) {
        return PolySymbolDocumentationImpl.copy$default(this, null, null, null, null, null, null, null, library, null, null, null, null, 3967, null);
    }

    @Override
    @NotNull
    public PolySymbolDocumentation withIcon(@Nullable Icon icon) {
        return PolySymbolDocumentationImpl.copy$default(this, null, null, null, null, null, null, null, null, icon, null, null, null, 3839, null);
    }

    @Override
    @NotNull
    public PolySymbolDocumentation withDescriptionSection(@Nls @NotNull String name, @Nls @NotNull String contents) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        return PolySymbolDocumentationImpl.copy$default(this, null, null, null, null, null, null, null, null, null, MapsKt.plus(this.getDescriptionSections(), (Pair)new Pair((Object)name, (Object)contents)), null, null, 3583, null);
    }

    @Override
    @NotNull
    public PolySymbolDocumentation withDescriptionSections(@NotNull Map<String, String> sections) {
        Intrinsics.checkNotNullParameter(sections, (String)"sections");
        return PolySymbolDocumentationImpl.copy$default(this, null, null, null, null, null, null, null, null, null, MapsKt.plus(this.getDescriptionSections(), sections), null, null, 3583, null);
    }

    @Override
    @NotNull
    public PolySymbolDocumentation withFootnote(@Nls @Nullable String footnote) {
        return PolySymbolDocumentationImpl.copy$default(this, null, null, null, null, null, null, null, null, null, null, footnote, null, 3071, null);
    }

    @Override
    @NotNull
    public PolySymbolDocumentation withHeader(@Nullable String header) {
        return PolySymbolDocumentationImpl.copy$default(this, null, null, null, null, null, null, null, null, null, null, null, header, 2047, null);
    }

    @Override
    @NotNull
    public DocumentationResult build(@NotNull Function1<? super String, ? extends Icon> iconProvider) {
        Intrinsics.checkNotNullParameter(iconProvider, (String)"iconProvider");
        Map url2ImageMap = new LinkedHashMap();
        String string = this.appendFootnote(this.appendSections(this.appendDescription(this.appendDefinition(this.appendHeader(new StringBuilder()), url2ImageMap)))).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String contents = this.loadLocalImages(string, iconProvider, url2ImageMap);
        return (DocumentationResult)DocumentationResult.Companion.documentation(contents).images(url2ImageMap).externalUrl(this.getDocUrl()).definitionDetails(this.getDefinitionDetails());
    }

    private final StringBuilder appendDefinition(StringBuilder $this$appendDefinition, Map<String, Image> url2ImageMap) {
        StringBuilder stringBuilder;
        StringBuilder it = stringBuilder = $this$appendDefinition.append("<div class='definition'><pre>");
        boolean bl = false;
        Icon icon = this.getIcon();
        if (icon != null) {
            Icon it2 = icon;
            boolean bl2 = false;
            this.appendIcon($this$appendDefinition, it2, url2ImageMap).append("&nbsp;");
        }
        StringBuilder stringBuilder2 = stringBuilder.append(this.getDefinition()).append("</pre></div>").append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        return stringBuilder2;
    }

    private final StringBuilder appendDescription(StringBuilder $this$appendDescription) {
        CharSequence charSequence;
        block3: {
            block2: {
                charSequence = this.getDescription();
                if (charSequence == null) break block2;
                String it = charSequence;
                boolean bl = false;
                StringBuilder stringBuilder = $this$appendDescription.append("<div class='content'>").append('\n').append(it).append('\n').append("</div>");
                charSequence = stringBuilder;
                if (stringBuilder != null) break block3;
            }
            charSequence = $this$appendDescription;
        }
        return charSequence;
    }

    private final StringBuilder appendSections(StringBuilder $this$appendSections) {
        Map<String, String> sections = this.buildSections();
        boolean bl = false;
        if (!sections.isEmpty()) {
            $this$appendSections.append("<table class='sections'>").append('\n');
            Iterable $this$forEach$iv = sections.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl2 = false;
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                $this$appendSections.append("<tr><td valign='top' class='section'><p>").append(StringUtil.capitalize((String)name));
                if (!StringsKt.isBlank((CharSequence)value)) {
                    if (!StringsKt.endsWith$default((String)name, (String)":", (boolean)false, (int)2, null)) {
                        $this$appendSections.append(':');
                    }
                    $this$appendSections.append("</td><td valign='top'>").append(value);
                }
                $this$appendSections.append("</td>").append('\n');
            }
            $this$appendSections.append("</table>").append('\n');
        }
        return $this$appendSections;
    }

    private final StringBuilder appendFootnote(StringBuilder $this$appendFootnote) {
        CharSequence charSequence;
        block3: {
            block2: {
                charSequence = this.getFootnote();
                if (charSequence == null) break block2;
                String it = charSequence;
                boolean bl = false;
                StringBuilder stringBuilder = $this$appendFootnote.append("<div class='content'>").append(it).append("</div>").append('\n');
                charSequence = stringBuilder;
                if (stringBuilder != null) break block3;
            }
            charSequence = $this$appendFootnote;
        }
        return charSequence;
    }

    private final StringBuilder appendHeader(StringBuilder $this$appendHeader) {
        CharSequence charSequence;
        block3: {
            block2: {
                charSequence = this.getHeader();
                if (charSequence == null) break block2;
                String it = charSequence;
                boolean bl = false;
                StringBuilder stringBuilder = $this$appendHeader.append("<div class='top'>").append(it).append("</div>\n");
                charSequence = stringBuilder;
                if (stringBuilder != null) break block3;
            }
            charSequence = $this$appendHeader;
        }
        return charSequence;
    }

    private final Map<String, String> buildSections() {
        LinkedHashMap<String, String> linkedHashMap;
        block17: {
            String it;
            LinkedHashMap<String, String> sections = linkedHashMap = new LinkedHashMap<String, String>(this.getDescriptionSections());
            boolean bl = false;
            PolySymbolApiStatus polySymbolApiStatus = this.getApiStatus();
            if (polySymbolApiStatus != null) {
                PolySymbolApiStatus status = polySymbolApiStatus;
                boolean bl2 = false;
                PolySymbolApiStatus polySymbolApiStatus2 = status;
                if (polySymbolApiStatus2 instanceof PolySymbolApiStatus.Deprecated) {
                    Map map = sections;
                    String string = PolySymbolsBundle.message("mdn.documentation.section.status.Deprecated", new Object[0]);
                    String string2 = ((PolySymbolApiStatus.Deprecated)status).getMessage();
                    if (string2 == null) {
                        string2 = "";
                    }
                    String string3 = string2;
                    map.put(string, string3);
                    String string4 = ((PolySymbolApiStatus.Deprecated)status).getSince();
                    if (string4 != null) {
                        String it2 = string4;
                        boolean bl3 = false;
                        ((Map)sections).put(PolySymbolsBundle.message("mdn.documentation.section.status.DeprecatedSince", new Object[0]), it2);
                    }
                } else if (polySymbolApiStatus2 instanceof PolySymbolApiStatus.Obsolete) {
                    Map map = sections;
                    String string = PolySymbolsBundle.message("mdn.documentation.section.status.Obsolete", new Object[0]);
                    String string5 = ((PolySymbolApiStatus.Obsolete)status).getMessage();
                    if (string5 == null) {
                        string5 = "";
                    }
                    String it2 = string5;
                    map.put(string, it2);
                    String string6 = ((PolySymbolApiStatus.Obsolete)status).getSince();
                    if (string6 != null) {
                        it2 = string6;
                        boolean bl4 = false;
                        ((Map)sections).put(PolySymbolsBundle.message("mdn.documentation.section.status.ObsoleteSince", new Object[0]), it2);
                    }
                } else if (polySymbolApiStatus2 instanceof PolySymbolApiStatus.Experimental) {
                    Map map = sections;
                    String string = PolySymbolsBundle.message("mdn.documentation.section.status.Experimental", new Object[0]);
                    String string7 = ((PolySymbolApiStatus.Experimental)status).getMessage();
                    if (string7 == null) {
                        string7 = "";
                    }
                    String it3 = string7;
                    map.put(string, it3);
                    String string8 = ((PolySymbolApiStatus.Experimental)status).getSince();
                    if (string8 != null) {
                        it3 = string8;
                        boolean bl5 = false;
                        ((Map)sections).put(PolySymbolsBundle.message("mdn.documentation.section.status.Since", new Object[0]), it3);
                    }
                } else if (polySymbolApiStatus2 instanceof PolySymbolApiStatus.Stable) {
                    String string = ((PolySymbolApiStatus.Stable)status).getSince();
                    if (string != null) {
                        String it4 = string;
                        boolean bl6 = false;
                        ((Map)sections).put(PolySymbolsBundle.message("mdn.documentation.section.status.Since", new Object[0]), it4);
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String string = this.getDefaultValue();
            if (string != null) {
                it = string;
                boolean bl7 = false;
                ((Map)sections).put(PolySymbolsBundle.message("mdn.documentation.section.defaultValue", new Object[0]), "<p><code>" + it + "</code>");
            }
            String string9 = this.getLibrary();
            if (string9 == null) break block17;
            it = string9;
            boolean bl8 = false;
            ((Map)sections).put(PolySymbolsBundle.message("mdn.documentation.section.library", new Object[0]), "<p>" + it);
        }
        return linkedHashMap;
    }

    private final StringBuilder appendIcon(StringBuilder $this$appendIcon, Icon icon, Map<String, Image> url2ImageMap) {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2 = new BufferedImage(1, 1, 2);
        Graphics2D g = bufferedImage2.createGraphics();
        g.setFont(UIUtil.getToolTipFont());
        int height = (int)g.getFontMetrics().getLineMetrics("T", g).getHeight();
        g.dispose();
        try {
            bufferedImage = IconUtil.toBufferedImage$default((Icon)PolySymbolsImplUtilsKt.scaleToHeight(icon, height), (boolean)false, (int)2, null);
        }
        catch (Exception e) {
            return $this$appendIcon;
        }
        BufferedImage image = bufferedImage;
        String url = "https://img" + url2ImageMap.size();
        url2ImageMap.put(url, image);
        $this$appendIcon.append("<img src='" + url + "' height=\"" + height + "\" width=\"" + height * icon.getIconWidth() / icon.getIconHeight() + "\" border=0 />");
        return $this$appendIcon;
    }

    /*
     * WARNING - void declaration
     */
    private final String loadLocalImages(String $this$loadLocalImages, Function1<? super String, ? extends Icon> iconProvider, Map<String, Image> url2ImageMap) {
        void $this$sortedBy$iv;
        Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)Regex.findAll$default((Regex)this.imgSrcRegex, (CharSequence)$this$loadLocalImages, (int)0, (int)2, null), PolySymbolDocumentationImpl::loadLocalImages$lambda$0), PolySymbolDocumentationImpl::loadLocalImages$lambda$1), arg_0 -> PolySymbolDocumentationImpl.loadLocalImages$lambda$2(iconProvider, url2ImageMap, arg_0));
        boolean $i$f$sortedBy = false;
        List replaces = SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((IntRange)it.getFirst()).getFirst());
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((IntRange)it.getFirst()).getFirst()));
            }
        }));
        if (replaces.isEmpty()) {
            return $this$loadLocalImages;
        }
        StringBuilder result2 = new StringBuilder();
        int lastIndex = 0;
        for (Pair replace : replaces) {
            Intrinsics.checkNotNullExpressionValue((Object)result2.append($this$loadLocalImages, lastIndex, ((IntRange)replace.getFirst()).getFirst()), (String)"append(...)");
            result2.append((String)replace.getSecond());
            lastIndex = ((IntRange)replace.getFirst()).getLast() + 1;
        }
        if (lastIndex < $this$loadLocalImages.length()) {
            Intrinsics.checkNotNullExpressionValue((Object)result2.append($this$loadLocalImages, lastIndex, $this$loadLocalImages.length()), (String)"append(...)");
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final String component2() {
        return this.definition;
    }

    @Nullable
    public final String component3() {
        return this.definitionDetails;
    }

    @Nullable
    public final String component4() {
        return this.description;
    }

    @Nullable
    public final String component5() {
        return this.docUrl;
    }

    @Nullable
    public final PolySymbolApiStatus component6() {
        return this.apiStatus;
    }

    @Nullable
    public final String component7() {
        return this.defaultValue;
    }

    @Nullable
    public final String component8() {
        return this.library;
    }

    @Nullable
    public final Icon component9() {
        return this.icon;
    }

    @NotNull
    public final Map<String, String> component10() {
        return this.descriptionSections;
    }

    @Nullable
    public final String component11() {
        return this.footnote;
    }

    @Nullable
    public final String component12() {
        return this.header;
    }

    @NotNull
    public final PolySymbolDocumentationImpl copy(@NotNull String name, @NotNull String definition, @Nullable String definitionDetails, @Nullable String description, @Nullable String docUrl, @Nullable PolySymbolApiStatus apiStatus, @Nullable String defaultValue, @Nullable String library, @Nullable Icon icon, @NotNull Map<String, String> descriptionSections, @Nullable String footnote, @Nullable String header) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        Intrinsics.checkNotNullParameter(descriptionSections, (String)"descriptionSections");
        return new PolySymbolDocumentationImpl(name, definition, definitionDetails, description, docUrl, apiStatus, defaultValue, library, icon, descriptionSections, footnote, header);
    }

    public static /* synthetic */ PolySymbolDocumentationImpl copy$default(PolySymbolDocumentationImpl polySymbolDocumentationImpl, String string, String string2, String string3, String string4, String string5, PolySymbolApiStatus polySymbolApiStatus, String string6, String string7, Icon icon, Map map, String string8, String string9, int n, Object object) {
        if ((n & 1) != 0) {
            string = polySymbolDocumentationImpl.name;
        }
        if ((n & 2) != 0) {
            string2 = polySymbolDocumentationImpl.definition;
        }
        if ((n & 4) != 0) {
            string3 = polySymbolDocumentationImpl.definitionDetails;
        }
        if ((n & 8) != 0) {
            string4 = polySymbolDocumentationImpl.description;
        }
        if ((n & 0x10) != 0) {
            string5 = polySymbolDocumentationImpl.docUrl;
        }
        if ((n & 0x20) != 0) {
            polySymbolApiStatus = polySymbolDocumentationImpl.apiStatus;
        }
        if ((n & 0x40) != 0) {
            string6 = polySymbolDocumentationImpl.defaultValue;
        }
        if ((n & 0x80) != 0) {
            string7 = polySymbolDocumentationImpl.library;
        }
        if ((n & 0x100) != 0) {
            icon = polySymbolDocumentationImpl.icon;
        }
        if ((n & 0x200) != 0) {
            map = polySymbolDocumentationImpl.descriptionSections;
        }
        if ((n & 0x400) != 0) {
            string8 = polySymbolDocumentationImpl.footnote;
        }
        if ((n & 0x800) != 0) {
            string9 = polySymbolDocumentationImpl.header;
        }
        return polySymbolDocumentationImpl.copy(string, string2, string3, string4, string5, polySymbolApiStatus, string6, string7, icon, map, string8, string9);
    }

    @NotNull
    public String toString() {
        return "PolySymbolDocumentationImpl(name=" + this.name + ", definition=" + this.definition + ", definitionDetails=" + this.definitionDetails + ", description=" + this.description + ", docUrl=" + this.docUrl + ", apiStatus=" + this.apiStatus + ", defaultValue=" + this.defaultValue + ", library=" + this.library + ", icon=" + this.icon + ", descriptionSections=" + this.descriptionSections + ", footnote=" + this.footnote + ", header=" + this.header + ")";
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + this.definition.hashCode();
        result2 = result2 * 31 + (this.definitionDetails == null ? 0 : this.definitionDetails.hashCode());
        result2 = result2 * 31 + (this.description == null ? 0 : this.description.hashCode());
        result2 = result2 * 31 + (this.docUrl == null ? 0 : this.docUrl.hashCode());
        result2 = result2 * 31 + (this.apiStatus == null ? 0 : this.apiStatus.hashCode());
        result2 = result2 * 31 + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result2 = result2 * 31 + (this.library == null ? 0 : this.library.hashCode());
        result2 = result2 * 31 + (this.icon == null ? 0 : this.icon.hashCode());
        result2 = result2 * 31 + ((Object)this.descriptionSections).hashCode();
        result2 = result2 * 31 + (this.footnote == null ? 0 : this.footnote.hashCode());
        result2 = result2 * 31 + (this.header == null ? 0 : this.header.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PolySymbolDocumentationImpl)) {
            return false;
        }
        PolySymbolDocumentationImpl polySymbolDocumentationImpl = (PolySymbolDocumentationImpl)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)polySymbolDocumentationImpl.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.definition, (Object)polySymbolDocumentationImpl.definition)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.definitionDetails, (Object)polySymbolDocumentationImpl.definitionDetails)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)polySymbolDocumentationImpl.description)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.docUrl, (Object)polySymbolDocumentationImpl.docUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.apiStatus, (Object)polySymbolDocumentationImpl.apiStatus)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.defaultValue, (Object)polySymbolDocumentationImpl.defaultValue)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.library, (Object)polySymbolDocumentationImpl.library)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.icon, (Object)polySymbolDocumentationImpl.icon)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.descriptionSections, polySymbolDocumentationImpl.descriptionSections)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.footnote, (Object)polySymbolDocumentationImpl.footnote)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.header, (Object)polySymbolDocumentationImpl.header);
    }

    private static final MatchGroup loadLocalImages$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getGroups().get(1);
    }

    private static final boolean loadLocalImages$lambda$1(MatchGroup it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.contains$default((CharSequence)it.getValue(), (char)':', (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Pair loadLocalImages$lambda$2(Function1 $iconProvider, Map $url2ImageMap, MatchGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Icon icon = (Icon)$iconProvider.invoke((Object)group.getValue());
        if (icon == null) return null;
        Object it = icon;
        boolean bl = false;
        BufferedImage bufferedImage = IconUtil.toBufferedImage((Icon)it, (boolean)true);
        if (bufferedImage == null) return null;
        it = bufferedImage;
        boolean bl2 = false;
        String url = "https://img" + $url2ImageMap.size();
        $url2ImageMap.put(url, it);
        Pair pair = new Pair((Object)group.getRange(), (Object)url);
        return pair;
    }
}

