/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.polySymbols.utils;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J(\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J(\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0007J \u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0002J0\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/polySymbols/utils/NameCaseUtils;", "", "<init>", "()V", "toPascalCase", "", "str", "preserveConsecutiveUppercase", "", "toCamelCase", "toKebabCase", "noHyphenBeforeDigit", "noHyphenBetweenDigitAndLowercase", "splitConsecutiveUppercase", "toSnakeCase", "noUnderscoreBeforeDigit", "noUnderscoreBetweenDigitAndLowercase", "pascalCase", "toSeparatorBasedCase", "separator", "", "noSeparatorBeforeDigit", "noSeparatorBetweenDigitAndLowercase", "isCaseSeparator", "codePoint", "", "isRegularDigit", "intellij.platform.polySymbols"})
public final class NameCaseUtils {
    @NotNull
    public static final NameCaseUtils INSTANCE = new NameCaseUtils();

    private NameCaseUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String toPascalCase(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return INSTANCE.toCamelCase(str, false, true);
    }

    @JvmStatic
    @NotNull
    public static final String toPascalCase(@NotNull String str, boolean preserveConsecutiveUppercase) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return INSTANCE.toCamelCase(str, preserveConsecutiveUppercase, true);
    }

    @JvmStatic
    @NotNull
    public static final String toCamelCase(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return INSTANCE.toCamelCase(str, false, false);
    }

    @JvmStatic
    @NotNull
    public static final String toCamelCase(@NotNull String str, boolean preserveConsecutiveUppercase) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return INSTANCE.toCamelCase(str, preserveConsecutiveUppercase, false);
    }

    @JvmStatic
    @NotNull
    public static final String toKebabCase(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return INSTANCE.toSeparatorBasedCase('-', str, false, false, false);
    }

    @JvmStatic
    @NotNull
    public static final String toKebabCase(@NotNull String str, boolean noHyphenBeforeDigit, boolean noHyphenBetweenDigitAndLowercase, boolean splitConsecutiveUppercase) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return INSTANCE.toSeparatorBasedCase('-', str, noHyphenBeforeDigit, noHyphenBetweenDigitAndLowercase, splitConsecutiveUppercase);
    }

    @JvmStatic
    @NotNull
    public static final String toSnakeCase(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return INSTANCE.toSeparatorBasedCase('_', str, false, false, false);
    }

    @JvmStatic
    @NotNull
    public static final String toSnakeCase(@NotNull String str, boolean noUnderscoreBeforeDigit, boolean noUnderscoreBetweenDigitAndLowercase, boolean splitConsecutiveUppercase) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return INSTANCE.toSeparatorBasedCase('_', str, noUnderscoreBeforeDigit, noUnderscoreBetweenDigitAndLowercase, splitConsecutiveUppercase);
    }

    private final String toCamelCase(String str, boolean preserveConsecutiveUppercase, boolean pascalCase) {
        StringBuilder result2 = new StringBuilder();
        int[] codePoints = str.codePoints().toArray();
        int n = codePoints.length;
        for (int i = 0; i < n; ++i) {
            int prevChar;
            int ch = codePoints[i];
            if (Character.isUpperCase(ch)) {
                prevChar = i > 0 ? codePoints[i - 1] : 0;
                int nextChar = i < codePoints.length - 1 ? codePoints[i + 1] : 0;
                StringBuilder stringBuilder = ((CharSequence)result2).length() == 0 && (pascalCase || preserveConsecutiveUppercase && Character.isUpperCase(nextChar)) || ((CharSequence)result2).length() > 0 && (preserveConsecutiveUppercase || this.isCaseSeparator(prevChar) || this.isRegularDigit(prevChar) || !Character.isUpperCase(prevChar) || Character.isLowerCase(nextChar)) ? result2.appendCodePoint(ch) : result2.appendCodePoint(Character.toLowerCase(ch));
                continue;
            }
            if (Character.isLowerCase(ch)) {
                prevChar = i > 0 ? codePoints[i - 1] : 0;
                StringBuilder stringBuilder = ((CharSequence)result2).length() == 0 && pascalCase || ((CharSequence)result2).length() > 0 && (this.isCaseSeparator(prevChar) || this.isRegularDigit(prevChar)) ? result2.appendCodePoint(Character.toUpperCase(ch)) : result2.appendCodePoint(ch);
                continue;
            }
            if (this.isCaseSeparator(ch)) continue;
            result2.appendCodePoint(ch);
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String toSeparatorBasedCase(char separator, String str, boolean noSeparatorBeforeDigit, boolean noSeparatorBetweenDigitAndLowercase, boolean splitConsecutiveUppercase) {
        StringBuilder result2 = new StringBuilder();
        int[] codePoints = str.codePoints().toArray();
        int n = codePoints.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            int nextChar;
            int ch = codePoints[i];
            int prevChar = i > 0 ? codePoints[i - 1] : 0;
            int n2 = nextChar = i + 1 < codePoints.length ? codePoints[i + 1] : 0;
            if (this.isCaseSeparator(ch)) {
                if (!this.isCaseSeparator(nextChar) && nextChar != 0 && ((CharSequence)result2).length() > 0) {
                    result2.append(separator);
                }
                object = Unit.INSTANCE;
                continue;
            }
            if (Character.isUpperCase(ch)) {
                if (!this.isCaseSeparator(prevChar) && ((CharSequence)result2).length() > 0 && (this.isRegularDigit(prevChar) || !Character.isUpperCase(prevChar) || splitConsecutiveUppercase || Character.isLowerCase(nextChar))) {
                    result2.append(separator);
                }
                object = result2.appendCodePoint(Character.toLowerCase(ch));
                continue;
            }
            if (Character.isLowerCase(ch)) {
                if (!noSeparatorBetweenDigitAndLowercase && this.isRegularDigit(prevChar)) {
                    result2.append(separator);
                }
                object = result2.appendCodePoint(ch);
                continue;
            }
            if (!noSeparatorBeforeDigit && this.isRegularDigit(ch)) {
                if (!this.isCaseSeparator(prevChar) && !this.isRegularDigit(prevChar) && ((CharSequence)result2).length() > 0) {
                    result2.append(separator);
                }
                object = result2.appendCodePoint(ch);
                continue;
            }
            object = result2.appendCodePoint(ch);
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final boolean isCaseSeparator(int codePoint) {
        return codePoint == 95 || codePoint == 46 || codePoint == 45 || codePoint == 32;
    }

    private final boolean isRegularDigit(int codePoint) {
        return 48 <= codePoint && codePoint <= 57;
    }
}

