/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.devcontainers.feautures;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.intellij.docker.agent.devcontainers.feautures.DevcontainerFeatureRefMigrationKt;
import com.intellij.docker.agent.devcontainers.model.DevcontainerFeature;
import com.intellij.docker.agent.i18n.DockerAgentBundle;
import java.net.URI;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u0000 \r2\u00020\u0001:\u0003\f\r\u000eB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource;", "", "ref", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource$Ref;", "cachePath", "", "<init>", "(Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource$Ref;Ljava/lang/String;)V", "getRef", "()Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource$Ref;", "getCachePath", "()Ljava/lang/String;", "SourceType", "Companion", "Ref", "intellij.clouds.docker.agent"})
public final class DevcontainerResource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ref ref;
    @Nullable
    private final String cachePath;

    public DevcontainerResource(@NotNull Ref ref, @Nullable String cachePath) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        this.ref = ref;
        this.cachePath = cachePath;
    }

    public /* synthetic */ DevcontainerResource(Ref ref, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(ref, string);
    }

    @NotNull
    public final Ref getRef() {
        return this.ref;
    }

    @Nullable
    public final String getCachePath() {
        return this.cachePath;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource$Companion;", "", "<init>", "()V", "fromFeature", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource;", "feature", "Lcom/intellij/docker/agent/devcontainers/model/DevcontainerFeature;", "fromId", "id", "", "intellij.clouds.docker.agent"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DevcontainerResource fromFeature(@NotNull DevcontainerFeature feature) {
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            return new DevcontainerResource(feature.getRef(), feature.getCachePath());
        }

        @NotNull
        public final DevcontainerResource fromId(@NotNull String id2) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            return new DevcontainerResource(new Ref(id2), null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001#B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0012\u0012\u0006\u0010\t\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\nB\u0011\b\u0017\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\fJ\n\u0010\u0014\u001a\u00020\u0003H\u0096\u0080\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0007J\u0012\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0000H\u0096\u0082\u0004J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u001f\u001a\u00020 2\b\u0010\u0019\u001a\u0004\u0018\u00010!H\u00d6\u0083\u0004J\n\u0010\"\u001a\u00020\u0018H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0012\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006$"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource$Ref;", "", "registry", "", "namespace", "id", "tag", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "ref", "(Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource$Ref;)V", "text", "(Ljava/lang/String;)V", "getRegistry", "()Ljava/lang/String;", "getNamespace", "getId", "getTag", "dependencyId", "getDependencyId", "toString", "getSource", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource$SourceType;", "compareTo", "", "other", "component1", "component2", "component3", "component4", "copy", "equals", "", "", "hashCode", "Companion", "intellij.clouds.docker.agent"})
    public static final class Ref
    implements Comparable<Ref> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String registry;
        @NotNull
        private final String namespace;
        @NotNull
        private final String id;
        @NotNull
        private final String tag;
        @NotNull
        private static final String HTTPS_PREFIX = "https://";
        @NotNull
        private static final String DIRECT_TARBALL = "tarball";
        @NotNull
        private static final String BUILT_IN = "builtin:";
        @NotNull
        public static final String LOCAL_DIR = "local";
        @NotNull
        public static final String TARBALL_SUFFIX = ".tgz";
        @NotNull
        public static final String TARBALL_PREFIX = "devcontainer-feature-";
        @NotNull
        private static final String DEFAULT_TAG = "latest";
        @NotNull
        private static final Regex VALID_FEATURE_ID_REGEX = new Regex("^[a-zA-Z0-9_-]*$");

        public Ref(@NotNull String registry, @NotNull String namespace, @NotNull String id2, @NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.registry = registry;
            this.namespace = namespace;
            this.id = id2;
            this.tag = tag;
        }

        @NotNull
        public final String getRegistry() {
            return this.registry;
        }

        @NotNull
        public final String getNamespace() {
            return this.namespace;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getTag() {
            return this.tag;
        }

        private Ref(Ref ref) {
            this(ref.registry, ref.namespace, ref.id, ref.tag);
        }

        @JsonCreator
        public Ref(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this(Companion.extractRef$intellij_clouds_docker_agent(DevcontainerFeatureRefMigrationKt.migrateId(text)));
        }

        @JsonIgnore
        @NotNull
        public final String getDependencyId() {
            return Intrinsics.areEqual((Object)this.registry, (Object)LOCAL_DIR) ? this.namespace + "/" + this.id : this.registry + "/" + this.namespace + "/" + this.id;
        }

        @NotNull
        public String toString() {
            return this.getDependencyId() + "/" + this.tag;
        }

        @JsonIgnore
        @NotNull
        public final SourceType getSource() {
            return switch (this.registry) {
                case DIRECT_TARBALL -> SourceType.DirectTarball;
                case LOCAL_DIR -> SourceType.Local;
                case BUILT_IN -> SourceType.BuiltIn;
                default -> SourceType.OCIRegistry;
            };
        }

        @Override
        public int compareTo(@NotNull Ref other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.toString().compareTo(other.toString());
        }

        @NotNull
        public final String component1() {
            return this.registry;
        }

        @NotNull
        public final String component2() {
            return this.namespace;
        }

        @NotNull
        public final String component3() {
            return this.id;
        }

        @NotNull
        public final String component4() {
            return this.tag;
        }

        @NotNull
        public final Ref copy(@NotNull String registry, @NotNull String namespace, @NotNull String id2, @NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            return new Ref(registry, namespace, id2, tag);
        }

        public static /* synthetic */ Ref copy$default(Ref ref, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = ref.registry;
            }
            if ((n & 2) != 0) {
                string2 = ref.namespace;
            }
            if ((n & 4) != 0) {
                string3 = ref.id;
            }
            if ((n & 8) != 0) {
                string4 = ref.tag;
            }
            return ref.copy(string, string2, string3, string4);
        }

        public int hashCode() {
            int result2 = this.registry.hashCode();
            result2 = result2 * 31 + this.namespace.hashCode();
            result2 = result2 * 31 + this.id.hashCode();
            result2 = result2 * 31 + this.tag.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Ref)) {
                return false;
            }
            Ref ref = (Ref)other;
            if (!Intrinsics.areEqual((Object)this.registry, (Object)ref.registry)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.namespace, (Object)ref.namespace)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.id, (Object)ref.id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tag, (Object)ref.tag);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource$Ref$Companion;", "", "<init>", "()V", "HTTPS_PREFIX", "", "DIRECT_TARBALL", "BUILT_IN", "LOCAL_DIR", "TARBALL_SUFFIX", "TARBALL_PREFIX", "DEFAULT_TAG", "VALID_FEATURE_ID_REGEX", "Lkotlin/text/Regex;", "extractRef", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource$Ref;", "id", "extractRef$intellij_clouds_docker_agent", "intellij.clouds.docker.agent"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Ref extractRef$intellij_clouds_docker_agent(@NotNull String id2) {
                block18: {
                    String path;
                    URI uri;
                    block20: {
                        block19: {
                            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
                            if (!StringsKt.startsWith$default((String)id2, (String)Ref.HTTPS_PREFIX, (boolean)false, (int)2, null)) break block18;
                            URI rawUri = new URL(id2).toURI();
                            uri = rawUri.normalize();
                            path = uri.getPath();
                            if (!Intrinsics.areEqual((Object)uri, (Object)rawUri)) break block19;
                            String string = uri.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"..", (boolean)false, (int)2, null)) break block20;
                        }
                        throw new IllegalStateException(("Suspicious path in feature id: " + uri.getPath()).toString());
                    }
                    Intrinsics.checkNotNull((Object)path);
                    int tarSuffixInd = StringsKt.lastIndexOf$default((CharSequence)path, (String)Ref.TARBALL_SUFFIX, (int)0, (boolean)false, (int)6, null);
                    if (tarSuffixInd < 0) {
                        throw new IllegalStateException("Directly referenced feature must have .tgz extension".toString());
                    }
                    int filePrefixInd = StringsKt.lastIndexOf$default((CharSequence)path, (String)Ref.TARBALL_PREFIX, (int)0, (boolean)false, (int)6, null);
                    if (filePrefixInd < 0) {
                        throw new IllegalStateException("Directly referenced feature must contain devcontainer-feature-".toString());
                    }
                    if (filePrefixInd > tarSuffixInd) {
                        throw new IllegalStateException(("Unrecognized directly referenced feature format " + id2).toString());
                    }
                    String string = uri.getAuthority();
                    String string2 = path.substring(0, filePrefixInd - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    String namespace = string + string2;
                    String string3 = path.substring(filePrefixInd + 21, tarSuffixInd);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    String shortId = string3;
                    if (!VALID_FEATURE_ID_REGEX.matches((CharSequence)shortId)) {
                        throw new IllegalStateException("Invalid feature ID, may contain only alphanumeric, underscore and dash characters are allowed".toString());
                    }
                    return new Ref(Ref.DIRECT_TARBALL, namespace, shortId, Ref.DEFAULT_TAG);
                }
                if (StringsKt.startsWith$default((String)id2, (String)".", (boolean)false, (int)2, null)) {
                    int lastSepInd = StringsKt.lastIndexOf$default((CharSequence)id2, (char)'/', (int)0, (boolean)false, (int)6, null);
                    if (lastSepInd < 0) {
                        throw new IllegalStateException("A local feature path must contain at least one / character".toString());
                    }
                    if (lastSepInd == id2.length()) {
                        throw new IllegalStateException("Missing feature directory/id".toString());
                    }
                    String string = id2.substring(0, lastSepInd);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String namespace = string;
                    String string4 = id2.substring(lastSepInd + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    String shortId = string4;
                    return new Ref(Ref.LOCAL_DIR, namespace, shortId, Ref.DEFAULT_TAG);
                }
                if (StringsKt.startsWith$default((String)id2, (String)Ref.BUILT_IN, (boolean)false, (int)2, null)) {
                    String string;
                    String namespace;
                    String noPrefixId = StringsKt.removePrefix((String)id2, (CharSequence)Ref.BUILT_IN);
                    int lastSepIndex = StringsKt.lastIndexOf$default((CharSequence)noPrefixId, (String)"/", (int)0, (boolean)false, (int)6, null);
                    if (lastSepIndex >= 0) {
                        String string5 = noPrefixId.substring(0, lastSepIndex);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                        v7 = StringsKt.removePrefix((String)string5, (CharSequence)"/");
                    } else {
                        v7 = namespace = "";
                    }
                    if (lastSepIndex >= 0) {
                        String string6 = noPrefixId.substring(lastSepIndex + 1);
                        string = string6;
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                    } else {
                        string = noPrefixId;
                    }
                    String[] filePrefixInd = new String[]{":"};
                    List idTag = StringsKt.split$default((CharSequence)string, (String[])filePrefixInd, (boolean)false, (int)0, (int)6, null);
                    String shortId = (String)idTag.get(0);
                    String tag = idTag.size() > 1 ? (String)idTag.get(1) : Ref.DEFAULT_TAG;
                    return new Ref(Ref.BUILT_IN, namespace, shortId, tag);
                }
                int colonPos = StringsKt.lastIndexOf$default((CharSequence)id2, (char)':', (int)0, (boolean)false, (int)6, null);
                String source = id2;
                String tag = null;
                if (colonPos >= 0) {
                    String string = id2.substring(0, colonPos);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    source = string;
                    String string7 = id2.substring(colonPos + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                    tag = string7;
                } else {
                    tag = Ref.DEFAULT_TAG;
                }
                String[] stringArray = new String[]{"/"};
                List chunks = StringsKt.split$default((CharSequence)source, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                if (chunks.size() < 3) {
                    throw new IllegalStateException(DockerAgentBundle.Companion.message("devcontainer.invalid.feature.reference", new Object[0]).toString());
                }
                return new Ref((String)chunks.get(0), CollectionsKt.joinToString$default((Iterable)chunks.subList(1, chunks.size() - 1), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null), (String)chunks.get(chunks.size() - 1), tag);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource$SourceType;", "", "<init>", "(Ljava/lang/String;I)V", "Local", "DirectTarball", "OCIRegistry", "BuiltIn", "intellij.clouds.docker.agent"})
    public static final class SourceType
    extends Enum<SourceType> {
        public static final /* enum */ SourceType Local = new SourceType();
        public static final /* enum */ SourceType DirectTarball = new SourceType();
        public static final /* enum */ SourceType OCIRegistry = new SourceType();
        public static final /* enum */ SourceType BuiltIn = new SourceType();
        private static final /* synthetic */ SourceType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SourceType[] values() {
            return (SourceType[])$VALUES.clone();
        }

        public static SourceType valueOf(String value) {
            return Enum.valueOf(SourceType.class, value);
        }

        @NotNull
        public static EnumEntries<SourceType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sourceTypeArray = new SourceType[]{SourceType.Local, SourceType.DirectTarball, SourceType.OCIRegistry, SourceType.BuiltIn};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

