/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.common.plantuml;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.extensions.CodeFenceGeneratingProvider;
import org.intellij.plugins.markdown.extensions.ExtensionsExternalFilesPathManager;
import org.intellij.plugins.markdown.extensions.MarkdownExtensionsUtil;
import org.intellij.plugins.markdown.extensions.common.plantuml.PlantUMLCodeGeneratingProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\rH\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u0014H\u0002J\u0006\u0010\u001a\u001a\u00020\u0014J\b\u0010\u001b\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/plantuml/PlantUMLJarManager;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "loadedClassAndMethod", "Lorg/intellij/plugins/markdown/extensions/common/plantuml/PlantUMLJarManager$Holder;", "isDisposed", "", "loadClass", "Ljava/lang/Class;", "path", "Ljava/io/File;", "findMethod", "Ljava/lang/reflect/Method;", "loadedClass", "findPath", "obtainCurrentHolder", "generateImage", "", "source", "", "outputStream", "Ljava/io/OutputStream;", "actuallyDropCache", "dropCache", "dispose", "Holder", "Companion", "intellij.markdown"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPlantUMLJarManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlantUMLJarManager.kt\norg/intellij/plugins/markdown/extensions/common/plantuml/PlantUMLJarManager\n+ 2 MarkdownExtensionsUtil.kt\norg/intellij/plugins/markdown/extensions/MarkdownExtensionsUtil\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,130:1\n37#2:131\n812#3,12:132\n13#4:144\n*S KotlinDebug\n*F\n+ 1 PlantUMLJarManager.kt\norg/intellij/plugins/markdown/extensions/common/plantuml/PlantUMLJarManager\n*L\n64#1:131\n64#1:132,12\n122#1:144\n*E\n"})
public final class PlantUMLJarManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReentrantLock lock = new ReentrantLock();
    @Nullable
    private Holder loadedClassAndMethod;
    private boolean isDisposed;
    @NotNull
    private static final String className = "net.sourceforge.plantuml.SourceStringReader";
    @NotNull
    private static final Logger logger;

    private final Class<?> loadClass(File path) {
        URL[] uRLArray = new URL[]{path.toURI().toURL()};
        URLClassLoader classLoader = new URLClassLoader(uRLArray, this.getClass().getClassLoader());
        try {
            return Class.forName(className, false, classLoader);
        }
        catch (Throwable exception) {
            logger.warn("Failed to find net.sourceforge.plantuml.SourceStringReader class in downloaded PlantUML jar. Please try to download another PlantUML library version.", exception);
            classLoader.close();
            return null;
        }
    }

    private final Method findMethod(Class<?> loadedClass) {
        String methodName = "generateImage";
        try {
            Class[] classArray = new Class[]{Class.forName("java.io.OutputStream")};
            return loadedClass.getDeclaredMethod(methodName, classArray);
        }
        catch (Throwable exception) {
            logger.warn("Failed to find 'generateImage' method in the class 'net.sourceforge.plantuml.SourceStringReader'. Please try to download another PlantUML library version.", exception);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final File findPath() {
        void $this$filterIsInstanceTo$iv$iv$iv;
        MarkdownExtensionsUtil this_$iv = MarkdownExtensionsUtil.INSTANCE;
        boolean $i$f$findCodeFenceGeneratingProvider = false;
        Iterable $this$filterIsInstance$iv$iv = CodeFenceGeneratingProvider.Companion.collectProviders();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof PlantUMLCodeGeneratingProvider)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        PlantUMLCodeGeneratingProvider plantUMLCodeGeneratingProvider = (PlantUMLCodeGeneratingProvider)((CodeFenceGeneratingProvider)CollectionsKt.firstOrNull((List)((List)destination$iv$iv$iv)));
        if (plantUMLCodeGeneratingProvider == null) {
            return null;
        }
        PlantUMLCodeGeneratingProvider extension = plantUMLCodeGeneratingProvider;
        String filename = "plantuml.jar";
        Path directory = ExtensionsExternalFilesPathManager.Companion.obtainExternalFilesDirectoryPath(extension);
        return directory.resolve(filename).toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Holder obtainCurrentHolder() {
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            Method method;
            Class<?> loadedClass;
            block10: {
                Class<?> clazz;
                block9: {
                    File file;
                    block8: {
                        block7: {
                            boolean bl = false;
                            if (!this.isDisposed) break block7;
                            return null;
                        }
                        if (this.loadedClassAndMethod != null) return this.loadedClassAndMethod;
                        if (this.findPath() != null) break block8;
                        return null;
                    }
                    File path = file;
                    if (this.loadClass(path) != null) break block9;
                    return null;
                }
                loadedClass = clazz;
                if (this.findMethod(loadedClass) != null) break block10;
                return null;
            }
            Method method2 = method;
            this.loadedClassAndMethod = new Holder(loadedClass, method2);
            return this.loadedClassAndMethod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generateImage(@NotNull String source, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            Object object;
            boolean bl = false;
            Holder holder = this.obtainCurrentHolder();
            if (holder == null) {
                return;
            }
            Holder holder2 = holder;
            Class<?> loadedClass = holder2.component1();
            Method method = holder2.component2();
            try {
                object = new Object[]{String.class};
                Constructor<?> constructor = loadedClass.getConstructor((Class<?>[])object);
                object = new Object[]{source};
                Object obj = constructor.newInstance(object);
                object = new Object[]{outputStream};
                object = method.invoke(obj, object);
            }
            catch (Throwable exception) {
                logger.warn("Failed to invoke method.", exception);
                object = Unit.INSTANCE;
            }
            Object[] objectArray = object;
        }
    }

    private final void actuallyDropCache() {
        Holder holder = this.loadedClassAndMethod;
        if (holder != null) {
            Holder it = holder;
            boolean bl = false;
            try {
                Unit unit;
                ClassLoader classLoader = it.getLoadedClass().getClassLoader();
                URLClassLoader uRLClassLoader = classLoader instanceof URLClassLoader ? (URLClassLoader)classLoader : null;
                if (uRLClassLoader != null) {
                    uRLClassLoader.close();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit2 = unit;
            }
            catch (Throwable exception) {
                logger.warn("Failed to close class loader.", exception);
                Unit unit = Unit.INSTANCE;
            }
        }
        this.loadedClassAndMethod = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dropCache() {
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            this.actuallyDropCache();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            this.actuallyDropCache();
            this.isDisposed = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    @JvmStatic
    @NotNull
    public static final PlantUMLJarManager getInstance() {
        return Companion.getInstance();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PlantUMLJarManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        PlantUMLJarManager.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/plantuml/PlantUMLJarManager$Companion;", "", "<init>", "()V", "className", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lorg/intellij/plugins/markdown/extensions/common/plantuml/PlantUMLJarManager;", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nPlantUMLJarManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlantUMLJarManager.kt\norg/intellij/plugins/markdown/extensions/common/plantuml/PlantUMLJarManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,130:1\n42#2,3:131\n*S KotlinDebug\n*F\n+ 1 PlantUMLJarManager.kt\norg/intellij/plugins/markdown/extensions/common/plantuml/PlantUMLJarManager$Companion\n*L\n126#1:131,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PlantUMLJarManager getInstance() {
            boolean $i$f$service = false;
            Class<PlantUMLJarManager> serviceClass$iv = PlantUMLJarManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (PlantUMLJarManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J!\u0010\u000e\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/plantuml/PlantUMLJarManager$Holder;", "", "loadedClass", "Ljava/lang/Class;", "method", "Ljava/lang/reflect/Method;", "<init>", "(Ljava/lang/Class;Ljava/lang/reflect/Method;)V", "getLoadedClass", "()Ljava/lang/Class;", "getMethod", "()Ljava/lang/reflect/Method;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.markdown"})
    private static final class Holder {
        @NotNull
        private final Class<?> loadedClass;
        @NotNull
        private final Method method;

        public Holder(@NotNull Class<?> loadedClass, @NotNull Method method) {
            Intrinsics.checkNotNullParameter(loadedClass, (String)"loadedClass");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            this.loadedClass = loadedClass;
            this.method = method;
        }

        @NotNull
        public final Class<?> getLoadedClass() {
            return this.loadedClass;
        }

        @NotNull
        public final Method getMethod() {
            return this.method;
        }

        @NotNull
        public final Class<?> component1() {
            return this.loadedClass;
        }

        @NotNull
        public final Method component2() {
            return this.method;
        }

        @NotNull
        public final Holder copy(@NotNull Class<?> loadedClass, @NotNull Method method) {
            Intrinsics.checkNotNullParameter(loadedClass, (String)"loadedClass");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            return new Holder(loadedClass, method);
        }

        public static /* synthetic */ Holder copy$default(Holder holder, Class clazz, Method method, int n, Object object) {
            if ((n & 1) != 0) {
                clazz = holder.loadedClass;
            }
            if ((n & 2) != 0) {
                method = holder.method;
            }
            return holder.copy(clazz, method);
        }

        @NotNull
        public String toString() {
            return "Holder(loadedClass=" + this.loadedClass + ", method=" + this.method + ")";
        }

        public int hashCode() {
            int result = this.loadedClass.hashCode();
            result = result * 31 + this.method.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Holder)) {
                return false;
            }
            Holder holder = (Holder)other;
            if (!Intrinsics.areEqual(this.loadedClass, holder.loadedClass)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.method, (Object)holder.method);
        }
    }
}

