/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.ui.awt.RelativePoint;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.intellij.plugins.markdown.ui.preview.PreviewLAFThemeStyles;
import org.intellij.plugins.markdown.ui.preview.jcef.MarkdownJCEFHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.jcef.zoomIndicator.PreviewZoomIndicatorManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u001d\b\u0004\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/ChangeFontSizeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "transform", "Lkotlin/Function1;", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Increase", "Decrease", "Lorg/intellij/plugins/markdown/ui/actions/ChangeFontSizeAction$Decrease;", "Lorg/intellij/plugins/markdown/ui/actions/ChangeFontSizeAction$Increase;", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nChangeFontSizeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeFontSizeAction.kt\norg/intellij/plugins/markdown/ui/actions/ChangeFontSizeAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,43:1\n1#2:44\n30#3,2:45\n*S KotlinDebug\n*F\n+ 1 ChangeFontSizeAction.kt\norg/intellij/plugins/markdown/ui/actions/ChangeFontSizeAction\n*L\n30#1:45,2\n*E\n"})
public abstract sealed class ChangeFontSizeAction
extends DumbAwareAction {
    @NotNull
    private final Function1<Integer, Integer> transform;

    private ChangeFontSizeAction(Function1<? super Integer, Integer> transform) {
        this.transform = transform;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(@NotNull AnActionEvent event) {
        Balloon balloon;
        Project project;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MarkdownPreviewFileEditor editor2 = MarkdownActionUtil.findMarkdownPreviewEditor(event);
        if (editor2 == null) {
            boolean $i$a$-checkNotNull-ChangeFontSizeAction$actionPerformed$22 = false;
            String $i$a$-checkNotNull-ChangeFontSizeAction$actionPerformed$22 = "Preview editor should be obtainable from the action event";
            throw new IllegalStateException($i$a$-checkNotNull-ChangeFontSizeAction$actionPerformed$22.toString());
        }
        WeakReference<MarkdownHtmlPanel> weakReference = editor2.getUserData(MarkdownPreviewFileEditor.Companion.getPREVIEW_BROWSER());
        Object object = weakReference;
        if (weakReference == null) return;
        if ((object = (MarkdownHtmlPanel)((Reference)object).get()) == null) {
            return;
        }
        Object preview = object;
        if (!(preview instanceof MarkdownJCEFHtmlPanel)) {
            return;
        }
        Integer n = ((MarkdownJCEFHtmlPanel)preview).getTemporaryFontSize();
        int currentSize = n != null ? n.intValue() : PreviewLAFThemeStyles.INSTANCE.getDefaultFontSize();
        int newSize = ((Number)this.transform.invoke((Object)currentSize)).intValue();
        ((MarkdownJCEFHtmlPanel)preview).changeFontSize$intellij_markdown(newSize, true);
        Project project2 = project = event.getProject();
        Object object2 = project2;
        if (project2 == null) return;
        ComponentManager $this$service$iv = (ComponentManager)object2;
        boolean $i$f$service = false;
        Class<PreviewZoomIndicatorManager> serviceClass$iv = PreviewZoomIndicatorManager.class;
        Object object3 = $this$service$iv.getService(serviceClass$iv);
        if (object3 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        PreviewZoomIndicatorManager previewZoomIndicatorManager = (PreviewZoomIndicatorManager)object3;
        object2 = previewZoomIndicatorManager;
        if (previewZoomIndicatorManager == null) return;
        Balloon balloon2 = ((PreviewZoomIndicatorManager)object2).createOrGetBalloon((MarkdownJCEFHtmlPanel)preview);
        Balloon balloon3 = balloon = balloon2;
        if (balloon3 == null) return;
        balloon3.show(RelativePoint.getSouthOf((JComponent)((MarkdownJCEFHtmlPanel)preview).getComponent()), Balloon.Position.below);
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MarkdownPreviewFileEditor editor2 = MarkdownActionUtil.findMarkdownPreviewEditor(event);
        event.getPresentation().setEnabledAndVisible(editor2 != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public /* synthetic */ ChangeFontSizeAction(Function1 transform, DefaultConstructorMarker $constructor_marker) {
        this((Function1<? super Integer, Integer>)transform);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/ChangeFontSizeAction$Decrease;", "Lorg/intellij/plugins/markdown/ui/actions/ChangeFontSizeAction;", "<init>", "()V", "intellij.markdown"})
    public static final class Decrease
    extends ChangeFontSizeAction {
        public Decrease() {
            super(Decrease::_init_$lambda$0, null);
        }

        private static final int _init_$lambda$0(int it) {
            return RangesKt.coerceAtLeast((int)(it - 1), (int)1);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/ChangeFontSizeAction$Increase;", "Lorg/intellij/plugins/markdown/ui/actions/ChangeFontSizeAction;", "<init>", "()V", "intellij.markdown"})
    public static final class Increase
    extends ChangeFontSizeAction {
        public Increase() {
            super(Increase::_init_$lambda$0, null);
        }

        private static final int _init_$lambda$0(int it) {
            return it + 1;
        }
    }
}

