/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.refactoring;

import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.ide.DataManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J!\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0002R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/httpClient/http/request/refactoring/HttpMoveRequestsIntention;", "Lcom/intellij/codeInsight/intention/AbstractIntentionAction;", "<init>", "()V", "getText", "", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "invoke", "", "moveHandler", "Lcom/intellij/refactoring/RefactoringActionHandler;", "getMoveHandler", "()Lcom/intellij/refactoring/RefactoringActionHandler;", "intellij.restClient"})
public final class HttpMoveRequestsIntention
extends AbstractIntentionAction {
    @NotNull
    public String getText() {
        String string = RestClientBundle.message("rest.client.refactoring.move.request.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile psiFile) {
        PsiElement elementAt;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        PsiElement psiElement = elementAt = psiFile.findElementAt(editor2.getCaretModel().getOffset());
        if (!((psiElement != null ? psiElement.getContainingFile() : null) instanceof HttpRequestPsiFile)) {
            return false;
        }
        HttpRequestBlock requestBlock = (HttpRequestBlock)PsiTreeUtil.getParentOfType((PsiElement)elementAt, HttpRequestBlock.class);
        return requestBlock != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        this.getMoveHandler().invoke(project, editor2, psiFile, DataManager.getInstance().getDataContext((Component)editor2.getComponent()));
    }

    private final RefactoringActionHandler getMoveHandler() {
        RefactoringActionHandler refactoringActionHandler = RefactoringActionHandlerFactory.getInstance().createMoveHandler();
        Intrinsics.checkNotNullExpressionValue((Object)refactoringActionHandler, (String)"createMoveHandler(...)");
        return refactoringActionHandler;
    }
}

