/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.merge.MergeThreesideViewer;
import com.intellij.diff.merge.TextMergeChange;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Condition;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H%J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0015J \u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0004J\u0017\u0010\u001d\u001a\t\u0018\u00010\u001e\u00a2\u0006\u0002\b\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H$J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012H$J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0015H$R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\""}, d2={"Lcom/intellij/diff/merge/ApplySelectedChangesActionBase;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "viewer", "Lcom/intellij/diff/merge/MergeThreesideViewer;", "<init>", "(Lcom/intellij/diff/merge/MergeThreesideViewer;)V", "getViewer", "()Lcom/intellij/diff/merge/MergeThreesideViewer;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "apply", "side", "Lcom/intellij/diff/util/ThreeSide;", "changes", "", "Lcom/intellij/diff/merge/TextMergeChange;", "isSomeChangeSelected", "", "getSelectedChanges", "isChangeSelected", "change", "lines", "Ljava/util/BitSet;", "getText", "", "Lorg/jetbrains/annotations/Nls;", "isVisible", "isEnabled", "intellij.platform.diff.impl"})
@SourceDebugExtension(value={"SMAP\nMergeThreesideViewerActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergeThreesideViewerActions.kt\ncom/intellij/diff/merge/ApplySelectedChangesActionBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n777#2:229\n873#2,2:230\n1807#2,3:232\n*S KotlinDebug\n*F\n+ 1 MergeThreesideViewerActions.kt\ncom/intellij/diff/merge/ApplySelectedChangesActionBase\n*L\n79#1:229\n79#1:230,2\n69#1:232,3\n*E\n"})
public abstract class ApplySelectedChangesActionBase
extends AnAction
implements DumbAware {
    @NotNull
    private final MergeThreesideViewer viewer;

    protected ApplySelectedChangesActionBase(@NotNull MergeThreesideViewer viewer) {
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        this.viewer = viewer;
    }

    @NotNull
    protected final MergeThreesideViewer getViewer() {
        return this.viewer;
    }

    @NotNull
    public final ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public final void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (DiffUtil.isFromShortcut(e)) {
            e.getPresentation().setEnabledAndVisible(true);
            return;
        }
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        ThreeSide side = this.viewer.getEditorSide(editor);
        if (side == null) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        if (!this.isVisible(side)) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        presentation2.setText(this.getText(side));
        presentation2.setEnabledAndVisible(this.isSomeChangeSelected(side) && !this.viewer.isExternalOperationInProgress());
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        ThreeSide threeSide = this.viewer.getEditorSide(editor2);
        if (threeSide == null) {
            return;
        }
        ThreeSide side = threeSide;
        List<TextMergeChange> selectedChanges = this.getSelectedChanges(side);
        if (selectedChanges.isEmpty()) {
            return;
        }
        Object[] objectArray = new Object[]{e.getPresentation().getText()};
        String string = DiffBundle.message((String)"message.do.in.merge.command", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String title = string;
        this.viewer.executeMergeCommand(title, selectedChanges.size() > 1, selectedChanges, () -> ApplySelectedChangesActionBase.actionPerformed$lambda$0(this, side, selectedChanges));
    }

    @RequiresWriteLock
    protected abstract void apply(@NotNull ThreeSide var1, @NotNull List<TextMergeChange> var2);

    public final boolean isSomeChangeSelected(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        EditorEx editorEx = this.viewer.getEditor(side);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor(...)");
        EditorEx editor = editorEx;
        return DiffUtil.isSomeRangeSelected((Editor)editor, (Condition<? super BitSet>)((Condition)arg_0 -> ApplySelectedChangesActionBase.isSomeChangeSelected$lambda$0(this, side, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @NotNull
    protected List<TextMergeChange> getSelectedChanges(@NotNull ThreeSide side) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        EditorEx editorEx = this.viewer.getEditor(side);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor(...)");
        EditorEx editor = editorEx;
        BitSet bitSet = DiffUtil.getSelectedLines((Editor)editor);
        Intrinsics.checkNotNullExpressionValue((Object)bitSet, (String)"getSelectedLines(...)");
        BitSet lines = bitSet;
        List<TextMergeChange> list = this.viewer.getChanges();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getChanges(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextMergeChange change = (TextMergeChange)element$iv$iv;
            boolean bl = false;
            if (!this.isChangeSelected(change, lines, side)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    protected final boolean isChangeSelected(@NotNull TextMergeChange change, @NotNull BitSet lines, @NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        if (!this.isEnabled(change)) {
            return false;
        }
        int line1 = change.getStartLine(side);
        int line2 = change.getEndLine(side);
        return DiffUtil.isSelectedByLine(lines, line1, line2);
    }

    @Nullable
    protected abstract String getText(@NotNull ThreeSide var1);

    protected abstract boolean isVisible(@NotNull ThreeSide var1);

    protected abstract boolean isEnabled(@NotNull TextMergeChange var1);

    private static final void actionPerformed$lambda$0(ApplySelectedChangesActionBase this$0, ThreeSide $side, List $selectedChanges) {
        this$0.apply($side, $selectedChanges);
    }

    private static final boolean isSomeChangeSelected$lambda$0(ApplySelectedChangesActionBase this$0, ThreeSide $side, BitSet lines) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
            List<TextMergeChange> list = this$0.viewer.getAllChanges();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAllChanges(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TextMergeChange change = (TextMergeChange)element$iv;
                    boolean bl2 = false;
                    if (!this$0.isChangeSelected(change, lines, $side)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

