/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.combined;

import com.intellij.diff.EditorDiffViewer;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.tools.combined.BlockBounds;
import com.intellij.diff.tools.combined.CombinedDiffBlocksPanel;
import com.intellij.diff.tools.combined.CombinedDiffKeysKt;
import com.intellij.diff.tools.combined.CombinedDiffViewer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\nH\u0002\u001a\u0018\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u0014\u0010\u001c\u001a\u00020\u0012*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\"\u0017\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n8G\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u001a\u0010\u0011\u001a\u00020\u0012*\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013\u00a8\u0006 "}, d2={"runPreservingViewportContent", "", "scroll", "Lcom/intellij/ui/components/JBScrollPane;", "blocksPanel", "Lcom/intellij/diff/tools/combined/CombinedDiffBlocksPanel;", "run", "Lkotlin/Function0;", "currentEditor", "Lcom/intellij/openapi/editor/Editor;", "Lcom/intellij/diff/FrameDiffTool$DiffViewer;", "getCurrentEditor", "(Lcom/intellij/diff/FrameDiffTool$DiffViewer;)Lcom/intellij/openapi/editor/Editor;", "editors", "", "getEditors", "(Lcom/intellij/diff/FrameDiffTool$DiffViewer;)Ljava/util/List;", "isEditorBased", "", "(Lcom/intellij/diff/FrameDiffTool$DiffViewer;)Z", "configureEditorForCombinedDiff", "viewer", "removeAdditionalLines", "disableAdditionalPageAtBottom", "installCombinedDiffViewer", "newViewer", "combinedDiffViewer", "Lcom/intellij/diff/tools/combined/CombinedDiffViewer;", "intersects", "Ljava/awt/Rectangle;", "bb", "Lcom/intellij/diff/tools/combined/BlockBounds;", "intellij.platform.diff.impl"})
@SourceDebugExtension(value={"SMAP\nCombinedDiffViewer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CombinedDiffViewer.kt\ncom/intellij/diff/tools/combined/CombinedDiffViewerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,962:1\n231#2,2:963\n1915#2,2:965\n1915#2,2:967\n*S KotlinDebug\n*F\n+ 1 CombinedDiffViewer.kt\ncom/intellij/diff/tools/combined/CombinedDiffViewerKt\n*L\n906#1:963,2\n935#1:965,2\n948#1:967,2\n*E\n"})
public final class CombinedDiffViewerKt {
    private static final void runPreservingViewportContent(JBScrollPane scroll, CombinedDiffBlocksPanel blocksPanel, Function0<Unit> run) {
        Object element$iv2;
        Rectangle newViewRect;
        boolean isTopBoundAnchor;
        int diff;
        block5: {
            Rectangle viewRect = scroll.getViewport().getViewRect();
            BlockBounds anchorBlock = null;
            diff = 0;
            isTopBoundAnchor = false;
            for (BlockBounds block : blocksPanel.getBlockBounds()) {
                int minY = block.getMinY();
                int maxY = block.getMaxY();
                Intrinsics.checkNotNull((Object)viewRect);
                if (!CombinedDiffViewerKt.intersects(viewRect, block)) continue;
                if (minY == (int)viewRect.getMinY()) {
                    anchorBlock = block;
                    isTopBoundAnchor = true;
                    break;
                }
                if ((double)maxY >= viewRect.getMinY() && (double)maxY <= viewRect.getMaxY()) {
                    anchorBlock = block;
                    diff = MathKt.roundToInt((double)((double)maxY - viewRect.getMinY()));
                    break;
                }
                if (!((double)maxY > viewRect.getMaxY()) || !((double)minY < viewRect.getMinY())) continue;
                anchorBlock = block;
                isTopBoundAnchor = true;
                diff = (int)((double)minY - viewRect.getMinY());
                break;
            }
            run.invoke();
            if (anchorBlock == null) {
                return;
            }
            newViewRect = scroll.getViewport().getViewRect();
            Iterable $this$first$iv = blocksPanel.getBlockBounds();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                BlockBounds it = (BlockBounds)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getBlockId(), (Object)anchorBlock.getBlockId())) continue;
                break block5;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        BlockBounds newBlockRect = (BlockBounds)element$iv2;
        newViewRect.y = isTopBoundAnchor ? newBlockRect.getMinY() : newBlockRect.getMaxY();
        newViewRect.y -= diff;
        scroll.getViewport().setViewPosition(new Point(newViewRect.x, newViewRect.y));
    }

    @ApiStatus.Internal
    @Nullable
    public static final Editor getCurrentEditor(@NotNull FrameDiffTool.DiffViewer $this$currentEditor) {
        Intrinsics.checkNotNullParameter((Object)$this$currentEditor, (String)"<this>");
        return $this$currentEditor instanceof EditorDiffViewer ? ((EditorDiffViewer)$this$currentEditor).getCurrentEditor() : null;
    }

    @NotNull
    public static final List<Editor> getEditors(@NotNull FrameDiffTool.DiffViewer $this$editors) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$editors, (String)"<this>");
        if ($this$editors instanceof EditorDiffViewer) {
            List list2 = ((EditorDiffViewer)$this$editors).getEditors();
            list = list2;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEditors(...)");
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final boolean isEditorBased(FrameDiffTool.DiffViewer $this$isEditorBased) {
        return $this$isEditorBased instanceof EditorDiffViewer;
    }

    private static final void configureEditorForCombinedDiff(FrameDiffTool.DiffViewer viewer) {
        CombinedDiffViewerKt.removeAdditionalLines(viewer);
        CombinedDiffViewerKt.disableAdditionalPageAtBottom(viewer);
    }

    private static final void removeAdditionalLines(FrameDiffTool.DiffViewer viewer) {
        Iterable $this$forEach$iv = CombinedDiffViewerKt.getEditors(viewer);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Editor editor = (Editor)element$iv;
            boolean bl = false;
            editor.getSettings().setAdditionalLinesCount(0);
            EditorImpl editorImpl = editor instanceof EditorImpl ? (EditorImpl)editor : null;
            if (editorImpl == null) continue;
            editorImpl.resetSizes();
        }
    }

    private static final void disableAdditionalPageAtBottom(FrameDiffTool.DiffViewer viewer) {
        for (Editor editor : CombinedDiffViewerKt.getEditors(viewer)) {
            editor.getSettings().setAdditionalPageAtBottom(false);
        }
    }

    private static final void installCombinedDiffViewer(FrameDiffTool.DiffViewer newViewer, CombinedDiffViewer combinedDiffViewer) {
        Iterable $this$forEach$iv = CombinedDiffViewerKt.getEditors(newViewer);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Editor it = (Editor)element$iv;
            boolean bl = false;
            it.putUserData(CombinedDiffKeysKt.getCOMBINED_DIFF_VIEWER_KEY(), (Object)combinedDiffViewer);
        }
    }

    private static final boolean intersects(Rectangle $this$intersects, BlockBounds bb) {
        return (double)bb.getMinY() >= $this$intersects.getMinY() && (double)bb.getMinY() < $this$intersects.getMaxY() || (double)bb.getMaxY() > $this$intersects.getMinY() && (double)bb.getMaxY() <= $this$intersects.getMaxY() || (double)bb.getMinY() <= $this$intersects.getMinY() && (double)bb.getMaxY() >= $this$intersects.getMaxY();
    }

    public static final /* synthetic */ void access$configureEditorForCombinedDiff(FrameDiffTool.DiffViewer viewer) {
        CombinedDiffViewerKt.configureEditorForCombinedDiff(viewer);
    }

    public static final /* synthetic */ void access$installCombinedDiffViewer(FrameDiffTool.DiffViewer newViewer, CombinedDiffViewer combinedDiffViewer) {
        CombinedDiffViewerKt.installCombinedDiffViewer(newViewer, combinedDiffViewer);
    }

    public static final /* synthetic */ void access$runPreservingViewportContent(JBScrollPane scroll, CombinedDiffBlocksPanel blocksPanel, Function0 run) {
        CombinedDiffViewerKt.runPreservingViewportContent(scroll, blocksPanel, (Function0<Unit>)run);
    }

    public static final /* synthetic */ boolean access$isEditorBased(FrameDiffTool.DiffViewer $receiver) {
        return CombinedDiffViewerKt.isEditorBased($receiver);
    }

    public static final /* synthetic */ boolean access$intersects(Rectangle $receiver, BlockBounds bb) {
        return CombinedDiffViewerKt.intersects($receiver, bb);
    }
}

