/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UnifiedEditorRangeHighlighter {
    @NotNull
    private final List<Element> myPieces;

    UnifiedEditorRangeHighlighter(@Nullable Project project, @NotNull Document document1, @NotNull Document document2, @NotNull List<? extends HighlightRange> ranges) {
        if (document1 == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(0);
        }
        if (document2 == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(1);
        }
        if (ranges == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(2);
        }
        this.myPieces = new ArrayList<Element>();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        MarkupModelEx model1 = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)document1, (Project)project, (boolean)false);
        MarkupModelEx model2 = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)document2, (Project)project, (boolean)false);
        this.init(model1, model2, ranges);
    }

    private void init(@Nullable MarkupModelEx model1, @Nullable MarkupModelEx model2, @NotNull List<? extends HighlightRange> ranges) {
        if (ranges == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(3);
        }
        for (HighlightRange highlightRange : ranges) {
            if (highlightRange.getSide().isLeft()) {
                if (model1 == null) continue;
                this.processRange(model1, highlightRange);
                continue;
            }
            if (model2 == null) continue;
            this.processRange(model2, highlightRange);
        }
    }

    private void processRange(@NotNull MarkupModelEx model, @NotNull HighlightRange range) {
        if (model == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(4);
        }
        if (range == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(5);
        }
        TextRange base = range.getBase();
        TextRange changed = range.getChanged();
        int changedLength = changed.getEndOffset() - changed.getStartOffset();
        model.processRangeHighlightersOverlappingWith(changed.getStartOffset(), changed.getEndOffset(), marker -> {
            int relativeStart = Math.max(marker.getStartOffset() - changed.getStartOffset(), 0);
            int relativeEnd = Math.min(marker.getEndOffset() - changed.getStartOffset(), changedLength);
            int newStart = base.getStartOffset() + relativeStart;
            int newEnd = base.getStartOffset() + relativeEnd;
            if (newEnd - newStart < 0) {
                return true;
            }
            if (newEnd == newStart && !marker.isAfterEndOfLine()) {
                return true;
            }
            if (this.myPieces.size() % 1014 == 0) {
                ProgressManager.checkCanceled();
            }
            this.myPieces.add(new Element((RangeHighlighterEx)marker, newStart, newEnd));
            return true;
        });
    }

    public static void erase(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(6);
        }
        MarkupModel model = DocumentMarkupModel.forDocument((Document)document, (Project)project, (boolean)true);
        model.removeAllHighlighters();
    }

    public void apply(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            UnifiedEditorRangeHighlighter.$$$reportNull$$$0(7);
        }
        MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)document, (Project)project, (boolean)true);
        for (Element piece : this.myPieces) {
            RangeHighlighterEx delegate = piece.getDelegate();
            if (!delegate.isValid()) continue;
            model.addRangeHighlighterAndChangeAttributes(delegate.getTextAttributesKey(), piece.getStart(), piece.getEnd(), delegate.getLayer(), delegate.getTargetArea(), false, ex -> ex.copyFrom(delegate));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document2";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedEditorRangeHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processRange";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "erase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Element {
        @NotNull
        private final RangeHighlighterEx myDelegate;
        private final int myStart;
        private final int myEnd;

        Element(@NotNull RangeHighlighterEx delegate, int start, int end) {
            if (delegate == null) {
                Element.$$$reportNull$$$0(0);
            }
            this.myDelegate = delegate;
            this.myStart = start;
            this.myEnd = end;
        }

        @NotNull
        public RangeHighlighterEx getDelegate() {
            RangeHighlighterEx rangeHighlighterEx = this.myDelegate;
            if (rangeHighlighterEx == null) {
                Element.$$$reportNull$$$0(1);
            }
            return rangeHighlighterEx;
        }

        public int getStart() {
            return this.myStart;
        }

        public int getEnd() {
            return this.myEnd;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedEditorRangeHighlighter$Element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedEditorRangeHighlighter$Element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

