/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.vcs.ex.BlocksRefresher;
import com.intellij.openapi.vcs.ex.BulkRangeChangeHandler;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.openapi.vcs.ex.DocumentTrackerKt;
import com.intellij.openapi.vcs.ex.RangeChangeHandler;
import com.intellij.openapi.vcs.ex.RangeExclusionState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u0006\u0010\u0015\u001a\u00020\u000eJ\u0006\u0010\u0016\u001a\u00020\u0013J.\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u000eJ\u0016\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!J&\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020!J\u0016\u0010)\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%2\u0006\u0010*\u001a\u00020+J(\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u0006\u0010$\u001a\u00020%2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020/0.J\u001e\u00100\u001a\u00020\u00132\f\u00101\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\u0006\u00102\u001a\u00020\nH\u0002J\u0018\u00103\u001a\u00020\u00132\u0006\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020\nH\u0002J\u0010\u00104\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u000eH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/openapi/vcs/ex/LineTracker;", "", "handlers", "", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "originalChanges", "Lcom/intellij/diff/util/Range;", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "value", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "blocks", "getBlocks", "()Ljava/util/List;", "", "isDirty", "()Z", "forceMergeNearbyBlocks", "setRanges", "", "ranges", "dirty", "destroy", "refreshDirty", "text1", "", "text2", "lineOffsets1", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "lineOffsets2", "fastRefresh", "resetTrackerState", "lineCount1", "", "lineCount2", "rangeChanged", "side", "Lcom/intellij/diff/util/Side;", "startLine", "beforeLength", "afterLength", "rangesChanged", "iterable", "Lcom/intellij/diff/comparison/iterables/FairDiffIterable;", "partiallyApplyBlocks", "condition", "Lkotlin/Function1;", "Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "onRangesChanged", "before", "after", "onRangeShifted", "afterBulkRangeChange", "intellij.platform.diff.impl"})
@SourceDebugExtension(value={"SMAP\nDocumentTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/LineTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1400:1\n1586#2:1401\n1661#2,3:1402\n1586#2:1405\n1661#2,3:1406\n1915#2,2:1409\n1915#2,2:1411\n1915#2,2:1413\n*S KotlinDebug\n*F\n+ 1 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/LineTracker\n*L\n615#1:1401\n615#1:1402,3\n624#1:1405\n624#1:1406,3\n758#1:1409,2\n762#1:1411,2\n766#1:1413,2\n*E\n"})
final class LineTracker {
    @NotNull
    private final List<DocumentTracker.Handler> handlers;
    @NotNull
    private List<DocumentTracker.Block> blocks;
    private boolean isDirty;
    private boolean forceMergeNearbyBlocks;

    /*
     * WARNING - void declaration
     */
    public LineTracker(@NotNull List<? extends DocumentTracker.Handler> handlers, @NotNull List<Range> originalChanges) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(handlers, (String)"handlers");
        Intrinsics.checkNotNullParameter(originalChanges, (String)"originalChanges");
        this.handlers = handlers;
        Iterable iterable = originalChanges;
        LineTracker lineTracker = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Range range = (Range)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DocumentTracker.Block((Range)it, false, false));
        }
        lineTracker.blocks = (List)destination$iv$iv;
    }

    @NotNull
    public final List<DocumentTracker.Block> getBlocks() {
        return this.blocks;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRanges(@NotNull List<Range> ranges, boolean dirty) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        Iterable $this$map$iv = ranges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Range range = (Range)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DocumentTracker.Block((Range)it, dirty, false));
        }
        List newBlocks = (List)destination$iv$iv;
        for (DocumentTracker.Block block : newBlocks) {
            this.onRangesChanged(CollectionsKt.emptyList(), block);
        }
        this.blocks = newBlocks;
        this.isDirty = dirty;
        this.forceMergeNearbyBlocks = false;
        this.afterBulkRangeChange(this.isDirty);
    }

    public final void destroy() {
        this.blocks = CollectionsKt.emptyList();
    }

    public final void refreshDirty(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, boolean fastRefresh) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)lineOffsets1, (String)"lineOffsets1");
        Intrinsics.checkNotNullParameter((Object)lineOffsets2, (String)"lineOffsets2");
        if (!this.isDirty) {
            return;
        }
        BlocksRefresher.Result result = new BlocksRefresher(this.handlers, text1, text2, lineOffsets1, lineOffsets2, this.forceMergeNearbyBlocks).refresh(this.blocks, fastRefresh);
        this.blocks = result.getNewBlocks();
        this.isDirty = false;
        this.forceMergeNearbyBlocks = false;
        this.afterBulkRangeChange(this.isDirty);
    }

    public final void resetTrackerState(int lineCount1, int lineCount2) {
        Range fullRange = new Range(0, lineCount1, 0, lineCount2);
        DocumentTracker.Block dirtyBlock = new DocumentTracker.Block(fullRange, true, false);
        this.onRangesChanged(CollectionsKt.emptyList(), dirtyBlock);
        this.blocks = CollectionsKt.listOf((Object)dirtyBlock);
        this.isDirty = true;
        this.forceMergeNearbyBlocks = false;
        this.afterBulkRangeChange(this.isDirty);
    }

    public final void rangeChanged(@NotNull Side side, int startLine, int beforeLength, int afterLength) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        RangeChangeHandler.Result data = new RangeChangeHandler().run(this.blocks, side, startLine, beforeLength, afterLength);
        this.onRangesChanged(data.getAffectedBlocks(), data.getNewAffectedBlock());
        int n = ((Collection)data.getAfterBlocks()).size();
        for (int i = 0; i < n; ++i) {
            this.onRangeShifted(data.getAfterBlocks().get(i), data.getNewAfterBlocks().get(i));
        }
        this.blocks = data.getNewBlocks();
        this.isDirty = !((Collection)data.getNewBlocks()).isEmpty();
        this.afterBulkRangeChange(this.isDirty);
    }

    public final void rangesChanged(@NotNull Side side, @NotNull FairDiffIterable iterable) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)iterable, (String)"iterable");
        List<DocumentTracker.Block> newBlocks = new BulkRangeChangeHandler(this.handlers, this.blocks, side).run(iterable);
        this.blocks = newBlocks;
        this.forceMergeNearbyBlocks = this.isDirty = !((Collection)newBlocks).isEmpty();
        this.afterBulkRangeChange(this.isDirty);
    }

    @NotNull
    public final List<Range> partiallyApplyBlocks(@NotNull Side side, @NotNull Function1<? super DocumentTracker.Block, ? extends RangeExclusionState> condition) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        List newBlocks = new ArrayList();
        List appliedRanges = new ArrayList();
        int shift = 0;
        for (DocumentTracker.Block block : this.blocks) {
            RangeExclusionState exclusionState = (RangeExclusionState)condition.invoke((Object)block);
            RangeExclusionState rangeExclusionState = exclusionState;
            if (Intrinsics.areEqual((Object)rangeExclusionState, (Object)RangeExclusionState.Included.INSTANCE)) {
                appliedRanges.add(block.getRange());
                shift += DocumentTrackerKt.access$getRangeDelta(block.getRange(), side);
                continue;
            }
            if (Intrinsics.areEqual((Object)rangeExclusionState, (Object)RangeExclusionState.Excluded.INSTANCE)) {
                DocumentTracker.Block newBlock = DocumentTrackerKt.access$shift(block, side, shift);
                this.onRangeShifted(block, newBlock);
                newBlocks.add(newBlock);
                continue;
            }
            if (rangeExclusionState instanceof RangeExclusionState.Partial) {
                Ref.IntRef deletedCount = new Ref.IntRef();
                Ref.IntRef addedCount = new Ref.IntRef();
                Ref.IntRef partialShift = new Ref.IntRef();
                ((RangeExclusionState.Partial)exclusionState).iterateIncludedDeletionRanges(block.getRange(), (Function1<? super Range, Unit>)((Function1)arg_0 -> LineTracker.partiallyApplyBlocks$lambda$0(appliedRanges, deletedCount, partialShift, side, arg_0)));
                ((RangeExclusionState.Partial)exclusionState).iterateIncludedAdditionRanges(block.getRange(), (Function1<? super Range, Unit>)((Function1)arg_0 -> LineTracker.partiallyApplyBlocks$lambda$1(appliedRanges, addedCount, partialShift, side, arg_0)));
                Range newRange = side.isLeft() ? new Range(block.getRange().start1 + shift, block.getRange().end1 + shift + addedCount.element - deletedCount.element, block.getRange().start2, block.getRange().end2) : new Range(block.getRange().start1, block.getRange().end1, block.getRange().start2 + shift, block.getRange().end2 + shift + deletedCount.element - addedCount.element);
                DocumentTracker.Block newBlock = new DocumentTracker.Block(newRange, true, false);
                shift += partialShift.element;
                this.onRangesChanged(CollectionsKt.listOf((Object)block), newBlock);
                ((Collection)newBlocks).add(newBlock);
                this.isDirty = true;
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        this.blocks = newBlocks;
        this.afterBulkRangeChange(this.isDirty);
        return appliedRanges;
    }

    private final void onRangesChanged(List<DocumentTracker.Block> before, DocumentTracker.Block after) {
        Iterable $this$forEach$iv = this.handlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocumentTracker.Handler it = (DocumentTracker.Handler)element$iv;
            boolean bl = false;
            it.onRangesChanged(before, after);
        }
    }

    private final void onRangeShifted(DocumentTracker.Block before, DocumentTracker.Block after) {
        Iterable $this$forEach$iv = this.handlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocumentTracker.Handler it = (DocumentTracker.Handler)element$iv;
            boolean bl = false;
            it.onRangeShifted(before, after);
        }
    }

    private final void afterBulkRangeChange(boolean isDirty) {
        Iterable $this$forEach$iv = this.handlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocumentTracker.Handler it = (DocumentTracker.Handler)element$iv;
            boolean bl = false;
            it.afterBulkRangeChange(isDirty);
        }
    }

    private static final Unit partiallyApplyBlocks$lambda$0(List $appliedRanges, Ref.IntRef $deletedCount, Ref.IntRef $partialShift, Side $side, Range deletedRange) {
        Intrinsics.checkNotNullParameter((Object)deletedRange, (String)"deletedRange");
        ((Collection)$appliedRanges).add(deletedRange);
        $deletedCount.element += deletedRange.end1 - deletedRange.start1;
        $partialShift.element += DocumentTrackerKt.access$getRangeDelta(deletedRange, $side);
        return Unit.INSTANCE;
    }

    private static final Unit partiallyApplyBlocks$lambda$1(List $appliedRanges, Ref.IntRef $addedCount, Ref.IntRef $partialShift, Side $side, Range addedRange) {
        Intrinsics.checkNotNullParameter((Object)addedRange, (String)"addedRange");
        ((Collection)$appliedRanges).add(addedRange);
        $addedCount.element += addedRange.end2 - addedRange.start2;
        $partialShift.element += DocumentTrackerKt.access$getRangeDelta(addedRange, $side);
        return Unit.INSTANCE;
    }
}

