/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.connection.backend.statistics;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.connection.backend.statistics.CwmGuestsConnectionStatisticsManager;
import com.intellij.cwm.plugin.join.BackendJoinLinkManager;
import com.intellij.cwm.plugin.join.JoinLinkData;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.split.connection.protocol.transport.WireTransportListener;
import com.intellij.platform.split.connection.protocol.transport.creator.TransportInfo;
import com.jetbrains.rd.platform.codeWithMe.statistics.CodeWithMeLifecycleUsagesCollector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/cwm/connection/backend/statistics/CwmStatisticsGuestTransportListener;", "Lcom/intellij/platform/split/connection/protocol/transport/WireTransportListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "transportConnected", "", "clientId", "Lcom/intellij/codeWithMe/ClientId;", "transport", "Lcom/intellij/platform/split/connection/protocol/transport/creator/TransportInfo;", "transportDisconnected", "intellij.cwm.connection.backend"})
@SourceDebugExtension(value={"SMAP\nCwmStatisticsGuestTransportListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CwmStatisticsGuestTransportListener.kt\ncom/intellij/cwm/connection/backend/statistics/CwmStatisticsGuestTransportListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,32:1\n30#2,2:33\n23#3:35\n23#3:36\n*S KotlinDebug\n*F\n+ 1 CwmStatisticsGuestTransportListener.kt\ncom/intellij/cwm/connection/backend/statistics/CwmStatisticsGuestTransportListener\n*L\n15#1:33,2\n18#1:35\n27#1:36\n*E\n"})
public final class CwmStatisticsGuestTransportListener
implements WireTransportListener {
    @NotNull
    private final Project project;

    public CwmStatisticsGuestTransportListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void transportConnected(@NotNull ClientId clientId, @NotNull TransportInfo transport) {
        String sessionId;
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Object object = ClientSessionsManager.Companion.getProjectSession(this.project, clientId);
        if (object != null) {
            ComponentManager $this$service$iv = (ComponentManager)object;
            boolean $i$f$service = false;
            Class<CwmGuestsConnectionStatisticsManager> serviceClass$iv = CwmGuestsConnectionStatisticsManager.class;
            Object object2 = $this$service$iv.getService(serviceClass$iv);
            if (object2 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            object = (CwmGuestsConnectionStatisticsManager)((Object)object2);
            if (object != null) {
                object.setLastTransportInfo(transport);
            }
        }
        JoinLinkData joinLinkData = BackendJoinLinkManager.Companion.getInstance(this.project).getJoinLinkData();
        String string = sessionId = joinLinkData != null ? joinLinkData.getSessionId() : null;
        if (sessionId == null) {
            CwmStatisticsGuestTransportListener $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CwmStatisticsGuestTransportListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("sessionId is null when transportConnected");
            return;
        }
        CodeWithMeLifecycleUsagesCollector.CodeWithMeLifecycleLogger.INSTANCE.onTransportConnected(sessionId, clientId, transport.getTransportType());
    }

    public void transportDisconnected(@NotNull ClientId clientId, @NotNull TransportInfo transport) {
        String sessionId;
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        JoinLinkData joinLinkData = BackendJoinLinkManager.Companion.getInstance(this.project).getJoinLinkData();
        String string = sessionId = joinLinkData != null ? joinLinkData.getSessionId() : null;
        if (sessionId == null) {
            CwmStatisticsGuestTransportListener $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CwmStatisticsGuestTransportListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("sessionId is null when transportConnected");
            return;
        }
        CodeWithMeLifecycleUsagesCollector.CodeWithMeLifecycleLogger.INSTANCE.onTransportDisconnected(sessionId, clientId, transport.getTransportType());
    }
}

