/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gateway.eel.descriptors;

import com.intellij.gateway.eel.descriptors.GatewaySshEelDescriptor;
import com.intellij.platform.eel.tcp.TcpEelPathParser;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/gateway/eel/descriptors/GatewaySshTcpEelPathParser;", "Lcom/intellij/platform/eel/tcp/TcpEelPathParser;", "<init>", "()V", "isPathCompatible", "", "path", "", "extractInternalMachineId", "Ljava/nio/file/Path;", "toDescriptor", "Lcom/intellij/gateway/eel/descriptors/GatewaySshEelDescriptor;", "internalName", "intellij.gateway.eel"})
public final class GatewaySshTcpEelPathParser
implements TcpEelPathParser {
    public boolean isPathCompatible(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return StringsKt.startsWith$default((String)path, (String)"/tcp-ssh-", (boolean)false, (int)2, null);
    }

    @Nullable
    public String extractInternalMachineId(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!this.isPathCompatible(path)) {
            return null;
        }
        return StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)path, (String)"/tcp-", null, (int)2, null), (String)"/", null, (int)2, null);
    }

    @Nullable
    public final String extractInternalMachineId(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!this.isPathCompatible(((Object)path).toString())) {
            return null;
        }
        Path path2 = path.getRoot();
        return path2 != null ? ((Object)path2).toString() : null;
    }

    @NotNull
    public GatewaySshEelDescriptor toDescriptor(@NotNull String internalName) {
        Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
        String sshConfigId = StringsKt.drop((String)StringsKt.substringAfter$default((String)internalName, (String)"ssh", null, (int)2, null), (int)1);
        return new GatewaySshEelDescriptor(sshConfigId);
    }
}

