/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.fullLine.core.utils.common;

import com.intellij.codeInsight.inline.completion.InlineCompletionRequest;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\f\u0010\n\u001a\u00020\u000b*\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/fullLine/core/utils/common/InlineCompletionInjectedEditorUtils;", "", "<init>", "()V", "getInjectedEditorOrEditor", "Lcom/intellij/openapi/editor/Editor;", "request", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionRequest;", "getInjectedFileAt", "Lcom/intellij/psi/PsiFile;", "shouldInjectedLanguageBeChecked", "", "intellij.fullLine.core.utils.common"})
@ApiStatus.Internal
public final class InlineCompletionInjectedEditorUtils {
    @NotNull
    public static final InlineCompletionInjectedEditorUtils INSTANCE = new InlineCompletionInjectedEditorUtils();

    private InlineCompletionInjectedEditorUtils() {
    }

    @JvmStatic
    @NotNull
    public static final Editor getInjectedEditorOrEditor(@NotNull InlineCompletionRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Editor editor2 = InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)request.getEditor(), (PsiFile)InlineCompletionInjectedEditorUtils.getInjectedFileAt(request));
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getInjectedEditorForInjectedFile(...)");
        return editor2;
    }

    @JvmStatic
    @NotNull
    public static final PsiFile getInjectedFileAt(@NotNull InlineCompletionRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!INSTANCE.shouldInjectedLanguageBeChecked(request.getFile())) {
            return request.getFile();
        }
        PsiFile originalFile = request.getFile();
        Project project2 = originalFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        int offset = request.getEndOffset();
        List list2 = InjectedLanguageManager.getInstance((Project)project3).getCachedInjectedDocumentsInRange(originalFile, (TextRange)ProperTextRange.create((int)offset, (int)offset));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getCachedInjectedDocumentsInRange(...)");
        List injectedDocuments = list2;
        for (DocumentWindow injectedDocument : injectedDocuments) {
            if (!injectedDocument.isValid() || !injectedDocument.containsRange(offset, offset)) continue;
            PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)project3).getPsiFile((Document)injectedDocument);
            if (psiFile2 == null) continue;
            PsiFile injectedFile = psiFile2;
            return injectedFile;
        }
        return originalFile;
    }

    private final boolean shouldInjectedLanguageBeChecked(PsiFile $this$shouldInjectedLanguageBeChecked) {
        return Intrinsics.areEqual((Object)$this$shouldInjectedLanguageBeChecked.getFileType().getDefaultExtension(), (Object)"ipynb");
    }
}

