/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.terminal.completion.validation;

import com.intellij.ml.llm.terminal.completion.ParsedCommand;
import com.intellij.ml.llm.terminal.completion.validation.CloudResourceDamageValidator;
import com.intellij.ml.llm.terminal.completion.validation.ContainerHavocValidator;
import com.intellij.ml.llm.terminal.completion.validation.DataLossValidator;
import com.intellij.ml.llm.terminal.completion.validation.DatabaseDamageValidator;
import com.intellij.ml.llm.terminal.completion.validation.NetworkDisruptionValidator;
import com.intellij.ml.llm.terminal.completion.validation.PackageCorruptionValidator;
import com.intellij.ml.llm.terminal.completion.validation.RiskCategory;
import com.intellij.ml.llm.terminal.completion.validation.SecurityRiskValidator;
import com.intellij.ml.llm.terminal.completion.validation.ServiceDisruptionValidator;
import com.intellij.ml.llm.terminal.completion.validation.SystemCorruptionValidator;
import com.intellij.ml.llm.terminal.completion.validation.ValidationResult;
import com.intellij.ml.llm.terminal.completion.validation.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0000\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"systemCriticalPaths", "", "", "getSystemCriticalPaths", "()Ljava/util/List;", "dataLossCommands", "", "getDataLossCommands", "()Ljava/util/Set;", "validators", "Lcom/intellij/ml/llm/terminal/completion/validation/Validator;", "validateCommand", "Lcom/intellij/ml/llm/terminal/completion/validation/ValidationResult;", "command", "intellij.ml.llm.terminal.completion"})
@SourceDebugExtension(value={"SMAP\nValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Validator.kt\ncom/intellij/ml/llm/terminal/completion/validation/ValidatorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1642#2,10:87\n1915#2:97\n1916#2:99\n1652#2:100\n1586#2:101\n1661#2,3:102\n1#3:98\n*S KotlinDebug\n*F\n+ 1 Validator.kt\ncom/intellij/ml/llm/terminal/completion/validation/ValidatorKt\n*L\n66#1:87,10\n66#1:97\n66#1:99\n66#1:100\n71#1:101\n71#1:102,3\n66#1:98\n*E\n"})
public final class ValidatorKt {
    @NotNull
    private static final List<String> systemCriticalPaths;
    @NotNull
    private static final Set<String> dataLossCommands;
    @NotNull
    private static final List<Validator> validators;

    @NotNull
    public static final List<String> getSystemCriticalPaths() {
        return systemCriticalPaths;
    }

    @NotNull
    public static final Set<String> getDataLossCommands() {
        return dataLossCommands;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ValidationResult validateCommand(@NotNull String command) {
        void $this$mapTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (((CharSequence)((Object)StringsKt.trim((CharSequence)command)).toString()).length() == 0) {
            return new ValidationResult(command, RiskCategory.NONE, true, "Empty command poses no risk", null, 16, null);
        }
        ParsedCommand parsed = new ParsedCommand(command);
        if (Intrinsics.areEqual((Object)parsed.getBaseCommand(), (Object)"sudo")) {
            int sudoStart = StringsKt.indexOf$default((CharSequence)parsed.getFullCommand(), (String)"sudo", (int)0, (boolean)false, (int)6, null);
            String string = parsed.getFullCommand().substring(sudoStart + 5);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String sudoCommand = string;
            return ValidatorKt.validateCommand(sudoCommand);
        }
        Iterable $this$mapNotNull$iv = validators;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair<RiskCategory, String> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Validator it = (Validator)element$iv$iv;
            boolean bl2 = false;
            if (it.validate(parsed) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List risks = (List)destination$iv$iv;
        Pair primaryRisk = (Pair)CollectionsKt.firstOrNull((List)risks);
        Object object = primaryRisk;
        if (object == null || (object = (RiskCategory)((Object)object.getFirst())) == null) {
            object = RiskCategory.NONE;
        }
        Object category = object;
        Iterable $this$map$iv = risks;
        boolean $i$f$map = false;
        $this$forEach$iv$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair bl = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl4 = false;
            collection.add((String)it.getSecond());
        }
        List riskDescriptions = (List)destination$iv$iv2;
        String detailMessage = risks.isEmpty() ? "Command appears safe. No significant risks detected." : "Risk detected: " + CollectionsKt.joinToString$default((Iterable)riskDescriptions, (CharSequence)"; ", null, null, (int)0, null, null, (int)62, null);
        return new ValidationResult(command, (RiskCategory)((Object)category), category == RiskCategory.NONE, detailMessage, riskDescriptions);
    }

    static {
        Object[] objectArray = new String[]{"/bin", "/sbin", "/lib", "/lib32", "/lib64", "/usr", "/usr/bin", "/usr/sbin", "/usr/lib", "/boot", "/etc", "/dev", "/proc", "/sys", "/System", "/Library", "/Applications"};
        systemCriticalPaths = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"rm", "rmdir", "unlink", "shred", "wipe", "scrub", "truncate"};
        dataLossCommands = SetsKt.setOf((Object[])objectArray);
        objectArray = new Validator[]{new DataLossValidator(), new SystemCorruptionValidator(), new PackageCorruptionValidator(), new ServiceDisruptionValidator(), new ContainerHavocValidator(), new DatabaseDamageValidator(), new CloudResourceDamageValidator(), new NetworkDisruptionValidator(), new SecurityRiskValidator()};
        validators = CollectionsKt.listOf((Object[])objectArray);
    }
}

