/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.utils.graph;

import com.intellij.rml.dfa.utils.graph.Graph;
import com.intellij.rml.dfa.utils.graph.GraphImpl;
import com.intellij.rml.dfa.utils.graph.IntGraphBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fJ\u0019\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0019\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u001b\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J\u0014\u0010\u0018\u001a\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aJ\u0013\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001cJ\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/rml/dfa/utils/graph/GraphBuilder;", "T", "", "<init>", "()V", "nodeToId", "", "", "idToNode", "builder", "Lcom/intellij/rml/dfa/utils/graph/IntGraphBuilder;", "getNodes", "", "incomingNodes", "node", "(Ljava/lang/Object;)Ljava/util/Set;", "outgoingNodes", "addNode", "(Ljava/lang/Object;)I", "addEdge", "", "from", "to", "(Ljava/lang/Object;Ljava/lang/Object;)V", "addSubGraph", "g", "Lcom/intellij/rml/dfa/utils/graph/Graph;", "removeNode", "(Ljava/lang/Object;)V", "getGraph", "intellij.rml.dfa"})
@SourceDebugExtension(value={"SMAP\nGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Graph.kt\ncom/intellij/rml/dfa/utils/graph/GraphBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,230:1\n1586#2:231\n1661#2,3:232\n1586#2:235\n1661#2,3:236\n1#3:239\n*S KotlinDebug\n*F\n+ 1 Graph.kt\ncom/intellij/rml/dfa/utils/graph/GraphBuilder\n*L\n164#1:231\n164#1:232,3\n168#1:235\n168#1:236,3\n*E\n"})
public class GraphBuilder<T> {
    @NotNull
    private final Map<T, Integer> nodeToId = new LinkedHashMap();
    @NotNull
    private final Map<Integer, T> idToNode = new LinkedHashMap();
    @NotNull
    private final IntGraphBuilder builder = new IntGraphBuilder();

    @NotNull
    public final Set<T> getNodes() {
        return this.nodeToId.keySet();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<T> incomingNodes(T node) {
        void $this$mapTo$iv$iv;
        Integer n = this.nodeToId.get(node);
        Intrinsics.checkNotNull((Object)n);
        Iterable $this$map$iv = this.builder.incomingNodes(((Number)n).intValue());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n2 = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            T t = this.idToNode.get((int)it);
            Intrinsics.checkNotNull(t);
            collection.add(t);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<T> outgoingNodes(T node) {
        void $this$mapTo$iv$iv;
        Integer n = this.nodeToId.get(node);
        Intrinsics.checkNotNull((Object)n);
        Iterable $this$map$iv = this.builder.outgoingNodes(((Number)n).intValue());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n2 = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            T t = this.idToNode.get((int)it);
            Intrinsics.checkNotNull(t);
            collection.add(t);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public final int addNode(T node) {
        Integer n = this.nodeToId.get(node);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            return it;
        }
        int nodeId = this.nodeToId.size();
        this.nodeToId.put(node, nodeId);
        this.idToNode.put(nodeId, node);
        this.builder.addNode(nodeId);
        return nodeId;
    }

    public final void addEdge(T from, T to) {
        this.builder.addEdge(this.addNode(from), this.addNode(to));
    }

    public final void addSubGraph(@NotNull Graph<T> g) {
        Intrinsics.checkNotNullParameter(g, (String)"g");
        for (T pair : g.nodes()) {
            this.addNode(pair);
        }
        for (Pair pair : g.edges()) {
            Object v = pair.component1();
            Object to = pair.component2();
            this.addEdge(v, to);
        }
    }

    public final void removeNode(T node) {
        Integer n = this.nodeToId.get(node);
        Intrinsics.checkNotNull((Object)n);
        this.builder.removeNode(((Number)n).intValue());
        this.nodeToId.remove(node);
    }

    @NotNull
    public final Graph<T> getGraph() {
        return new GraphImpl<T>(this.builder.getGraph(), this.nodeToId, this.idToNode);
    }
}

