/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sqlite;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.sqlite.BaseBinder;
import org.jetbrains.sqlite.NativeDB;
import org.jetbrains.sqlite.SqliteConnectionKt;
import org.jetbrains.sqlite.SqliteDb;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fJ\u001d\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0010\u00a2\u0006\u0002\b\u0014J\n\u0010\u0015\u001a\u00020\u0016H\u0096\u0080\u0004J\b\u0010\u0017\u001a\u00020\nH\u0016J\u001d\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0019H\u0010\u00a2\u0006\u0002\b\u001aR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/sqlite/LongBinder;", "Lorg/jetbrains/sqlite/BaseBinder;", "paramCount", "", "batchCountHint", "<init>", "(II)V", "batch", "", "bind", "", "v1", "", "v2", "v3", "v4", "bindParams", "pointer", "db", "Lorg/jetbrains/sqlite/SqliteDb;", "bindParams$intellij_platform_sqlite", "toString", "", "addBatch", "executeBatch", "Lorg/jetbrains/sqlite/NativeDB;", "executeBatch$intellij_platform_sqlite", "intellij.platform.sqlite"})
public final class LongBinder
extends BaseBinder {
    @NotNull
    private long[] batch;

    public LongBinder(int paramCount, int batchCountHint) {
        super(paramCount, null);
        this.batch = new long[paramCount * batchCountHint];
    }

    public /* synthetic */ LongBinder(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        this(n, n2);
    }

    public final void bind(long v1) {
        boolean bl;
        boolean bl2 = bl = this.getParamCount$intellij_platform_sqlite() == 1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.batch[this.batchPosition] = v1;
    }

    public final void bind(long v1, long v2) {
        boolean bl;
        boolean bl2 = bl = this.getParamCount$intellij_platform_sqlite() == 2;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.batch[this.batchPosition] = v1;
        this.batch[this.batchPosition + 1] = v2;
    }

    public final void bind(long v1, long v2, long v3) {
        boolean bl;
        boolean bl2 = bl = this.getParamCount$intellij_platform_sqlite() == 3;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.batch[this.batchPosition] = v1;
        this.batch[this.batchPosition + 1] = v2;
        this.batch[this.batchPosition + 2] = v3;
    }

    public final void bind(long v1, long v2, long v3, long v4) {
        boolean bl;
        boolean bl2 = bl = this.getParamCount$intellij_platform_sqlite() == 4;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.batch[this.batchPosition] = v1;
        this.batch[this.batchPosition + 1] = v2;
        this.batch[this.batchPosition + 2] = v3;
        this.batch[this.batchPosition + 3] = v4;
    }

    @Override
    public void bindParams$intellij_platform_sqlite(long pointer, @NotNull SqliteDb db) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        boolean bl2 = bl = this.getBatchQueryCount() == 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        long[] lArray = this.batch;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            long value = lArray[i];
            int status = db.bind_long(pointer, index + 1, value) & 0xFF;
            if (status == 0) continue;
            throw SqliteDb.newException$default(db, status, null, 2, null);
        }
    }

    @NotNull
    public String toString() {
        String string = Arrays.toString(this.batch);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public void addBatch() {
        this.batchPosition += this.getParamCount$intellij_platform_sqlite();
        int n = this.getBatchQueryCount();
        this.setBatchQueryCount(n + 1);
        if (this.batchPosition + this.getParamCount$intellij_platform_sqlite() > this.batch.length) {
            long[] newBatch = new long[this.batch.length * 2];
            ArraysKt.copyInto$default((long[])this.batch, (long[])newBatch, (int)0, (int)0, (int)0, (int)14, null);
            this.batch = newBatch;
        }
    }

    @Override
    public void executeBatch$intellij_platform_sqlite(long pointer, @NotNull NativeDB db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        int n = this.getBatchQueryCount();
        for (int batchIndex = 0; batchIndex < n; ++batchIndex) {
            db.reset(pointer);
            int n2 = this.getParamCount$intellij_platform_sqlite();
            for (int index = 0; index < n2; ++index) {
                int status = db.bind_long(pointer, index + 1, this.batch[batchIndex * this.getParamCount$intellij_platform_sqlite() + index]) & 0xFF;
                if (status == 0) continue;
                throw SqliteDb.newException$default(db, status, null, 2, null);
            }
            SqliteConnectionKt.stepInBatch(pointer, db, batchIndex);
        }
        db.reset(pointer);
    }
}

