/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.lineProfiler.data;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.profiler.lineProfiler.data.ClassFQN;
import com.intellij.profiler.lineProfiler.data.MethodDescriptor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0007J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001a\u001a\u00020\u001bH\u00d6\u0081\u0004J\n\u0010\u001c\u001a\u00020\u0011H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/intellij/profiler/lineProfiler/data/ClassAndMethodWithHits;", "", "clazz", "Lcom/intellij/profiler/lineProfiler/data/ClassFQN;", "method", "Lcom/intellij/profiler/lineProfiler/data/MethodDescriptor;", "hits", "", "<init>", "(Lcom/intellij/profiler/lineProfiler/data/ClassFQN;Lcom/intellij/profiler/lineProfiler/data/MethodDescriptor;J)V", "getClazz", "()Lcom/intellij/profiler/lineProfiler/data/ClassFQN;", "getMethod", "()Lcom/intellij/profiler/lineProfiler/data/MethodDescriptor;", "getHits", "()J", "fullName", "", "fullClassName", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.profiler.lineProfiler"})
public final class ClassAndMethodWithHits {
    @NotNull
    private final ClassFQN clazz;
    @NotNull
    private final MethodDescriptor method;
    private final long hits;

    public ClassAndMethodWithHits(@NotNull ClassFQN clazz, @NotNull MethodDescriptor method, long hits) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.clazz = clazz;
        this.method = method;
        this.hits = hits;
    }

    @NotNull
    public final ClassFQN getClazz() {
        return this.clazz;
    }

    @NotNull
    public final MethodDescriptor getMethod() {
        return this.method;
    }

    public final long getHits() {
        return this.hits;
    }

    @NlsSafe
    @NotNull
    public final String fullName() {
        return this.fullClassName() + ":" + this.method.getMethodName();
    }

    private final String fullClassName() {
        return ((CharSequence)this.clazz.getPackageName()).length() == 0 ? this.clazz.getClassName() : this.clazz.getPackageName() + "." + this.clazz.getClassName();
    }

    @NotNull
    public final ClassFQN component1() {
        return this.clazz;
    }

    @NotNull
    public final MethodDescriptor component2() {
        return this.method;
    }

    public final long component3() {
        return this.hits;
    }

    @NotNull
    public final ClassAndMethodWithHits copy(@NotNull ClassFQN clazz, @NotNull MethodDescriptor method, long hits) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return new ClassAndMethodWithHits(clazz, method, hits);
    }

    public static /* synthetic */ ClassAndMethodWithHits copy$default(ClassAndMethodWithHits classAndMethodWithHits, ClassFQN classFQN, MethodDescriptor methodDescriptor, long l, int n, Object object) {
        if ((n & 1) != 0) {
            classFQN = classAndMethodWithHits.clazz;
        }
        if ((n & 2) != 0) {
            methodDescriptor = classAndMethodWithHits.method;
        }
        if ((n & 4) != 0) {
            l = classAndMethodWithHits.hits;
        }
        return classAndMethodWithHits.copy(classFQN, methodDescriptor, l);
    }

    @NotNull
    public String toString() {
        return "ClassAndMethodWithHits(clazz=" + this.clazz + ", method=" + this.method + ", hits=" + this.hits + ")";
    }

    public int hashCode() {
        int result = this.clazz.hashCode();
        result = result * 31 + this.method.hashCode();
        result = result * 31 + Long.hashCode(this.hits);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClassAndMethodWithHits)) {
            return false;
        }
        ClassAndMethodWithHits classAndMethodWithHits = (ClassAndMethodWithHits)other;
        if (!Intrinsics.areEqual((Object)this.clazz, (Object)classAndMethodWithHits.clazz)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.method, (Object)classAndMethodWithHits.method)) {
            return false;
        }
        return this.hits == classAndMethodWithHits.hits;
    }
}

